/* Generated by GOB (v2.0.6) on Sun Feb  8 14:54:34 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 6

#define selfp (self->_priv)

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 3 "gpeiconlist.gob"

/*
  gpeiconlist - an icon list widget
  Copyright (C) 2002  Robert Mibus <mibus@handhelds.org>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>

#include "gpe-iconlist.h"
#include "gpeiconlistitem.h"
#include "link-warning.h"

#define LABEL_YMARGIN	8
#define TOP_MARGIN	5

#define il_label_height(_x)	(GPE_ICONLIST (_x)->_priv->label_height)
#define il_icon_size(_x)	(GPE_ICONLIST (_x)->_priv->icon_size)
#define il_row_height(_x)	(il_icon_size (_x) \
	                         + (((GPE_ICONLIST (_x)->_priv)->flag_show_title) ? \
		                     (il_label_height (_x)) : 0 ) \
				 + LABEL_YMARGIN)
#define il_col_width(_x)	(il_icon_size (_x) + (2 * GPE_ICONLIST (_x)->_priv->icon_xmargin))

//private structure used to find an icon from its data, see _find_from_udata()
struct _Pack
{
  gpointer udata;         //udata to find
  GPEIconListItem *icon;  //the icon if found, NULL if not found
};


#line 70 "gpe-iconlist.c"
/* self casting macros */
#define SELF(x) GPE_ICONLIST(x)
#define SELF_CONST(x) GPE_ICONLIST_CONST(x)
#define IS_SELF(x) GPE_IS_ICONLIST(x)
#define TYPE_SELF GPE_TYPE_ICONLIST
#define SELF_CLASS(x) GPE_ICONLIST_CLASS(x)

#define SELF_GET_CLASS(x) GPE_ICONLIST_GET_CLASS(x)

/* self typedefs */
typedef GPEIconList Self;
typedef GPEIconListClass SelfClass;

struct _GPEIconListPrivate {
#line 53 "gpeiconlist.gob"
	GList * icons;
#line 54 "gpeiconlist.gob"
	GdkPixbuf * bgpixbuf;
#line 55 "gpeiconlist.gob"
	guint32 bgcolor;
#line 57 "gpeiconlist.gob"
	int rows;
#line 58 "gpeiconlist.gob"
	int cols;
#line 59 "gpeiconlist.gob"
	int mcol;
#line 60 "gpeiconlist.gob"
	int mrow;
#line 61 "gpeiconlist.gob"
	int popup_timeout;
#line 62 "gpeiconlist.gob"
	gboolean flag_embolden;
#line 63 "gpeiconlist.gob"
	gboolean flag_show_title;
#line 64 "gpeiconlist.gob"
	guint icon_size;
#line 65 "gpeiconlist.gob"
	guint icon_xmargin;
#line 66 "gpeiconlist.gob"
	guint label_height;
#line 111 "gpe-iconlist.c"
};
/* here are local prototypes */
static void gpe_iconlist_class_init (GPEIconListClass * c) G_GNUC_UNUSED;
static void gpe_iconlist_init (GPEIconList * self) G_GNUC_UNUSED;
static gint gpe_iconlist__title_height (GPEIconList * widget) G_GNUC_UNUSED;
static void gpe_iconlist__check_icon_size (GPEIconList * il, GObject * obj) G_GNUC_UNUSED;
static gboolean gpe_iconlist__expose (GtkWidget * widget, GdkEventExpose * event, gpointer data) G_GNUC_UNUSED;
static void gpe_iconlist__recalc_size (GPEIconList * self, GtkAllocation * allocation) G_GNUC_UNUSED;
static GObject * gpe_iconlist_new_icon (char * title, char * icon, gpointer udata, GdkPixbuf * pb) G_GNUC_UNUSED;
static void gpe_iconlist__find_from_udata (gpointer icon, gpointer data_pak) G_GNUC_UNUSED;
static void ___19_gpe_iconlist_size_allocate (GtkWidget * self, GtkAllocation * allocation) G_GNUC_UNUSED;
static void gpe_iconlist__get_rowcol (GPEIconList * widget, int x, int y, int * col, int * row) G_GNUC_UNUSED;
static void gpe_iconlist__refresh_containing (GPEIconList * widget, int col, int row) G_GNUC_UNUSED;
static GPEIconListItem * gpe_iconlist__get_icon (GPEIconList * il, int col, int row) G_GNUC_UNUSED;
static void gpe_iconlist__cancel_popup (GPEIconList * il) G_GNUC_UNUSED;
static gint gpe_iconlist__button_release (GtkWidget * widget, GdkEventButton * event) G_GNUC_UNUSED;
static gint gpe_iconlist__popup (gpointer data) G_GNUC_UNUSED;
static gint gpe_iconlist__button_press (GtkWidget * widget, GdkEventButton * event, gpointer user_data) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__clicked(object,func,data)	gpe_iconlist_connect__clicked((object),(func),(data))
#define self_connect_after__clicked(object,func,data)	gpe_iconlist_connect_after__clicked((object),(func),(data))
#define self_connect_data__clicked(object,func,data,destroy_data,flags)	gpe_iconlist_connect_data__clicked((object),(func),(data),(destroy_data),(flags))
#define self_connect__show_popup(object,func,data)	gpe_iconlist_connect__show_popup((object),(func),(data))
#define self_connect_after__show_popup(object,func,data)	gpe_iconlist_connect_after__show_popup((object),(func),(data))
#define self_connect_data__show_popup(object,func,data,destroy_data,flags)	gpe_iconlist_connect_data__show_popup((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (GPEIconList *, gpointer , gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((GPEIconList *)data1,
		(gpointer ) g_value_get_pointer (param_values + 1),
		data2);
}


enum {
	CLICKED_SIGNAL,
	SHOW_POPUP_SIGNAL,
	LAST_SIGNAL
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkScrolledWindowClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_clicked(args...) gpe_iconlist_clicked(args)
#define self_show_popup(args...) gpe_iconlist_show_popup(args)
#define self_new() gpe_iconlist_new()
#define self_set_bg(args...) gpe_iconlist_set_bg(args)
#define self_set_bg_pixmap(args...) gpe_iconlist_set_bg_pixmap(args)
#define self_set_bg_color(args...) gpe_iconlist_set_bg_color(args)
#define self__title_height(args...) gpe_iconlist__title_height(args)
#define self__check_icon_size(args...) gpe_iconlist__check_icon_size(args)
#define self__expose(args...) gpe_iconlist__expose(args)
#define self__recalc_size(args...) gpe_iconlist__recalc_size(args)
#define self_new_icon(args...) gpe_iconlist_new_icon(args)
#define self_update_icon_item_with_udata(args...) gpe_iconlist_update_icon_item_with_udata(args)
#define self__find_from_udata(args...) gpe_iconlist__find_from_udata(args)
#define self_remove_item_with_udata(args...) gpe_iconlist_remove_item_with_udata(args)
#define self_add_item(args...) gpe_iconlist_add_item(args)
#define self_add_item_pixbuf(args...) gpe_iconlist_add_item_pixbuf(args)
#define self_remove_item(args...) gpe_iconlist_remove_item(args)
#define self_set_item_icon(args...) gpe_iconlist_set_item_icon(args)
#define self_set_embolden(args...) gpe_iconlist_set_embolden(args)
#define self_set_show_title(args...) gpe_iconlist_set_show_title(args)
#define self_set_icon_xmargin(args...) gpe_iconlist_set_icon_xmargin(args)
#define self_clear(args...) gpe_iconlist_clear(args)
#define self_set_icon_size(args...) gpe_iconlist_set_icon_size(args)
#define self__get_rowcol(args...) gpe_iconlist__get_rowcol(args)
#define self__refresh_containing(args...) gpe_iconlist__refresh_containing(args)
#define self__get_icon(args...) gpe_iconlist__get_icon(args)
#define self__cancel_popup(args...) gpe_iconlist__cancel_popup(args)
#define self__button_release(args...) gpe_iconlist__button_release(args)
#define self__popup(args...) gpe_iconlist__popup(args)
#define self_popup_removed(args...) gpe_iconlist_popup_removed(args)
#define self__button_press(args...) gpe_iconlist__button_press(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static void (* const self_clicked) (GPEIconList * self, gpointer udata) = gpe_iconlist_clicked;
static void (* const self_show_popup) (GPEIconList * self, gpointer udata) = gpe_iconlist_show_popup;
static GtkWidget * (* const self_new) (void) = gpe_iconlist_new;
static void (* const self_set_bg) (GPEIconList * self, char * bg) = gpe_iconlist_set_bg;
static void (* const self_set_bg_pixmap) (GPEIconList * self, GdkPixbuf * bg) = gpe_iconlist_set_bg_pixmap;
static void (* const self_set_bg_color) (GPEIconList * self, guint32 color) = gpe_iconlist_set_bg_color;
static gint (* const self__title_height) (GPEIconList * widget) = gpe_iconlist__title_height;
static void (* const self__check_icon_size) (GPEIconList * il, GObject * obj) = gpe_iconlist__check_icon_size;
static gboolean (* const self__expose) (GtkWidget * widget, GdkEventExpose * event, gpointer data) = gpe_iconlist__expose;
static void (* const self__recalc_size) (GPEIconList * self, GtkAllocation * allocation) = gpe_iconlist__recalc_size;
static GObject * (* const self_new_icon) (char * title, char * icon, gpointer udata, GdkPixbuf * pb) = gpe_iconlist_new_icon;
static void (* const self_update_icon_item_with_udata) (GPEIconList * self, GdkPixbuf * pixbuf, gpointer udata) = gpe_iconlist_update_icon_item_with_udata;
static void (* const self__find_from_udata) (gpointer icon, gpointer data_pak) = gpe_iconlist__find_from_udata;
static void (* const self_remove_item_with_udata) (GPEIconList * self, gpointer udata) = gpe_iconlist_remove_item_with_udata;
static GObject * (* const self_add_item) (GPEIconList * self, char * title, char * icon, gpointer udata) = gpe_iconlist_add_item;
static GObject * (* const self_add_item_pixbuf) (GPEIconList * self, char * title, GdkPixbuf * icon, gpointer udata) = gpe_iconlist_add_item_pixbuf;
static void (* const self_remove_item) (GPEIconList * self, GObject * item) = gpe_iconlist_remove_item;
static void (* const self_set_item_icon) (GPEIconList * self, GObject * item, GdkPixbuf * new_pixbuf) = gpe_iconlist_set_item_icon;
static void (* const self_set_embolden) (GPEIconList * self, gboolean yes) = gpe_iconlist_set_embolden;
static void (* const self_set_show_title) (GPEIconList * self, gboolean yes) = gpe_iconlist_set_show_title;
static void (* const self_set_icon_xmargin) (GPEIconList * self, guint margin) = gpe_iconlist_set_icon_xmargin;
static void (* const self_clear) (GPEIconList * self) = gpe_iconlist_clear;
static void (* const self_set_icon_size) (GPEIconList * self, guint size) = gpe_iconlist_set_icon_size;
static void (* const self__get_rowcol) (GPEIconList * widget, int x, int y, int * col, int * row) = gpe_iconlist__get_rowcol;
static void (* const self__refresh_containing) (GPEIconList * widget, int col, int row) = gpe_iconlist__refresh_containing;
static GPEIconListItem * (* const self__get_icon) (GPEIconList * il, int col, int row) = gpe_iconlist__get_icon;
static void (* const self__cancel_popup) (GPEIconList * il) = gpe_iconlist__cancel_popup;
static gint (* const self__button_release) (GtkWidget * widget, GdkEventButton * event) = gpe_iconlist__button_release;
static gint (* const self__popup) (gpointer data) = gpe_iconlist__popup;
static void (* const self_popup_removed) (GPEIconList * self) = gpe_iconlist_popup_removed;
static gint (* const self__button_press) (GtkWidget * widget, GdkEventButton * event, gpointer user_data) = gpe_iconlist__button_press;

GType
gpe_iconlist_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GPEIconListClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gpe_iconlist_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GPEIconList),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gpe_iconlist_init,
		};

		type = g_type_register_static (GTK_TYPE_SCROLLED_WINDOW, "GPEIconList", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GPEIconList *)g_object_new(gpe_iconlist_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GPEIconList * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GPEIconList *
GET_NEW_VARG (const char *first, ...)
{
	GPEIconList *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GPEIconList *)g_object_new_valist (gpe_iconlist_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "GPE:IconList::finalize"
	GPEIconList *self = GPE_ICONLIST (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
gpe_iconlist_class_init (GPEIconListClass * c)
{
#define __GOB_FUNCTION__ "GPE:IconList::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;
	GtkWidgetClass *gtk_widget_class = (GtkWidgetClass *)c;

	parent_class = g_type_class_ref (GTK_TYPE_SCROLLED_WINDOW);

	object_signals[CLICKED_SIGNAL] =
		g_signal_new ("clicked",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (GPEIconListClass, clicked),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_POINTER);
	if ___GOB_UNLIKELY(sizeof(gpointer ) != sizeof(gpointer )) {
		g_error("gpeiconlist.gob line 69: Type mismatch of \"clicked\" signal signature");
	}
	object_signals[SHOW_POPUP_SIGNAL] =
		g_signal_new ("show_popup",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (GPEIconListClass, show_popup),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_POINTER);
	if ___GOB_UNLIKELY(sizeof(gpointer ) != sizeof(gpointer )) {
		g_error("gpeiconlist.gob line 72: Type mismatch of \"show_popup\" signal signature");
	}

	c->clicked = NULL;
	c->show_popup = NULL;
#line 597 "gpeiconlist.gob"
	gtk_widget_class->size_allocate = ___19_gpe_iconlist_size_allocate;
#line 346 "gpe-iconlist.c"
	g_object_class->finalize = ___finalize;
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__
#line 76 "gpeiconlist.gob"
static void 
gpe_iconlist_init (GPEIconList * self)
#line 356 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::init"
	self->_priv = g_new0 (GPEIconListPrivate, 1);
#line 3 "gpeiconlist.gob"
	self->_priv->icons = NULL;
#line 362 "gpe-iconlist.c"
#line 3 "gpeiconlist.gob"
	self->_priv->bgpixbuf = NULL;
#line 365 "gpe-iconlist.c"
#line 3 "gpeiconlist.gob"
	self->_priv->bgcolor = 0xffffffff;
#line 368 "gpe-iconlist.c"
#line 3 "gpeiconlist.gob"
	self->_priv->rows = 1;
#line 371 "gpe-iconlist.c"
#line 3 "gpeiconlist.gob"
	self->_priv->cols = 1;
#line 374 "gpe-iconlist.c"
#line 3 "gpeiconlist.gob"
	self->_priv->mcol = -1;
#line 377 "gpe-iconlist.c"
#line 3 "gpeiconlist.gob"
	self->_priv->mrow = -1;
#line 380 "gpe-iconlist.c"
#line 3 "gpeiconlist.gob"
	self->_priv->popup_timeout = 0;
#line 383 "gpe-iconlist.c"
#line 3 "gpeiconlist.gob"
	self->_priv->flag_embolden = TRUE;
#line 386 "gpe-iconlist.c"
#line 3 "gpeiconlist.gob"
	self->_priv->flag_show_title = TRUE;
#line 389 "gpe-iconlist.c"
#line 3 "gpeiconlist.gob"
	self->_priv->icon_size = 48;
#line 392 "gpe-iconlist.c"
#line 3 "gpeiconlist.gob"
	self->_priv->icon_xmargin = 12;
#line 395 "gpe-iconlist.c"
#line 3 "gpeiconlist.gob"
	self->_priv->label_height = 0;
#line 398 "gpe-iconlist.c"
 {
#line 77 "gpeiconlist.gob"

	  GtkWidget *vp, *da;

	  gtk_scrolled_window_set_hadjustment (GTK_SCROLLED_WINDOW(self), NULL);
	  gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW(self), NULL);

	  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (GTK_SCROLLED_WINDOW (self)),
					  GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	  vp = gtk_viewport_new (NULL, NULL);
	  gtk_container_add (GTK_CONTAINER (self), vp);

	  da = gtk_drawing_area_new ();
	  gtk_widget_add_events (GTK_WIDGET (da), GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);
	  g_signal_connect (G_OBJECT (da), "expose_event",
			    G_CALLBACK (gpe_iconlist__expose), NULL);
	  g_signal_connect (G_OBJECT (da), "button_release_event",
			    G_CALLBACK (gpe_iconlist__button_release), NULL);
	  g_signal_connect (G_OBJECT (da), "button_press_event",
			    G_CALLBACK (gpe_iconlist__button_press), NULL);
	  gtk_container_add (GTK_CONTAINER (vp), da);
	  
	  gtk_object_set_data (GTK_OBJECT (self), "da", da);
	  gtk_object_set_data (GTK_OBJECT (da), "il", self);
	  gtk_object_set_data (GTK_OBJECT (da), "va", gtk_viewport_get_vadjustment (GTK_VIEWPORT (vp)));
	  
	  self->_priv->label_height = gpe_iconlist__title_height (self);
	  
	  gtk_widget_show_all (vp);
	
#line 431 "gpe-iconlist.c"
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


#line 69 "gpeiconlist.gob"
void 
gpe_iconlist_clicked (GPEIconList * self, gpointer udata)
#line 442 "gpe-iconlist.c"
{
	GValue ___param_values[2];
	GValue ___return_val = {0};

#line 69 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 69 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 451 "gpe-iconlist.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_POINTER);
	g_value_set_pointer (&___param_values[1], (gpointer ) udata);

	g_signal_emitv (___param_values,
		object_signals[CLICKED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}

#line 72 "gpeiconlist.gob"
void 
gpe_iconlist_show_popup (GPEIconList * self, gpointer udata)
#line 473 "gpe-iconlist.c"
{
	GValue ___param_values[2];
	GValue ___return_val = {0};

#line 72 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 72 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 482 "gpe-iconlist.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_POINTER);
	g_value_set_pointer (&___param_values[1], (gpointer ) udata);

	g_signal_emitv (___param_values,
		object_signals[SHOW_POPUP_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}


#line 108 "gpeiconlist.gob"
GtkWidget * 
gpe_iconlist_new (void)
#line 505 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::new"
{
#line 110 "gpeiconlist.gob"
	
	  return GTK_WIDGET (GET_NEW);
	}}
#line 513 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 115 "gpeiconlist.gob"
void 
gpe_iconlist_set_bg (GPEIconList * self, char * bg)
#line 519 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::set_bg"
{
#line 116 "gpeiconlist.gob"
	
		if (self->_priv->bgpixbuf)
			gdk_pixbuf_unref (self->_priv->bgpixbuf);
		if (bg)
			self->_priv->bgpixbuf = gdk_pixbuf_new_from_file (bg, NULL);
		else
			self->_priv->bgpixbuf = NULL;
	}}
#line 532 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 125 "gpeiconlist.gob"
void 
gpe_iconlist_set_bg_pixmap (GPEIconList * self, GdkPixbuf * bg)
#line 538 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::set_bg_pixmap"
{
#line 126 "gpeiconlist.gob"
	
		if (self->_priv->bgpixbuf)
			gdk_pixbuf_unref (self->_priv->bgpixbuf);
		gdk_pixbuf_ref (bg);
		self->_priv->bgpixbuf = bg;
	}}
#line 549 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 133 "gpeiconlist.gob"
void 
gpe_iconlist_set_bg_color (GPEIconList * self, guint32 color)
#line 555 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::set_bg_color"
{
#line 134 "gpeiconlist.gob"
	
		self->_priv->bgcolor = color;
	}}
#line 563 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 139 "gpeiconlist.gob"
static gint 
gpe_iconlist__title_height (GPEIconList * widget)
#line 569 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::_title_height"
{
#line 140 "gpeiconlist.gob"
	
		PangoContext *pc;
		PangoLayout *pl;
		PangoRectangle pr;
		int label_height;

		/* Pango font rendering setup */
		if ((pc = gtk_widget_get_pango_context (GTK_WIDGET(widget))) == NULL)
			pc = gtk_widget_create_pango_context (GTK_WIDGET(widget));
		pl = pango_layout_new (pc);
		
		/* Find out how tall icon labels will be */
		pango_layout_set_text (pl, "QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm\nQWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm", -1);
		pango_layout_get_pixel_extents  (pl, NULL, &pr);
		label_height = pr.height;

		g_object_unref (pl);

		return label_height;
	}}
#line 594 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 161 "gpeiconlist.gob"
static void 
gpe_iconlist__check_icon_size (GPEIconList * il, GObject * obj)
#line 600 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::_check_icon_size"
{
#line 162 "gpeiconlist.gob"
	
		GPEIconListItem *icon = GPE_ICON_LIST_ITEM (obj);
		if (icon->pb) {
			guint h = gdk_pixbuf_get_height (icon->pb);
			if (h > il->_priv->icon_size + 1
			   || h < il->_priv->icon_size - 1) {
				double ratio = (double)il->_priv->icon_size / (double)h; 
				guint new_width = gdk_pixbuf_get_width (icon->pb) * ratio;
				icon->pb_scaled = gdk_pixbuf_scale_simple (icon->pb, new_width, il->_priv->icon_size, GDK_INTERP_BILINEAR);
			} else {
				gdk_pixbuf_ref (icon->pb);
				icon->pb_scaled = icon->pb;
			}
		}
	}}
#line 620 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 179 "gpeiconlist.gob"
static gboolean 
gpe_iconlist__expose (GtkWidget * widget, GdkEventExpose * event, gpointer data)
#line 626 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::_expose"
{
#line 180 "gpeiconlist.gob"
	
	  GPEIconList *il;
	  GList *icons;
	  GdkPixbuf *dest;
	  int row=0, col=0;
	  GtkAdjustment *va;
	  PangoContext *pc;
	  PangoLayout *pl;
	  int label_height;
	  int i;
	  
	  il = GPE_ICONLIST(gtk_object_get_data (GTK_OBJECT(widget), "il"));

	  /* Pango font rendering setup */
	  if ((pc = gtk_widget_get_pango_context (widget)) == NULL)
	    pc = gtk_widget_create_pango_context (widget);

	  pl = pango_layout_new (pc);
	  pango_layout_set_width (pl, il_col_width (il) * PANGO_SCALE);
	  pango_layout_set_alignment (pl, PANGO_ALIGN_CENTER);
	  
	  label_height = il_label_height (il);

	  /* Get the GtkAdjustment used for the vertical scrollbar
	     va->value is the current displacement of the view as compared to the widget */
	  va = gtk_object_get_data (GTK_OBJECT (widget), "va");
	  
	  /* Make a new pixbuf for rendering icons to */
	  dest = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8,
				 event->area.width, event->area.height);

	  /* set the background color */
	  gdk_pixbuf_fill (dest, il->_priv->bgcolor);

	  /* Paint the background image, scaled */
	  if (il->_priv->bgpixbuf)
	    {
	      /* ??? pb: what's this loop for?  why not just render the area of
		 background image given by event->area?  */
	      for (i = 0; 
		   i < il->_priv->rows * il_row_height (il); 
		   i += gdk_pixbuf_get_height (il->_priv->bgpixbuf)) 
		{
		  GdkRectangle r1, dst;
		  r1.x = 0; r1.y = i;
		  r1.width = gdk_pixbuf_get_width (il->_priv->bgpixbuf);
		  r1.height = gdk_pixbuf_get_height (il->_priv->bgpixbuf);
		  
		  if (gdk_rectangle_intersect (&r1, &(event->area), &dst)) {
		    gdk_pixbuf_composite (il->_priv->bgpixbuf, dest,
					  dst.x-event->area.x,
					  dst.y-event->area.y,
					  dst.width, dst.height,
					  r1.x-event->area.x, r1.y-event->area.y,
					  1,
					  1,
					  GDK_INTERP_BILINEAR, 255);
		  }
		}
	    }

	  for (icons = il->_priv->icons; icons != NULL; icons = icons->next) 
	    {
	      GdkRectangle r1, r2, dst;
	      GPEIconListItem *icon;
	      GdkPixbuf *pixbuf=NULL;
	    
	      icon = icons->data;
	    
	      /* Compute & render the icon */
	      r1.x=col * il_col_width (il);
	      r1.y=row * il_row_height (il) + 5;
	      r1.width = il_col_width (il);
	      r1.height = il->_priv->icon_size;
	      
	      r2.x = event->area.x;
	      r2.y = event->area.y;
	      r2.width = event->area.width;
	      r2.height = event->area.height;
	      
	      if (gdk_rectangle_intersect (&r1, &r2, &dst)) 
		{
		  /* Get the icon from the cache if its there, if not put it there :) */
		  if (icon->pb_scaled)
		    pixbuf = icon->pb_scaled;
		  else 
		    {
		      if (icon->pb == NULL)
			icon->pb = gdk_pixbuf_new_from_file (icon->icon, NULL);

		      gpe_iconlist__check_icon_size (il, G_OBJECT (icon));

		      if (icon->icon) 
			{
			  gdk_pixbuf_unref (icon->pb);
			  icon->pb = NULL;
			}

		      pixbuf = icon->pb_scaled;
		    }
	      
		  if (pixbuf) 
		    {
		      // adjust X position for actual size
		      r1.width = gdk_pixbuf_get_width (pixbuf);
		      r1.x=col * il_col_width (il) + (il_col_width (il) - r1.width) / 2;
		
		      // recompute intersection: maybe nothing to do any more
		      if (gdk_rectangle_intersect (&r1, &r2, &dst)) 
			{
			  gdk_pixbuf_composite (pixbuf, dest, // from, to
						dst.x - event->area.x, //dest_x
						dst.y - event->area.y,// + va->value, // dest_y
						dst.width, dst.height, // dest_width, dest_height
						r1.x - event->area.x, // offset_x
						r1.y - event->area.y, // + va->value, // offset_y
						1.0, 1.0,
						GDK_INTERP_BILINEAR, // filtering
						col == il->_priv->mcol && row == il->_priv->mrow ? 128 : 255);
			}
		    }
		}
	      
	      if (++col == il->_priv->cols) 
		{
		  col = 0; 
		  row++;
		}
	    }

	  /* Dump to drawingarea */
	  gdk_pixbuf_render_to_drawable (dest, widget->window, widget->style->fg_gc[GTK_STATE_NORMAL],
					 0, 0, event->area.x, event->area.y,
					 event->area.width, event->area.height,
					 GDK_RGB_DITHER_NORMAL, event->area.x, event->area.y);
 	  
	  gdk_pixbuf_unref (dest);
	  
	  col = row = 0;
	  
	  for (icons = il->_priv->icons; icons != NULL; icons = icons->next) 
	    {
	      GdkRectangle r1, r2, dst;
	      GPEIconListItem *icon;
	      icon = icons->data;
	    
	      if (il->_priv->flag_show_title && icon->title)
		{
		  /* if show_title mode is set and current title non NULL, then */
		  /* Compute & render the title */
		  r1.x=col * il_col_width (il);
		  r1.y=row * il_row_height (il) + il->_priv->icon_size + LABEL_YMARGIN;
		  r1.width = il_col_width (il);
		  r1.height = label_height;
	      
		  r2.x = event->area.x;
		  r2.y = event->area.y;
		  r2.width = event->area.width;
		  r2.height = event->area.height;
	      
		  if (gdk_rectangle_intersect (&r1, &r2, &dst)) 
		    {
		      char *stxt; int slen;
		      int selected=0;
		      PangoRectangle pr;
		      
		      stxt=icon->title;
		      slen = strlen (stxt);
          
		      selected = (il->_priv->mrow == row && il->_priv->mcol == col);
		      if (selected && il->_priv->flag_embolden) 
			{
			  char *newtxt;
			  newtxt = g_strdup_printf ("<b>%s</b>", stxt);
			  pango_layout_set_markup (pl, newtxt, -1);
			  g_free (newtxt);
			} 
		      else
			pango_layout_set_text (pl, stxt, -1);
		
		      pango_layout_get_pixel_extents  (pl, NULL, &pr);
		      
		      while ((pango_layout_get_line_count (pl) > 2 ||
			      pr.width > il_col_width (il)) && slen>0) {
			char *newtxt;
			char *fmt;
			if (stxt[slen-2] == ' ')
			  slen--;
            
			if (selected && il->_priv->flag_embolden)
			  fmt = g_strdup_printf ("<b>%%.%ds...</b>", --slen);
			else
			  fmt = g_strdup_printf ("%%.%ds...", --slen);
		  
			newtxt = g_strdup_printf (fmt, stxt);
			g_free (fmt);
		  
			if (selected)
			  pango_layout_set_markup (pl, newtxt, -1);
			else
			  pango_layout_set_text (pl, newtxt, -1);
			g_free (newtxt);
			
			pango_layout_get_pixel_extents  (pl, NULL, &pr);
		      }
		
		      gtk_paint_layout (widget->style, widget->window, GTK_WIDGET_STATE (widget),
					FALSE, &dst,
					widget, "detail?wtf?", r1.x, r1.y, pl);
		    }
		} //(if show title, compute and render)
	      
	      if (++col == il->_priv->cols) 
		{
		  col = 0; 
		  row++;
		}
	  }
	  
	  g_object_unref (pl);
	  
	  return TRUE;
	}}
#line 854 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 404 "gpeiconlist.gob"
static void 
gpe_iconlist__recalc_size (GPEIconList * self, GtkAllocation * allocation)
#line 860 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::_recalc_size"
#line 404 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 404 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 867 "gpe-iconlist.c"
{
#line 405 "gpeiconlist.gob"
	
	  int count;
	  int da_new_height;
	  GtkAdjustment *adj;
	  GtkWidget *viewport;

	  adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (self));
	  
	  /* calculate number of columns that will fit.  If none will, use one anyway */
	  self->_priv->cols = allocation->width / il_col_width (self);
	  if (self->_priv->cols == 0)
	    self->_priv->cols = 1;
	  
	  count = g_list_length (self->_priv->icons);
		
	  self->_priv->rows = (count - 1) / self->_priv->cols + 1;
		
	  // update drawing area
	  da_new_height = self->_priv->rows * il_row_height (self) + TOP_MARGIN;
	  gtk_widget_set_usize (GTK_WIDGET (gtk_object_get_data (GTK_OBJECT (self), "da")),
				-1, da_new_height);
	  viewport = GTK_WIDGET (gtk_bin_get_child (GTK_BIN (self)));
	  gtk_widget_size_allocate (viewport, &viewport->allocation);
	}}
#line 894 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 430 "gpeiconlist.gob"
static GObject * 
gpe_iconlist_new_icon (char * title, char * icon, gpointer udata, GdkPixbuf * pb)
#line 900 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::new_icon"
{
#line 431 "gpeiconlist.gob"
	
	  GPEIconListItem *ret;
	  ret = (GPEIconListItem *) gpe_icon_list_item_new ();
	  ret->title = title;
	  ret->icon = icon;
	  ret->udata = udata;
	  ret->pb = pb;
	  ret->pb_scaled = NULL;
	  return G_OBJECT (ret);
	}}
#line 915 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 444 "gpeiconlist.gob"
void 
gpe_iconlist_update_icon_item_with_udata (GPEIconList * self, GdkPixbuf * pixbuf, gpointer udata)
#line 921 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::update_icon_item_with_udata"
#line 444 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 444 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 928 "gpe-iconlist.c"
{
#line 445 "gpeiconlist.gob"
	
	  GtkWidget *da = g_object_get_data (G_OBJECT (self), "da");
	  struct _Pack pak;
	  pak.udata = udata;
	  pak.icon  = NULL;
	  g_list_foreach (self->_priv->icons, gpe_iconlist__find_from_udata, &pak);
	  
	  if (pak.icon != NULL)
	    {
	      gdk_pixbuf_unref(pak.icon->pb);
	      gdk_pixbuf_unref(pak.icon->pb_scaled);

	      pak.icon->pb = pixbuf;
	      gdk_pixbuf_ref(pak.icon->pb);
	      gpe_iconlist__check_icon_size (self, G_OBJECT (pak.icon));
	    }
	  else
	    {
	      g_error ("icon to update NOT found :(\n");
	    }

	  gpe_iconlist__recalc_size (self, &da->allocation);
	}}
#line 954 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 470 "gpeiconlist.gob"
static void 
gpe_iconlist__find_from_udata (gpointer icon, gpointer data_pak)
#line 960 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::_find_from_udata"
{
#line 471 "gpeiconlist.gob"
	
	  if( ((GPEIconListItem *)icon)->udata == ((struct _Pack *)data_pak)->udata )
	    {
	      ((struct _Pack *)data_pak)->icon = icon;
	    }
	}}
#line 971 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 480 "gpeiconlist.gob"
void 
gpe_iconlist_remove_item_with_udata (GPEIconList * self, gpointer udata)
#line 977 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::remove_item_with_udata"
#line 480 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 480 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 984 "gpe-iconlist.c"
{
#line 481 "gpeiconlist.gob"
	
	  GtkWidget *da = g_object_get_data (G_OBJECT (self), "da");
	  struct _Pack pak;
	  pak.udata = udata;
	  pak.icon  = NULL;
	  g_list_foreach (self->_priv->icons, gpe_iconlist__find_from_udata, &pak);
	  
	  if (pak.icon != NULL)
	    {
	      self->_priv->icons = g_list_remove (self->_priv->icons, pak.icon);
	    }
	  else
	    {
	      g_error ("icon to remove NOT found :(\n");
	    }
	  gpe_iconlist__recalc_size (self, &da->allocation);
	}}
#line 1004 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 499 "gpeiconlist.gob"
GObject * 
gpe_iconlist_add_item (GPEIconList * self, char * title, char * icon, gpointer udata)
#line 1010 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::add_item"
#line 499 "gpeiconlist.gob"
	g_return_val_if_fail (self != NULL, (GObject * )0);
#line 499 "gpeiconlist.gob"
	g_return_val_if_fail (GPE_IS_ICONLIST (self), (GObject * )0);
#line 1017 "gpe-iconlist.c"
{
#line 500 "gpeiconlist.gob"
	
	  GtkWidget *da = g_object_get_data (G_OBJECT (self), "da");
	  GObject *new = gpe_iconlist_new_icon (title, icon, udata, NULL);
	  self->_priv->icons = g_list_append (self->_priv->icons, new);
	  gpe_iconlist__recalc_size (self, &da->allocation);
	  return new;
	}}
#line 1027 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 508 "gpeiconlist.gob"
GObject * 
gpe_iconlist_add_item_pixbuf (GPEIconList * self, char * title, GdkPixbuf * icon, gpointer udata)
#line 1033 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::add_item_pixbuf"
#line 508 "gpeiconlist.gob"
	g_return_val_if_fail (self != NULL, (GObject * )0);
#line 508 "gpeiconlist.gob"
	g_return_val_if_fail (GPE_IS_ICONLIST (self), (GObject * )0);
#line 1040 "gpe-iconlist.c"
{
#line 509 "gpeiconlist.gob"
	
	  GObject *new;
	  GtkWidget *da = g_object_get_data (G_OBJECT (self), "da");
	  gdk_pixbuf_ref (icon);
	  new = gpe_iconlist_new_icon (title, NULL, udata, icon);
	  self->_priv->icons = g_list_append (self->_priv->icons, new);
	  gpe_iconlist__check_icon_size (self, new);
	  gpe_iconlist__recalc_size (self, &da->allocation);
	  return new;
	}}
#line 1053 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 520 "gpeiconlist.gob"
void 
gpe_iconlist_remove_item (GPEIconList * self, GObject * item)
#line 1059 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::remove_item"
#line 520 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 520 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 1066 "gpe-iconlist.c"
{
#line 521 "gpeiconlist.gob"
	
	  GtkWidget *da;
	  da = g_object_get_data (G_OBJECT (self), "da");
	  self->_priv->icons = g_list_remove (self->_priv->icons, item);
	  g_object_unref (item);
	  gpe_iconlist__recalc_size (self, &da->allocation);
	}}
#line 1076 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 529 "gpeiconlist.gob"
void 
gpe_iconlist_set_item_icon (GPEIconList * self, GObject * item, GdkPixbuf * new_pixbuf)
#line 1082 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::set_item_icon"
#line 529 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 529 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 1089 "gpe-iconlist.c"
{
#line 530 "gpeiconlist.gob"
	
	  GPEIconListItem *i;

	  i = GPE_ICON_LIST_ITEM (item);
	  
	  if (i->pb)
	    gdk_pixbuf_unref (i->pb);
	  if (i->pb_scaled)
	    gdk_pixbuf_unref (i->pb_scaled);
	  
	  i->pb = new_pixbuf;
	  gdk_pixbuf_ref (i->pb);

	  gpe_iconlist__check_icon_size (self, item);
	}}
#line 1107 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 546 "gpeiconlist.gob"
void 
gpe_iconlist_set_embolden (GPEIconList * self, gboolean yes)
#line 1113 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::set_embolden"
#line 546 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 546 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 1120 "gpe-iconlist.c"
{
#line 547 "gpeiconlist.gob"
	
	  self->_priv->flag_embolden = yes;
	}}
#line 1126 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 551 "gpeiconlist.gob"
void 
gpe_iconlist_set_show_title (GPEIconList * self, gboolean yes)
#line 1132 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::set_show_title"
#line 551 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 551 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 1139 "gpe-iconlist.c"
{
#line 552 "gpeiconlist.gob"
	
	  self->_priv->flag_show_title = yes;
	}}
#line 1145 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 556 "gpeiconlist.gob"
void 
gpe_iconlist_set_icon_xmargin (GPEIconList * self, guint margin)
#line 1151 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::set_icon_xmargin"
#line 556 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 556 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 1158 "gpe-iconlist.c"
{
#line 557 "gpeiconlist.gob"
	
	  self->_priv->icon_xmargin = margin;
	}}
#line 1164 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 561 "gpeiconlist.gob"
void 
gpe_iconlist_clear (GPEIconList * self)
#line 1170 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::clear"
#line 561 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 561 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 1177 "gpe-iconlist.c"
{
#line 562 "gpeiconlist.gob"
	
	  GList *iter;
	  GtkWidget *da = g_object_get_data (G_OBJECT (self), "da");
	  for (iter = self->_priv->icons; iter; iter = iter->next) 
	    {
	      GPEIconListItem *i = GPE_ICON_LIST_ITEM (iter->data);
	      g_object_unref (i);
	    }
	  
	  g_list_free (self->_priv->icons);
	  self->_priv->icons = NULL;
	  
	  gpe_iconlist__recalc_size (self, &da->allocation);
	}}
#line 1194 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 577 "gpeiconlist.gob"
void 
gpe_iconlist_set_icon_size (GPEIconList * self, guint size)
#line 1200 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::set_icon_size"
#line 577 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 577 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 1207 "gpe-iconlist.c"
{
#line 578 "gpeiconlist.gob"
	
	  GList *iter;
	  GtkWidget *da = g_object_get_data (G_OBJECT (self), "da");

	  for (iter = self->_priv->icons; iter; iter = iter->next) 
	    {
	      GPEIconListItem *i = GPE_ICON_LIST_ITEM (iter->data);
	      if (i->pb_scaled)
		gdk_pixbuf_unref (i->pb_scaled);
	      i->pb_scaled = NULL;
	    }
	  
	  self->_priv->icon_size = size;
	  
	  gpe_iconlist__recalc_size (self, &da->allocation);
	  
	  gtk_widget_draw (GTK_WIDGET (self), NULL);
	}}
#line 1228 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 597 "gpeiconlist.gob"
static void 
___19_gpe_iconlist_size_allocate (GtkWidget * self, GtkAllocation * allocation)
#line 1234 "gpe-iconlist.c"
#define PARENT_HANDLER(___self,___allocation) \
	{ if(GTK_WIDGET_CLASS(parent_class)->size_allocate) \
		(* GTK_WIDGET_CLASS(parent_class)->size_allocate)(___self,___allocation); }
{
#define __GOB_FUNCTION__ "GPE:IconList::size_allocate"
{
#line 600 "gpeiconlist.gob"
	
	  GPEIconList *il;
	  GtkWidget *da = g_object_get_data (G_OBJECT (self), "da");
	  il = GPE_ICONLIST(self);

	  if ((int)g_object_get_data (G_OBJECT(il), "size_x") == allocation->width &&
	      (int)g_object_get_data (G_OBJECT(il), "size_y") == allocation->height)
	    return;
	  
	  g_object_set_data (G_OBJECT(il), "size_x", (gpointer)allocation->width);
	  g_object_set_data (G_OBJECT(il), "size_y", (gpointer)allocation->height);
		
	  PARENT_HANDLER (self, allocation);
	  gpe_iconlist__recalc_size (il, &da->allocation);	//luc: recalc *after* the size is allocated :)
	}}
#line 1257 "gpe-iconlist.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 616 "gpeiconlist.gob"
static void 
gpe_iconlist__get_rowcol (GPEIconList * widget, int x, int y, int * col, int * row)
#line 1264 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::_get_rowcol"
{
#line 617 "gpeiconlist.gob"
	
	  *col = x / il_col_width (widget);
	  *row = y / il_row_height (widget);
	}}
#line 1273 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 622 "gpeiconlist.gob"
static void 
gpe_iconlist__refresh_containing (GPEIconList * widget, int col, int row)
#line 1279 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::_refresh_containing"
{
#line 623 "gpeiconlist.gob"
	
		int x, y;
		GtkWidget *w = GTK_WIDGET(gtk_object_get_data (GTK_OBJECT(widget), "da"));

		x=col * il_col_width (widget);
		y=row * il_row_height (widget);

		gtk_widget_queue_draw_area (w, x, y, il_col_width (widget), il_row_height (widget) + 5);
	}}
#line 1293 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 633 "gpeiconlist.gob"
static GPEIconListItem * 
gpe_iconlist__get_icon (GPEIconList * il, int col, int row)
#line 1299 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::_get_icon"
{
#line 634 "gpeiconlist.gob"
	
		int i;
		GList *icons;

		icons = il->_priv->icons;
		for (i=0;i<row*il->_priv->cols+col && icons;i++)
			icons = icons->next;

		return icons ? icons->data : NULL;

	}}
#line 1315 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 646 "gpeiconlist.gob"
static void 
gpe_iconlist__cancel_popup (GPEIconList * il)
#line 1321 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::_cancel_popup"
{
#line 647 "gpeiconlist.gob"
	
		if (il->_priv->popup_timeout != 0) {
			gtk_timeout_remove (il->_priv->popup_timeout);
			il->_priv->popup_timeout = 0;
		}
	}}
#line 1332 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 654 "gpeiconlist.gob"
static gint 
gpe_iconlist__button_release (GtkWidget * widget, GdkEventButton * event)
#line 1338 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::_button_release"
{
#line 655 "gpeiconlist.gob"
	
		GPEIconList *il;
		int row, col;

		il = GPE_ICONLIST(gtk_object_get_data (GTK_OBJECT(widget), "il"));

		gpe_iconlist__cancel_popup (il);

		gpe_iconlist__refresh_containing (il, il->_priv->mcol, il->_priv->mrow);

		gpe_iconlist__get_rowcol (il, event->x, event->y, &(col), &(row));
		if (col == il->_priv->mcol && row == il->_priv->mrow) {
			GPEIconListItem *data;
			data = gpe_iconlist__get_icon(il, il->_priv->mcol, il->_priv->mrow);
			il->_priv->mcol = il->_priv->mrow = -1;
			if (data) {
				gpe_icon_list_item_button_release (data, event);
				gpe_iconlist_clicked (il, data->udata);
			}
		} else
			il->_priv->mcol = il->_priv->mrow = -1;

		return TRUE;
	}}
#line 1367 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 680 "gpeiconlist.gob"
static gint 
gpe_iconlist__popup (gpointer data)
#line 1373 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::_popup"
{
#line 680 "gpeiconlist.gob"
	
		GPEIconList *il = data;
		int row, col;

		row = il->_priv->mrow;
		col = il->_priv->mcol;
		
		gpe_iconlist_show_popup(il, gpe_iconlist__get_icon(il,col, row)->udata);

		return FALSE;
	}}
#line 1389 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 692 "gpeiconlist.gob"
void 
gpe_iconlist_popup_removed (GPEIconList * self)
#line 1395 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::popup_removed"
#line 692 "gpeiconlist.gob"
	g_return_if_fail (self != NULL);
#line 692 "gpeiconlist.gob"
	g_return_if_fail (GPE_IS_ICONLIST (self));
#line 1402 "gpe-iconlist.c"
{
#line 692 "gpeiconlist.gob"
	
		int row, col;

		row = self->_priv->mrow;
		col = self->_priv->mcol;
		
		self->_priv->mcol = self->_priv->mrow = -1;

		gpe_iconlist__refresh_containing (self, col, row);
	}}
#line 1415 "gpe-iconlist.c"
#undef __GOB_FUNCTION__

#line 703 "gpeiconlist.gob"
static gint 
gpe_iconlist__button_press (GtkWidget * widget, GdkEventButton * event, gpointer user_data)
#line 1421 "gpe-iconlist.c"
{
#define __GOB_FUNCTION__ "GPE:IconList::_button_press"
{
#line 703 "gpeiconlist.gob"
	
		GPEIconList *il;
		GPEIconListItem *data;

		il = GPE_ICONLIST(gtk_object_get_data (GTK_OBJECT(widget), "il"));

		gpe_iconlist__get_rowcol (il, event->x, event->y, &(il->_priv->mcol), &(il->_priv->mrow));
		gpe_iconlist__refresh_containing (il, il->_priv->mcol, il->_priv->mrow);

		data = gpe_iconlist__get_icon(il, il->_priv->mcol, il->_priv->mrow);
		if (data) {
			gpe_icon_list_item_button_press (data, event);
			
			/* Register a popup if there is an icon under the cursor */
			il->_priv->popup_timeout = gtk_timeout_add (500, gpe_iconlist__popup, (gpointer)il);
		}

		return TRUE;
	}}
#line 1445 "gpe-iconlist.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___gpe_iconlist_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_clicked)();
	((void (*)(void))self_show_popup)();
	((void (*)(void))self_new)();
	((void (*)(void))self_set_bg)();
	((void (*)(void))self_set_bg_pixmap)();
	((void (*)(void))self_set_bg_color)();
	((void (*)(void))self__title_height)();
	((void (*)(void))self__check_icon_size)();
	((void (*)(void))self__expose)();
	((void (*)(void))self__recalc_size)();
	((void (*)(void))self_new_icon)();
	((void (*)(void))self_update_icon_item_with_udata)();
	((void (*)(void))self__find_from_udata)();
	((void (*)(void))self_remove_item_with_udata)();
	((void (*)(void))self_add_item)();
	((void (*)(void))self_add_item_pixbuf)();
	((void (*)(void))self_remove_item)();
	((void (*)(void))self_set_item_icon)();
	((void (*)(void))self_set_embolden)();
	((void (*)(void))self_set_show_title)();
	((void (*)(void))self_set_icon_xmargin)();
	((void (*)(void))self_clear)();
	((void (*)(void))self_set_icon_size)();
	((void (*)(void))self__get_rowcol)();
	((void (*)(void))self__refresh_containing)();
	((void (*)(void))self__get_icon)();
	((void (*)(void))self__cancel_popup)();
	((void (*)(void))self__button_release)();
	((void (*)(void))self__popup)();
	((void (*)(void))self_popup_removed)();
	((void (*)(void))self__button_press)();
	___gpe_iconlist_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */


#line 724 "gpeiconlist.gob"

link_warning (gpe_iconlist_update_icon_item_with_udata, "warning: gpe_iconlist_update_icon_item_with_udata is obsolete; use gpe_iconlist_set_item_icon instead.");
link_warning (gpe_iconlist_remove_item_with_udata, "warning: gpe_iconlist_remove_item_with_udata is obsolete; use gpe_iconlist_remove_item instead.");

#line 1500 "gpe-iconlist.c"
