/*
 * Copyright (C) 2003 Nils Faerber <nils@kernelconcepts.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>    
#include <string.h>
#include <sys/time.h>
#include <assert.h>
#include <libintl.h>

#include <gtk/gtk.h>

/* GPE specific */
#ifdef USE_GPE
#include <gpe/pixmaps.h>
#include <gpe/init.h>
#include <gpe/render.h>
#include <gpe/picturebutton.h>
#include <gpe/errorbox.h>
#include <gpe/gpetimesel.h>
#include <gpe/gpeclockface.h>
#endif


static struct gpe_icon my_icons[] = {
	{ NULL, NULL }
};


/* GTK UI */
GtkWidget *window;				/* Main window */
GtkStyle *style;
GtkObject *HourAdjuster, *MinuteAdjuster;

/* helper for i8n */
#define _(x) gettext(x)


static void
set_volume (GtkObject *o, void *t)
{
//  GtkAdjustment *a = GTK_ADJUSTMENT (o);

#ifdef DEBUG
  g_print("vol=(%d)%d\n", *(int *)t, volume);
#endif
}


static gboolean
button_press (GtkWidget *w, GdkEventButton *b, GpeTimeSel *sel)
{

	g_print("button release\n");
return FALSE;
}


static gboolean
button_release (GtkWidget *w, GdkEventButton *b, GpeTimeSel *sel)
{

	g_print("button release\n");
return FALSE;
}



int
main (int argc, char *argv[])
{
/* GTK Widgets */
GdkColor col;
gchar *color = "gray80";
GtkObject *hours, *minutes;
GtkWidget *clockface,*widget;
GtkWidget *hslider, *mslider;
GdkBitmap *bitmap;
GtkWidget *popup;

#ifdef USE_GPE
	if (gpe_application_init (&argc, &argv) == FALSE)
		exit (1);

	if (gpe_load_icons (my_icons) == FALSE)
		exit (1);
#else
	gtk_set_locale ();
	gtk_init (&argc, &argv);
#endif

	gdk_color_parse (color, &col);
  
	/* GTK Window stuff */
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (window), "Clock");
	gtk_window_set_default_size(GTK_WINDOW(window), 240, 240);
	gtk_widget_realize (window);
	// gdk_window_set_type_hint (window->window, GDK_WINDOW_TYPE_HINT_TOOLBAR);

	/* Destroy handler */
	g_signal_connect (G_OBJECT (window), "destroy",
			G_CALLBACK (gtk_main_quit), NULL);

#ifdef USE_GPE
	// gpe_set_window_icon (window, "icon");
#endif
#if 1
	widget=gtk_table_new(3,1,FALSE);
	gtk_container_add (GTK_CONTAINER (window), widget);
	gtk_widget_show(widget);

	hours = gtk_adjustment_new(1.0,0.0,23.0,1,15,1);
	minutes = gtk_adjustment_new(2.0,0.0,59.0,1,15,1);

	hslider = gtk_vscale_new (GTK_ADJUSTMENT (hours));
	mslider = gtk_vscale_new (GTK_ADJUSTMENT (minutes));

	gtk_table_attach(GTK_TABLE(widget), hslider, 2,3,0,1,(GtkAttachOptions) (GTK_FILL),(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	gtk_table_attach(GTK_TABLE(widget), mslider, 1,2,0,1,(GtkAttachOptions) (GTK_FILL),(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

	gtk_widget_show(hslider);
	gtk_widget_show(mslider);

	gtk_widget_realize(window);
	clockface = gpe_clock_face_new(GTK_ADJUSTMENT(hours), GTK_ADJUSTMENT(minutes), NULL);
	//gpe_clock_face_set_radius (clockface, 32);
	gpe_clock_face_set_do_grabs (GPE_CLOCK_FACE (clockface), FALSE);
	//gpe_clock_face_set_hand_width (GPE_CLOCK_FACE (clockface), 1.0);
	//gtk_container_add (GTK_CONTAINER (popup), clockface);
	gtk_table_attach(GTK_TABLE(widget), clockface, 0,1,0,1,(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	
	//gtk_widget_show (clockface);
	//gpe_clock_face_set_do_grabs (GPE_CLOCK_FACE (clockface), FALSE);

	g_signal_connect (G_OBJECT (clockface), "button_press_event", 
                        G_CALLBACK (button_press), NULL);
	g_signal_connect (G_OBJECT (clockface), "button_release_event", 
                        G_CALLBACK (button_release), NULL);

#else
	widget=gtk_table_new(1,1,TRUE);
	
	gtk_container_add (GTK_CONTAINER (window), widget);
	gtk_widget_show(widget);
	clockface=gpe_time_sel_new();
	gtk_table_attach(GTK_TABLE(widget), clockface, 1,2,1,2,(GtkAttachOptions) (GTK_FILL),(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	gtk_widget_show(clockface);
#endif
	gtk_widget_show_all (window);

	gtk_widget_show (window);
	gtk_main ();

return (0);
}
