/* RFC 2445 iCal Recurrence Rule Object
 * Copyright (C) 2004 Phil Blundell <pb@nexus.co.uk>
 *
 * $Id: mimedir-recurrence.h,v 1.1 2002/08/28 04:57:12 srittau Exp $
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "mimedir-recurrence-rule.h"


#ifndef _
#define _(x) (dgettext(GETTEXT_PACKAGE, (x)))
#endif


static void	 mimedir_recurrence_rule_class_init	(MIMEDirRecurrenceRuleClass	*klass);
static void	 mimedir_recurrence_rule_init		(MIMEDirRecurrenceRule		*recurrence);
static void	 mimedir_recurrence_rule_dispose	(GObject			*object);


struct _MIMEDirRecurrenceRulePriv {
	MIMEDirRecurrenceFrequency frequency;
	int interval;
};

static GObjectClass *parent_class = NULL;

/*
 * Class and Object Management
 */

GType
mimedir_recurrence_rule_get_type (void)
{
	static GType mimedir_recurrence_rule_type = 0;

	if (!mimedir_recurrence_rule_type) {
		static const GTypeInfo mimedir_recurrence_rule_info = {
			sizeof (MIMEDirRecurrenceRuleClass),
			NULL, /* base_init */
			NULL, /* base_finalize */
			(GClassInitFunc) mimedir_recurrence_rule_class_init,
			NULL, /* class_finalize */
			NULL, /* class_data */
			sizeof (MIMEDirRecurrenceRule),
			1,    /* n_preallocs */
			(GInstanceInitFunc) mimedir_recurrence_rule_init,
		};

		mimedir_recurrence_rule_type = g_type_register_static (G_TYPE_OBJECT,
								       "MIMEDirRecurrenceRule",
								       &mimedir_recurrence_rule_info,
								       0);
	}

	return mimedir_recurrence_rule_type;
}


static void
mimedir_recurrence_rule_class_init (MIMEDirRecurrenceRuleClass *klass)
{
	GObjectClass *gobject_class;

	g_return_if_fail (klass != NULL);
	g_return_if_fail (MIMEDIR_IS_RECURRENCE_RULE_CLASS (klass));

	gobject_class = G_OBJECT_CLASS (klass);

	gobject_class->dispose      = mimedir_recurrence_rule_dispose;

	parent_class = g_type_class_peek_parent (klass);
}


static void
mimedir_recurrence_rule_init (MIMEDirRecurrenceRule *rule)
{
	MIMEDirRecurrenceRulePriv *priv;

	g_return_if_fail (rule != NULL);
	g_return_if_fail (MIMEDIR_IS_RECURRENCE_RULE (rule));

	priv = g_new0 (MIMEDirRecurrenceRulePriv, 1);
	rule->priv = priv;
}


static void
mimedir_recurrence_rule_dispose (GObject *object)
{
	MIMEDirRecurrenceRule *rule;

	g_return_if_fail (object != NULL);
	g_return_if_fail (MIMEDIR_IS_RECURRENCE_RULE (object));

	rule = MIMEDIR_RECURRENCE_RULE (object);

	g_free (rule->priv);
	rule->priv = NULL;

	G_OBJECT_CLASS (parent_class)->dispose (object);
}

/*
 * Public Methods
 */

/**
 * mimedir_recurrence_rule_new:
 *
 * Creates a new iCal recurrence object.
 *
 * Return value: a new recurrence object
 **/
MIMEDirRecurrenceRule *
mimedir_recurrence_rule_new (void)
{
	MIMEDirRecurrenceRule *rule;

	rule = g_object_new (MIMEDIR_TYPE_RECURRENCE_RULE, NULL);

	return rule;
}

/**
 * mimedir_recurrence_rule_get_frequency:
 *
 * Retrieves the base frequency for the corresponding recurrence object.
 *
 * Return value: a #MIMEDirRecurrenceFrequency
 **/
MIMEDirRecurrenceFrequency
mimedir_recurrence_rule_get_frequency (MIMEDirRecurrenceRule *rule)
{
	g_return_val_if_fail (MIMEDIR_IS_RECURRENCE_RULE (rule), 0);

	return rule->priv->frequency;
}

/**
 * mimedir_recurrence_rule_get_interval:
 *
 * Retrieves the interval for the corresponding recurrence object.
 *
 * Return value: an #int
 **/
int
mimedir_recurrence_rule_get_interval (MIMEDirRecurrenceRule *rule)
{
	g_return_val_if_fail (MIMEDIR_IS_RECURRENCE_RULE (rule), 0);

	return rule->priv->interval;
}
