/* RFC 2445 iCal Recurrence Rule Object
 * Copyright (C) 2004 Phil Blundell <pb@nexus.co.uk>
 *
 * $Id: mimedir-recurrence.h,v 1.1 2002/08/28 04:57:12 srittau Exp $
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __MIMEDIR_RECURRENCE_RULE_H__
#define __MIMEDIR_RECURRENCE_RULE_H__

#include <glib.h>
#include <glib-object.h>

#include "mimedir/mimedir-datetime.h"

#define MIMEDIR_TYPE_RECURRENCE_RULE		(mimedir_recurrence_get_type())
#define MIMEDIR_RECURRENCE_RULE(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), MIMEDIR_TYPE_RECURRENCE_RULE, MIMEDirRecurrenceRule))
#define MIMEDIR_RECURRENCE_RULE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), MIMEDIR_TYPE_RECURRENCE_RULE, MIMEDirRecurrenceRuleClass))
#define MIMEDIR_IS_RECURRENCE_RULE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), MIMEDIR_TYPE_RECURRENCE_RULE))
#define MIMEDIR_IS_RECURRENCE_RULE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), MIMEDIR_TYPE_RECURRENCE_RULE))

typedef struct _MIMEDirRecurrenceRule		MIMEDirRecurrenceRule;
typedef struct _MIMEDirRecurrenceRulePriv	MIMEDirRecurrenceRulePriv;
typedef struct _MIMEDirRecurrenceRuleClass	MIMEDirRecurrenceRuleClass;

typedef enum {
	MIMEDIR_RECURRENCE_RULE_SECONDLY,
	MIMEDIR_RECURRENCE_RULE_MINUTELY,
	MIMEDIR_RECURRENCE_RULE_HOURLY,
	MIMEDIR_RECURRENCE_RULE_DAILY,
	MIMEDIR_RECURRENCE_RULE_WEEKLY,
	MIMEDIR_RECURRENCE_RULE_MONTHLY,
	MIMEDIR_RECURRENCE_RULE_YEARLY,
} MIMEDirRecurrenceFrequency;

struct _MIMEDirRecurrenceRule
{
	GObject parent;

	MIMEDirRecurrenceRulePriv *priv;
};

struct _MIMEDirRecurrenceRuleClass
{
	GObjectClass parent_class;
};

MIMEDirRecurrenceFrequency	mimedir_recurrence_rule_get_frequency (MIMEDirRecurrenceRule *);
int				mimedir_recurrence_rule_get_interval (MIMEDirRecurrenceRule *);
int				mimedir_recurrence_rule_get_count (MIMEDirRecurrenceRule *);
MIMEDirDateTime		       *mimedir_recurrence_rule_get_end_date (MIMEDirRecurrenceRule *);

void				mimedir_recurrence_rule_set (MIMEDirRecurrenceRule *,
							     MIMEDirRecurrenceFrequency freq,
							     int interval);

GType				mimedir_recurrence_rule_get_type		(void);
MIMEDirRecurrenceRule	       *mimedir_recurrence_rule_new			(void);

#endif

