/****************************************************************************/
/* Copyright 1999 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/

#ifndef _itsyethdat_h_
#define _itsyethdat_h_

// ItsyEthSetUINT_OID - ItsyEthSetUINT_OID
// A UINT to set
#define ItsyEthSetUINT_OIDGuid \
    { 0x58259380,0x433d,0x11d3, { 0xb6,0x41,0x00,0x00,0xf8,0xe2,0x2f,0x6b } }

DEFINE_GUID(ItsyEthSetUINT_OID_GUID, \
            0x58259380,0x433d,0x11d3,0xb6,0x41,0x00,0x00,0xf8,0xe2,0x2f,0x6b);


typedef struct _ItsyEthSetUINT_OID
{
    // Set this UINT then query it.
    ULONG ItsyEthSetUINT_OID;
    #define ItsyEthSetUINT_OID_ItsyEthSetUINT_OID_SIZE sizeof(ULONG)
    #define ItsyEthSetUINT_OID_ItsyEthSetUINT_OID_ID 1

} ItsyEthSetUINT_OID, *PItsyEthSetUINT_OID;

// ItsyEthQueryUINT_OID - ItsyEthQueryUINT_OID
// A UINT to Query
#define ItsyEthQueryUINT_OIDGuid \
    { 0x58259381,0x433d,0x11d3, { 0xb6,0x41,0x00,0x00,0xf8,0xe2,0x2f,0x6b } }

DEFINE_GUID(ItsyEthQueryUINT_OID_GUID, \
            0x58259381,0x433d,0x11d3,0xb6,0x41,0x00,0x00,0xf8,0xe2,0x2f,0x6b);


typedef struct _ItsyEthQueryUINT_OID
{
    // Query this UINT and get back the set UINT + 1.
    ULONG ItsyEthQueryUINT_OID;
    #define ItsyEthQueryUINT_OID_ItsyEthQueryUINT_OID_SIZE sizeof(ULONG)
    #define ItsyEthQueryUINT_OID_ItsyEthQueryUINT_OID_ID 1

} ItsyEthQueryUINT_OID, *PItsyEthQueryUINT_OID;

// ItsyEthQueryArrayOID - ItsyEthQueryArrayOID
// An Array to query (should be 4 bytes of MAC address)
#define ItsyEthQueryArrayOIDGuid \
    { 0x58259382,0x433d,0x11d3, { 0xb6,0x41,0x00,0x00,0xf8,0xe2,0x2f,0x6b } }

DEFINE_GUID(ItsyEthQueryArrayOID_GUID, \
            0x58259382,0x433d,0x11d3,0xb6,0x41,0x00,0x00,0xf8,0xe2,0x2f,0x6b);


typedef struct _ItsyEthQueryArrayOID
{
    // Number of array elements.
    ULONG NumberElements;
    #define ItsyEthQueryArrayOID_NumberElements_SIZE sizeof(ULONG)
    #define ItsyEthQueryArrayOID_NumberElements_ID 1

    // Query this array to get 4 bytes of MAC address.
    UCHAR ItsyEthQueryArray[1];
    #define ItsyEthQueryArrayOID_ItsyEthQueryArray_ID 2

} ItsyEthQueryArrayOID, *PItsyEthQueryArrayOID;

// ItsyEthQueryStringOID - ItsyEthQueryStringOID
// An ANSI string to Query
#define ItsyEthQueryStringOIDGuid \
    { 0x58259383,0x433d,0x11d3, { 0xb6,0x41,0x00,0x00,0xf8,0xe2,0x2f,0x6b } }

DEFINE_GUID(ItsyEthQueryStringOID_GUID, \
            0x58259383,0x433d,0x11d3,0xb6,0x41,0x00,0x00,0xf8,0xe2,0x2f,0x6b);


typedef struct _ItsyEthQueryStringOID
{
    // Query this to get an ANSI string back (it will be the VENDORDESCRIPTOR string).
    CHAR VariableData[1];
    #define ItsyEthQueryStringOID_ItsyEthQueryStringOID_ID 1

} ItsyEthQueryStringOID, *PItsyEthQueryStringOID;

#endif
