/****************************************************************************/
/* Copyright 1999 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/

/****************************************************************************
** COPYRIGHT (C) 1994-1997 INTEL CORPORATION                               **
** DEVELOPED FOR MICROSOFT BY INTEL CORP., HILLSBORO, OREGON               **
** HTTP://WWW.INTEL.COM/                                                   **
** THIS FILE IS PART OF THE INTEL ETHEREXPRESS PRO/100B(TM) AND            **
** ETHEREXPRESS PRO/100+(TM) NDIS 5.0 MINIPORT SAMPLE DRIVER               **
****************************************************************************/

/****************************************************************************
Module Name:
    ItsyEthpr.h

This driver runs on the following hardware:
    - 82557/82558 based PCI 10/100Mb ethernet adapters
    (aka Intel EtherExpress(TM) PRO Adapters)

Environment:
    Kernel Mode - Or whatever is the equivalent on WinNT

Revision History
    - JCB 8/14/97 Example Driver Created
*****************************************************************************/

#ifndef _ITSYETHPR_H
#define _ITSYETHPR_H

//
// We define the external interfaces to the ItsyEth driver.
// These routines are only external to permit separate
// compilation.  Given a truely fast compiler they could
// all reside in a single file and be static.
//


// =============================================
// Routines in ItsyEth.c
// =============================================

VOID
SoftwareReset(
              IN PItsyEth_ADAPTER Adapter
              );

NTSTATUS
DriverEntry(
            IN PDRIVER_OBJECT DriverObject,
            IN PUNICODE_STRING RegistryPath
            );

BOOLEAN
ItsyEthCheckForHang(
                 IN NDIS_HANDLE MiniportAdapterContext
                 );

VOID
ItsyEthHalt(
         IN  NDIS_HANDLE MiniportAdapterContext
         );

VOID
ItsyEthShutdownHandler(
                    IN  NDIS_HANDLE MiniportAdapterContext
                    );

NTSTATUS
ItsyEth_StartDevice(
	IN  PDEVICE_OBJECT DeviceObject,
	IN  PDEVICE_OBJECT NextDeviceObject,
	OUT PITSYETH_WDM_HANDLE *WdmHandle
    );

NTSTATUS
ItsyEth_RemoveDevice(
    IN  PITSYETH_WDM_HANDLE *WdmHandle
    );

NDIS_STATUS
ItsyEthInitialize(
               OUT PNDIS_STATUS OpenErrorStatus,
               OUT PUINT SelectedMediumIndex,
               IN PNDIS_MEDIUM MediumArray,
               IN UINT MediumArraySize,
               IN NDIS_HANDLE MiniportAdapterHandle,
               IN NDIS_HANDLE WrapperConfigurationContext
               );

NDIS_STATUS
ItsyEthReset(
          OUT PBOOLEAN AddressingReset,
          IN  NDIS_HANDLE MiniportAdapterContext
          );

VOID
ItsyEthReturnPackets(
                       IN NDIS_HANDLE  MiniportAdapterContext,
                       IN PNDIS_PACKET Packet
                       );

VOID
ItsyEthAllocateComplete(NDIS_HANDLE MiniportAdapterContext,
                     IN PVOID VirtualAddress,
                     IN PNDIS_PHYSICAL_ADDRESS PhysicalAddress,
                     IN ULONG Length,
                     IN PVOID Context);


VOID
ItsyEthResetComplete(PVOID sysspiff1,
                  NDIS_HANDLE MiniportAdapterContext,
                  PVOID sysspiff2, PVOID sysspiff3);

VOID
ItsyEth_DriverInit(
    IN PDRIVER_OBJECT DriverObject
    );


// =============================================
// Routines in request.c
// =============================================

NDIS_STATUS
ItsyEthChangeMCAddresses(
                      IN PItsyEth_ADAPTER Adapter,
                      IN UINT AddressCount
                      );


NDIS_STATUS
ItsyEthSetInformation(
                   IN NDIS_HANDLE MiniportAdapterContext,
                   IN NDIS_OID Oid,
                   IN PVOID InformationBuffer,
                   IN ULONG InformationBufferLength,
                   OUT PULONG BytesRead,
                   OUT PULONG BytesNeeded
                   );

NDIS_STATUS
ItsyEthQueryInformation(
                     IN NDIS_HANDLE MiniportAdapterContext,
                     IN NDIS_OID Oid,
                     IN PVOID InformationBuffer,
                     IN ULONG InformationBufferLength,
                     OUT PULONG BytesWritten,
                     OUT PULONG BytesNeeded
                     );

// =============================================
// routines in send.c
// =============================================
VOID
ItsyEthMultipleSend(
                 IN  NDIS_HANDLE             MiniportAdapterContext,
                 IN  PPNDIS_PACKET           PacketArray,
                 IN  UINT                    NumberOfPackets
                 );

VOID
ItsyEthCopyFromPacketToBuffer(
                           IN PItsyEth_ADAPTER Adapter,
                           IN PNDIS_PACKET Packet,
                           IN UINT BytesToCopy,
                           IN PCHAR DestBuffer,
                           IN PNDIS_BUFFER FirstBuffer,
                           OUT PUINT BytesCopied
                           );

BOOLEAN
ProcessTXInterrupt(
                   IN OUT PItsyEth_ADAPTER Adapter
                   );

NDIS_STATUS
SetupNextSend(PItsyEth_ADAPTER Adapter,
              PNDIS_PACKET Packet);

void
ItsyEth_Send(PITSYETH_WDM_HANDLE WdmHandle,
			 PITSYETH_FRAME_HANDLE FrameHandle, 
			 VOID (*Callback)(PVOID, PVOID, int), 
			 PVOID Arg1,
			 PVOID Arg2);

//BOOLEAN
//PrepareForTransmit(PItsyEth_ADAPTER Adapter,
//                   PNDIS_PACKET Packet,
//                   PItsyEthSwTcb SwTcb);



VOID
ItsyEthInitialiseRecvQueue(PItsyEth_ADAPTER Adapter);

VOID
ItsyEthStartReceive(PItsyEth_ADAPTER Adapter);

// =============================================
// routines in parse.c
// =============================================

NDIS_STATUS
ParseRegistryParameters(
                        IN PItsyEth_ADAPTER Adapter,
                        IN NDIS_HANDLE ConfigHandle
                        );

#endif  //_ITSYETHPR_H

