/****************************************************************************/
/* Copyright 1999 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/

/****************************************************************************
Module Name:
    ItsyEthsw.h

This driver runs on the following hardware:
    - Itsy Ethernet/USB

Environment:
    Kernel Mode - Or whatever is the equivalent on WinNT

Revision History
    - JCB 8/14/97 Example Driver Created
*****************************************************************************/


#ifndef _ITSYETHSW_
#define _ITSYETHSW_

#include "itsyethcom.h"

#define ITSYETH_NDIS_MAJOR_VERSION        0x5
#define ITSYETH_NDIS_MINOR_VERSION        0x0

#define ITSYETH_DRIVER_VERSION ((ITSYETH_NDIS_MAJOR_VERSION*0x100) + ITSYETH_NDIS_MINOR_VERSION)

//- Driver defaults
#define     LOOKAHEAD_SIZE      222

//- Ethernet 14-byte Header
typedef struct _ETH_HEADER_STRUCT {
    UCHAR       Destination[ETHERNET_ADDRESS_LENGTH];
    UCHAR       Source[ETHERNET_ADDRESS_LENGTH];
    USHORT      TypeLength;
} ETH_HEADER_STRUCT, *PETH_HEADER_STRUCT;

#define ETHARP 0x0608

//- Size of the Ethernet Header
#define ENET_HEADER_SIZE       sizeof(ETH_HEADER_STRUCT)

//-------------------------------------------------------------------------
// Itsy Ethernet _LIST_ENTRY
//-------------------------------------------------------------------------
typedef struct _ITSYETH_LIST_ENTRY {

    LIST_ENTRY  Link;

} ITSYETH_LIST_ENTRY, *PITSYETH_LIST_ENTRY;

//-------------------------------------------------------------------------
// This macro might be used to debug spinlock acquires and releases
// with the NdisAcquireSpinlock() and NdisReleaseSpinlock() call
// it aligns itself over 8 dwords, making reading in the debugger
// easy. Beware the NdisGetTime call sometimes returns the same
// value... when called in close proximity to each other...
// you might have a macro that replaced spinlock calls with some
// fill in of this structure and then acquire/release the spinlock
//-------------------------------------------------------------------------
#if DBG
typedef struct _ItsyEthSpinDebug
{
    // 8 dwords total (hopefully) trying to debug a spin lock problem
    USHORT      action;
    USHORT      line;
    ULONG       file;
    LARGE_INTEGER    time;
    //    LONGLONG    blank;
} ItsyEthSpinDebug, *PItsyEthSpinDebug;
#endif

//-------------------------------------------------------------------------
// ItsyEth_ADAPTER
//
//  The main Adapter structure definition. This structure has all fields
//  relevant to the hardware.
//-------------------------------------------------------------------------
typedef struct _ItsyEth_ADAPTER
{
#if DBG
    UINT                Debug;
    USHORT              txsent;
    USHORT              txind;
    UINT    sdebugindex;

#define DBG_QUEUE_LEN      4095   //0xfff
    UINT                DbgIndex;
    UCHAR               DbgQueue[DBG_QUEUE_LEN];
    UINT IndicateReceivePacketCounter;
    UINT PacketsIndicated;
    UINT ReceiveCompleteCounter;
#endif

    // the pointer to the first packet we have queued in send
    // deserialized miniport support variables
    PNDIS_PACKET        FirstTxQueue;
    PNDIS_PACKET        LastTxQueue;
    UINT                NumPacketsQueued;

	NDIS_HANDLE        RecvPacketPool;
	NDIS_HANDLE        RecvBufferPool;
	PNDIS_PACKET        RecvPacket;
    PITSYETH_FRAME_HANDLE RecvFrame;
	PCHAR  RecvVA;

    // Handle given by NDIS when the Adapter registered itself.
    NDIS_HANDLE         ItsyEthAdapterHandle;

    UCHAR               NodeAddress[ETH_LENGTH_OF_ADDRESS];
	UCHAR               DevAddress[ETH_LENGTH_OF_ADDRESS];
    UCHAR               PermanentNodeAddress[ETH_LENGTH_OF_ADDRESS];
	UINT                LineSpeedCur;

    // This variable should be initialized to false, and set to true
    // to prevent re-entrancy in our driver during reset spinlock and unlock
    // stuff related to checking our link status
    BOOLEAN             ResetInProgress;    

    NDIS_MEDIA_STATE    LinkIsActive;

    // The Current Global Packet Filter and look ahead size.
    ULONG               PacketFilter;
    UINT                LookAhead;

    // Packet counts
    UINT                GoodTransmits;
    UINT                GoodReceives;
    UINT                NumTxSinceLastAdjust;

    // Count of transmit errors
    UINT                TxAbortExcessCollisions;
    UINT                TxLateCollisions;
    UINT                TxDmaUnderrun;
    UINT                TxLostCRS;
    UINT                TxOKButDeferred;
    UINT                OneRetry;
    UINT                MoreThanOneRetry;
    UINT                TotalRetries;

    // Count of receive errors
    UINT                RcvCrcErrors;
    UINT                RcvAlignmentErrors;
    UINT                RcvResourceErrors;
    UINT                RcvDmaOverrunErrors;
    UINT                RcvCdtFrames;
    UINT                RcvRuntErrors;

    NDIS_SPIN_LOCK      Lock;

    NDIS_DEVICE_POWER_STATE CurrentPowerState;
    NDIS_DEVICE_POWER_STATE NextPowerState;

	PITSYETH_WDM_HANDLE WdmHandle;
} ItsyEth_ADAPTER, *PItsyEth_ADAPTER;

//-------------------------------------------------------------------------
// Miniport and MAC specific Defines
//-------------------------------------------------------------------------
typedef struct _ItsyEth_RESERVED {

    // next packet in the chain of queued packets being allocated,
    // or waiting for the finish of transmission.
    //
    // We always keep the packet on a list so that in case the
    // the adapter is closing down or resetting, all the packets
    // can easily be located and "canceled".
    //
    PNDIS_PACKET Next;
} ItsyEth_RESERVED,*PItsyEth_RESERVED;

#define PItsyEth_RESERVED_FROM_PACKET(_Packet) \
    ((PItsyEth_RESERVED)((_Packet)->MiniportReserved))

#define EnqueuePacket(_Head, _Tail, _Packet)           \
{                                                      \
    if (!_Head) {                                      \
    _Head = _Packet;                                   \
    } else {                                           \
    PItsyEth_RESERVED_FROM_PACKET(_Tail)->Next = _Packet; \
}                                                      \
    PItsyEth_RESERVED_FROM_PACKET(_Packet)->Next = NULL;  \
    _Tail = _Packet;                                   \
}

#define DequeuePacket(Head, Tail)                      \
{                                                      \
    PItsyEth_RESERVED Reserved =                          \
    PItsyEth_RESERVED_FROM_PACKET(Head);                  \
    if (!Reserved->Next) {                             \
    Tail = NULL;                                       \
    }                                                  \
    Head = Reserved->Next;                             \
}

//Given a MiniportContextHandle return the PItsyEth_ADAPTER it represents.
#define PITSYETH_ADAPTER_FROM_CONTEXT_HANDLE(Handle) ((PItsyEth_ADAPTER)(Handle))

//================================================
// Global Variables shared by all driver instances
//================================================

// arrange this any way you want, but it can't add up to more
// than regparam NUMRFD + MAX_RECEIVE_DESCRIPTORS,
// total max is 1024 OR 0X400 right now
static const UINT packet_count[NUM_RMD] =
    {0x10,0x20,0x30,0x40,0x50,0x20,0x20,0x20,0x20,0x20};

// This constant is used for places where NdisAllocateMemory needs to be
// called and the HighestAcceptableAddress does not matter.
static const NDIS_PHYSICAL_ADDRESS HighestAcceptableMax =
    NDIS_PHYSICAL_ADDRESS_CONST(-1,-1);

#endif /* _ItsyEthSW_ */

