/**
 * 21285bs.h provides procedures to access the pins in the 21285 scanring.
 */

#include <stdio.h>
#include <assert.h>
#include "library\PCI.h"
#include "bscan.h"
#include "21285bs.h"
#include "sa110bs.h"

struct Scanring *skfmlbsr = NULL;

struct Scanring *corelogicScanring = 0L;
ScanCell corelogicScanCells[] =
{
 {   0, BC_4, "BA1",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {   1, BC_1, "BA1",         OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {   2, BC_4, "BA0",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {   3, BC_1, "BA0",         OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {   4, BC_4, "MA12",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {   5, BC_1, "MA12",        OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {   6, BC_4, "MA11",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {   7, BC_1, "MA11",        OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {   8, BC_4, "MA10",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {   9, BC_1, "MA10",        OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {  10, BC_4, "MA9",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  11, BC_1, "MA9",         OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {  12, BC_4, "MA8",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  13, BC_1, "MA8",         OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {  14, BC_4, "MA7",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  15, BC_1, "MA7",         OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {  16, BC_4, "MA6",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  17, BC_1, "MA6",         OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {  18, BC_4, "MA5",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  19, BC_1, "MA5",         OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {  20, BC_4, "MA4",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  21, BC_1, "MA4",         OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {  22, BC_4, "MA3",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  23, BC_1, "MA3",         OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {  24, BC_4, "MA2",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  25, BC_1, "MA2",         OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {  26, BC_4, "MA1",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  27, BC_1, "MA1",         OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {  28, BC_4, "MA0",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  29, BC_1, "MA0",         OUTPUT3_CELL,      X,   30,   1, Z_STATE     },
 {  30, BC_2, "MA_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 {  31, BC_4, "IRQ_IN_L3",   INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  32, BC_4, "IRQ_IN_L2",   INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  33, BC_4, "IRQ_IN_L1",   INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  34, BC_4, "IRQ_IN_L0",   INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  35, BC_4, "INTERNAL0",        INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 {  36, BC_1, "CS_L3",       OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 {  37, BC_4, "INTERNAL1",          INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 {  38, BC_1, "CS_L2",       OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 {  39, BC_4, "INTERNAL2",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 {  40, BC_1, "CS_L1",       OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 {  41, BC_4, "INTERNAL3",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 {  42, BC_1, "CS_L0",       OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 {  43, BC_4, "INTERNAL4",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 {  44, BC_1, "D_WREN_L",      OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 {  45, BC_4, "INTERNAL5",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 {  46, BC_1, "CMD2",        OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 {  47, BC_4, "INTERNAL6",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 {  48, BC_1, "CMD1",        OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 {  49, BC_4, "INTERNAL7",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 {  50, BC_1, "CMD0",        OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 {  51, BC_2, "XOIW_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 {  52, BC_2, "ROM_CE_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 {  53, BC_4, "INTERNAL10",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 {  54, BC_1, "ROM_CE_L",      OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 {  55, BC_4, "SCAN_EN",       INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  56, BC_4, "XIOW_L",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  57, BC_1, "XIOW_L",        OUTPUT3_CELL,      X,  51,   1, Z_STATE      },
 {  58, BC_4, "XIOR_L",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  59, BC_1, "XIOR_L",        OUTPUT3_CELL,      X,  51,   1, Z_STATE      },
 {  60, BC_4, "XD_WREN_L",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  61, BC_1, "XD_WREN_L",     OUTPUT3_CELL,      X,  51,   1, Z_STATE      },
 {  62, BC_4, "XCS_L2",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  63, BC_1, "XCS_L2",      OUTPUT3_CELL,      X,  70,   1, Z_STATE      },
 {  64, BC_4, "XCS_L1",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  65, BC_1, "XCS_L1",      OUTPUT3_CELL,      X,  69,   1, Z_STATE      },
 {  66, BC_4, "XCS_L0",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  67, BC_1, "XCS_L0",      OUTPUT3_CELL,      X,   68,   1, Z_STATE     },
 {  68, BC_2, "XCS0_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 {  69, BC_2, "XCS1_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 {  70, BC_2, "XCS2_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 {  71, BC_4, "RX",            INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  72, BC_4, "INTERNAL11",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 {  73, BC_1, "TX",            OUTPUT2_CELL,      X,   -1,   X, IN_STATE    },
 {  74, BC_4, "INTERNAL12",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 {  75, BC_1, "PCI_GNT_L",     OUTPUT3_CELL,      X,  76,   1, Z_STATE      },
 {  76, BC_2, "PCI_GNT_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 {  77, BC_4, "PCI_REQ_L",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  78, BC_4, "PCI_RST_L",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  79, BC_1, "PCI_RST_L",     OUTPUT3_CELL,      X,  80,   1, Z_STATE      },
 {  80, BC_2, "PCI_RST_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 {  81, BC_4, "PCI_CLK_INVERTED",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 {  82, BC_4, "GNT_L",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  83, BC_4, "REQ_L",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  84, BC_1, "REQ_L",         OUTPUT3_CELL,      X,  85,   1, Z_STATE      },
 {  85, BC_2, "REQ_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 {  86, BC_4, "AD31",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  87, BC_1, "AD31",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 {  88, BC_4, "AD30",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  89, BC_1, "AD30",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 {  90, BC_4, "AD29",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  91, BC_1, "AD29",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 {  92, BC_4, "AD28",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  93, BC_1, "AD28",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 {  94, BC_4, "AD27",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  95, BC_1, "AD27",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 {  96, BC_4, "AD26",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  97, BC_1, "AD26",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 {  98, BC_4, "AD25",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 {  99, BC_1, "AD25",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 { 100, BC_4, "AD24",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 101, BC_1, "AD24",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 { 102, BC_4, "CBE_L3",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 103, BC_1, "CBE_L3",      OUTPUT3_CELL,      X,  171,   1, Z_STATE     },
 { 104, BC_4, "IDSEL",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 105, BC_4, "AD23",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 106, BC_1, "AD23",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 { 107, BC_4, "AD22",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 108, BC_1, "AD22",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 { 109, BC_4, "AD21",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 110, BC_1, "AD21",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 { 111, BC_4, "AD20",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 112, BC_1, "AD20",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 { 113, BC_4, "AD19",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 114, BC_1, "AD19",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 { 115, BC_4, "AD18",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 116, BC_1, "AD18",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 { 117, BC_4, "AD17",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 118, BC_1, "AD17",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 { 119, BC_4, "AD16",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 120, BC_1, "AD16",        OUTPUT3_CELL,      X,  121,   1, Z_STATE     },
 { 121, BC_2, "AD_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 122, BC_4, "CBE_L2",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 123, BC_1, "CBE_L2",      OUTPUT3_CELL,      X,  171,   1, Z_STATE     },
 { 124, BC_4, "FRAME_L",       INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 125, BC_1, "FRAME_L",       OUTPUT3_CELL,      X,  126,   1, Z_STATE     },
 { 126, BC_2, "FRAME_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 127, BC_4, "IRDY_L",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 128, BC_1, "IRDY_L",        OUTPUT3_CELL,      X,  129,   1, Z_STATE     },
 { 129, BC_2, "IRDY_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 130, BC_4, "TRDY_L",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 131, BC_1, "TRDY_L",        OUTPUT3_CELL,      X,  132,   1, Z_STATE     },
 { 132, BC_2, "TRDY_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 133, BC_4, "DEVSEL_L",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 134, BC_1, "DEVSEL_L",      OUTPUT3_CELL,      X,  132,   1, Z_STATE     },
 { 135, BC_4, "STOP_L",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 136, BC_1, "STOP_L",        OUTPUT3_CELL,      X,  132,   1, Z_STATE     },
 { 137, BC_4, "PCI_CFN",       INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 138, BC_4, "PERR_L",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 139, BC_1, "PERR_L",        OUTPUT3_CELL,      X,  140,   1, Z_STATE     },
 { 140, BC_2, "PERR_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 141, BC_4, "SERR_L",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 142, BC_1, "SERR_L",        OUTPUT3_CELL,      X,  143,   1, Z_STATE     },
 { 143, BC_2, "SERR_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 144, BC_4, "PAR",           INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 145, BC_1, "PAR",           OUTPUT3_CELL,      X,  146,   1, Z_STATE     },
 { 146, BC_2, "PAR_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 147, BC_4, "CBE_L1",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 148, BC_1, "CBE_L1",      OUTPUT3_CELL,      X,  171,   1, Z_STATE     },
 { 149, BC_4, "AD15",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 150, BC_1, "AD15",        OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 151, BC_2, "AD_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 152, BC_4, "AD14",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 153, BC_1, "AD14",        OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 154, BC_4, "AD13",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 155, BC_1, "AD13",        OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 156, BC_4, "AD12",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 157, BC_1, "AD12",        OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 158, BC_4, "AD11",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 159, BC_1, "AD11",        OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 160, BC_4, "AD10",        INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 161, BC_1, "AD10",        OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 162, BC_4, "AD9",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 163, BC_1, "AD9",         OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 164, BC_4, "AD8",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 165, BC_1, "AD8",         OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 166, BC_4, "PCI_IRQ_L",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 167, BC_1, "PCI_IRQ_L",     OUTPUT3_CELL,      X,  168,   1, Z_STATE     },
 { 168, BC_2, "PCI_IRQ_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 169, BC_4, "CBE_L0",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 170, BC_1, "CBE_L0",      OUTPUT3_CELL,      X,  171,    1,Z_STATE     },
 { 171, BC_2, "CBE_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 172, BC_4, "AD7",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 173, BC_1, "AD7",         OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 174, BC_4, "AD6",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 175, BC_1, "AD6",         OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 176, BC_4, "AD5",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 177, BC_1, "AD5",         OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 178, BC_4, "AD4",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 179, BC_1, "AD4",         OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 180, BC_4, "AD3",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 181, BC_1, "AD3",         OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 182, BC_4, "AD2",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 183, BC_1, "AD2",         OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 184, BC_4, "AD1",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 185, BC_1, "AD1",         OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 186, BC_4, "AD0",         INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 187, BC_1, "AD0",         OUTPUT3_CELL,      X,  151,   1, Z_STATE     },
 { 188, BC_4, "VIO_INTERNAL",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 { 189, BC_4, "VIO_INTERNAL",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 { 190, BC_1, "NIRQ",      OUTPUT3_CELL,      X,   52,   1, Z_STATE     },
 { 191, BC_4, "INTERNAL14",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 { 192, BC_1, "NFIQ",      OUTPUT3_CELL,      X,   52,   1, Z_STATE     },
 { 193, BC_4, "NRESET",    INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 194, BC_2, "NRESET_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 195, BC_1, "NRESET",    OUTPUT3_CELL,      X,  194,   1, Z_STATE     },
 { 196, BC_4, "A31",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 197, BC_1, "A31",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 198, BC_4, "A30",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 199, BC_1, "A30",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 200, BC_4, "A29",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 201, BC_1, "A29",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 202, BC_4, "A28",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 203, BC_1, "A28",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 204, BC_4, "A27",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 205, BC_1, "A27",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 206, BC_4, "A26",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 207, BC_1, "A26",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 208, BC_4, "A25",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 209, BC_1, "A25",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 210, BC_4, "A24",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 211, BC_1, "A24",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 212, BC_4, "A23",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 213, BC_1, "A23",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 214, BC_4, "A22",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 215, BC_1, "A22",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 216, BC_4, "A21",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 217, BC_1, "A21",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 218, BC_4, "A20",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 219, BC_1, "A20",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 220, BC_4, "A19",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 221, BC_1, "A19",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 222, BC_4, "A18",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 223, BC_1, "A18",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 224, BC_4, "A17",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 225, BC_1, "A17",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 226, BC_4, "A16",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 227, BC_1, "A16",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 228, BC_4, "A15",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 229, BC_1, "A15",     OUTPUT3_CELL,      X,  265,   1, Z_STATE     },
 { 230, BC_4, "A14",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 231, BC_1, "A14",     OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 232, BC_4, "A13",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 233, BC_1, "A13",     OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 234, BC_4, "A12",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 235, BC_1, "A12",     OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 236, BC_4, "A11",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 237, BC_1, "A11",     OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 238, BC_4, "A10",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 239, BC_1, "A10",     OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 240, BC_4, "A9",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 241, BC_1, "A9",      OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 242, BC_4, "A8",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 243, BC_1, "A8",      OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 244, BC_4, "A7",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 245, BC_1, "A7",      OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 246, BC_4, "A6",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 247, BC_1, "A6",      OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 248, BC_4, "A5",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 249, BC_1, "A5",      OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 250, BC_4, "A4",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 251, BC_1, "A4",      OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 252, BC_4, "A3",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 253, BC_1, "A3",      OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 254, BC_4, "A2",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 255, BC_1, "A2",      OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 256, BC_4, "A1",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 257, BC_1, "A1",      OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 258, BC_4, "A0",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 259, BC_1, "A0",      OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 260, BC_4, "MAS1",    INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 261, BC_1, "MAS0",    OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 262, BC_1, "MAS1",    OUTPUT3_CELL,      X,  264,   1, Z_STATE     },
 { 263, BC_4, "MAS0",    INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 264, BC_2, "A_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 265, BC_2, "A_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 266, BC_4, "INTERNAL15",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 { 267, BC_1, "ABE",       OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 { 268, BC_4, "NRW",       INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 269, BC_4, "LOCK",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 270, BC_4, "CLF",       INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 271, BC_1, "OSC",       INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 272, BC_4, "FCLK_INVERTED",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 { 273, BC_4, "NMREQ",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 274, BC_4, "INTERNAL17",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 { 275, BC_1, "DQM3",    OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 { 276, BC_4, "PARITY3", INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 277, BC_1, "PARITY3", OUTPUT3_CELL,      X,   278,   1, Z_STATE    },
 { 278, BC_2, "PARITY3_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 279, BC_4, "D31",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 280, BC_1, "D31",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 281, BC_4, "D30",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 282, BC_1, "D30",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 283, BC_4, "D29",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 284, BC_1, "D29",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 285, BC_4, "D28",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 286, BC_1, "D28",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 287, BC_4, "D27",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 288, BC_1, "D27",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 289, BC_4, "D26",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 290, BC_1, "D26",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 291, BC_4, "D25",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 292, BC_1, "D25",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 293, BC_4, "INTERNAL18",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 { 294, BC_1, "DBE",       OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 { 295, BC_4, "D24",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 296, BC_1, "D24",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 297, BC_4, "INTERNAL19",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 { 298, BC_1, "DQM2",    OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 { 299, BC_4, "PARITY2", INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 300, BC_1, "PARITY2", OUTPUT3_CELL,      X,   278,   1, Z_STATE    },
 { 301, BC_4, "D23",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 302, BC_1, "D23",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 303, BC_4, "D22",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 304, BC_1, "D22",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 305, BC_4, "D21",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 306, BC_1, "D21",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 307, BC_4, "D20",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 308, BC_1, "D20",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 309, BC_4, "D19",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 310, BC_1, "D19",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 311, BC_4, "D18",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 312, BC_1, "D18",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 313, BC_4, "D17",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 314, BC_1, "D17",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 315, BC_4, "D16",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 316, BC_1, "D16",     OUTPUT3_CELL,      X,   317,   1, Z_STATE    },
 { 317, BC_2, "D_CTL",             CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 318, BC_4, "INTERNAL20",             INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 { 319, BC_1, "DQM1",    OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 { 320, BC_4, "PARITY1", INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 321, BC_1, "PARITY1", OUTPUT3_CELL,      X,   278,   1, Z_STATE    },
 { 322, BC_4, "D15",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 323, BC_1, "D15",     OUTPUT3_CELL,      X,   338,   1, Z_STATE    },
 { 324, BC_4, "D14",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 325, BC_1, "D14",     OUTPUT3_CELL,      X,   338,   1, Z_STATE    },
 { 326, BC_4, "D13",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 327, BC_1, "D13",     OUTPUT3_CELL,      X,   338,   1, Z_STATE    },
 { 328, BC_4, "D12",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 329, BC_1, "D12",     OUTPUT3_CELL,      X,   338,   1, Z_STATE    },
 { 330, BC_4, "D11",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 331, BC_1, "D11",     OUTPUT3_CELL,      X,   338,   1, Z_STATE    },
 { 332, BC_4, "D10",     INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 333, BC_1, "D10",     OUTPUT3_CELL,      X,   338,   1, Z_STATE    },
 { 334, BC_4, "D9",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 335, BC_1, "D9",      OUTPUT3_CELL,      X,   338,   1, Z_STATE    },
 { 336, BC_4, "D8",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 337, BC_1, "D8",      OUTPUT3_CELL,      X,   338,   1, Z_STATE    },
 { 338, BC_2, "D_CTL",         CONTROL_CELL,      X,   -1,   X, IN_STATE    },
 { 339, BC_4, "INTERNAL21",    INTERNAL_CELL,     X,   -1,   X, IN_STATE    },
 { 340, BC_1, "DQM0",    OUTPUT3_CELL,      X,  52,   1, Z_STATE      },
 { 341, BC_4, "PARITY0", INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 342, BC_1, "PARITY0", OUTPUT3_CELL,      X,   278,   1, Z_STATE    },
 { 343, BC_4, "D7",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 344, BC_1, "D7",      OUTPUT3_CELL,      X,   359,   1, Z_STATE    },
 { 345, BC_4, "D6",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 346, BC_1, "D6",      OUTPUT3_CELL,      X,   359,   1, Z_STATE    },
 { 347, BC_4, "D5",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 348, BC_1, "D5",      OUTPUT3_CELL,      X,   359,   1, Z_STATE    },
 { 349, BC_4, "D4",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 350, BC_1, "D4",      OUTPUT3_CELL,      X,   359,   1, Z_STATE    },
 { 351, BC_4, "D3",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 352, BC_1, "D3",      OUTPUT3_CELL,      X,   359,   1, Z_STATE    },
 { 353, BC_4, "D2",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 354, BC_1, "D2",      OUTPUT3_CELL,      X,   359,   1, Z_STATE    },
 { 355, BC_4, "D1",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 356, BC_1, "D1",      OUTPUT3_CELL,      X,   359,   1, Z_STATE    },
 { 357, BC_4, "D0",      INPUT_CELL,        X,   -1,   X, IN_STATE    },
 { 358, BC_1, "D0",      OUTPUT3_CELL,      X,   359,   1, Z_STATE    },
 { 359, BC_2, "D_CTL",         CONTROL_CELL,      X,   -1,   X, IN_STATE },
 { -1, BC_2, "END",         CONTROL_CELL,      X,   -1,   X, IN_STATE }
};

void resetCorelogicScanring()
{
  int i = 0;
  assert(corelogicScanring != NULL);
  while (corelogicScanCells[i].cellnum >= 0) {
    ScanCell *sc = &corelogicScanCells[i];
    switch (sc->cellType) {
    case INPUT_CELL: /* do nothing */
    case INTERNAL_CELL: /* do nothing */
	case CLOCK:
		break;
    case CONTROL_CELL: /* handle this when we visit the output cell */
      break;
    case OUTPUT1_CELL:
    case OUTPUT2_CELL:
    case OUTPUT3_CELL:
      /* disable this cell by default */
      if (sc->controlCell >= 0) {
        set_scanring_bit(corelogicScanring, sc->controlCell, sc->disableValue);
      }
      break;
    default: {
      int improperCellType = 0;
      assert(improperCellType);
      }
    }
    i++;
  }

  /* now the special cases -- we drive the following pins by default */
  enable_corelogic_ROM_CE_L();
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_ROM_CE_L, 1);
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_CS_L0, 1);
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_CS_L1, 1);
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_CS_L2, 1);
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_CS_L3, 1);
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D_WREN_L, 1);

  set_scanring_bit(corelogicScanring, OUTPUT_CELL_NRESET, 1);

  enable_corelogic_PCI_RST_L();
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_PCI_RST_L, 0);

  enable_corelogic_PCI_GNT_L();
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_PCI_GNT_L, 1);
}

extern int get_corelogic_PAD_MAS();
extern void set_corelogic_PAD_MAS(long);

extern int get_corelogic_PCI_IRQ_L();
extern void set_corelogic_PCI_IRQ_L(long);

extern int get_corelogic_SERR_L();
extern void set_corelogic_SERR_L(long);

#ifdef TX_HAS_CONTROL_CELL
extern void enable_corelogic_TX()
{
  set_scanring_bit(corelogicScanring, CONTROL_CELL_TX, 
                   ~corelogicScanCells[OUTPUT_CELL_TX].disableValue);
}
extern void disable_corelogic_TX()
{
  set_scanring_bit(corelogicScanring, CONTROL_CELL_TX,
                   corelogicScanCells[OUTPUT_CELL_TX].disableValue);
}
#endif

extern void set_corelogic_TX(long tx)
{
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_TX, tx);
}

extern int get_corelogic_XCS_L();
extern void set_corelogic_XCS_L(long);

extern int get_corelogic_XIOW_L();
extern void set_corelogic_XIOW_L(long);

extern int get_corelogic_XIOR_L();
extern void set_corelogic_XIOR_L(long);

extern int get_corelogic_XD_WREN_L();
extern void set_corelogic_XD_WREN_L(long);

extern void set_corelogic_ROM_CE_L(long rom_ce_l) {
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_ROM_CE_L, rom_ce_l);
}
extern void enable_corelogic_ROM_CE_L() {
  set_scanring_bit(corelogicScanring, CONTROL_CELL_ROM_CE_L,
                   ~corelogicScanCells[OUTPUT_CELL_ROM_CE_L].disableValue);
}
extern void disable_corelogic_ROM_CE_L() {
  set_scanring_bit(corelogicScanring, CONTROL_CELL_ROM_CE_L, 
                   corelogicScanCells[OUTPUT_CELL_ROM_CE_L].disableValue);
}

extern int get_corelogic_D_WREN_L();
extern void set_corelogic_D_WREN_L(long);

void enable_corelogic_PCI_GNT_L()
{
  set_scanring_bit(corelogicScanring, 
                   corelogicScanCells[OUTPUT_CELL_PCI_GNT_L].controlCell,
                   ~corelogicScanCells[OUTPUT_CELL_PCI_GNT_L].disableValue);
}
void disable_corelogic_PCI_GNT_L()
{
  set_scanring_bit(corelogicScanring, 
                   corelogicScanCells[OUTPUT_CELL_PCI_GNT_L].controlCell,
                   corelogicScanCells[OUTPUT_CELL_PCI_GNT_L].disableValue);
}
extern void set_corelogic_PCI_GNT_L(long g)
{
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_PCI_GNT_L, g);
}

extern int get_corelogic_CS_L();
extern void set_corelogic_CS_L(long);

extern int get_corelogic_CMD();
extern void set_corelogic_CMD(long);

extern int get_corelogic_BA();
extern void set_corelogic_BA(long);

extern int get_corelogic_MA();
extern void set_corelogic_MA(long);

extern int get_corelogic_PAD_PARITY();
extern void set_corelogic_PAD_PARITY(long);

extern int get_corelogic_PAD_DQM();
extern void set_corelogic_PAD_DQM(long);

extern int get_corelogic_PAD_NRESET();
extern void set_corelogic_PAD_NRESET(long);

extern int get_corelogic_PAD_NFIQ();
extern void set_corelogic_PAD_NFIQ(long);

extern int get_corelogic_PAD_NIRQ();
extern void set_corelogic_PAD_NIRQ(long);

void enable_corelogic_DBE()
{
  set_scanring_bit(corelogicScanring, 
                   corelogicScanCells[OUTPUT_CELL_DBE].controlCell,
                   ~corelogicScanCells[OUTPUT_CELL_DBE].disableValue);
}
void disable_corelogic_DBE()
{
  set_scanring_bit(corelogicScanring, 
                   corelogicScanCells[OUTPUT_CELL_DBE].controlCell,
                   corelogicScanCells[OUTPUT_CELL_DBE].disableValue);
}

extern void set_corelogic_DBE(long value)
{
   set_scanring_bit(corelogicScanring, OUTPUT_CELL_DBE, value);
}


void enable_corelogic_ABE()
{
  int controlCell = corelogicScanCells[OUTPUT_CELL_ABE].controlCell;
  int disableValue = corelogicScanCells[OUTPUT_CELL_ABE].disableValue;
  set_scanring_bit(corelogicScanring, controlCell, ~disableValue);
}
void disable_corelogic_ABE()
{
  int controlCell = corelogicScanCells[OUTPUT_CELL_ABE].controlCell;
  int disableValue = corelogicScanCells[OUTPUT_CELL_ABE].disableValue;
  set_scanring_bit(corelogicScanring, controlCell, disableValue);
}

void set_corelogic_PAD_ABE(long abe)
{
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_ABE, abe);
}

int get_corelogic_D()
{
  long a = 0;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D31) << 31;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D30) << 30;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D29) << 29;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D28) << 28;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D27) << 27;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D26) << 26;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D25) << 25;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D24) << 24;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D23) << 23;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D22) << 22;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D21) << 21;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D20) << 20;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D19) << 19;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D18) << 18;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D17) << 17;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D16) << 16;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D15) << 15;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D14) << 14;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D13) << 13;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D12) << 12;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D11) << 11;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D10) << 10;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D9) << 9;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D8) << 8;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D7) << 7;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D6) << 6;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D5) << 5;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D4) << 4;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D3) << 3;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D2) << 2;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D1) << 1;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_D0) << 0;
  return a;
}
void enable_corelogic_D() 
{
  int disableValue = corelogicScanCells[OUTPUT_CELL_D0].disableValue;
  set_scanring_bit(corelogicScanring, CONTROL_CELL_D_0, ~disableValue);
  set_scanring_bit(corelogicScanring, CONTROL_CELL_D_1, ~disableValue);
  set_scanring_bit(corelogicScanring, CONTROL_CELL_D_2, ~disableValue);
}
void disable_corelogic_D()
{
  int disableValue = corelogicScanCells[OUTPUT_CELL_D0].disableValue;
  set_scanring_bit(corelogicScanring, CONTROL_CELL_D_0, disableValue);
  set_scanring_bit(corelogicScanring, CONTROL_CELL_D_1, disableValue);
  set_scanring_bit(corelogicScanring, CONTROL_CELL_D_2, disableValue);
}
extern void set_corelogic_D(long a) {
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D31, ((a >> 31)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D30, ((a >> 30)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D29, ((a >> 29)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D28, ((a >> 28)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D27, ((a >> 27)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D26, ((a >> 26)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D25, ((a >> 25)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D24, ((a >> 24)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D23, ((a >> 23)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D22, ((a >> 22)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D21, ((a >> 21)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D20, ((a >> 20)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D19, ((a >> 19)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D18, ((a >> 18)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D17, ((a >> 17)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D16, ((a >> 16)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D15, ((a >> 15)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D14, ((a >> 14)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D13, ((a >> 13)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D12, ((a >> 12)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D11, ((a >> 11)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D10, ((a >> 10)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D9, ((a >> 9)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D8, ((a >> 8)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D7, ((a >> 7)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D6, ((a >> 6)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D5, ((a >> 5)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D4, ((a >> 4)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D3, ((a >> 3)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D2, ((a >> 2)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D1, ((a >> 1)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_D0, ((a >> 0)&1));
}

int get_corelogic_A()
{
  long a = 0;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A31) << 31;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A30) << 30;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A29) << 29;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A28) << 28;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A27) << 27;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A26) << 26;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A25) << 25;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A24) << 24;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A23) << 23;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A22) << 22;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A21) << 21;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A20) << 20;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A19) << 19;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A18) << 18;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A17) << 17;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A16) << 16;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A15) << 15;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A14) << 14;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A13) << 13;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A12) << 12;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A11) << 11;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A10) << 10;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A9) << 9;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A8) << 8;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A7) << 7;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A6) << 6;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A5) << 5;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A4) << 4;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A3) << 3;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A2) << 2;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A1) << 1;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_A0) << 0;
  return a;
}

void enable_corelogic_A() 
{
  int disableValue = corelogicScanCells[OUTPUT_CELL_A0].disableValue;
  set_scanring_bit(corelogicScanring, CONTROL_CELL_A_0, ~disableValue);
  set_scanring_bit(corelogicScanring, CONTROL_CELL_A_1, ~disableValue);
}
void disable_corelogic_A()
{
  int disableValue = corelogicScanCells[OUTPUT_CELL_A0].disableValue;
  set_scanring_bit(corelogicScanring, CONTROL_CELL_A_0, disableValue);
  set_scanring_bit(corelogicScanring, CONTROL_CELL_A_1, disableValue);
}
void set_corelogic_A(long a) 
{
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A31, ((a >> 31)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A30, ((a >> 30)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A29, ((a >> 29)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A28, ((a >> 28)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A27, ((a >> 27)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A26, ((a >> 26)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A25, ((a >> 25)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A24, ((a >> 24)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A23, ((a >> 23)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A22, ((a >> 22)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A21, ((a >> 21)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A20, ((a >> 20)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A19, ((a >> 19)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A18, ((a >> 18)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A17, ((a >> 17)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A16, ((a >> 16)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A15, ((a >> 15)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A14, ((a >> 14)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A13, ((a >> 13)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A12, ((a >> 12)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A11, ((a >> 11)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A10, ((a >> 10)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A9, ((a >> 9)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A8, ((a >> 8)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A7, ((a >> 7)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A6, ((a >> 6)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A5, ((a >> 5)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A4, ((a >> 4)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A3, ((a >> 3)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A2, ((a >> 2)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A1, ((a >> 1)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_A0, ((a >> 0)&1));
}

void enable_corelogic_PCI_RST_L()
{
  set_scanring_bit(corelogicScanring, 
                   corelogicScanCells[OUTPUT_CELL_PCI_RST_L].controlCell,
                   ~corelogicScanCells[OUTPUT_CELL_PCI_RST_L].disableValue);
}
void disable_corelogic_PCI_RST_L()
{
  set_scanring_bit(corelogicScanring, 
                   corelogicScanCells[OUTPUT_CELL_PCI_RST_L].controlCell,
                   corelogicScanCells[OUTPUT_CELL_PCI_RST_L].disableValue);
}
int get_corelogic_PCI_RST_L()
{
  return get_scanring_bit(corelogicScanring, INPUT_CELL_PCI_RST_L);
}
extern void set_corelogic_PCI_RST_L(long t)
{
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_PCI_RST_L, t);
}

extern int get_corelogic_REQ_L();
extern void set_corelogic_REQ_L(long);

extern int get_corelogic_PERR_L();
extern void set_corelogic_PERR_L(long);

extern int get_corelogic_DEVSEL_L();
extern void set_corelogic_DEVSEL_L(long);

extern int get_corelogic_STOP_L();
extern void set_corelogic_STOP_L(long);

void enable_corelogic_TRDY_L()
{
  set_scanring_bit(corelogicScanring, 
                   corelogicScanCells[OUTPUT_CELL_TRDY_L].controlCell,
                   ~corelogicScanCells[OUTPUT_CELL_TRDY_L].disableValue);
}
void disable_corelogic_TRDY_L()
{
  set_scanring_bit(corelogicScanring, 
                   corelogicScanCells[OUTPUT_CELL_TRDY_L].controlCell,
                   corelogicScanCells[OUTPUT_CELL_TRDY_L].disableValue);
}
int get_corelogic_TRDY_L()
{
  return get_scanring_bit(corelogicScanring, INPUT_CELL_TRDY_L);
}
extern void set_corelogic_TRDY_L(long t)
{
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_TRDY_L, t);
}

void enable_corelogic_IRDY_L()
{
  set_scanring_bit(corelogicScanring, 
                   corelogicScanCells[OUTPUT_CELL_IRDY_L].controlCell,
                   ~corelogicScanCells[OUTPUT_CELL_IRDY_L].disableValue);
}
void disable_corelogic_IRDY_L()
{
  set_scanring_bit(corelogicScanring, 
                   corelogicScanCells[OUTPUT_CELL_IRDY_L].controlCell,
                   corelogicScanCells[OUTPUT_CELL_IRDY_L].disableValue);
}
int get_corelogic_IRDY_L()
{
  return get_scanring_bit(corelogicScanring, INPUT_CELL_IRDY_L);
}
extern void set_corelogic_IRDY_L(long t)
{
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_IRDY_L, t);
}

extern void enable_corelogic_FRAME_L()
{
  set_scanring_bit(corelogicScanring, 
                   corelogicScanCells[OUTPUT_CELL_FRAME_L].controlCell,
                   ~corelogicScanCells[OUTPUT_CELL_FRAME_L].disableValue);
}
extern void disable_corelogic_FRAME_L()
{
  set_scanring_bit(corelogicScanring, 
                   corelogicScanCells[OUTPUT_CELL_FRAME_L].controlCell,
                   corelogicScanCells[OUTPUT_CELL_FRAME_L].disableValue);
}
extern int get_corelogic_FRAME_L()
{
  return get_scanring_bit(corelogicScanring, INPUT_CELL_FRAME_L);
}
extern void set_corelogic_FRAME_L(long f)
{
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_FRAME_L, f);
}

extern int get_corelogic_PAR();
extern void set_corelogic_PAR(long);

extern void enable_corelogic_CBE_L()
{
  set_scanring_bit(corelogicScanring, CONTROL_CELL_CBE_L,
                   ~corelogicScanCells[OUTPUT_CELL_CBE_L0].disableValue);
}
extern void disable_corelogic_CBE_L()
{
  set_scanring_bit(corelogicScanring, CONTROL_CELL_CBE_L,
                   corelogicScanCells[OUTPUT_CELL_CBE_L0].disableValue);
}
extern int get_corelogic_CBE_L()
{
  int cbe = 0;
  cbe |= get_scanring_bit(corelogicScanring, INPUT_CELL_CBE_L3) << 3;
  cbe |= get_scanring_bit(corelogicScanring, INPUT_CELL_CBE_L2) << 2;
  cbe |= get_scanring_bit(corelogicScanring, INPUT_CELL_CBE_L1) << 1;
  cbe |= get_scanring_bit(corelogicScanring, INPUT_CELL_CBE_L0) << 0;
  return cbe;
}
extern void set_corelogic_CBE_L(long cbe)
{
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_CBE_L3, ((cbe >> 3)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_CBE_L2, ((cbe >> 2)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_CBE_L1, ((cbe >> 1)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_CBE_L0, ((cbe >> 0)&1));
}

void enable_corelogic_AD()
{
  set_scanring_bit(corelogicScanring, CONTROL_CELL_AD_1,
                   ~corelogicScanCells[OUTPUT_CELL_AD0].disableValue);
  set_scanring_bit(corelogicScanring, CONTROL_CELL_AD_2,
                   ~corelogicScanCells[OUTPUT_CELL_AD0].disableValue);
}
extern void disable_corelogic_AD()
{
  set_scanring_bit(corelogicScanring, CONTROL_CELL_AD_1,
                   corelogicScanCells[OUTPUT_CELL_AD0].disableValue);
  set_scanring_bit(corelogicScanring, CONTROL_CELL_AD_2,
                   corelogicScanCells[OUTPUT_CELL_AD0].disableValue);
}
extern int get_corelogic_AD()
{
  long a = 0;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD31) << 31;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD30) << 30;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD29) << 29;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD28) << 28;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD27) << 27;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD26) << 26;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD25) << 25;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD24) << 24;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD23) << 23;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD22) << 22;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD21) << 21;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD20) << 20;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD19) << 19;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD18) << 18;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD17) << 17;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD16) << 16;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD15) << 15;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD14) << 14;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD13) << 13;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD12) << 12;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD11) << 11;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD10) << 10;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD9) << 9;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD8) << 8;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD7) << 7;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD6) << 6;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD5) << 5;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD4) << 4;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD3) << 3;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD2) << 2;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD1) << 1;
  a |= get_scanring_bit(corelogicScanring, INPUT_CELL_AD0) << 0;
  return a;
}
extern void set_corelogic_AD(long a)
{
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD31, ((a >> 31)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD30, ((a >> 30)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD29, ((a >> 29)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD28, ((a >> 28)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD27, ((a >> 27)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD26, ((a >> 26)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD25, ((a >> 25)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD24, ((a >> 24)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD23, ((a >> 23)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD22, ((a >> 22)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD21, ((a >> 21)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD20, ((a >> 20)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD19, ((a >> 19)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD18, ((a >> 18)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD17, ((a >> 17)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD16, ((a >> 16)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD15, ((a >> 15)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD14, ((a >> 14)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD13, ((a >> 13)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD12, ((a >> 12)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD11, ((a >> 11)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD10, ((a >> 10)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD9, ((a >> 9)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD8, ((a >> 8)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD7, ((a >> 7)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD6, ((a >> 6)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD5, ((a >> 5)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD4, ((a >> 4)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD3, ((a >> 3)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD2, ((a >> 2)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD1, ((a >> 1)&1));
  set_scanring_bit(corelogicScanring, OUTPUT_CELL_AD0, ((a >> 0)&1));
}

extern int get_corelogic_NC();
extern void set_corelogic_NC(long);

extern int get_corelogic_PAD_FCLK_OUT();
extern void set_corelogic_PAD_FCLK_OUT(long);

extern int get_corelogic_PAD_MCLK();
extern void set_corelogic_PAD_MCLK(long);

extern int get_corelogic_PAD_SDCLK();
extern void set_corelogic_PAD_SDCLK(long);

extern int get_corelogic_IRQ_IN_L();
extern void set_corelogic_IRQ_IN_L(long);

extern int get_corelogic_IDSEL();
extern void set_corelogic_IDSEL(long);

extern int get_corelogic_GNT_L();
extern void set_corelogic_GNT_L(long);

extern int get_corelogic_PCI_CLK();
extern void set_corelogic_PCI_CLK(long);

extern int get_corelogic_PCI_CFN();
extern void set_corelogic_PCI_CFN(long);

extern int get_corelogic_VIO();
extern void set_corelogic_VIO(long);

extern int get_corelogic_PAD_OSC();
extern void set_corelogic_PAD_OSC(long);

extern int get_corelogic_PAD_FCLK_IN();
extern void set_corelogic_PAD_FCLK_IN(long);

extern int get_corelogic_NRW()
{
   return get_scanring_bit(corelogicScanring, INPUT_CELL_NRW);
}


int get_corelogic_NMREQ()
{
   return get_scanring_bit(corelogicScanring, INPUT_CELL_NMREQ);
}

extern int get_corelogic_CLF()
{
   return get_scanring_bit(corelogicScanring, INPUT_CELL_CLF);
}


extern int get_corelogic_LOCK()
{
   return get_scanring_bit(corelogicScanring, INPUT_CELL_LOCK);
}

extern int get_corelogic_SCAN_EN();
extern void set_corelogic_SCAN_EN(long);

extern int get_corelogic_PCI_REQ_L();
extern void set_corelogic_PCI_REQ_L(long);

extern int get_corelogic_RX();
extern void set_corelogic_RX(long);

extern int get_corelogic_TCK();
extern void set_corelogic_TCK(long);

extern int get_corelogic_TMS();
extern void set_corelogic_TMS(long);

extern int get_corelogic_TDI();
extern void set_corelogic_TDI(long);

extern int get_corelogic_TRST_L();
extern void set_corelogic_TRST_L(long);

extern int get_corelogic_TDO();
extern void set_corelogic_TDO(long);



long corelogic_PCI_configuration_read(int targetNumber, int targetFunction, int offset)
{
  int i = 0;
  long addr = 0;
  long data = 0xFFFFFFFFl;

  addr |= (1L << targetNumber) << 11; /* idsel */
  addr |= ((targetFunction&0x7) << 8);
  offset &= 0xFC;
  addr |= offset;

  enable_corelogic_FRAME_L();
  enable_corelogic_AD();
  enable_corelogic_CBE_L();
  enable_corelogic_IRDY_L();
  enable_corelogic_PCI_GNT_L();

  set_skfmlb_clock(0);
  set_corelogic_FRAME_L(0);
  set_corelogic_CBE_L(CBE_CONFIGURATION_READ);
  set_corelogic_AD(addr);
  set_corelogic_IRDY_L(1); /* initiator not ready yet */
  set_corelogic_PCI_GNT_L(1);

  skfmlb_scan(0);

  set_skfmlb_clock(1);
  skfmlb_scan(0);
  
  set_skfmlb_clock(0);
  set_corelogic_FRAME_L(1);
  set_corelogic_CBE_L(0xF); /* all bytes */
  disable_corelogic_AD(); /* let target drive AD bus */
  set_corelogic_IRDY_L(0); /* initiator ready */
  skfmlb_scan(0);

  for (i = 0; i < 10; i++) {
    set_skfmlb_clock(1);
    skfmlb_scan(1);
    if (get_corelogic_TRDY_L() == 0) {
      data = get_corelogic_AD();
      break;
    } else {
      set_skfmlb_clock(0);
      skfmlb_scan(0);
    }
    i++;
  }
  set_skfmlb_clock(0);

  disable_corelogic_FRAME_L();
  disable_corelogic_AD();
  disable_corelogic_CBE_L();
  disable_corelogic_IRDY_L();
  disable_corelogic_PCI_GNT_L();
  skfmlb_scan(0);

  return data;
}

void set_skfmlb_clock(int clk)
{
  set_scanring_bit(corelogicScanring, INPUT_CELL_OSC, clk);
}

void skfmlb_scan(int copyout)
{
  char irdata[128];
  char drdata[4096];
  memset(drdata, 0, skfmlbsr->nBytes);

  /* set up EXTEST instruction */
  *(long*)irdata =  SKFMLB_INSTRUCTION_EXTEST; /* EXTEST: 0b000000000 */

  scan_ir(0, (const short*)irdata, SKFMLB_INSTRUCTION_NBITS, (short *)irdata);

  scan_dr(0, (const short*)skfmlbsr->data, skfmlbsr->nBits, (short *)drdata);
  if (copyout)
     memcpy(skfmlbsr->data, drdata, skfmlbsr->nBytes);

}
