/**
 * 21285bs.h provides procedures to access the pins in the 21285 scanring.
 */

#ifndef _21285_BS_H_
#define _21285_BS_H_

#include "bscan.h"

#define SKFMLB_INSTRUCTION_EXTEST 0x0
/* #define SKFMLB_INSTRUCTION_SAMPLE 0x11 */
#define SKFMLB_INSTRUCTION_NBITS 21


#define CORELOGIC_INSTRUCTION_LENGTH 4
enum CorelogicInstruction {
   CORELOGIC_IDCODE = 0x4,
   CORELOGIC_CLAMP = 0x3,
   CORELOGIC_HIGHZ = 0x2,
   CORELOGIC_EXTEST = 0x0,
   CORELOGIC_SAMPLE = 0x1,
   CORELOGIC_BYPASS = 0xf,
};

enum CBE_COMMAND {
   CBE_INTERRUPT_ACKNOWLEDGE=0,
   CBE_INTERRUPT_SPECIAL_CYCLE=1,
   CBE_IO_READ=2,
   CBE_IO_WRITE=3,
   CBE_RESERVED4=4,
   CBE_RESERVED5=5,
   CBE_MEMORY_READ=6,
   CBE_MEMORY_WRITE=7,
   CBE_RESERVED_8=8,
   CBE_RESERVED_9=9,
   CBE_CONFIGURATION_READ=0xA,
   CBE_CONFIGURATION_WRITE=0xB,
   CBE_MEMORY_READ_MULTIPLE=0xC,
   CBE_DUAL_ADDRESS_CYCLE=0xD,
   CBE_MEMORY_READ_LINE=0xE,
   CBE_MEMORY_WRITE_AND_INVALIDATE=0xF,
};

#define CORELOGIC_SCANRING_LENGTH 360

/*---------------------------------------------------------------*/
/* cell  cell                                 cntl  disable      */
/* num	 type   port        function     safe cell  value   rslt */
/*---------------------------------------------------------------*/
extern ScanCell corelogicScanCells[];

#define OUTPUT_CELL_BA1		1
#define OUTPUT_CELL_BA0		3
#define OUTPUT_CELL_MA12		5
#define OUTPUT_CELL_MA11		7
#define OUTPUT_CELL_MA10		9
#define OUTPUT_CELL_MA9		11
#define OUTPUT_CELL_MA8		13
#define OUTPUT_CELL_MA7		15
#define OUTPUT_CELL_MA6		17
#define OUTPUT_CELL_MA5		19
#define OUTPUT_CELL_MA4		21
#define OUTPUT_CELL_MA3		23
#define OUTPUT_CELL_MA2		25
#define OUTPUT_CELL_MA1		27
#define OUTPUT_CELL_MA0		29
#define OUTPUT_CELL_CS_L3		36
#define OUTPUT_CELL_CS_L2		38
#define OUTPUT_CELL_CS_L1		40
#define OUTPUT_CELL_CS_L0		42
#define OUTPUT_CELL_D_WREN_L		44
#define OUTPUT_CELL_CMD2		46
#define OUTPUT_CELL_CMD1		48
#define OUTPUT_CELL_CMD0		50
#define OUTPUT_CELL_ROM_CE_L		54
#define OUTPUT_CELL_XIOW_L		57
#define OUTPUT_CELL_XIOR_L		59
#define OUTPUT_CELL_XD_WREN_L		61
#define OUTPUT_CELL_XCS_L2		63
#define OUTPUT_CELL_XCS_L1		65
#define OUTPUT_CELL_XCS_L0		67
#define OUTPUT_CELL_TX		73
#define OUTPUT_CELL_PCI_GNT_L		75
#define OUTPUT_CELL_PCI_RST_L		79
#define OUTPUT_CELL_REQ_L		84
#define OUTPUT_CELL_AD31		87
#define OUTPUT_CELL_AD30		89
#define OUTPUT_CELL_AD29		91
#define OUTPUT_CELL_AD28		93
#define OUTPUT_CELL_AD27		95
#define OUTPUT_CELL_AD26		97
#define OUTPUT_CELL_AD25		99
#define OUTPUT_CELL_AD24		101
#define OUTPUT_CELL_CBE_L3		103
#define OUTPUT_CELL_AD23		106
#define OUTPUT_CELL_AD22		108
#define OUTPUT_CELL_AD21		110
#define OUTPUT_CELL_AD20		112
#define OUTPUT_CELL_AD19		114
#define OUTPUT_CELL_AD18		116
#define OUTPUT_CELL_AD17		118
#define OUTPUT_CELL_AD16		120
#define OUTPUT_CELL_CBE_L2		123
#define OUTPUT_CELL_FRAME_L		125
#define OUTPUT_CELL_IRDY_L		128
#define OUTPUT_CELL_TRDY_L		131
#define OUTPUT_CELL_DEVSEL_L		134
#define OUTPUT_CELL_STOP_L		136
#define OUTPUT_CELL_PERR_L		139
#define OUTPUT_CELL_SERR_L		142
#define OUTPUT_CELL_PAR		145
#define OUTPUT_CELL_CBE_L1		148
#define OUTPUT_CELL_AD15		150
#define OUTPUT_CELL_AD14		153
#define OUTPUT_CELL_AD13		155
#define OUTPUT_CELL_AD12		157
#define OUTPUT_CELL_AD11		159
#define OUTPUT_CELL_AD10		161
#define OUTPUT_CELL_AD9		163
#define OUTPUT_CELL_AD8		165
#define OUTPUT_CELL_PCI_IRQ_L		167
#define OUTPUT_CELL_CBE_L0		170
#define OUTPUT_CELL_AD7		173
#define OUTPUT_CELL_AD6		175
#define OUTPUT_CELL_AD5		177
#define OUTPUT_CELL_AD4		179
#define OUTPUT_CELL_AD3		181
#define OUTPUT_CELL_AD2		183
#define OUTPUT_CELL_AD1		185
#define OUTPUT_CELL_AD0		187
#define OUTPUT_CELL_NIRQ		190
#define OUTPUT_CELL_NFIQ		192
#define OUTPUT_CELL_NRESET		195
#define OUTPUT_CELL_A31		197
#define OUTPUT_CELL_A30		199
#define OUTPUT_CELL_A29		201
#define OUTPUT_CELL_A28		203
#define OUTPUT_CELL_A27		205
#define OUTPUT_CELL_A26		207
#define OUTPUT_CELL_A25		209
#define OUTPUT_CELL_A24		211
#define OUTPUT_CELL_A23		213
#define OUTPUT_CELL_A22		215
#define OUTPUT_CELL_A21		217
#define OUTPUT_CELL_A20		219
#define OUTPUT_CELL_A19		221
#define OUTPUT_CELL_A18		223
#define OUTPUT_CELL_A17		225
#define OUTPUT_CELL_A16		227
#define OUTPUT_CELL_A15		229
#define OUTPUT_CELL_A14		231
#define OUTPUT_CELL_A13		233
#define OUTPUT_CELL_A12		235
#define OUTPUT_CELL_A11		237
#define OUTPUT_CELL_A10		239
#define OUTPUT_CELL_A9		241
#define OUTPUT_CELL_A8		243
#define OUTPUT_CELL_A7		245
#define OUTPUT_CELL_A6		247
#define OUTPUT_CELL_A5		249
#define OUTPUT_CELL_A4		251
#define OUTPUT_CELL_A3		253
#define OUTPUT_CELL_A2		255
#define OUTPUT_CELL_A1		257
#define OUTPUT_CELL_A0		259
#define OUTPUT_CELL_MAS0		261
#define OUTPUT_CELL_MAS1		262
#define OUTPUT_CELL_ABE		267
#define OUTPUT_CELL_DQM3		275
#define OUTPUT_CELL_PARITY3		277
#define OUTPUT_CELL_D31		280
#define OUTPUT_CELL_D30		282
#define OUTPUT_CELL_D29		284
#define OUTPUT_CELL_D28		286
#define OUTPUT_CELL_D27		288
#define OUTPUT_CELL_D26		290
#define OUTPUT_CELL_D25		292
#define OUTPUT_CELL_DBE		294
#define OUTPUT_CELL_D24		296
#define OUTPUT_CELL_DQM2		298
#define OUTPUT_CELL_PARITY2		300
#define OUTPUT_CELL_D23		302
#define OUTPUT_CELL_D22		304
#define OUTPUT_CELL_D21		306
#define OUTPUT_CELL_D20		308
#define OUTPUT_CELL_D19		310
#define OUTPUT_CELL_D18		312
#define OUTPUT_CELL_D17		314
#define OUTPUT_CELL_D16		316
#define OUTPUT_CELL_DQM1		319
#define OUTPUT_CELL_PARITY1		321
#define OUTPUT_CELL_D15		323
#define OUTPUT_CELL_D14		325
#define OUTPUT_CELL_D13		327
#define OUTPUT_CELL_D12		329
#define OUTPUT_CELL_D11		331
#define OUTPUT_CELL_D10		333
#define OUTPUT_CELL_D9		335
#define OUTPUT_CELL_D8		337
#define OUTPUT_CELL_DQM0		340
#define OUTPUT_CELL_PARITY0		342
#define OUTPUT_CELL_D7		344
#define OUTPUT_CELL_D6		346
#define OUTPUT_CELL_D5		348
#define OUTPUT_CELL_D4		350
#define OUTPUT_CELL_D3		352
#define OUTPUT_CELL_D2		354
#define OUTPUT_CELL_D1		356
#define OUTPUT_CELL_D0		358

#define INPUT_CELL_BA1		0
#define INPUT_CELL_BA0		2
#define INPUT_CELL_MA12		4
#define INPUT_CELL_MA11		6
#define INPUT_CELL_MA10		8
#define INPUT_CELL_MA9		10
#define INPUT_CELL_MA8		12
#define INPUT_CELL_MA7		14
#define INPUT_CELL_MA6		16
#define INPUT_CELL_MA5		18
#define INPUT_CELL_MA4		20
#define INPUT_CELL_MA3		22
#define INPUT_CELL_MA2		24
#define INPUT_CELL_MA1		26
#define INPUT_CELL_MA0		28
#define INPUT_CELL_IRQ_IN_L3		31
#define INPUT_CELL_IRQ_IN_L2		32
#define INPUT_CELL_IRQ_IN_L1		33
#define INPUT_CELL_IRQ_IN_L0		34
#define INPUT_CELL_SCAN_EN		55
#define INPUT_CELL_XIOW_L		56
#define INPUT_CELL_XIOR_L		58
#define INPUT_CELL_XD_WREN_L		60
#define INPUT_CELL_XCS_L2		62
#define INPUT_CELL_XCS_L1		64
#define INPUT_CELL_XCS_L0		66
#define INPUT_CELL_RX		71
#define INPUT_CELL_PCI_REQ_L		77
#define INPUT_CELL_PCI_RST_L		78
#define INPUT_CELL_GNT_L		82
#define INPUT_CELL_REQ_L		83
#define INPUT_CELL_AD31		86
#define INPUT_CELL_AD30		88
#define INPUT_CELL_AD29		90
#define INPUT_CELL_AD28		92
#define INPUT_CELL_AD27		94
#define INPUT_CELL_AD26		96
#define INPUT_CELL_AD25		98
#define INPUT_CELL_AD24		100
#define INPUT_CELL_CBE_L3		102
#define INPUT_CELL_IDSEL		104
#define INPUT_CELL_AD23		105
#define INPUT_CELL_AD22		107
#define INPUT_CELL_AD21		109
#define INPUT_CELL_AD20		111
#define INPUT_CELL_AD19		113
#define INPUT_CELL_AD18		115
#define INPUT_CELL_AD17		117
#define INPUT_CELL_AD16		119
#define INPUT_CELL_CBE_L2		122
#define INPUT_CELL_FRAME_L		124
#define INPUT_CELL_IRDY_L		127
#define INPUT_CELL_TRDY_L		130
#define INPUT_CELL_DEVSEL_L		133
#define INPUT_CELL_STOP_L		135
#define INPUT_CELL_PCI_CFN		137
#define INPUT_CELL_PERR_L		138
#define INPUT_CELL_SERR_L		141
#define INPUT_CELL_PAR		144
#define INPUT_CELL_CBE_L1		147
#define INPUT_CELL_AD15		149
#define INPUT_CELL_AD14		152
#define INPUT_CELL_AD13		154
#define INPUT_CELL_AD12		156
#define INPUT_CELL_AD11		158
#define INPUT_CELL_AD10		160
#define INPUT_CELL_AD9		162
#define INPUT_CELL_AD8		164
#define INPUT_CELL_PCI_IRQ_L		166
#define INPUT_CELL_CBE_L0		169
#define INPUT_CELL_AD7		172
#define INPUT_CELL_AD6		174
#define INPUT_CELL_AD5		176
#define INPUT_CELL_AD4		178
#define INPUT_CELL_AD3		180
#define INPUT_CELL_AD2		182
#define INPUT_CELL_AD1		184
#define INPUT_CELL_AD0		186
#define INPUT_CELL_NRESET		193
#define INPUT_CELL_A31		196
#define INPUT_CELL_A30		198
#define INPUT_CELL_A29		200
#define INPUT_CELL_A28		202
#define INPUT_CELL_A27		204
#define INPUT_CELL_A26		206
#define INPUT_CELL_A25		208
#define INPUT_CELL_A24		210
#define INPUT_CELL_A23		212
#define INPUT_CELL_A22		214
#define INPUT_CELL_A21		216
#define INPUT_CELL_A20		218
#define INPUT_CELL_A19		220
#define INPUT_CELL_A18		222
#define INPUT_CELL_A17		224
#define INPUT_CELL_A16		226
#define INPUT_CELL_A15		228
#define INPUT_CELL_A14		230
#define INPUT_CELL_A13		232
#define INPUT_CELL_A12		234
#define INPUT_CELL_A11		236
#define INPUT_CELL_A10		238
#define INPUT_CELL_A9		240
#define INPUT_CELL_A8		242
#define INPUT_CELL_A7		244
#define INPUT_CELL_A6		246
#define INPUT_CELL_A5		248
#define INPUT_CELL_A4		250
#define INPUT_CELL_A3		252
#define INPUT_CELL_A2		254
#define INPUT_CELL_A1		256
#define INPUT_CELL_A0		258
#define INPUT_CELL_MAS1		260
#define INPUT_CELL_MAS0		263
#define INPUT_CELL_NRW		268
#define INPUT_CELL_LOCK		269
#define INPUT_CELL_CLF		270
#define INPUT_CELL_OSC		271
#define INPUT_CELL_NMREQ		273
#define INPUT_CELL_PARITY3		276
#define INPUT_CELL_D31		279
#define INPUT_CELL_D30		281
#define INPUT_CELL_D29		283
#define INPUT_CELL_D28		285
#define INPUT_CELL_D27		287
#define INPUT_CELL_D26		289
#define INPUT_CELL_D25		291
#define INPUT_CELL_D24		295
#define INPUT_CELL_PARITY2		299
#define INPUT_CELL_D23		301
#define INPUT_CELL_D22		303
#define INPUT_CELL_D21		305
#define INPUT_CELL_D20		307
#define INPUT_CELL_D19		309
#define INPUT_CELL_D18		311
#define INPUT_CELL_D17		313
#define INPUT_CELL_D16		315
#define INPUT_CELL_PARITY1		320
#define INPUT_CELL_D15		322
#define INPUT_CELL_D14		324
#define INPUT_CELL_D13		326
#define INPUT_CELL_D12		328
#define INPUT_CELL_D11		330
#define INPUT_CELL_D10		332
#define INPUT_CELL_D9		334
#define INPUT_CELL_D8		336
#define INPUT_CELL_PARITY0		341
#define INPUT_CELL_D7		343
#define INPUT_CELL_D6		345
#define INPUT_CELL_D5		347
#define INPUT_CELL_D4		349
#define INPUT_CELL_D3		351
#define INPUT_CELL_D2		353
#define INPUT_CELL_D1		355
#define INPUT_CELL_D0		357

#define CONTROL_CELL_MA		30
#define CONTROL_CELL_XIOW		51
#define CONTROL_CELL_ROM_CE_L		52
#define CONTROL_CELL_XCS0		68
#define CONTROL_CELL_XCS1		69
#define CONTROL_CELL_XCS2		70
#define CONTROL_CELL_PCI_GNT_L		76
#define CONTROL_CELL_PCI_RST_L		80
#define CONTROL_CELL_REQ		85
#define CONTROL_CELL_AD_1		121
#define CONTROL_CELL_FRAME		126
#define CONTROL_CELL_IRDY		129
#define CONTROL_CELL_TRDY		132
#define CONTROL_CELL_PERR		140
#define CONTROL_CELL_SERR		143
#define CONTROL_CELL_PAR		146
#define CONTROL_CELL_AD_2		151
#define CONTROL_CELL_PCI_IRQ		168
#define CONTROL_CELL_CBE_L		171
#define CONTROL_CELL_NRESET		194
#define CONTROL_CELL_A_0		264
#define CONTROL_CELL_A_1	265
#define CONTROL_CELL_PARITY3		278
#define CONTROL_CELL_D_0		317
#define CONTROL_CELL_D_1		338
#define CONTROL_CELL_D_2		359


extern struct Scanring *skfmlbsr;

extern struct Scanring *corelogicScanring;

extern void resetCorelogicScanring(void);

extern int get_corelogic_MAS();
extern void set_corelogic_MAS(long);

extern int get_corelogic_PCI_IRQ_L();
extern void set_corelogic_PCI_IRQ_L(long);

extern int get_corelogic_SERR_L();
extern void set_corelogic_SERR_L(long);

extern int get_corelogic_TX();
extern void set_corelogic_TX(long);

extern int get_corelogic_XCS_L();
extern void set_corelogic_XCS_L(long);

extern int get_corelogic_XIOW_L();
extern void set_corelogic_XIOW_L(long);

extern int get_corelogic_XIOR_L();
extern void set_corelogic_XIOR_L(long);

extern int get_corelogic_XD_WREN_L();
extern void set_corelogic_XD_WREN_L(long);

extern void enable_corelogic_ROM_CE_L();
extern void disable_corelogic_ROM_CE_L();
extern void set_corelogic_ROM_CE_L(long rom_ce_l);

extern int get_corelogic_D_WREN_L();
extern void set_corelogic_D_WREN_L(long);

extern void enable_corelogic_PCI_GNT_L();
extern void disable_corelogic_PCI_GNT_L();
extern int get_corelogic_PCI_GNT_L();
extern void set_corelogic_PCI_GNT_L(long);

extern int get_corelogic_CS_L();
extern void set_corelogic_CS_L(long);

extern int get_corelogic_CMD();
extern void set_corelogic_CMD(long);

extern int get_corelogic_BA();
extern void set_corelogic_BA(long);

extern int get_corelogic_MA();
extern void set_corelogic_MA(long);

extern int get_corelogic_PARITY();
extern void set_corelogic_PARITY(long);

extern int get_corelogic_DQM();
extern void set_corelogic_DQM(long);

extern int get_corelogic_NRESET();
extern void set_corelogic_NRESET(long);

extern int get_corelogic_NFIQ();
extern void set_corelogic_NFIQ(long);

extern int get_corelogic_NIRQ();
extern void set_corelogic_NIRQ(long);

extern void enable_corelogic_DBE();
extern void disable_corelogic_DBE();
extern int get_corelogic_DBE();
extern void set_corelogic_DBE(long);

extern void enable_corelogic_ABE();
extern void disable_corelogic_ABE();
extern int get_corelogic_ABE();
extern void set_corelogic_ABE(long);

extern int get_corelogic_D();
extern void set_corelogic_D(long);
extern void enable_corelogic_D();
extern void disable_corelogic_D();

extern int get_corelogic_A();
extern void set_corelogic_A(long a);
extern void enable_corelogic_A();
extern void disable_corelogic_A();

extern void enable_corelogic_PCI_RST_L();
extern void disable_corelogic_PCI_RST_L();
extern int get_corelogic_PCI_RST_L();
extern void set_corelogic_PCI_RST_L(long);

extern int get_corelogic_REQ_L();
extern void set_corelogic_REQ_L(long);

extern int get_corelogic_PERR_L();
extern void set_corelogic_PERR_L(long);

extern int get_corelogic_DEVSEL_L();
extern void set_corelogic_DEVSEL_L(long);

extern int get_corelogic_STOP_L();
extern void set_corelogic_STOP_L(long);

extern int get_corelogic_TRDY_L();
extern void set_corelogic_TRDY_L(long);

extern int get_corelogic_IRDY_L();
extern void set_corelogic_IRDY_L(long);

extern int get_corelogic_FRAME_L();
extern void set_corelogic_FRAME_L(long);

extern int get_corelogic_PAR();
extern void set_corelogic_PAR(long);

extern void enable_corelogic_CBE_L();
extern void disable_corelogic_CBE_L();
extern int get_corelogic_CBE_L();
extern void set_corelogic_CBE_L(long);

extern void enable_corelogic_AD();
extern void disable_corelogic_AD();
extern int get_corelogic_AD();
extern void set_corelogic_AD(long);

extern int get_corelogic_NC();
extern void set_corelogic_NC(long);

extern int get_corelogic_FCLK_OUT();
extern void set_corelogic_FCLK_OUT(long);

extern int get_corelogic_MCLK();
extern void set_corelogic_MCLK(long);

extern int get_corelogic_SDCLK();
extern void set_corelogic_SDCLK(long);

extern int get_corelogic_IRQ_IN_L();
extern void set_corelogic_IRQ_IN_L(long);

extern int get_corelogic_IDSEL();
extern void set_corelogic_IDSEL(long);

extern int get_corelogic_GNT_L();
extern void set_corelogic_GNT_L(long);

extern int get_corelogic_PCI_CLK();
extern void set_corelogic_PCI_CLK(long);

extern int get_corelogic_PCI_CFN();
extern void set_corelogic_PCI_CFN(long);

extern int get_corelogic_VIO();
extern void set_corelogic_VIO(long);

extern int get_corelogic_OSC();
extern void set_corelogic_OSC(long);

extern int get_corelogic_FCLK_IN();
extern void set_corelogic_FCLK_IN(long);

extern int get_corelogic_NRW();

extern int get_corelogic_NMREQ();
extern void set_corelogic_NMREQ(long);

extern int get_corelogic_CLF();
extern void set_corelogic_CLF(long);

extern int get_corelogic_LOCK();
extern void set_corelogic_LOCK(long);

extern int get_corelogic_SCAN_EN();
extern void set_corelogic_SCAN_EN(long);

extern int get_corelogic_PCI_REQ_L();
extern void set_corelogic_PCI_REQ_L(long);

extern int get_corelogic_RX();
extern void set_corelogic_RX(long);

extern int get_corelogic_TCK();
extern void set_corelogic_TCK(long);

extern int get_corelogic_TMS();
extern void set_corelogic_TMS(long);

extern int get_corelogic_TDI();
extern void set_corelogic_TDI(long);

extern int get_corelogic_TRST_L();
extern void set_corelogic_TRST_L(long);

extern int get_corelogic_TDO();
extern void set_corelogic_TDO(long);

extern int get_corelogic_VDDI();
extern void set_corelogic_VDDI(long);

extern int get_corelogic_VDDX();
extern void set_corelogic_VDDX(long);

extern int get_corelogic_VDDX_P();
extern void set_corelogic_VDDX_P(long);

extern int get_corelogic_VDD();
extern void set_corelogic_VDD(long);

extern int get_corelogic_VSSI();
extern void set_corelogic_VSSI(long);

extern int get_corelogic_VSSX();
extern void set_corelogic_VSSX(long);

extern int get_corelogic_VSSX_P();
extern void set_corelogic_VSSX_P(long);

extern int get_corelogic_VSS();
extern void set_corelogic_VSS(long);

extern void reset_skfmlb_scanring();
extern void set_skfmlb_clock(int);
extern void skfmlb_scan(int);
extern long corelogic_PCI_configuration_read(int targetNumber, int targetFunction, int offset);

#endif /* _21285_BS_H_ */
