/*********************************************************************/
/*   PCI-1149.1 Scan Function Library                                */
/*********************************************************************/


#ifndef _PCI_H_
#define _PCI_H_


#define _PRE_ __declspec(dllexport)
#define _POST_ _stdcall


/* Microsoft undersocre adjustment */
#ifdef _MSC_VER
   #include <windows.h>
#else
   #define TRUE 1
   #define FALSE 0
#endif

#define PORTA 0
#define PORTB 1
/* Enumerated Data Type Definitions */
enum TAPS 
   {// Available TAP's 
   TAP1=0,
   TAP2=1,
   TAP3=2,
   TAP4=3};
   
enum STATES
   {// Different possible stable states
   STATE_TLR=0, // TEST-LOGIC RESET
   STATE_RTI=1, // RUN-TEST/IDLE
   STATE_PDR=2, // PAUSE-DR
   STATE_PIR=3, // PAUSE-IR
   STATE_SDR=4, // SHIFT-DR
   STATE_SIR=5};// SHIFT-IR
   
enum OSCILLATORS
   {// Available Oscillators
   _30MHZ=0,
   _40MHZ=1,
   _50MHZ=2,
   External=3};

enum VOLTAGE 
   {// Voltage Selections 
   _2_00=0x4b,
   _2_05=0x50,
   _2_10=0x55,
   _2_15=0x5a,
   _2_20=0x5f,
   _2_25=0x64,
   _2_30=0x69,
   _2_35=0x6e,
   _2_40=0x73,
   _2_45=0x78,
   _2_50=0x7d,
   _2_55=0x82,
   _2_60=0x87,
   _2_65=0x8c,
   _2_70=0x91,
   _2_75=0x96,
   _2_80=0x9b,
   _2_85=0xa0,
   _2_90=0xa5,
   _2_95=0xaa,
   _3_00=0xaf,
   _3_05=0xb4,
   _3_10=0xb9,
   _3_15=0xbe,
   _3_20=0xc3,
   _3_25=0xc8,
   _3_30=0xcd,
   _3_35=0xd2,
   _3_40=0xd7};

#define PORTA 0
#define PORTB 1

#define CLK_12                  0       /* set clock 1/2 */
#define CLK_34                  1       /* set clock 3/4 */

#define NO_PRESCALE             0       /* clock, without /16 prescaler */
#define PRESCALE_16             1       /* clock, with /16 prescaler */


#define CLK_DIV_BY_2            0       /* divide selected clock by 2 */
#define CLK_DIV_BY_4            1       /* divide selected clock by 4 */
#define CLK_DIV_BY_6            2       /* divide selected clock by 6 */
#define CLK_DIV_BY_8            3       /* divide selected clock by 8 */
#define CLK_DIV_BY_10           4       /* divide selected clock by 10 */
#define CLK_DIV_BY_12           5       /* divide selected clock by 12 */
#define CLK_DIV_BY_14           6       /* divide selected clock by 14 */
#define CLK_DIV_BY_16           7       /* divide selected clock by 16 */
#define CLK_DIV_BY_18           8       /* divide selected clock by 18 */
#define CLK_DIV_BY_20           9       /* divide selected clock by 20 */
#define CLK_DIV_BY_22          10       /* divide selected clock by 22 */
#define CLK_DIV_BY_24          11       /* divide selected clock by 24 */
#define CLK_DIV_BY_26          12       /* divide selected clock by 26 */
#define CLK_DIV_BY_28          13       /* divide selected clock by 28 */
#define CLK_DIV_BY_30          14       /* divide selected clock by 30 */
#define CLK_DIV_BY_32          15       /* divide selected clock by 32 */


/*********************************************************/
/*                 Access & Test Function                */
/*********************************************************/
/* Library Link Test */
_PRE_ short int  _POST_ test 
   (short int dummy);               // Value to return
 

/*********************************************************/
/*                Hardware Reset Functions               */
/*********************************************************/
/* Holds TMS signal high for 5 TCKS */
_PRE_ void _POST_ tms_reset 
      (enum TAPS test_bus);               // Which TAP to reset 

/* Pulse the TRST signal low then high on the selected TAP */                
_PRE_ short int _POST_ trst_reset
      (enum TAPS test_bus);               // Which TAP to reset 

                
/* Reset BSC controllers via reset bit*/                
_PRE_ void _POST_ soft_reset
      (enum TAPS test_bus);               // Which TAP pair to reset 


/* Hard reset the boards functions */                
_PRE_ short _POST_ hard_reset
      (short int rs422_enable,            // Enable RS422, and TAP 4 receive
	    enum VOLTAGE volts) ;             // Output voltage level


                
/*********************************************************/
/*                  Scanning Functions                   */
/*********************************************************/                
/* Scan data to and from the JTAG Data Register */
_PRE_ void _POST_ scan_dr
      (enum TAPS test_bus,                 // Which TAP to Scan
       const unsigned short int *out_data, // Holds data shifted out of card
       unsigned long bit_length,           // Number of bits to be shifted
       unsigned short int *in_data);       // Data to be shifted into card
                                                   
/* Scan data to and from the JTAG Data Register with hardware accereration */
_PRE_ void _POST_ scan_dr_turbo
      (enum TAPS test_bus,                 // Which TAP to Scan
       const unsigned long *out_data,      // Holds data shifted out of card
       unsigned long bit_length,           // Number of bits to be shifted
       unsigned long *in_data);            // Data to be shifted into card

/* Scan data to and from the JTAG Data Register leaving JTAG in Pause-DR state*/
_PRE_ void _POST_ scan_to_pause_dr
      (enum TAPS test_bus,                 // Which TAP to Scan
       const unsigned short int *out_data, // Holds data shifted out of card
       unsigned long bit_length,           // Number of bits to be shifted
       unsigned short int *in_data);       // Data to be shifted into card

/* Scan data to and from the JTAG Instruction Register */
_PRE_ void _POST_ scan_ir
      (enum TAPS test_bus,                 // Which TAP to Scan
       const unsigned short int *out_data, // Holds data shifted out of card
       unsigned long bit_length,           // Number of bits to be shifted
       unsigned short int *in_data);       // Data to be shifted into card
             
/* Scan data to and from the JTAG Instruction Register with hardware accel */            
_PRE_ void _POST_ scan_ir_turbo
      (enum TAPS test_bus,                 // Which TAP to Scan
       const unsigned long *out_data,      // Holds data shifted out of card
       unsigned long bit_length,           // Number of bits to be shifted
       unsigned long *in_data);            // Data to be shifted into card

/* Scan data to and from the JTAG Ins Register leaving JTAG in Pause-IR state*/
_PRE_ void _POST_ scan_to_pause_ir
      (enum TAPS test_bus,                 // Which TAP to Scan
       const unsigned short int *out_data, // Holds data shifted out of card
       unsigned long bit_length,           // Number of bits to be shifted
       unsigned short int *in_data);       // Data to be shifted into card
                        
/* Set JTAG's state machine to a given state */
_PRE_ void _POST_ move_to_state 
      (enum TAPS test_bus,                 // Which TAP to transition
       enum STATES final_state);           // Final transition state
                         
/* Set the TCK clock speed for specified TAP */
_PRE_ void _POST_ set_scan_clk 
      (unsigned short int clock,           // Which TAP pair to set(0:1&2 1:3&4)
       enum OSCILLATORS clk_select,        // Which clock oscillator to use
       short int prescaler,                // Enable clock prescaler
       unsigned short int clk_divider);    // Integer used as clock divisor
   
/* Scan data out then back into Data Register */
_PRE_ void _POST_ circulate_dr 
      (enum TAPS test_bus,                 // Which TAP to scan
       unsigned long bit_lengh,            // Number of bits to be shifted
       unsigned short int *in_data);       // Array to hold data shifted to card

_PRE_ void _POST_ scan_NxCLK(
		enum TAPS test_bus,     		   // Which TAP to scan	
		enum STATES curr_state,			   // Current state	
		unsigned long num_ticks);	       // Number of clocks to scan through



/*********************************************************/
/*                   Reading Functions                   */
/*********************************************************/ 
             
/* Read input level of all signals at 8-bit input port */
_PRE_ unsigned char _POST_ read_io(
		unsigned char port);				// PORTA or PORTB
                                           

/* Sets the output levels of signals on 8-bit output port */
_PRE_ void _POST_ set_io(
		unsigned char port,					// PORTA or PORTB
		unsigned char output_data);         // Data to be output

/* Sets the open collector output levels on 8-bit output port A */
_PRE_ void _POST_ set_oc_output(
		short int bit,						// Open collector bit 0 or 1 
		short int output_data);             // 0 - signal driven low, 1 - signal driven high


/* Output to a memory location */
_PRE_ long  _POST_  out32(unsigned long addr, 
                          unsigned long data);
_PRE_ short _POST_  out16(unsigned long addr, 
                          unsigned short data);
_PRE_ char  _POST_  out8( unsigned long addr, 
                          unsigned char data);

/* input from a port */
_PRE_ long  _POST_ in32(unsigned long addr);
_PRE_ short _POST_ in16(unsigned long addr);
_PRE_ char  _POST_ in8( unsigned long addr);
#endif

   

 

 








