##
## filename is where we write the binary data
##

set zImageFilename "s:/jamey/linux-2.3.99-pre1-rmk1-np1-orig/arch/arm/boot/zImage"
set zImageFilename "c:/skiff/aerozImage"

## load the DLL defining our new commands for programming flash
load Debug/Corelis.dll

## corelis.tcl defines some useful constants
source corelis.tcl
source flash-utils.tcl
source intelflash.tcl

##

set_scan_clk $OSC_30MHZ $CLK_DIV_BY_4

proc doubleword {w} {
    set d [expr ($w << 16) | $w]
    return $d
}
tms_reset 0



## query flash
set addr 0x0
set limit 0x200000

tms_reset 0

## put flash in query mode
puts [aero_write_flash [expr 0x55 << 2] [doubleword 0x98]]
puts [aero_write_flash [expr 0x55 << 2] [doubleword 0x98]]
set val1 [format "\t 0x%08x" [aero_read_flash [expr 0x00 << 2]]]
if {$val1 != 0x00890089} {
    puts "Please reset board and try again: query flash returned $val1"
    exit -1
}
puts "0x00:"
puts [format "\t 0x%08x" [aero_read_flash [expr 0x00 << 2]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x01 << 2]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x02 << 2]]]

## reset flash to read mode
puts [aero_write_flash [expr 0x55 << 2] [doubleword 0xF0]]
puts [aero_write_flash [expr 0x55 << 2] [doubleword 0xF0]]

puts "reading 0x00:"
puts [format "\t 0x%08x" [aero_read_flash [expr 0x00 << 2]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x01 << 2]]]


set kernelStart 0x00040000
set kernelsize [file size $zImageFilename]
programFlashFromFile $zImageFilename $kernelStart "0x5a5abeef $kernelsize 0xC0000000" 0

hard_reset 0
