##
## filename is where we write the binary data
##

## load the DLL defining our new commands for programming flash
load Debug/Corelis.dll

## corelis.tcl defines some useful constants
source corelis.tcl
source flash-utils.tcl

##
source amdflash.tcl

set_scan_clk $OSC_30MHZ $CLK_DIV_BY_8

proc doubleword {w} {
    set d [expr ($w << 16) | $w]
    return $d
}
tms_reset 0



## query flash
set addr 0x0
set limit 0x200000

tms_reset 0

## put flash in query mode
puts [aero_write_flash [expr 0x55 << 2] [doubleword 0x98]]
puts [aero_write_flash [expr 0x55 << 2] [doubleword 0x98]]
puts "0x00:"
puts [format "\t 0x%08x" [aero_read_flash [expr 0x00 << 2]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x01 << 2]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x02 << 2]]]

puts "0x10:"
puts [format "\t 0x%08x" [aero_read_flash [expr 0x10 << 2]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x11 << 2]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x12 << 2]]]

puts "0x30:"
puts [format "\t 0x%08x" [aero_read_flash [expr 0x30 << 2]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x31 << 2]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x32 << 2]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x33 << 2]]]

## reset flash to read mode
puts [aero_write_flash [expr 0x55 << 2] [doubleword 0xFF]]
puts [aero_write_flash [expr 0x55 << 2] [doubleword 0xFF]]


puts "reading 0x00:"
puts [format "\t 0x%08x" [aero_read_flash [expr 0x00 << 2]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x01 << 2]]]

