##
## Support for programming AMD Flash
##


#
# Reset the flash statemachine
#
proc resetFlash {} {
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]
}

#
# Programs a 32-bit word at the given address
#
proc programFlashWord {addr value} {
    send_program_flash_word_command $addr $value
    set count 0
    while {[read_flash_old_way $addr] != $value} {
        # puts "."
        if {$count > 200} {
	    set v1 [read_flash_old_way $addr]
	    set v2 [read_flash_old_way $addr]
	    if {$v1 == $v2} {
		puts "ProgramFlashWord timed out\n"
		puts [format "Count=$count addr=%08x value=%08x flash=%08x flash_read_again=%08x" $addr $value $v1 [read_flash_old_way $addr]]

		resetFlash
		return
	    }
	}
        incr count
    }
}

#
# Erases the whole chip
#
proc eraseFlashChip {} {
    ## reset flash to read mode
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]

    ## put flash in query mode
    puts [write_flash [expr 0x55 << 2] [doubleword 0x98]]
    puts [write_flash [expr 0x55 << 2] [doubleword 0x98]]

    puts [read_flash_old_way [expr 0x10 << 2]]
    puts [read_flash_old_way [expr 0x11 << 2]]
    puts [read_flash_old_way [expr 0x12 << 2]]

    puts [read_flash_old_way [expr 0x10 << 2]]
    puts [read_flash_old_way [expr 0x11 << 2]]
    puts [read_flash_old_way [expr 0x12 << 2]]

    ## reset flash to read mode
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]

    puts "eraseFlashChip  ************************************************************"
    write_flash [expr 0x555 << 2] [doubleword 0xAA]
    write_flash [expr 0x2AA << 2] [doubleword 0x55]
    write_flash [expr 0x555 << 2] [doubleword 0x80]
    write_flash [expr 0x555 << 2] [doubleword 0xAA]
    write_flash [expr 0x2AA << 2] [doubleword 0x55]
    write_flash [expr 0x555 << 2] [doubleword 0x10]
    set count 00
    while {[read_flash_old_way 0] != 0xFFFFFFFF} {
        puts [read_flash_old_way 0]
        if {$count > 1000} {
            puts "EraseFlashChip timed out\n"
            puts [format "Count=$count flash=%08x" [read_flash_old_way 0]]
            exit
        }
	## sleep 10000ms
	after 10000 
        incr count
    }
    puts "eraseFlashChip done 0"
}

#
# Erases the sector starting at addr
#  addr must be a start of sector address
#
proc eraseFlashSector {addr} {
    ## reset flash to read mode
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]

    ## put flash in query mode
    puts [write_flash [expr 0x55 << 2] [doubleword 0x98]]
    puts [write_flash [expr 0x55 << 2] [doubleword 0x98]]

#    puts [read_flash [expr 0x10 << 2]]
#    puts [read_flash [expr 0x11 << 2]]
#    puts [read_flash [expr 0x12 << 2]]

    puts [read_flash_old_way [expr 0x10 << 2]]
    puts [read_flash_old_way [expr 0x11 << 2]]
    puts [read_flash_old_way [expr 0x12 << 2]]

    ## reset flash to read mode
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]

    puts "eraseFlashSector $addr ************************************************************"
    write_flash [expr 0x555 << 2] [doubleword 0xAA]
    write_flash [expr 0x2AA << 2] [doubleword 0x55]
    write_flash [expr 0x555 << 2] [doubleword 0x80]
    write_flash [expr 0x555 << 2] [doubleword 0xAA]
    write_flash [expr 0x2AA << 2] [doubleword 0x55]
    write_flash [expr $addr] [doubleword 0x30]
    set count 00
    while {[read_flash_old_way $addr] != 0xFFFFFFFF} {
        puts [read_flash_old_way $addr]
        if {$count > 1000} {
            puts "EraseFlashSector timed out\n"
            puts [format "Count=$count addr=%08x flash=%08x" $addr [read_flash_old_way $addr]]
            exit
        }
        incr count
    }
    puts "eraseFlashSector done $addr"
}

# sector addresses for 4MB of flash
set 4mbsectors {
    0x00000000
    0x00008000
    0x0000c000
    0x00010000
    0x00020000
    0x00040000
    0x00060000
    0x00080000
    0x000A0000
    0x000C0000
    0x000E0000
    0x00100000
    0x00120000
    0x00140000
    0x00160000
    0x00180000
    0x001A0000
    0x001C0000
    0x001E0000
    0x00200000
    0x00220000
    0x00240000
    0x00260000
    0x00280000
    0x002A0000
    0x002C0000
    0x002E0000
    0x00300000
    0x00320000
    0x00340000
    0x00360000
    0x00380000
    0x003A0000
    0x003C0000
    0x003E0000
}

set 8mbsectors {
    0x00000000
    0x00020000
    0x00040000
    0x00060000
    0x00080000
    0x000a0000
    0x000c0000
    0x000e0000
    0x00100000
    0x00120000
    0x00140000
    0x00160000
    0x00180000
    0x001a0000
    0x001c0000
    0x001e0000
    0x00200000
    0x00220000
    0x00240000
    0x00260000
    0x00280000
    0x002a0000
    0x002c0000
    0x002e0000
    0x00300000
    0x00320000
    0x00340000
    0x00360000
    0x00380000
    0x003a0000
    0x003c0000
    0x003e0000
    0x00400000
    0x00420000
    0x00440000
    0x00460000
    0x00480000
    0x004a0000
    0x004c0000
    0x004e0000
    0x00500000
    0x00520000
    0x00540000
    0x00560000
    0x00580000
    0x005a0000
    0x005c0000
    0x005e0000
    0x00600000
    0x00620000
    0x00640000
    0x00660000
    0x00680000
    0x006a0000
    0x006c0000
    0x006e0000
    0x00700000
    0x00720000
    0x00740000
    0x00760000
    0x00780000
    0x007a0000
    0x007c0000
    0x007e0000
    0x007e4000
    0x007e8000
    0x007ec000
    0x007f0000
    0x007f4000
    0x007f8000
    0x007fc000
}

set sectors $4mbsectors
set sectors $8mbsectors
