/**
 * bs.c talks to JTAG boundary scan port.  
 */


int main()
{
  /* reset */
  soft_reset( );
  pgrm_scan_clk (TAP_1, 30MHZ, NO_PRESCALE, DIVIDE_BY_2);

  int datain[100];
  int dataout = IDCODE; // IDCODE is predefined in a header file
  scan_ir(JTAG_BUS1,&dataout,4); // issue the IDCODE command
  scan_dr(JTAG_BUS1,&dataout,32,&datain[0]); // Read the data out

  /* Prepare the processor to receive scan data to the I/O pins using
     the SAMPLE/PRELOAD instruction */
  dataout = SAMPLE; // SAMPLE is predefined in a header file
  scan_ir (JTAG_BUS1,&dataout,4);

  /* Isolate the internal logic from the actual pins using the EXTEST
     instruction */
  dataout = EXTEST; // EXTEST is predefined in a header file
  scan_ir (JTAG_BUS1,&dataout,4);

  {

    /* Write the FLASH Intelligent Identifier request command: */
    /* scan in the address, data with write strobe active low */

    set_address(0x0); // Function created to modify BSC bits
    set_data(0x90); // Function created to modify BSC bits
    set_control(write_low); // Function created to modify BSC bits
    scan_dr(JTAG_BUS1,&BSC[0],BSC_Length,&datain[0]); // Scan the bits
    /* scan in the write strobe high */
    set_address(0x0); // Function created to modify BSC bits
    set_data(0x90); // Function created to modify BSC bits
    set_control(write_high); // Function created to modify BSC bits
    scan_dr(JTAG_BUS1,&BSC[0],BSC_Length,&datain[0]); // Scan the bits
    /* Read the FLASH ID:
       /* scan in the address with the read strobe active low */
    set_address(0x0); // Function created to modify BSC bits
    set_control(read_low); // Function created to modify BSC bits
    scan_dr(JTAG_BUS1,&BSC[0],BSC_Length,&datain[0]); // Scan the bits
    /* scan in with the read strobe high. The read data is in the scanned out bits from
       the device */
    set_address(0x0); // Function created to modify BSC bits
    set_control(read_high); // Function created to modify BSC bits
    scan_dr(JTAG_BUS1,&BSC[0],BSC_Length,&datain[0]); // Scan the bits
  }

}
