#include <assert.h>
#include <malloc.h>
#include <string.h>
#include "bscan.h"

struct Scanring *new_scanring(long nBits)
{
  struct Scanring *sr = (struct Scanring *)calloc(1, sizeof(struct Scanring));
  long nBytes = nBits / 8 + 1;
  assert(sizeof(char) == 1);
  sr->data = (char*)calloc(nBytes, sizeof(char));
  sr->startBit = 0;
  sr->nBits = nBits;
  sr->nBytes = nBytes;
  return sr;
}

struct Scanring *new_subring(struct Scanring *oldring, long startBit)
{
  struct Scanring *newring = (struct Scanring *)calloc(1, sizeof(struct Scanring));
  newring->data = oldring->data;
  newring->startBit = startBit;
  newring->nBits = oldring->nBits;
  return newring;
}

void set_scanring_bit(struct Scanring *scanring, long bitpos, long value)
{
  long bitnum = bitpos+scanring->startBit;
  long bytenum = bitnum >> 3;
  long bitnumInByte = bitnum & 0x7L;
  long bitmask = 1 << bitnumInByte;
  char data;
  assert(bitnum < scanring->nBits);
  assert(bitnum >= 0);
  data = scanring->data[bytenum] & (char)~bitmask;
  data |= ((value << bitnumInByte)&(char)bitmask);
  scanring->data[bytenum] = data;

}

char get_scanring_bit(struct Scanring *scanring, long bitpos)
{
  long bitnum = bitpos+scanring->startBit;
  long bytenum = bitnum >> 3;
  long bitnumInByte = bitnum & 0x7L;
  char data;
  assert(bitnum < scanring->nBits);
  assert(bitnum >= 0);
  data = (scanring->data[bytenum] >> bitnumInByte) & 1;
  return data;
}

void clear_scanring_bit(struct Scanring *scanring, long bitpos)
{
  long bitnum = bitpos+scanring->startBit;
  long bytenum = bitnum >> 3;
  long bitnumInByte = bitnum & 0x7L;
  long bitmask = 1L << bitnumInByte;
  assert(bitnum < scanring->nBits);
  assert(bitnum >= 0);

  scanring->data[bytenum] &= ~bitmask;
}

void clear_scanring(struct Scanring *scanring)
{
  assert(scanring->startBit == 0);
  memset(scanring->data, 0, scanring->nBytes);
}

void set_scanring_irbit(struct Scanring *scanring, long bitpos, long value)
{
  long bitnum = bitpos;
  long bytenum = bitnum >> 3;
  long bitnumInByte = bitnum & 0x7L;
  long bitmask = 1 << bitnumInByte;
  char instruction;
  assert(scanring->startBit == 0);
  assert(bitnum < scanring->instructionNBits);
  assert(bitnum >= 0);
  instruction = scanring->instruction[bytenum] & (char)~bitmask;
  instruction |= ((value << bitnumInByte)&(char)bitmask);
  scanring->instruction[bytenum] = instruction;
}

char get_scanring_irbit(struct Scanring *scanring, long bitpos)
{
  long bitnum = bitpos;
  long bytenum = bitnum >> 3;
  long bitnumInByte = bitnum & 0x7L;
  char instruction;
  assert(scanring->startBit == 0);
  assert(bitnum < scanring->nBits);
  assert(bitnum >= 0);
  instruction = (scanring->instruction[bytenum] >> bitnumInByte) & 1;
  return instruction;
}

void clear_scanring_irbit(struct Scanring *scanring, long bitpos)
{
  long bitnum = bitpos;
  long bytenum = bitnum >> 3;
  long bitnumInByte = bitnum & 0x7L;
  long bitmask = 1L << bitnumInByte;
  assert(scanring->startBit == 0);
  assert(bitnum < scanring->nBits);
  assert(bitnum >= 0);

  scanring->instruction[bytenum] &= ~bitmask;
}
