#ifndef _BSCAN_H_
#define _BSCAN_H_

enum BS_CELLTYPE {
   INPUT_CELL, CONTROL_CELL, OUTPUT1_CELL, OUTPUT2_CELL, OUTPUT3_CELL, INTERNAL_CELL, CLOCK
};

enum BS_Disable_State {
   Z_STATE, IN_STATE, OUT_STATE
};

enum BS_DONTCARE {
   X=-1
};

enum BS_BCN {
   BC_1,
   BC_2,
   BC_4,
   BC_7
};

typedef struct {
   int cellnum;
   enum BS_BCN bcn;
   const char *name;
   enum BS_CellType cellType;
   int safeValue;
   int controlCell;
   int disableValue;
   enum BS_DisableState disableState;
} ScanCell;

struct Scanring {
   char *data;
   long startBit;
   long nBits;
   long nBytes;
   char instruction[8];
   long instructionNBits;
   long instructionNBytes;
};

extern struct Scanring *new_scanring(long nBits);
extern struct Scanring *new_subring(struct Scanring *oldring, long startBit);
extern void set_scanring_bit(struct Scanring *scanring, long bitpos, long value);
extern char get_scanring_bit(struct Scanring *scanring, long bitpos);
extern void clear_scanring_bit(struct Scanring *scanring, long bitpos);
extern void clear_scanring(struct Scanring *scanring);

#endif /* _BSCAN_H_ */
