##
## Generic Flash Support
##

set FLASH_WORD_SIZE 2

proc doubleword {w} {
    set d [expr ($w << 16) | $w]
    return $d
}

proc programFlashFromFile {filename targetAddress headerDataList fileoffset} {
    global sectors lastAddressProgrammed lastValueProgrammed lastFileOffset

    set fchan [open $filename]
    fconfigure $fchan -translation binary
    seek $fchan $fileoffset

    set fsize [file size $filename]
    set fsize [expr $fsize - $fileoffset]

    set lsize [expr 4 * [llength $headerDataList]]

    set limitAddress [expr $targetAddress + $fsize + $lsize]

    puts "filename=$filename fsize=$fsize lsize=$lsize limitAddress=$limitAddress"
    puts ============================================================

    ## move_to_state RTI

    ## flash reset command:
    resetFlash

    set sectorsToErase {}
    if {1 == 1} {

        set lastsector 0
        foreach sector $sectors {
            if {$lastsector < $targetAddress && $sector > $targetAddress} {
                puts "Need to erase $lastsector"
                set sectorsToErase "$sectorsToErase $lastsector"
            }
            if {$targetAddress <= $sector && $sector < $limitAddress} {
                puts "Need to erase $sector"
                set sectorsToErase "$sectorsToErase $sector"
            }
            set lastsector $sector
        }

        puts $sectorsToErase
    }
    set beginTime [clock seconds]
    puts [clock format $beginTime -format %c]

    if 1 {
        foreach str $sectorsToErase {
            eraseFlashSector $str
        }
        set nbytes 0
        set addr $targetAddress

        foreach val $headerDataList {
            programFlashWord $addr $val
            
            puts [format "Header %08lx %08lx fileoffset=%d" $addr $val $fileoffset]
            incr fileoffset $FLASH_WORD_SIZE
            incr addr $FLASH_WORD_SIZE
            incr nbytes $FLASH_WORD_SIZE

        }

        ## now for the file data
        set_input_channel $fchan
        while {$addr < $limitAddress} {
            # binary scan [read $fchan 4] i1 val
            ## read_dword reads from $fchan
            set val [read_dword]
            if {($nbytes & 0xFFF) == 0} {
                puts [format "%08lx %08lx" $addr $val]
            }
            programFlashWord $addr $val
            incr addr $FLASH_WORD_SIZE
            incr nbytes $FLASH_WORD_SIZE
        }
    }
    set endTime [clock seconds]
    puts [clock format $endTime -format %c]
    set elapsedTime [expr $endTime - $beginTime]
    set Bps [expr $nbytes / $elapsedTime]
    puts "Elapsed time: $elapsedTime seconds ($Bps bytes/second)"
}
