#include <assert.h>
#include <memory.h>

int getFlashNSectors();
int getFlashSectorSize(int sectorNumber);
int eraseFlashSector(uint32 *flashAddr);
int programFlashWord(uint32 *flashAddr, uint32 data);
int unlockFlashBypass();
int resetFlashBypass();
int programFlashWordBypass(uint32 *flashAddr, uint32 data);
int programFlashWord(uint32 *flashAddr, uint32 data);
void writeFlashCommand(int offset, uint32 command);
int pollFlashData(uint32 *flashAddr, uint32 data);
int programFlashSector(uint32 *flashAddr, const uint32 *newdata, size_t sectorSize);
int programFlash(uint32 *flashAddr, const uint32 *data, size_t nbytes);

void writeFlashCommand(int offset, uint32 command)
{
  command &= 0xFF;
  writeFlashUint32(skfmlb.flashBase + (offset << 2), 
                   (command << 16) | command);
}

int pollFlashData(uint32 *flashAddr, uint32 data)
{
  uint32 d7d7 = data & 0x00800080L;
  while (1) {
    uint32 dq = readFlashUint32(flashAddr);
    if ((dq&0x00800080L) == d7d7)
      return SUCCESS;
    if ((dq & (1L<<21)) || (dq & (1L<<5))) {
      dq = readFlashUint32(flashAddr);
      if ((dq&0x00800080L) == d7d7)
	return SUCCESS;
      else
	return FAIL;
    }     
  }
}

int programFlashWord(uint32 *flashAddr, uint32 data)
{
  writeFlashCommand(0x555, 0xAAL);
  writeFlashCommand(0x2AA, 0x55);
  writeFlashCommand(0x555, 0xA0);
  writeFlashUint32(flashAddr, data);
  return pollFlashData(flashAddr, data);
}

int unlockFlashBypass()
{
  assert(!lockBypassed);
  writeFlashCommand(0x555, 0xAA);
  writeFlashCommand(0x2AA, 0x55);
  writeFlashCommand(0x555, 0x20);
  lockBypassed = 1;
  return SUCCESS
}

int unlockFlashBypassReset()
{
  assert(lockBypassed);
  writeFlashCommand(0, 0x90);
  writeFlashCommand(0, 0x00);
  lockBypassed = 0;
  return SUCCESS
}


int unlockFlashBypassProgramWord(uint32 *flashAddr, uint32 data)
{
  assert(lockBypassed);
  writeFlashCommand(0x555, 0xA0);
  writeFlashUint32(flashAddr, data);
  return pollFlashData(flashAddr, data);
}


// programFlashSector:
//  flashAddr must be the beginning of the sector and nbytes must be the length of the sector
int programFlashSector(uint32 *flashAddr, const uint32 *newdata, size_t sectorSize)
{
  int nwords = sectorSize/sizeof(uint32);
  uint32 *endAddr = flashAddr + nwords;
  uint32 *wdata = newdata;

  eraseFlashSector(flashAddr);
  unlockFlashBypass();
  for (uint32 *wflash = flashAddr; wflash < endAddr; wflash++, wdata++) {
    programFlashWordBypass(wflash, *wdata);
  }
  resetFlashBypass();
}

int programFlash(uint32 *flashAddr, const uint32 *data, size_t nbytes)
{
  int nsectors = getFlashNSectors();
  for (int sectorNum = 0; sectorNum < nsectors; sectorNum++) {
    int sectorSize = getFlashSectorSize(sectorNum);
    uint32 *sectorStart = getFlashSectorStart(sectorNum);
    int sectorWords = sectorSize / sizeof(uint32);
    uint32 *nextSectorStart = sectorStart+sectorWords;
    if (flashAddr >= sectorStart && flashAddr < nextSectorStart) {
      int startOffset = flashAddr - sectorStart;

      if (flashAddr > sectorStart || nbytes < sectorSize) {
	int endOffset = (sectorStart+sectorWords)-flashAddr;
	int nbytes1 = sectorSize - startOffset - endOffset;
	uint32 *sectorData = (uint32*)malloc(sectorSize);
	copyFromFlash(sectorData, sectorStart, sectorSize);
	memcpy(sectorData+startOffset, data, nbytes1);
	programFlashSector(sectorStart, sectorData, sectorSize);

	flashAddr += (nbytes1/sizeof(uint23));
	data += (nbytes1/sizeof(uint23));
	free(sectorData);

      } else {
	assert(nbytes >= sectorSize);
	assert(flashAddr == sectorStart);
	programFlashSector(flashAddr, data, sectorSize);
	flashAddr += sectorWords;
	data += sectorWords;
      }
    }
  }
}

