##
## filename is where we write the binary data
##

set FLASH_WORD_SHIFT 1
set bootldrfilename "i:/mobile/jamey/v0bootldr/bootldr"
set bootldrfilename "i:/linux/boot_loader/blob/blob2"
set bootldrfilename "i:/mobile/jamey/ohh/bootldr/bootldr"
set bootldrfilename "c:/corelis/bootldr"

## load the DLL defining our new commands for programming flash
load Debug/Corelis.dll

## corelis.tcl defines some useful constants
source corelis.tcl
source flash-utils16.tcl
source intelflash16.tcl

##

set_scan_clk $OSC_30MHZ $CLK_DIV_BY_32
set_scan_clk $OSC_30MHZ $CLK_DIV_BY_16
set_scan_clk $OSC_30MHZ $CLK_DIV_BY_8
set_scan_clk $OSC_30MHZ $CLK_DIV_BY_4
set_scan_clk $OSC_40MHZ $CLK_DIV_BY_4

proc doubleword {w} {
    set d [expr ($w << 16) | $w]
    return $d
}
hard_reset 0



## query flash
set addr 0x0
set limit 0x200000

set idcode  [read_idcode]
puts "Idcode=$idcode"
aero_write_egpio 0x09000000 255 0x1f
aero_write_egpio 0x09000000 0 0x1f
aero_write_egpio 0x09000000 255 0x1f
aero_write_egpio 0x09000000 0 0x1f
aero_write_egpio 0x09000000 255 0x1f


if {0 == 1} {
    set iaddr 0
    set ilimit [expr 64 * 1024]
    while {$iaddr < $ilimit} {
	puts [format "\t %08x %08x" $iaddr [aero_read_flash $iaddr]]
	incr iaddr 4
    }
    puts "============================================================"
}

## put flash in query mode
aero_write_flash [expr 0x55 << $FLASH_WORD_SHIFT] [doubleword 0x98]
aero_write_flash [expr 0x55 << $FLASH_WORD_SHIFT] [doubleword 0x98]
set val1 [aero_read_flash [expr 0x00 << $FLASH_WORD_SHIFT]]
if {$val1 != 0x00890089} {
    puts "Please reset board and try again: query flash returned $val1"
    exit -1
}

puts "0x00:"
puts [format "\t 0x%08x" [aero_read_flash [expr 0x00 << $FLASH_WORD_SHIFT]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x01 << $FLASH_WORD_SHIFT]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x02 << $FLASH_WORD_SHIFT]]]

puts "0x10:"
puts [format "\t 0x%08x" [aero_read_flash [expr 0x10 << $FLASH_WORD_SHIFT]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x11 << $FLASH_WORD_SHIFT]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x12 << $FLASH_WORD_SHIFT]]]

puts "0x30:"
puts [format "\t 0x%08x" [aero_read_flash [expr 0x30 << $FLASH_WORD_SHIFT]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x31 << $FLASH_WORD_SHIFT]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x32 << $FLASH_WORD_SHIFT]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x33 << $FLASH_WORD_SHIFT]]]

## reset flash to read mode
puts [aero_write_flash [expr 0x55 << $FLASH_WORD_SHIFT] [doubleword 0xF0]]
puts [aero_write_flash [expr 0x55 << $FLASH_WORD_SHIFT] [doubleword 0xF0]]

puts [aero_write_flash [expr 0x55 << $FLASH_WORD_SHIFT] [doubleword 0xFF]]
puts [aero_write_flash [expr 0x55 << $FLASH_WORD_SHIFT] [doubleword 0xFF]]

puts "reading 0x00:"
puts [format "\t 0x%08x" [aero_read_flash [expr 0x00 << $FLASH_WORD_SHIFT]]]
puts [format "\t 0x%08x" [aero_read_flash [expr 0x01 << $FLASH_WORD_SHIFT]]]

# puts "erasing block 0"
# eraseFlashSector 0x0

programFlashFromFile $bootldrfilename 0 {} 0

aero_write_flash 0 [doubleword 0xFF]
aero_write_flash 0 [doubleword 0xFF]
aero_write_flash 0 [doubleword 0xFF]
aero_write_flash 0 [doubleword 0xFF]

# hard_reset 0
