##
## Support for programming Intel Flash
##


proc resetFlash {} {
    enable_vpp
    write_flash [expr 0x55 << 2] [doubleword 0xf0]
    write_flash [expr 0x55 << 2] [doubleword 0xFF]
}

proc eraseFlashSector {addr} {
    ## reset flash to read mode
    enable_vpp
    set count 0
    while {$count < 20} {
        puts [aero_read_flash 0]
        incr count
    }

    aero_write_flash [expr 0x55 << 2] [doubleword 0xFF]
    aero_write_flash [expr 0x55 << 2] [doubleword 0xFF]

    puts "eraseFlashSector $addr ************************************************************"
    enable_vpp

    aero_write_flash [expr 0x55 << 2] [doubleword 0xFF]

    aero_write_flash [expr $addr] [doubleword 0x20]
    aero_write_flash [expr $addr] [doubleword 0xD0]
    set count 00
    while {[expr [aero_read_flash $addr] & 0x00800080] != 0x00800080} {
        puts [aero_read_flash $addr]
        if {$count > 1000} {
            puts "EraseFlashSector timed out\n"
            puts [format "Count=$count addr=%08x flash=%08x" $addr [aero_read_flash $addr]]
            exit
        }
        incr count
    }
    set status [readStatusRegister]
    puts [format "statusRegister=0x%08x" $status]
    ## clearStatusRegister
    if {$status == 0x00800080} {
	puts "eraseFlashSector done $addr"
    } else {
	puts "eraseFlashSector failed with status $status"
	exit -1
    }
}

proc readStatusRegister {} {
    aero_write_flash 0x0 [doubleword 0x70]
    return [aero_read_flash 0x0]
}

proc clearStatusRegister {} {
    aero_write_flash 0x0 [doubleword 0x50]
}


proc programFlashWord {addr value} {
    resetFlash
    clearStatusRegister

    enable_vpp
    aero_write_flash $addr [doubleword 0xff]

    aero_write_flash $addr [doubleword 0x40]
    aero_write_flash $addr $value
    
    set count 0
    set readback [aero_read_flash $addr]
    while {$readback != 0x00800080} {
        # puts "."
        if {$count > 100} {
	    set v1 [readStatusRegister]
	    puts "ProgramFlashWord timed out\n"
	    puts [format "Count=$count addr=%08x value=%08x status=%08x" $addr $value $v1]

	    resetFlash
	    return
	}
        set readback [aero_read_flash $addr]
        incr count
    }
    clearStatusRegister
     # puts [format "addr=%08x value=%08x flash=%08x" $addr $value [aero_read_flash $addr]]
#    resetFlash
}

set sectors {
  0x00000000 
  0x00040000 
  0x00080000 
  0x000c0000 
  0x00100000 
  0x00140000 
  0x00180000 
  0x001c0000 
  0x00200000 
  0x00240000 
  0x00280000 
  0x002c0000 
  0x00300000 
  0x00340000 
  0x00380000 
  0x003c0000 
  0x00400000 
  0x00440000 
  0x00480000 
  0x004c0000 
  0x00500000 
  0x00540000 
  0x00580000 
  0x005c0000 
  0x00600000 
  0x00640000 
  0x00680000 
  0x006c0000 
  0x00700000 
  0x00740000 
  0x00780000 
  0x007c0000 
  0x00800000 
  0x00840000 
  0x00880000 
  0x008c0000 
  0x00900000 
  0x00940000 
  0x00980000 
  0x009c0000 
  0x00a00000 
  0x00a40000 
  0x00a80000 
  0x00ac0000 
  0x00b00000 
  0x00b40000 
  0x00b80000 
  0x00bc0000 
  0x00c00000 
  0x00c40000 
  0x00c80000 
  0x00cc0000 
  0x00d00000 
  0x00d40000 
  0x00d80000 
  0x00dc0000 
  0x00e00000 
  0x00e40000 
  0x00e80000 
  0x00ec0000 
  0x00f00000 
  0x00f40000 
  0x00f80000 
  0x00fc0000 
  0x01000000 
  0x01040000 
  0x01080000 
  0x010c0000 
  0x01100000 
  0x01140000 
  0x01180000 
  0x011c0000 
  0x01200000 
  0x01240000 
  0x01280000 
  0x012c0000 
  0x01300000 
  0x01340000 
  0x01380000 
  0x013c0000 
  0x01400000 
  0x01440000 
  0x01480000 
  0x014c0000 
  0x01500000 
  0x01540000 
  0x01580000 
  0x015c0000 
  0x01600000 
  0x01640000 
  0x01680000 
  0x016c0000 
  0x01700000 
  0x01740000 
  0x01780000 
  0x017c0000 
  0x01800000 
  0x01840000 
  0x01880000 
  0x018c0000 
  0x01900000 
  0x01940000 
  0x01980000 
  0x019c0000 
  0x01a00000 
  0x01a40000 
  0x01a80000 
  0x01ac0000 
  0x01b00000 
  0x01b40000 
  0x01b80000 
  0x01bc0000 
  0x01c00000 
  0x01c40000 
  0x01c80000 
  0x01cc0000 
  0x01d00000 
  0x01d40000 
  0x01d80000 
  0x01dc0000 
  0x01e00000 
  0x01e40000 
  0x01e80000 
  0x01ec0000 
  0x01f00000 
  0x01f40000 
  0x01f80000 
  0x01fc0000 
  0x02000000
}
