##
## Support for programming Intel Flash
##


proc resetFlash {} {
    write_flash [expr 0x55 << $FLASH_WORD_SHIFT] [doubleword 0xFF]
}

proc eraseFlashSector {addr} {
    ## reset flash to read mode
    aero_write_egpio 0x09000000 255 0x1f

    aero_write_flash [expr 0x55 << $FLASH_WORD_SHIFT] [doubleword 0xFF]
    aero_write_flash [expr 0x55 << $FLASH_WORD_SHIFT] [doubleword 0xFF]

    puts "eraseFlashSector $addr ************************************************************"
    aero_write_flash [expr $addr] [doubleword 0x20]
    aero_write_flash [expr $addr] [doubleword 0xD0]
    set count 00
    while {[expr [aero_read_flash $addr] & 0x00800080] != 0x00800080} {
        puts [aero_read_flash $addr]
        if {$count > 1000} {
            puts "EraseFlashSector timed out\n"
            puts [format "Count=$count addr=%08x flash=%08x" $addr [aero_read_flash $addr]]
            exit
        }
        incr count
    }
    set status [readStatusRegister]
    puts [format "statusRegister=0x%08x" $status]
    clearStatusRegister
    if {$status == 0x00800080} {
	puts "eraseFlashSector done $addr"
    } else {
	puts "eraseFlashSector failed with status $status"
	exit -1
    }
}

proc readStatusRegister {} {
    aero_write_flash 0x0 [doubleword 0x70]
    return [aero_read_flash 0x0]
}

proc clearStatusRegister {} {
    aero_write_flash 0x0 [doubleword 0x50]
}


proc programFlashWord {addr value} {
    resetFlash
    clearStatusRegister

    aero_write_egpio 0x09000000 255 0x1f

    aero_write_flash $addr [doubleword 0x40]
    aero_write_flash $addr $value
    
    set count 0
    set readback [aero_read_flash $addr]
    while {$readback != 0x00800080} {
        # puts "."
        if {$count > 100} {
	    set v1 [readStatusRegister]
	    puts "ProgramFlashWord timed out\n"
	    puts [format "Count=$count addr=%08x value=%08x status=%08x" $addr $value $v1]

	    resetFlash
	    return
	}
        set readback [aero_read_flash $addr]
        incr count
    }
    clearStatusRegister
     # puts [format "addr=%08x value=%08x flash=%08x" $addr $value [aero_read_flash $addr]]
#    resetFlash
}

set sectors {
  0x00000000
  0x00020000
  0x00040000
  0x00060000
  0x00080000
  0x000a0000
  0x000c0000
  0x000e0000
  0x00100000
  0x00120000
  0x00140000
  0x00160000
  0x00180000
  0x001a0000
  0x001c0000
  0x001e0000
  0x00200000
  0x00220000
  0x00240000
  0x00260000
  0x00280000
  0x002a0000
  0x002c0000
  0x002e0000
  0x00300000
  0x00320000
  0x00340000
  0x00360000
  0x00380000
  0x003a0000
  0x003c0000
  0x003e0000
  0x00400000
  0x00420000
  0x00440000
  0x00460000
  0x00480000
  0x004a0000
  0x004c0000
  0x004e0000
  0x00500000
  0x00520000
  0x00540000
  0x00560000
  0x00580000
  0x005a0000
  0x005c0000
  0x005e0000
  0x00600000
  0x00620000
  0x00640000
  0x00660000
  0x00680000
  0x006a0000
  0x006c0000
  0x006e0000
  0x00700000
  0x00720000
  0x00740000
  0x00760000
  0x00780000
  0x007a0000
  0x007c0000
  0x007e0000
  0x00800000
  0x00820000
  0x00840000
  0x00860000
  0x00880000
  0x008a0000
  0x008c0000
  0x008e0000
  0x00900000
  0x00920000
  0x00940000
  0x00960000
  0x00980000
  0x009a0000
  0x009c0000
  0x009e0000
  0x00a00000
  0x00a20000
  0x00a40000
  0x00a60000
  0x00a80000
  0x00aa0000
  0x00ac0000
  0x00ae0000
  0x00b00000
  0x00b20000
  0x00b40000
  0x00b60000
  0x00b80000
  0x00ba0000
  0x00bc0000
  0x00be0000
  0x00c00000
  0x00c20000
  0x00c40000
  0x00c60000
  0x00c80000
  0x00ca0000
  0x00cc0000
  0x00ce0000
  0x00d00000
  0x00d20000
  0x00d40000
  0x00d60000
  0x00d80000
  0x00da0000
  0x00dc0000
  0x00de0000
  0x00e00000
  0x00e20000
  0x00e40000
  0x00e60000
  0x00e80000
  0x00ea0000
  0x00ec0000
  0x00ee0000
  0x00f00000
  0x00f20000
  0x00f40000
  0x00f60000
  0x00f80000
  0x00fa0000
  0x00fc0000
  0x00fe0000
  0x01000000

}
