import java.io.*;
import java.util.*;

/****************/
/* BoundaryInfo */
/****************/ 

public class BoundaryInfo {
  private int ringLength;
  private Vector entries;
  private String name;

  public BoundaryInfo() {
    name = null;
    ringLength = -1;
    entries = new Vector();
  }

  public void addRingLength(String data) {
    int index = data.indexOf(';');
    data = data.substring(0, index);
    Vector temp = StringFunctions.filter("BOUNDARY_LENGTH of <STR> : entity is <STR>", data);
	
    if ((temp == null) || (temp.size() != 2)) {
      System.err.println("004) Error parsing ringLength value: " + data);
      return;
    }

    try {
      ringLength = Integer.parseInt((String) temp.elementAt(1));
    } catch (NumberFormatException e) {
      System.err.println("005) Error parsing ringLength value: " + (String) temp.elementAt(1) + " || " + data);
    }
  }

  public void addScanRingInfo(String data) {
    TreeSet ts = new TreeSet();
    TreeSet bns = new TreeSet();
    StringTokenizer st = new StringTokenizer(data, ";&");

    while (st.hasMoreTokens()) {
      BoundaryRegisterEntry bre = new BoundaryRegisterEntry(st.nextToken(), name);
      System.out.println("addScanRingInfo\n\t " + bre.toString());
      ts.add(bre);
    }

    entries.addAll(ts);
  }

  public void setName(String name) {
    this.name = name;
  }

  public String generateCTable() {
    StringBuffer sb = new StringBuffer();

    sb.append("ScanCell " + name.toLowerCase() + "ScanCells[] = {\n");
       
    for (int i = 0; i < entries.size(); i++) {
      sb.append(((BoundaryRegisterEntry)entries.elementAt(i)).generateCEntry() +",\n");
    }

    sb.append("{\t-1,\tBC_4,\t\"end\",\t-1,\tX,\t-1,\tX,\tIN_STATE\t}\n");
    sb.append("};\n\n");

    return sb.toString();
  }

  public String generateHDefine() {
    StringBuffer sbPre = new StringBuffer();
    StringBuffer sbInput = new StringBuffer();
    StringBuffer sbOutput = new StringBuffer();
    StringBuffer sbControl = new StringBuffer();
    StringBuffer sbInternal = new StringBuffer();
    StringBuffer sbClock = new StringBuffer();

    if (name == null) {
      System.err.println("012) Name is not defined, cannot continue!");
    } else {

      sbPre.append("#define " + name.toUpperCase() + "_" + "SCANRING_LENGTH\t" + ringLength + "\n\n");
	    
      for (int i = 0; i < entries.size(); i++) {
        BoundaryRegisterEntry bre = (BoundaryRegisterEntry)entries.elementAt(i);
		
        if (bre.isOutput()) {
          sbOutput.append(bre.generateHEntry() + "\n");
        } else if (bre.isInput()) {
          sbInput.append(bre.generateHEntry() + "\n");
        } else if (bre.isControl()) {
          sbControl.append(bre.generateHEntry() + "\n");
        } else  if (bre.isInternal()) {
          sbInternal.append(bre.generateHEntry() + "\n");
        } else  if (bre.isClock()) {
          sbClock.append(bre.generateHEntry() + "\n");
        } else {

          System.err.println("015) Unknown type of scanRing: " + bre.toString());		    
        }
      }
    }

    return sbPre.toString() + sbOutput.toString() + "\n\n" + sbInput.toString() + "\n\n" + sbControl.toString() + "\n\n" + sbInternal.toString() + "\n\n" + sbClock.toString() + "\n\n";
  }

  public int getRingLength() {
    return ringLength;
  }

  public Vector getEntries() {
    return entries;
  }

  public BoundaryRegisterEntry getScanCell(int scanCell) {
    BoundaryRegisterEntry bre;

    for (int i = 0; i < entries.size(); i++) {
      bre = (BoundaryRegisterEntry) entries.elementAt(i);
	    
      if (bre.getScanCell() == scanCell) return bre;
    }

    System.err.println("018) Error, scanCell not found : " + scanCell);
    return null;
  }

  public String toString() {
    StringBuffer s = new StringBuffer();
	
    s.append("ScanRing Length: " + ringLength + "\n");
	
    for (int i = 0; i < entries.size(); i++) {
      s.append(((BoundaryRegisterEntry) entries.elementAt(i)).toString() + "\n");
    }
	
    return s.toString();
  }
}
