import java.io.*;
import java.util.*;

/*************************/
/* BoundaryRegisterEntry */
/*************************/ 

class BoundaryRegisterEntry implements Comparable {
  public static String[] functionList = {"OUTPUT1_CELL", "OUTPUT2_CELL", "OUTPUT3_CELL", 
                                         "INPUT_CELL", "CONTROL_CELL", "INTERNAL_CELL", "CLOCK"};
  private static String[] functionList2 = {"OUTPUT_CELL", "OUTPUT_CELL", "OUTPUT_CELL", 
                                           "INPUT_CELL", "CONTROL_CELL", "INTERNAL_CELL", "CLOCK"};
  public static int OUTPUT1 = 0, OUTPUT2 = 1, OUTPUT3 = 2, INPUT = 3, CONTROL = 4, INTERNAL = 5, CLOCK = 6;    
  private int scanCell, cntlCell, disableValue, functionNumber;
  private static int controlNumber = 0;
  private String cellType, port, altPort, function, safe, disableState, constantName, name;

  public BoundaryRegisterEntry(String data, String name) {
    Vector temp = null;		

    scanCell = -1;
    cntlCell = -1;
    disableValue = 0;
    functionNumber = -1;
    cellType = "";
    port = "";
    altPort = "";
    function = "";
    safe = "X";
    disableState = "X";
    constantName = "";
    this.name = name;
	
    temp = StringFunctions.filter("\"<STR> (<STR>, <STR>, <STR>, <STR>, <STR>, <STR>, <STR>),\"", data);
    if (temp == null) temp = StringFunctions.filter("\"<STR> (<STR>, <STR>, <STR>, <STR>),\"", data);
    if (temp == null) temp = StringFunctions.filter("\"<STR> (<STR>, <STR>, <STR>, <STR>)\"", data);

    if ((temp == null) || !((temp.size() == 5) || (temp.size() == 8))) {
      System.err.println("006) Error parsing data line: " + data);
      return;
    }
	    
    try {
      scanCell = Integer.parseInt((String) temp.elementAt(0));
    } catch (NumberFormatException e) {
      System.err.println("007) Error parsing scanCell value: " + (String) temp.elementAt(0) + " || " + data);
    }
	
    cellType = (String) temp.elementAt(1);
    port = (String) temp.elementAt(2);

    altPort = port;
    if (port.equals("*")) {
      altPort = Integer.toString(controlNumber);
      controlNumber++;
    }

    function = (String) temp.elementAt(3);
    if (function.toLowerCase().startsWith("control")) functionNumber = CONTROL;
    else if (function.toLowerCase().startsWith("output1")) functionNumber = OUTPUT1;
    else if (function.toLowerCase().startsWith("output2")) functionNumber = OUTPUT2; 
    else if (function.toLowerCase().startsWith("output3")) functionNumber = OUTPUT3;
    else if (function.toLowerCase().startsWith("input")) functionNumber = INPUT;
    else if (function.toLowerCase().startsWith("internal")) functionNumber = INTERNAL;
    else if (function.toLowerCase().startsWith("clock")) functionNumber = CLOCK;
    else System.err.println("008) Unknown function for cell: " + function + " || " + data);
	
    safe = (String) temp.elementAt(4);
    //	System.out.println("SCANCELL: " + scanCell + " | SAFE: " + safe);

    if ((temp.size() == 8) && (functionNumber == OUTPUT3)) {
      try {
        cntlCell = Integer.parseInt((String) temp.elementAt(5));
      } catch (NumberFormatException e) {
        System.err.println("009) Error parsing cntlCell value: " + (String) temp.elementAt(5) + " || " + data);
      }
	    
      try {
        disableValue = Integer.parseInt((String) temp.elementAt(6));
      } catch (NumberFormatException e) {
        System.err.println("010) Error parsing disableValue value: " + (String) temp.elementAt(6) + " || " + data);
      }

      disableState = (String) temp.elementAt(7);
    }
  }

  public String generateCEntry() {
    StringBuffer sb = new StringBuffer();

    sb.append("{\t" + scanCell + ",\t" + cellType + ",\t" + "\"" + StringFunctions.removeParens(port) 
              + "\",\t" + functionList[functionNumber] + ",\t" + safe.toUpperCase() + ",\t" + cntlCell 
              + ",\t" + disableValue + ",\t");
	
    if (disableState.equalsIgnoreCase("Z")) sb.append("Z_STATE\t}");
    else sb.append("IN_STATE\t}");

    return sb.toString();
  }

  public String generateConstant() {
    return functionList2[functionNumber] + "_" + name.toUpperCase() + "_" 
      + StringFunctions.removeParens(altPort);
  }

  public String generateHEntry() {
    StringBuffer sb = new StringBuffer();       

    sb.append("#define " + generateConstant() + "\t" + scanCell);

    return sb.toString();
  }
    
  public boolean isOutput() {
    return (isOutput1() || isOutput2() || isOutput3());
  }
    
  public boolean isOutput1() {
    return (functionNumber == OUTPUT1);
  }

  public boolean isOutput2() {
    return (functionNumber == OUTPUT2);
  }

  public boolean isOutput3() {
    return (functionNumber == OUTPUT3);
  }

  public boolean isInput() {
    return (functionNumber == INPUT);
  }

  public boolean isControl() {
    return (functionNumber == CONTROL);
  }

  public boolean isInternal() {
    return (functionNumber == INTERNAL);
  }

  public boolean isClock() {
    return (functionNumber == CLOCK);
  }
    
  public boolean isControlled() {
    return (cntlCell != -1);
  }

  public int getScanCell() {
    return scanCell;
  }

  public int getCntlCell() {
    return cntlCell;
  }

  public int getDisableValue() {
    return disableValue;
  }
	
  public String getCellType() {
    return cellType;
  }

  public String getPort() {
    return port;
  }

  public String getAltPort() {
    return altPort;
  }
    
  public String getFunction() {
    return function;
  }

  public int getFunctionNumber() {
    return functionNumber;
  }
    
  public String getSafe() {
    return safe;
  }
    
  public String getDisableState() {
    return disableState;
  }


  public int compareTo(Object o) {
    if (this.scanCell > ((BoundaryRegisterEntry)o).scanCell) return 1;
    else if (this.scanCell < ((BoundaryRegisterEntry)o).scanCell) return -1;	
    else return 0;
  }

  public String toString() {	
    String s = new String();

    s = "| " + scanCell + " || " + cellType + " || " + port + " || " + function + " || " + safe + " |";
	
    if (functionNumber == OUTPUT3) {
      s += "| " + cntlCell + " || " + disableValue + " || " + disableState + " |";
    }
	
    return s;
  }
}
