import java.io.*;
import java.util.*;

/*******************/
/* InstructionInfo */
/*******************/ 

public class InstructionInfo {
    private int instructionLength;
    private Vector instructions;
    private String name;

    public InstructionInfo() {
	instructionLength = 0;
	instructions = new Vector();
    }
    
    public void addInstructionLength(String data) {
	int index = data.indexOf(';');
	data = data.substring(0, index);
	Vector temp = StringFunctions.filter("INSTRUCTION_LENGTH of <STR> : entity is <STR>", data);
	
	if ((temp == null) || (temp.size() != 2)) {
	    System.err.println("000) Error parsing instructionLength value: " + data);
	    return;
	}
	
	try {
	    instructionLength = Integer.parseInt((String) temp.elementAt(1));
	} catch (NumberFormatException e) {
	    System.err.println("001) Error parsing instructionLength value: " + (String) temp.elementAt(1) + " || " + data);
	}
    }
    
    public void addInstructionInfo(String data) {	
	StringTokenizer st = new StringTokenizer(data, ";&");
	
	while (st.hasMoreTokens()) {
	    instructions.addElement(new InstructionEntry(st.nextToken()));
	}
    }

    public String generateHStuff() {
	StringBuffer sb = new StringBuffer();
	if (name == null) {
	    System.err.println("013) Name is not defined, cannot continue!");
	} else {

	    sb.append("#define " + name.toUpperCase() + "_" + "INSTRUCTION_LENGTH\t" + instructionLength + "\n\n");
	    sb.append("enum " + name.toUpperCase() + "Instruction {\n");

	    for (int i = 0; i < instructions.size(); i++) {
		sb.append(((InstructionEntry)instructions.elementAt(i)).generateHEntry(name));
		if (i != instructions.size()-1) sb.append(",\n");
		else sb.append("\n");
	    }

	    sb.append("};\n\n");
	}

	return sb.toString();
    }

    public void setName(String name) {
	this.name = name;
    }
    
    public int getInstructionLength() {
	return instructionLength;
    }
    
    public Vector getInstructions() {
	return instructions;
    }    

    public String toString() {
	StringBuffer s = new StringBuffer();

	s.append("Instruction Length: " + instructionLength + "\n");
	
	for (int i = 0; i < instructions.size(); i++) {
	    s.append(((InstructionEntry) instructions.elementAt(i)).toString() + "\n");
	}
	
	return s.toString();
    }
}


/********************/
/* InstructionEntry */
/********************/ 

class InstructionEntry implements Comparable {
    private int opcode;
    private String name;
    
    public InstructionEntry(String data) {	
	Vector temp;
	
	opcode = -1;
	name = "";
	
	temp = StringFunctions.filter("\"<STR> (<STR>),\"", data);
	if (temp == null) temp = StringFunctions.filter("\"<STR> (<STR>)\"", data);

	if ((temp == null) || (temp.size() != 2)) {
	    System.err.println("002) Error parsing data line: " + data);
	    return;
	}

	name = (String) temp.elementAt(0);

	try {
	    opcode = Integer.parseInt((String) temp.elementAt(1),2);
	} catch (NumberFormatException e) {
	    System.err.println("003) Error parsing ringLength value: " + (String) temp.elementAt(1) + " || " + data);
	}	
    }

    public String generateHEntry(String deviceName) {
	StringBuffer sb = new StringBuffer();
	sb.append(deviceName.toUpperCase() + "_" + name + " =\t0x" + Integer.toHexString(opcode));	

	return sb.toString();
    }

    public int getOpcode() {
	return opcode;
    }

    public String getName() {
	return name;
    }

    public int compareTo(Object o) {
	if (this.opcode > ((InstructionEntry)o).opcode) return 1;
	else if (this.opcode < ((InstructionEntry)o).opcode) return -1;
	else return 0;
    }

    public String toString() {
	return "| " + name + " || " + Integer.toHexString(opcode) + " |";
    }
}

