import java.io.*;
import java.util.*;

public class Port implements Comparable {
  /**
   * the name of this port
   */
  private String name;
  /**
   * name of the bus this entry belongs to
   */
  private String bname;
  /**
   * index of this entry within the bus to which it belongs
   */
  private int bindex;

  public Port(String name) {
    this.name = name;
    if (isBusElement()) {
      int i;
      int nameLen = 0;
      for (i = name.length(); i > 1; i--) {
        char c = name.charAt(i-1);
        if (!((c >= '0') && (c <= '9')))
          break;
      }
      if (name.charAt(i-1) == '_') {
         nameLen = i-1;
      } else {
         nameLen = i;
      }
      bname = name.substring(0, nameLen);
      bindex = Integer.valueOf(name.substring(i, name.length())).intValue();
    }
    System.out.println("Port: this=" + this + " name=" + name);
    if (bname != null) {
        System.out.println("\t busName=" + bname + " bindex=" + bindex);
    }
  }

  public String getName() { return name; };


  /**
   * returns true if this entry's name ends in a number
   */
  public boolean isBusElement() {
    char lastChar = name.charAt(name.length()-1);
    return ((lastChar >= '0') && (lastChar <= '9'));
  };

  /**
   * returns the prefix of the name without the numeric suffix
   */
  public String getBusName() {
    return bname;
  };

  /**
   * return the index of this element within the bus to which it belongs
   */
  public int getBusIndex() {
    return bindex;
  };

  public int compareTo(Object o) {
    return this.name.compareTo(((Port)o).name);
  };
}
