import java.io.*;
import java.util.*;

/************/
/* PortInfo */
/************/ 

public class PortInfo {
  private String name;
  /**
   * maps String portNames to Port objects
   */
  private Hashtable ports;
  /**
   *
   */
  private TreeMap buses;

  /**
   * Names of the controlled ports (String values)
   */
  private Hashtable controlledPorts;
  private Hashtable[] portCellMaps;
  private static int numFunctions = 7;

  public PortInfo() {
    name = null;
    ports = new Hashtable();
    controlledPorts = new Hashtable();

    buses = new TreeMap();

    portCellMaps = new Hashtable[numFunctions];
    for (int i = 0; i < numFunctions; i++) {
      portCellMaps[i] = new Hashtable();
    }
  }

  public void addPortInfo(String data) {
    StringTokenizer st = new StringTokenizer(data, ";");

    while (st.hasMoreTokens()) {
      String portName = extractPortName((String) st.nextElement());
      System.out.println("addPortInfo: portname=" + portName);
      Port port = new Port(portName);
      ports.put(portName, port);
      if (port.isBusElement()) {
        String busName = port.getBusName();
        Bus bus = (Bus)buses.get(busName);
        if (bus == null) {
          bus = new Bus(busName);
          buses.put(busName, bus);
        }
        bus.addElement(portName, port.getBusIndex());
      }
    }
  }
    
  public void addControlledPort(String portName, String controlCell) {
    if ((controlledPorts.get(portName) != null) && !(controlledPorts.get(portName).equals(controlCell))) {
      System.err.println("016) Error, trying to add port that is controlled by two different ringNumbers! : " + portName + " | " + controlCell);
      return;
    } else {
      if (!ports.containsKey(portName)) {
        System.err.println("017) Error, port name discrepancy : " + portName);
        return;
      } else {
        controlledPorts.put(portName, controlCell);
      }
    }
  }

  public void addPortCellMap(String portName, String scanCell, int type) {
    Vector temp;

    if (!ports.containsKey(portName)) {
      // System.err.println("018) Error, port name discrepancy: " + portName + " scanCell=" + scanCell);
      return;
    } else {
      temp = (Vector) portCellMaps[type].get(portName);
      if (temp == null) temp = new Vector();

      if (!temp.contains(scanCell)) temp.addElement(scanCell);
      System.out.println("addPortCellMap: portName=" + portName + ", scanCell=" + scanCell + ", type=" + type + "\n");
      portCellMaps[type].put(portName, temp);
    }          
  }

  public String extractPortName(String data) {
    StringTokenizer st = new StringTokenizer(data, ":");
	
    if (st.hasMoreElements()) return ((String) st.nextElement()).trim();
    else return data;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String generateCFunctions() {
    StringBuffer sb = new StringBuffer();

    if (name == null) {
      System.err.println("015) Name is not defined, cannot continue!");
    } else {

      sb.append("extern void reset" + name.toUpperCase() + "Scanring(void)\n");
      sb.append("{\n");
      sb.append("  int i = 0;\n");
      sb.append("  assert("+ name.toLowerCase() + "Scanring != NULL);\n");
      sb.append("  /* disable all the output pins by default */\n");
      sb.append("  while (" + name.toLowerCase() + "ScanCells[i].cellnum >= 0) {\n");
      sb.append("    ScanCell *sc = &"+ name.toLowerCase() + "ScanCells[i];\n");
      sb.append("    switch (sc->cellType) {\n");
      sb.append("    case INPUT_CELL: /* do nothing */\n");
      sb.append("    case INTERNAL_CELL: /* do nothing */\n");
      sb.append("    case CLOCK: /* do nothing */\n");
      sb.append("      break;\n");
      sb.append("    case CONTROL_CELL: /* handle this when we visit the output cell */\n");
      sb.append("      break;\n");
      sb.append("    case OUTPUT1_CELL:\n");
      sb.append("    case OUTPUT2_CELL:\n");
      sb.append("    case OUTPUT3_CELL:\n");
      sb.append("      /* disable this cell by default */\n");
      sb.append("      if (sc->controlCell >= 0) {\n");
      sb.append("        set_scanring_bit(" + name.toLowerCase() + "Scanring, sc->controlCell, sc->disableValue);\n");
      sb.append("      }\n");
      sb.append("      break;\n");
      sb.append("    default: {\n");
      sb.append("      int improperCellType = 0;\n");
      sb.append("      assert(improperCellType);\n");
      sb.append("    }\n}\ni++;\n}\n");
      sb.append("}\n\n");

      for (Enumeration is = ports.elements(); is.hasMoreElements(); ) {
        String controlCell;
        Port port = (Port)is.nextElement();
        String portName = port.getName();
        Vector outputCells = getOutputCells(portName);
        String inputCell = getInputCell(portName);
		
        System.out.println("genC: port=" + port + " portName=" + portName + " outputCells=" + outputCells + " inputCell=" + inputCell + "\n");

        if (inputCell != null) {
            sb.append("long get_" + name.toUpperCase() + "_" + (portName).toUpperCase() + "()\n");
            sb.append("{\n");
            sb.append("  return get_scanring_bit(" + name.toLowerCase() + "Scanring, " + inputCell + ");\n");
            sb.append("}\n");
        }
        if (outputCells != null) {
            String outputCell = (String) outputCells.elementAt(0);
            sb.append("void set_" + name.toUpperCase() + "_" + (portName).toUpperCase() + "(long val)\n");
            sb.append("{\n");
            sb.append("  set_scanring_bit(" + name.toLowerCase() + "Scanring, " + outputCell + ", val);\n");
            sb.append("}\n");
            if ((controlCell = (String) controlledPorts.get(portName)) != null) {
		    
                /* Enable Port */
                sb.append("void enable_" + name.toUpperCase() + "_" + (portName).toUpperCase() + "()\n");
                sb.append("{\n");
                sb.append("  int disableValue = " + name.toLowerCase() + "ScanCells[" + outputCell + "].disableValue;\n");
                sb.append("  set_scanring_bit(" + name.toLowerCase() + "Scanring, " + controlCell + ", ~disableValue);\n");
                sb.append("}\n\n");

		    
                /* Disable Port */
                sb.append("void disable_" + name.toUpperCase() + "_" + (portName).toUpperCase() + "()\n");
                sb.append("{\n");
                sb.append("  int disableValue = " + name.toLowerCase() + "ScanCells[" + outputCell + "].disableValue;\n");
                sb.append("  set_scanring_bit(" + name.toLowerCase() + "Scanring, " + controlCell + ", disableValue);\n");
                sb.append("}\n\n");
            }
        }
        sb.append("\n");
      }
      for (Iterator bs = buses.values().iterator(); bs.hasNext(); ) {
        Bus bus = (Bus)bs.next();
        sb.append("long get_" + name.toUpperCase() + "_" + bus.getName() + "()\n");
        sb.append("{\n");
        sb.append("  long val = 0;\n");
        for (Iterator bi = bus.iterator(); bi.hasNext(); ) {
            BusElement be = (BusElement)bi.next();
            String bitname = be.getName();
            String bitInputCell = getInputCell(bitname);
            if (bitInputCell != null) {
                sb.append("  val |= (get_scanring_bit(" + name.toLowerCase() + "Scanring, " + bitInputCell + ") << " + be.getIndex()
                          + ");\n");
            }
        }
        sb.append("  return val;\n");
        sb.append("}\n");
        sb.append("void set_" + name.toUpperCase() + "_" + bus.getName() + "(long val)\n");
        sb.append("{\n");
        for (Iterator bi = bus.iterator(); bi.hasNext(); ) {
            BusElement be = (BusElement)bi.next();
            String bitname = be.getName();
            Vector bitOutputCells = getOutputCells(bitname);
            if (bitOutputCells != null) {
                String bitOutputCell = (String)bitOutputCells.elementAt(0);
                sb.append("  set_scanring_bit(" + name.toLowerCase() + "Scanring, " 
                          + bitOutputCell + ", " 
                          + "(val >> " + be.getIndex() + ")&1"
                          + ");\n");
            }
        }
        sb.append("}\n");

        sb.append("void enable_" + name.toUpperCase() + "_" + bus.getName() + "()\n");
        sb.append("{\n");
        sb.append("  int disableValue;\n");
        Vector visitedControlCells = new Vector();
        for (Iterator bi = bus.iterator(); bi.hasNext(); ) {
            BusElement be = (BusElement)bi.next();
            String bitname = be.getName();
            String controlCell = (String) controlledPorts.get(bitname);
            Vector bitOutputCells = getOutputCells(bitname);
            if (controlCell != null && !visitedControlCells.contains(controlCell)) {
                String outputCell = (String)bitOutputCells.elementAt(0);
                sb.append("  disableValue = " + name.toLowerCase() + "ScanCells[" + outputCell + "].disableValue;\n");
                sb.append("  set_scanring_bit(" + name.toLowerCase() + "Scanring, " 
                          + controlCell + ", ~disableValue);\n");
                visitedControlCells.add(controlCell);
            }
        }
        sb.append("}\n");

        sb.append("void disable_" + name.toUpperCase() + "_" + bus.getName() + "()\n");
        sb.append("{\n");
        sb.append("  int disableValue;\n");
        visitedControlCells = new Vector();
        for (Iterator bi = bus.iterator(); bi.hasNext(); ) {
            BusElement be = (BusElement)bi.next();
            String bitname = be.getName();
            String controlCell = (String) controlledPorts.get(bitname);
            Vector bitOutputCells = getOutputCells(bitname);
            if (controlCell != null && !visitedControlCells.contains(controlCell)) {
                String outputCell = (String)bitOutputCells.elementAt(0);
                sb.append("  disableValue = " + name.toLowerCase() + "ScanCells[" + outputCell + "].disableValue;\n");
                sb.append("  set_scanring_bit(" + name.toLowerCase() + "Scanring, " 
                          + controlCell + ", disableValue);\n");
                visitedControlCells.add(controlCell);
            }
        }
        sb.append("}\n");
      }
    }
	
    return sb.toString();
  }

  public String generateHPrototypes() {
    StringBuffer sb = new StringBuffer();
    if (name == null) {
      System.err.println("014) Name is not defined, cannot continue!");
    } else {

      sb.append("extern void reset" + name.toUpperCase() + "Scanring(void);\n\n");

      for (Enumeration is = ports.elements(); is.hasMoreElements(); ) {
        String controlCell;
        Port port = (Port)is.nextElement();
        String portName = port.getName();

        if (controlledPorts.get(portName) != null) {
          sb.append("extern void enable_" + name.toUpperCase() + "_" + (portName).toUpperCase() + "();\n");
          sb.append("extern void disable_" + name.toUpperCase() + "_" + (portName).toUpperCase() + "();\n");
        }

        sb.append("extern long get_" + name.toUpperCase() + "_" + (portName).toUpperCase() + "();\n");
        sb.append("extern void set_" + name.toUpperCase() + "_" + (portName).toUpperCase() + "(long);\n\n");
      }
      for (Iterator bs = buses.values().iterator(); bs.hasNext(); ) {
        Bus bus = (Bus)bs.next();
        sb.append("long get_" + name.toUpperCase() + "_" + bus.getName() + "();\n");
        sb.append("void set_" + name.toUpperCase() + "_" + bus.getName() + "(long val);\n");
        sb.append("void enable_" + name.toUpperCase() + "_" + bus.getName() + "();\n");
        sb.append("void disable_" + name.toUpperCase() + "_" + bus.getName() + "();\n");
      }
    }

    return sb.toString();
  }

  public Map getPorts() {
    return ports;
  };

  public String getInputCell(String portName) {
    Vector temp = (Vector) portCellMaps[BoundaryRegisterEntry.INPUT].get(portName);
    if (temp == null)
        return null;
    else
        return (String)temp.elementAt(0);
  };

  public Vector getOutputCells(String portName) {
    Vector temp;

    if ((temp = (Vector) portCellMaps[BoundaryRegisterEntry.OUTPUT1].get(portName)) != null) return temp;
    else if ((temp = (Vector) portCellMaps[BoundaryRegisterEntry.OUTPUT2].get(portName)) != null) return temp;
    else if ((temp = (Vector) portCellMaps[BoundaryRegisterEntry.OUTPUT3].get(portName)) != null) return temp;
    else return temp;
  };

  public String toString () {
    StringBuffer s = new StringBuffer();
    Vector temp;
    String str;
	
    for (Enumeration is = ports.elements(); is.hasMoreElements(); ) {
      String controlCell;
      Port port = (Port)is.nextElement();
      String portName = port.getName();
      s.append("***\n");
      s.append("Port: " + portName + "\n");

      for (int k = 0; k < numFunctions; k++) {
        s.append("\t*** " + BoundaryRegisterEntry.functionList[k] + " ***\n");

        if ((temp = (Vector) portCellMaps[k].get(portName)) != null) {
          for (int j = 0; j < temp.size(); j++) {
            s.append("\t\t" + ((String) temp.elementAt(j))+ "\n");
          }
        }
      }
	    
      if ((str = (String) controlledPorts.get(portName)) != null) {
        s.append("\tControlled by: \n\t\t" + str + "\n");
      }	    
    }
	
    return s.toString();
  }
}



