import java.io.*;
import java.util.*;

/*******************/
/* StringFunctions */
/*******************/ 

class StringFunctions {
    public static int INT = 0, STR = 1, CHR = 2;

    /* CURRENT RECOGNIZED DATA TYPES: <STR> */

    public static Vector filter(String filter, String data) {
	String orgFilter = filter;
	String orgData = data;

	Vector extractedData = new Vector();
	int filterIndex = 0;
	int dataIndex = 0;
	String temp, subfilter;
	
	data = removeWhiteSpace(data);
	filter = removeWhiteSpace(filter);

	/* Check if we need to match leading text */
	filterIndex = filter.indexOf('<');

	if (filterIndex > 0) {	    
	    /* Leading text exists */
	    if (filter.substring(0, filterIndex).equalsIgnoreCase(data.substring(0, filterIndex))) {
		data = data.substring(filterIndex);
		filter = filter.substring(filterIndex);
	    } else {
		return null;
	    }
	} 
	
	/* Now, filter begins w/ a "<???>" control sequence */

	while (filter.length() > 0) {
	    /* Now we want to split the filter into "<???>XXX" +
               "<???>YYY" sequences */
	    
	    /* Start by finding start of next control signal (if any) */
	    filterIndex = filter.indexOf('<', 1);
	    
	    if (filterIndex == -1) {
		subfilter = filter;
		filter = new String();
	    } else {
		subfilter = filter.substring(0, filterIndex);
		filter = filter.substring(filterIndex);
	    }

	    /* Now subfilter contains the first filter + string pair
               "<???>XXX" and filter has the rest */
	    
	    filterIndex = subfilter.indexOf('>');
	    
	    if (filterIndex == -1) {
		return null;
	    } 
	    
	    /**** ASSUME ALL CONTROLS ARE STRINGS FOR NOW !!!  ****/
	    /**** Add code here to decode which control string ****/
	    subfilter = subfilter.substring(filterIndex+1);
	    
	    dataIndex = data.indexOf(subfilter);
	    
	    if (dataIndex < 0) {
		return null;
	    } 

	    if (dataIndex == 0) dataIndex = data.length();

	    temp = data.substring(0, dataIndex);
	    data = data.substring(dataIndex + subfilter.length());
	    
	    extractedData.addElement(temp);

	}

	if (data.length() != 0) {
	    return null;
	}

	return extractedData;
    }

    public static String removeWhiteSpace(String data) {
	StringBuffer sb = new StringBuffer();
	StringTokenizer st = new StringTokenizer(data);
	
	while (st.hasMoreElements()) {
	    sb.append((String) st.nextElement());
	}

	return sb.toString();
    }

    public static String removeBSDLComment(String data) {
	int index = data.indexOf("--");
	if (index >= 0) return data.substring(0, index);
	else return data;
    }

    public static String removeParens(String data) {
	StringBuffer sb = new StringBuffer();
	StringTokenizer st = new StringTokenizer(data, "()");
	
	while (st.hasMoreElements()) {
	    sb.append((String) st.nextElement());
	}

	return sb.toString();
    }

    public static String extractPortName(String data) {
	StringTokenizer st = new StringTokenizer(data, "(");
	
	if (st.hasMoreElements()) return ((String) st.nextElement()).trim();
	else return data;
    }
}
