/* A BSDL to C convertor for CRL in-house JTAG testing
   Date: 07/20/1999
   Author: Nilesh Agarwalla, Compaq Computer Corporation */

import java.io.*;
import java.util.*;
import java.text.*;

public class bsdl2c {
    public static BoundaryInfo boundaryInfo;
    public static InstructionInfo instructionInfo;
    public static PortInfo portInfo;
    private static String name;
    private static boolean foundEntity, foundPort, foundBoundaryRegister, 
	foundBoundaryLength, foundInstructionOpCode, foundInstructionLength;
	

    public static void main(String args[]) {
	LineNumberReader input = null;

	if (args.length != 1) error("Usage: bsdl2c bsdlfilename");
	
	try {
	    input = new LineNumberReader(new FileReader(args[0]));
	} catch (FileNotFoundException e) {
	    error("File not found: " + args[0]);
	}
	
	boundaryInfo = new BoundaryInfo();
	instructionInfo = new InstructionInfo();
	portInfo = new PortInfo();

	try {
	    for(;;) {
		StringBuffer buffer = new StringBuffer();
		String temp = input.readLine();
		if (temp == null) break;
		temp = temp.trim();

		/* Extract port info */
		if (temp.startsWith("port")) {		    
		    do {
			temp = StringFunctions.removeBSDLComment(input.readLine().trim());
			if (temp.length() > 0) buffer.append(temp);
		    } while (temp.indexOf(';') != -1);
		    
		    portInfo.addPortInfo(buffer.toString());
		    temp = new String();
		}

		/* Extract part name */
		if (temp.startsWith("entity") && !foundEntity) {
		    Vector temp2 = StringFunctions.filter("entity <str> is <str>", temp);
		    if ((temp2 != null) && (temp2.size() == 2)) {
			boundaryInfo.setName((String) temp2.elementAt(0));
			instructionInfo.setName((String) temp2.elementAt(0));
			portInfo.setName((String) temp2.elementAt(0));
			name = (String) temp2.elementAt(0);
		    }
		    temp = new String();			
		    foundEntity = true;
		}		    
		    
		if (temp.startsWith("attribute")) {
		    temp = temp.substring(9).trim();
		    
		    /* Extract BOUNDARY_REGISTER section */
		    if (temp.startsWith("BOUNDARY_REGISTER") && !foundBoundaryRegister) {		
			//			System.out.println("Found Boundary Register");
			do {
			    temp = StringFunctions.removeBSDLComment(input.readLine().trim());
			    if (temp.length() > 0) buffer.append(temp);
			} while (temp.indexOf(';') == -1);
			
			boundaryInfo.addScanRingInfo(buffer.toString());
			temp = new String();			
			foundBoundaryRegister = true;
		    }

		    /* Extract BOUNDARY_LENGTH section */
		    if (temp.startsWith("BOUNDARY_LENGTH") && !foundBoundaryLength) {		
			//			System.out.println("Found Boundary Length");
			do {
			    temp = StringFunctions.removeBSDLComment(temp);
			} while (temp.indexOf(';') == -1);
			
			boundaryInfo.addRingLength(temp);
			temp = new String();
			foundBoundaryLength = true;
		    }

		    /* Extract Instruction Opcode section */
		    if (temp.startsWith("INSTRUCTION_OPCODE") && !foundInstructionOpCode) {		
			//			System.out.println("Found Instruction Opcode");
			do {
			    temp = StringFunctions.removeBSDLComment(input.readLine().trim());
			    buffer.append(temp);
			} while (temp.indexOf(';') == -1);
			
			instructionInfo.addInstructionInfo(buffer.toString());
			temp = new String();
			foundInstructionOpCode = true;
		    }

		    /* Extract Insruction Length section */
		    if (temp.startsWith("INSTRUCTION_LENGTH") && !foundInstructionLength) {		
			//			System.out.println("Found Instruction Length");
			do {
			    temp = StringFunctions.removeBSDLComment(temp);
			} while (temp.indexOf(';') == -1);
			
			instructionInfo.addInstructionLength(temp);
			temp = new String();
			
			foundInstructionLength = true;
		    }		    
		}
	    }	 
	} catch (IOException e) {
	    error("IOException...suck.");
	}   


	if (foundEntity && foundPort && foundBoundaryRegister && foundBoundaryLength 
	    && foundInstructionOpCode && foundInstructionLength) {
	    
	    if (!foundEntity) System.err.println("Couldn't find entity name");
	    if (!foundPort) System.err.println("Couldn't find ports");
	    if (!foundBoundaryLength) System.err.println("Couldn't find boundary length");
	    if (!foundInstructionOpCode) System.err.println("Couldn't find instruction op-code");
	    if (!foundInstructionLength) System.err.println("Couldn't find instruction length");
	    
	} else {

          /* ********************
             We have all the data we need. So, now we need generate some
             lookup tables.  In particular, we need 2 mappings:
	  
             PORT -> SCANCELLS
             PORT -> CONTROLCELL (if any)
	  
             Both are held in class PortInfo
             ******************** */
	    
	    Vector entries = boundaryInfo.getEntries();
	    
	    for (int i=0; i < entries.size(); i++) {
		BoundaryRegisterEntry bre = (BoundaryRegisterEntry) entries.elementAt(i);
		String portName = StringFunctions.extractPortName(bre.getAltPort());
	    
		portInfo.addPortCellMap(portName, bre.generateConstant(), bre.getFunctionNumber());

		if (bre.isControlled()) {
		    BoundaryRegisterEntry breControl = boundaryInfo.getScanCell(bre.getCntlCell());
		
		    if (breControl != null) portInfo.addControlledPort(portName, breControl.generateConstant());
		}
	    }

	    /* We have all the info we need, so now generate the C code! */

	    StringBuffer hFile = new StringBuffer();
	    StringBuffer cFile = new StringBuffer();

	    hFile.append(genericHHeader());
	    hFile.append(instructionInfo.generateHStuff());
	    hFile.append(boundaryInfo.generateHDefine());
	    hFile.append(portInfo.generateHPrototypes());
	    hFile.append(genericHFooter());

	    cFile.append(genericCHeader());
	    cFile.append(boundaryInfo.generateCTable());
	    cFile.append(portInfo.generateCFunctions());
	    cFile.append(genericCFooter());
	
	    File hOutFile = new File(name + "bs.h");
	    File cOutFile = new File(name + "bs.c");
	

	    try {
		if (!hOutFile.createNewFile()) {
		    System.err.println("File: " + hOutFile.toString() + " already exists!");
		    return;
		}
	    
		if (!cOutFile.createNewFile()) {
		    System.err.println("File: " + cOutFile.toString() + " already exists!");
		    return;
		}
	    
		FileWriter hOutput = new FileWriter(hOutFile);
		FileWriter cOutput = new FileWriter(cOutFile);
	    
	    
		System.out.println("Writing: " + hOutFile.toString());
		hOutput.write(hFile.toString(), 0, hFile.length());
		System.out.println("Writing: " + cOutFile.toString());
		cOutput.write(cFile.toString(), 0, cFile.length());
	    
		hOutput.close();
		cOutput.close();			    
	    } catch (IOException e) {
		System.err.println("Error creating output files, aborting.");
		return;
	    }	
	}
    }   


    private static String genericHHeader() {
	StringBuffer sb = new StringBuffer();
	Date date = new Date();
	
	sb.append("/* " + name.toLowerCase() + "bs.h generated by bsdl2c on " + 
		  DateFormat.getDateTimeInstance().format(date) + " */\n\n");
	
	sb.append("#ifndef _" + name.toUpperCase() + "BS_H_\n");
	sb.append("#define _" + name.toUpperCase() + "BS_H_\n\n");

	sb.append("#include \"bscan.h\"\n\n");

	sb.append("extern struct Scanring *" + name.toLowerCase() + "Scanring;\n");
	sb.append("extern ScanCell " + name.toLowerCase() + "ScanCells[];\n\n");
	
	return sb.toString();
    }

    private static String genericHFooter() {
	StringBuffer sb = new StringBuffer();
	
	sb.append("#endif /* _" + name.toUpperCase() + "BS_H_ */\n");

	return sb.toString();
    }

    private static String genericCHeader() {
	StringBuffer sb = new StringBuffer();
	Date date = new Date();
	
	sb.append("/* " + name.toLowerCase() + "bs.c generated by bsdl2c on " + 
		  DateFormat.getDateTimeInstance().format(date) + " */\n\n");

	sb.append("#include <assert.h>\n");
	sb.append("#include <stdio.h>\n\n");
	sb.append("#include \"bscan.h\"\n");
	sb.append("#include \"" + name.toLowerCase() + "bs.h\"\n\n");
	sb.append("struct Scanring *" + name.toLowerCase() + "Scanring = 0L;\n\n");
	
	return sb.toString();
    }


    private static String genericCFooter() {
	return "";
    }
    
    private static void error(String arg) {
	System.err.println(arg);
	System.exit(0);
    }
}





