/** 
 * membs.c implements the memory primitives using boundary scan
 */
#include <stdio.h>
#include <assert.h>
#include "library\PCI.h"
#include "bscan.h"
#include "memory.h"
#include "sa110bs.h"
#include "21285bs.h"

#if 0
struct Skiff skfmlb = {
};
#endif


void writeFlashUint32(uint32 addr, uint32 data)
{
   /* set up address and data */
   enable_corelogic_A();
   enable_corelogic_D();
   disable_SA110_A();
   disable_SA110_D();
   enable_corelogic_ROM_CE_L();

   addr &= ~0x80000000L; /* assert ROM_WE_L, which is on A[31] */
   addr |=  0x40000000L; /* deassert ROM_OE_L, which is on A[30] */

   set_corelogic_A(addr);
   set_corelogic_D(data);
   /* pulse the Flash chip enable and write enable low */
   set_corelogic_ROM_CE_L(0);

   skfmlb_scan(0); /* now apply the scanring to the board */

   set_corelogic_ROM_CE_L(1); /* now disable ROM and write enable */

   skfmlb_scan(0); /* apply updated scanring to the board */
}

uint32 readFlashUint32(uint32 addr)
{
   char irdata[32];
   uint32 data = 0;

   memset(irdata, 0, 32);
   /* set up EXTEST instruction */
   *(long*)irdata =  SKFMLB_INSTRUCTION_EXTEST; /* EXTEST: 0b000000000 */
   scan_ir(0, (const short*)irdata, SKFMLB_INSTRUCTION_NBITS, (short *)irdata);

   reset_skfmlb_scanring();

   enable_corelogic_A();
   disable_corelogic_D();
   disable_SA110_A();
   disable_SA110_D();
   enable_corelogic_ROM_CE_L();

   set_corelogic_A(addr);

   set_corelogic_ROM_CE_L(0); /* deassert ROM_CE */
   skfmlb_scan(0);

   set_corelogic_ROM_CE_L(1); /* deassert ROM_CE */
   skfmlb_scan(1); /* apply updated scanring to the board */

   /* now get the data bits scanned in */
   data = get_corelogic_D();

   return data;
}

