load Debug/corelis.dll

## corelis.tcl defines some useful constants
source corelis.tcl

proc doubleword {w} {
    set d [expr ($w << 16) | $w]
    return $d
}

proc query_flash {addr} {
    write_flash [expr 0x555 << 2] [doubleword 0xAA]
    write_flash [expr 0x2AA << 2] [doubleword 0x55]
    write_flash [expr 0x555 << 2] [doubleword 0x90]
    return [read_flash_old_way $addr]
}

tms_reset 0

puts [read_flash_old_way 0x00]
puts [read_flash_old_way 0x04]
puts [read_flash_old_way 0x08]
puts [read_flash_old_way 0x0C]

## put flash in query mode
write_flash [expr 0x55 << 2] [doubleword 0x98]
write_flash [expr 0x55 << 2] [doubleword 0x98]
puts [read_flash_old_way [expr 0x10 << 2]]
puts [read_flash_old_way [expr 0x11 << 2]]
puts [read_flash_old_way [expr 0x12 << 2]]

## put flash in autoselect mode
puts "==== 0x00000 ===="
puts [query_flash 0]
puts [query_flash 4]
puts [query_flash 8]
puts [query_flash 12]

puts "==== 0x10000 ===="
puts [query_flash 0x10000]
puts [query_flash 0x10004]
puts [query_flash 0x10008]
puts [query_flash 0x1000c]

puts "==== 0x20000 ===="
puts [query_flash 0x20000]
puts [query_flash 0x20004]
puts [query_flash 0x20008]
puts [query_flash 0x2000c]

set addr 0x00700000
puts "==== $addr ===="
puts [query_flash [expr $addr + 0x00]]
puts [query_flash [expr $addr + 0x04]]
puts [query_flash [expr $addr + 0x08]]
puts [query_flash [expr $addr + 0x0c]]


## reset flash to read mode
write_flash [expr 0x55 << 2] [doubleword 0xF0]
write_flash [expr 0x55 << 2] [doubleword 0xF0]

