## load the DLL defining our new commands for programming flash
load Debug/corelis.dll

## corelis.tcl defines some useful constants
source corelis.tcl

## set programmBootldr to 1 to download bootldr
## set it to zero to download kernel (better to download kernel by running bootldr)
set programBootldr 1

## the name of the bootldr file
set bootldrfilename p:/mobile/release-1.10/bootldr
set bootldrfilename c:/skiff/bootldr
## the name of the kernel file
set kernelfilename c:/temp/netbsd

set_scan_clk $OSC_30MHZ $CLK_DIV_BY_8

#
# Resets the underlying C data structures, allocates space, etc.
#
reset_skfmlb

proc doubleword {w} {
    set d [expr ($w << 16) | $w]
    return $d
}
tms_reset 0

#
# Reset the flash statemachine
#
proc resetFlash {} {
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]
}

#
# Programs a 32-bit word at the given address
#
proc programFlashWord {addr value} {
    send_program_flash_word_command $addr $value
    set count 0
    while {[read_flash_old_way $addr] != $value} {
        puts "."
        if {$count > 100} {
            puts "ProgramFlashWord timed out\n"
            puts [format "Count=$count addr=%08x value=%08x flash=%08x" $addr $value [read_flash_old_way $addr]]
        }
        incr count
    }
}

#
# Erases the sector starting at addr
#  addr must be a start of sector address
#
proc eraseFlashSector {addr} {
    puts [write_flash [expr 0x55 << 2] [doubleword 0x98]]
    puts [write_flash [expr 0x55 << 2] [doubleword 0x98]]

#    puts [read_flash [expr 0x10 << 2]]
#    puts [read_flash [expr 0x11 << 2]]
#    puts [read_flash [expr 0x12 << 2]]

    puts [read_flash_old_way [expr 0x10 << 2]]
    puts [read_flash_old_way [expr 0x11 << 2]]
    puts [read_flash_old_way [expr 0x12 << 2]]

    ## reset flash to read mode
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]
    puts [write_flash [expr 0x55 << 2] [doubleword 0xF0]]

    puts "eraseFlashSector $addr ************************************************************"
    write_flash [expr 0x555 << 2] [doubleword 0xAA]
    write_flash [expr 0x2AA << 2] [doubleword 0x55]
    write_flash [expr 0x555 << 2] [doubleword 0x80]
    write_flash [expr 0x555 << 2] [doubleword 0xAA]
    write_flash [expr 0x2AA << 2] [doubleword 0x55]
    write_flash [expr $addr] [doubleword 0x30]
    set count 00
    while {[read_flash_old_way $addr] != 0xFFFFFFFF} {
        puts [read_flash_old_way $addr]
        if {$count > 1000} {
            puts "EraseFlashSector timed out\n"
            puts [format "Count=$count addr=%08x flash=%08x" $addr [read_flash_old_way $addr]]
            exit
        }
        incr count
    }
    puts "eraseFlashSector done $addr"
}

# sector addresses for 4MB of flash
set sectors {
    0x00000000
    0x00008000
    0x0000c000
    0x00010000
    0x00020000
    0x00040000
    0x00060000
    0x00080000
    0x000A0000
    0x000C0000
    0x000E0000
    0x00100000
    0x00120000
    0x00140000
    0x00160000
    0x00180000
    0x001A0000
    0x001C0000
    0x001E0000
    0x00200000
    0x00220000
    0x00240000
    0x00260000
    0x00280000
    0x002A0000
    0x002C0000
    0x002E0000
    0x00300000
    0x00320000
    0x00340000
    0x00360000
    0x00380000
    0x003A0000
    0x003C0000
    0x003E0000
}

#
# Erases target region, programs flash from file
#
proc programFlashFromFile {filename targetAddress headerDataList fileoffset} {
    global sectors lastAddressProgrammed lastValueProgrammed lastFileOffset
    set idcode  [read_idcode]
    puts "Idcode=$idcode"

    set fchan [open $filename]
    fconfigure $fchan -translation binary
    seek $fchan $fileoffset

    set fsize [file size $filename]
    set fsize [expr $fsize - $fileoffset]

    set lsize [expr 4 * [llength $headerDataList]]

    set limitAddress [expr $targetAddress + $fsize + $lsize]

    puts "filename=$filename fsize=$fsize lsize=$lsize limitAddress=$limitAddress"
    puts ============================================================

    tms_reset 0
    ## move_to_state RTI

    ## flash reset command:
    write_flash [expr 0x55 << 2] [doubleword 0xF0]
    write_flash [expr 0x55 << 2] [doubleword 0xF0]

    set sectorsToErase {}

    set lastsector 0
    foreach sector $sectors {
        if {$lastsector < $targetAddress && $sector > $targetAddress} {
            puts "Need to erase $lastsector"
            set sectorsToErase "$sectorsToErase $lastsector"
        }
        if {$targetAddress <= $sector && $sector < $limitAddress} {
            puts "Need to erase $sector"
            set sectorsToErase "$sectorsToErase $sector"
        }
        set lastsector $sector
    }

    puts $sectorsToErase

    set beginTime [clock seconds]
    puts [clock format $beginTime -format %c]

    if 1 {
        ## 1 for the Tcl program version of program flash from file
        ## 0 for the (broken) Tcl command
        if 1 {
            foreach str $sectorsToErase {
                if {1 || ([read_flash_old_way $str] != 0xFFFFFFFF)} {
                    eraseFlashSector $str
                }
            }
            set nbytes 0
            set addr $targetAddress

            foreach val $headerDataList {
                programFlashWord $addr $val
                
                puts [format "Header %08lx %08lx fileoffset=%d" $addr $val $fileoffset]
                incr fileoffset 4
                incr addr 4
                incr nbytes 4


            }

            ## now for the file data
            set_input_channel $fchan
            while {$addr < $limitAddress} {
                # binary scan [read $fchan 4] i1 val
                ## read_dword reads from $fchan
                set val [read_dword]
                if {($nbytes & 0xFFF) == 0} {
                    puts [format "%08lx %08lx" $addr $val]
                }
                programFlashWord $addr $val
                incr addr 4
                incr nbytes 4
            }
        } else {
            program_flash_from_file $bootfilename $targetAddress $fsize
        }
        move_to_state TLR
    }
    set endTime [clock seconds]
    puts [clock format $endTime -format %c]
    set elapsedTime [expr $endTime - $beginTime]
    set Bps [expr $nbytes / $elapsedTime]
    puts "Elapsed time: $elapsedTime seconds ($Bps bytes/second)"
}


## here we do the work
if $programBootldr {
    set addr 0x0
    set limit [expr 48 * 1024]
    while {$addr < $limit} {
	set val [read_flash_old_way $addr]
	puts "$addr $val"
	incr addr 4
    }
    exit

} else {

}


