#include <assert.h>
#include <stdio.h>

#include "bscan.h"
#include "sa110bs.h"

struct Scanring *sa110Scanring = 0L;

ScanCell sa110ScanCells[] = {
    {0,    BC_7, "D31",             OUTPUT3_CELL, X,     19,   0,     Z_STATE },
    {1,    BC_7, "D31",             INPUT_CELL,   X,     -1,   0,     IN_STATE },
    {2,    BC_7, "D30",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {3,    BC_7, "D30",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {4,    BC_7, "D29",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {5,    BC_7, "D29",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {6,    BC_7, "D28",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {7,    BC_7, "D28",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {8,    BC_7, "D27",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {9,    BC_7, "D27",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {10,   BC_7, "D26",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {11,   BC_7, "D26",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {12,   BC_7, "D25",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {13,   BC_7, "D25",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {14,   BC_7, "D24",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {15,   BC_7, "D24",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {16,   BC_7, "D23",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {17,   BC_7, "D23",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {18,   BC_4, "DBE",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {19,   BC_7, "D_CTL",           CONTROL_CELL, X,     -1,   0,     IN_STATE    },
    {20,   BC_7, "D22",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {21,   BC_7, "D22",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {22,   BC_7, "D21",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {23,   BC_7, "D21",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {24,   BC_7, "D20",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {25,   BC_7, "D20",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {26,   BC_7, "D19",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {27,   BC_7, "D19",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {28,   BC_7, "D18",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {29,   BC_7, "D18",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {30,   BC_7, "D17",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {31,   BC_7, "D17",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {32,   BC_7, "D16",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {33,   BC_7, "D16",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {34,   BC_7, "D15",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {35,   BC_7, "D15",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {36,   BC_7, "D14",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {37,   BC_7, "D14",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {38,   BC_7, "D13",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {39,   BC_7, "D13",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {40,   BC_7, "D12",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {41,   BC_7, "D12",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {42,   BC_7, "D11",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {43,   BC_7, "D11",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {44,   BC_7, "D10",             OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {45,   BC_7, "D10",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {46,   BC_7, "D9",              OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {47,   BC_7, "D9",              INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {48,   BC_7, "D8",              OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {49,   BC_7, "D8",              INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {50,   BC_7, "D7",              OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {51,   BC_7, "D7",              INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {52,   BC_7, "D6",              OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {53,   BC_7, "D6",              INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {54,   BC_7, "D5",              OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {55,   BC_7, "D5",              INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {56,   BC_7, "D4",              OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {57,   BC_7, "D4",              INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {58,   BC_7, "D3",              OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {59,   BC_7, "D3",              INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {60,   BC_7, "D2",              OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {61,   BC_7, "D2",              INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {62,   BC_7, "D1",              OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {63,   BC_7, "D1",              INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {64,   BC_7, "D0",              OUTPUT3_CELL, X,     19,   0,     Z_STATE     },
    {65,   BC_7, "D0",              INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {66,   BC_4, "IRQ",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {67,   BC_4, "FIQ",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {68,   BC_4, "SNA",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {69,   BC_4, "NRESET",          INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {70,   BC_4, "CCCFG0",          INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {71,   BC_4, "CCCFG1",          INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {72,   BC_4, "TESTCLK",         INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {73,   BC_4, "TESTBYP",         INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {74,   BC_4, "CLK",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {75,   BC_4, "NWAIT",           INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {76,   BC_4, "NMCLK",           OUTPUT3_CELL, X,     68,   0,     Z_STATE     },
    {77,   BC_7, "*",               INTERNAL_CELL, X,     -1,   0,     IN_STATE    },
    {78,   BC_7, "*",               INTERNAL_CELL, X,     -1,   0,     IN_STATE    },
    {79,   BC_4, "ABORT",           INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {80,   BC_4, "APE",             INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {81,   BC_1, "A31",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {82,   BC_1, "A30",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {83,   BC_1, "A29",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {84,   BC_1, "A28",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {85,   BC_1, "A27",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {86,   BC_1, "A26",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {87,   BC_1, "A25",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {88,   BC_1, "A24",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {89,   BC_1, "A23",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {90,   BC_1, "A22",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {91,   BC_1, "A21",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {92,   BC_1, "A20",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {93,   BC_1, "A19",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {94,   BC_1, "A18",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {95,   BC_1, "A17",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {96,   BC_1, "A16",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {97,   BC_1, "A15",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {98,   BC_1, "A14",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {99,   BC_1, "A13",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {100,  BC_1, "A12",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {101,  BC_1, "A11",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {102,  BC_1, "A10",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {103,  BC_1, "A9",              OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {104,  BC_1, "A8",              OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {105,  BC_1, "A7",              OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {106,  BC_1, "A6",              OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {107,  BC_1, "A5",              OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {108,  BC_1, "A4",              OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {109,  BC_1, "A3",              OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {110,  BC_1, "A2",              OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {111,  BC_1, "A1",              OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {112,  BC_1, "A0",              OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {113,  BC_1, "MAS1",            OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {114,  BC_1, "MAS0",            OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {115,  BC_4, "A_CTL",           CONTROL_CELL, X,     -1,   0,     IN_STATE    },
    {116,  BC_1, "RSTOUT",          OUTPUT2_CELL, X,     -1,   0,     IN_STATE    }, 
    {117,  BC_4, "CCCFG3",          INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {118,  BC_4, "CCCFG2",          INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {119,  BC_4, "MCCFG2",          INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {120,  BC_4, "MCCFG1",          INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {121,  BC_4, "MCCFG0",          INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {122,  BC_4, "SPDF",            INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {123,  BC_1, "NRW",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {124,  BC_1, "LOCK",            OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {125,  BC_1, "CLF",             OUTPUT3_CELL, X,    115,   0,     Z_STATE     },
    {126,  BC_1, "SEQ",             OUTPUT3_CELL, X,    129,   0,     Z_STATE     },
    {127,  BC_1, "NMREQ",           OUTPUT3_CELL, X,    129,   0,     Z_STATE     },
    {128,  BC_4, "CONFIG",          INPUT_CELL,   X,     -1,   0,     IN_STATE    },
    {129,  BC_4, "SEQ_NMREQ_CTL",   CONTROL_CELL, X,     -1,   0,     IN_STATE    },
    {68,   BC_4, "NMCLK_CTL",       CONTROL_CELL, 1,     -1,   0,     IN_STATE    },
    {-1,   BC_4, "end",		    -1, 	  X,     -1,   X,     IN_STATE    },
};

void resetSa110Scanring()
{
  int i = 0;
  assert(sa110Scanring != NULL);
  /* disable all the output pins by default */
  while (sa110ScanCells[i].cellnum >= 0) {
    ScanCell *sc = &sa110ScanCells[i];
    switch (sc->cellType) {
    case INPUT_CELL: /* do nothing */
    case INTERNAL_CELL: /* do nothing */
      break;
    case CONTROL_CELL: /* handle this when we visit the output cell */
      break;
    case OUTPUT1_CELL:
    case OUTPUT2_CELL:
    case OUTPUT3_CELL:
      /* disable this cell by default */
      if (sc->controlCell >= 0) {
        set_scanring_bit(sa110Scanring, sc->controlCell, sc->disableValue);
      }
      break;
    default: {
      int improperCellType = 0;
      assert(improperCellType);
      }
    }
    i++;
  }

  /* now the special cases -- we drive the following pins by default */
  /* there are no special cases -- Jamey 12/1/98 */
}

long get_SA110_MSE();
void set_SA110_MSE(long);

long get_SA110_ABE();
void set_SA110_ABE(long);

long get_SA110_MCLK();
void set_SA110_MCLK(long);

long get_SA110_SNA();
void set_SA110_SNA(long);

long get_SA110_CONFIG();
void set_SA110_CONFIG(long);

void enable_SA110_NMREQ()
{
  set_scanring_bit(sa110Scanring, 
                   sa110ScanCells[OUTPUT_CELL_SA110_NMREQ].controlCell,
                   ~sa110ScanCells[OUTPUT_CELL_SA110_NMREQ].disableValue);
}
void disable_SA110_NMREQ()
{
  set_scanring_bit(sa110Scanring, 
                   sa110ScanCells[OUTPUT_CELL_SA110_NMREQ].controlCell,
                   sa110ScanCells[OUTPUT_CELL_SA110_NMREQ].disableValue);
}
void set_SA110_NMREQ(long value)
{
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_NMREQ, value);
}

long get_SA110_SEQ();
void set_SA110_SEQ(long);

void enable_SA110_CLF()
{
  set_scanring_bit(sa110Scanring, 
                   sa110ScanCells[OUTPUT_CELL_SA110_CLF].controlCell,
                   ~sa110ScanCells[OUTPUT_CELL_SA110_CLF].disableValue);
}
void disable_SA110_CLF()
{
  set_scanring_bit(sa110Scanring, 
                   sa110ScanCells[OUTPUT_CELL_SA110_CLF].controlCell,
                   sa110ScanCells[OUTPUT_CELL_SA110_CLF].disableValue);
}
void set_SA110_CLF(long value)
{
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_CLF, value);
}

void enable_SA110_LOCK()
{
  set_scanring_bit(sa110Scanring, 
                   sa110ScanCells[OUTPUT_CELL_SA110_LOCK].controlCell,
                   ~sa110ScanCells[OUTPUT_CELL_SA110_LOCK].disableValue);
}
void disable_SA110_LOCK()
{
  set_scanring_bit(sa110Scanring, 
                   sa110ScanCells[OUTPUT_CELL_SA110_LOCK].controlCell,
                   sa110ScanCells[OUTPUT_CELL_SA110_LOCK].disableValue);
}

void set_SA110_LOCK(long value)
{
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_LOCK, value);
}

void enable_SA110_NRW()
{
  set_scanring_bit(sa110Scanring, 
                   sa110ScanCells[OUTPUT_CELL_SA110_NRW].controlCell,
                   ~sa110ScanCells[OUTPUT_CELL_SA110_NRW].disableValue);
}
void disable_SA110_NRW()
{
  set_scanring_bit(sa110Scanring, 
                   sa110ScanCells[OUTPUT_CELL_SA110_NRW].controlCell,
                   sa110ScanCells[OUTPUT_CELL_SA110_NRW].disableValue);
}
void set_SA110_NRW(long value)
{
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_NRW, value);
}

long get_SA110_SPDF();
void set_SA110_SPDF(long);

long get_SA110_MCCFG();
void set_SA110_MCCFG(long);

long get_SA110_CCCFG();
void set_SA110_CCCFG(long);

long get_SA110_RSTOUT();
void set_SA110_RSTOUT(long);

long get_SA110_MAS();
void set_SA110_MAS(long);

void enable_SA110_A() 
{
  int disableValue = sa110ScanCells[OUTPUT_CELL_SA110_A0].disableValue;
  set_scanring_bit(sa110Scanring, CONTROL_CELL_SA110_A, ~disableValue);
}
void disable_SA110_A()
{
  int disableValue = sa110ScanCells[OUTPUT_CELL_SA110_A0].disableValue;
  set_scanring_bit(sa110Scanring, CONTROL_CELL_SA110_A, disableValue);
}
void set_SA110_A(long a) 
{
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A31, ((a >> 31)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A30, ((a >> 30)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A29, ((a >> 29)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A28, ((a >> 28)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A27, ((a >> 27)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A26, ((a >> 26)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A25, ((a >> 25)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A24, ((a >> 24)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A23, ((a >> 23)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A22, ((a >> 22)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A21, ((a >> 21)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A20, ((a >> 20)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A19, ((a >> 19)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A18, ((a >> 18)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A17, ((a >> 17)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A16, ((a >> 16)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A15, ((a >> 15)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A14, ((a >> 14)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A13, ((a >> 13)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A12, ((a >> 12)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A11, ((a >> 11)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A10, ((a >> 10)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A9, ((a >> 9)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A8, ((a >> 8)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A7, ((a >> 7)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A6, ((a >> 6)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A5, ((a >> 5)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A4, ((a >> 4)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A3, ((a >> 3)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A2, ((a >> 2)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A1, ((a >> 1)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_A0, ((a >> 0)&1));
}

long get_SA110_APE();
void set_SA110_APE(long);

long get_SA110_ABORT();
void set_SA110_ABORT(long);

long get_SA110_NMCLK();
void set_SA110_NMCLK(long);

long get_SA110_NWAIT();
void set_SA110_NWAIT(long);

long get_SA110_CLK();
void set_SA110_CLK(long);

long get_SA110_TESTBYP();
void set_SA110_TESTBYP(long);

long get_SA110_TESTCLK();
void set_SA110_TESTCLK(long);

long get_SA110_NRESET();
void set_SA110_NRESET(long);

long get_SA110_FIQ();
void set_SA110_FIQ(long);

long get_SA110_IRQ();
void set_SA110_IRQ(long);

void enable_SA110_D() 
{
  int disableValue = sa110ScanCells[OUTPUT_CELL_SA110_D0].disableValue;
  set_scanring_bit(sa110Scanring, CONTROL_CELL_SA110_D, ~disableValue);
}
void disable_SA110_D()
{
  int disableValue = sa110ScanCells[OUTPUT_CELL_SA110_D0].disableValue;
  set_scanring_bit(sa110Scanring, CONTROL_CELL_SA110_D, disableValue);
}
long get_SA110_D()
{
  long a = 0;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D31) << 31;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D30) << 30;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D29) << 29;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D28) << 28;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D27) << 27;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D26) << 26;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D25) << 25;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D24) << 24;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D23) << 23;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D22) << 22;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D21) << 21;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D20) << 20;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D19) << 19;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D18) << 18;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D17) << 17;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D16) << 16;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D15) << 15;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D14) << 14;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D13) << 13;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D12) << 12;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D11) << 11;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D10) << 10;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D9) << 9;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D8) << 8;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D7) << 7;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D6) << 6;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D5) << 5;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D4) << 4;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D3) << 3;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D2) << 2;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D1) << 1;
  a |= get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_D0) << 0;
  return a;
}

void set_SA110_D(long a) 
{
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D31, ((a >> 31)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D30, ((a >> 30)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D29, ((a >> 29)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D28, ((a >> 28)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D27, ((a >> 27)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D26, ((a >> 26)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D25, ((a >> 25)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D24, ((a >> 24)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D23, ((a >> 23)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D22, ((a >> 22)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D21, ((a >> 21)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D20, ((a >> 20)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D19, ((a >> 19)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D18, ((a >> 18)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D17, ((a >> 17)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D16, ((a >> 16)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D15, ((a >> 15)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D14, ((a >> 14)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D13, ((a >> 13)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D12, ((a >> 12)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D11, ((a >> 11)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D10, ((a >> 10)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D9, ((a >> 9)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D8, ((a >> 8)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D7, ((a >> 7)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D6, ((a >> 6)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D5, ((a >> 5)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D4, ((a >> 4)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D3, ((a >> 3)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D2, ((a >> 2)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D1, ((a >> 1)&1));
  set_scanring_bit(sa110Scanring, OUTPUT_CELL_SA110_D0, ((a >> 0)&1));
}



long get_SA110_DBE()
{
   return get_scanring_bit(sa110Scanring, INPUT_CELL_SA110_DBE);
}


long get_SA110_PWRSLP();
void set_SA110_PWRSLP(long);

long get_SA110_TRST();
void set_SA110_TRST(long);

long get_SA110_TCK();
void set_SA110_TCK(long);

long get_SA110_TDI();
void set_SA110_TDI(long);

long get_SA110_TDO();
void set_SA110_TDO(long);

long get_SA110_TMS();
void set_SA110_TMS(long);

long get_SA110_VDD();
void set_SA110_VDD(long);

long get_SA110_VSS();
void set_SA110_VSS(long);

long get_SA110_VDDX();
void set_SA110_VDDX(long);

long get_SA110_VSSX();
void set_SA110_VSSX(long);

long get_SA110_NC();
void set_SA110_NC(long);
