#ifndef _SA110BS_H_
#define _SA110BS_H_

#include "bscan.h"

#define SA110_SCANRING_LENGTH 130
#define SA110_INSTRUCTION_LENGTH 5

enum SA110Instruction {
   SA110_IDCODE = 0x1,
   SA110_CLAMP = 0x4,
   SA110_HIGHZ = 0x5,
   SA110_EXTEST = 0x0,
   SA110_SAMPLE = 0x1,
   SA110_BYPASS = 0x1f,
};

/*-----------------------------------------------------------------------------*/
/*- scan   cell                                   cntr  disable disable        */
/*- cell   type   port             function safe  cell  value   state          */
/*-----------------------------------------------------------------------------*/
extern struct Scanring *sa110Scanring;
extern ScanCell sa110ScanCells[];

#define INPUT_CELL_SA110_D31        1
#define INPUT_CELL_SA110_D30        3
#define INPUT_CELL_SA110_D29        5
#define INPUT_CELL_SA110_D28        7
#define INPUT_CELL_SA110_D27        9
#define INPUT_CELL_SA110_D26        11
#define INPUT_CELL_SA110_D25        13
#define INPUT_CELL_SA110_D24        15
#define INPUT_CELL_SA110_D23        17
#define INPUT_CELL_SA110_DBE        18
#define INPUT_CELL_SA110_D22        21
#define INPUT_CELL_SA110_D21        23
#define INPUT_CELL_SA110_D20        25
#define INPUT_CELL_SA110_D19        27
#define INPUT_CELL_SA110_D18        29
#define INPUT_CELL_SA110_D17        31
#define INPUT_CELL_SA110_D16        33
#define INPUT_CELL_SA110_D15        35
#define INPUT_CELL_SA110_D14        37
#define INPUT_CELL_SA110_D13        39
#define INPUT_CELL_SA110_D12        41
#define INPUT_CELL_SA110_D11        43
#define INPUT_CELL_SA110_D10        45
#define INPUT_CELL_SA110_D9        47
#define INPUT_CELL_SA110_D8        49
#define INPUT_CELL_SA110_D7        51
#define INPUT_CELL_SA110_D6        53
#define INPUT_CELL_SA110_D5        55
#define INPUT_CELL_SA110_D4        57
#define INPUT_CELL_SA110_D3        59
#define INPUT_CELL_SA110_D2        61
#define INPUT_CELL_SA110_D1        63
#define INPUT_CELL_SA110_D0        65
#define INPUT_CELL_SA110_IRQ        66
#define INPUT_CELL_SA110_FIQ        67
#define INPUT_CELL_SA110_SNA        68
#define INPUT_CELL_SA110_NRESET        69
#define INPUT_CELL_SA110_CCCFG0        70
#define INPUT_CELL_SA110_CCCFG1        71
#define INPUT_CELL_SA110_TESTCLK        72
#define INPUT_CELL_SA110_TESTBYP        73
#define INPUT_CELL_SA110_CLK        74
#define INPUT_CELL_SA110_NWAIT        75
#define INPUT_CELL_SA110_ABORT        79
#define INPUT_CELL_SA110_APE        80
#define INPUT_CELL_SA110_CCCFG3        117
#define INPUT_CELL_SA110_CCCFG2        118
#define INPUT_CELL_SA110_MCCFG2        119
#define INPUT_CELL_SA110_MCCFG1        120
#define INPUT_CELL_SA110_MCCFG0        121
#define INPUT_CELL_SA110_SPDF        122
#define INPUT_CELL_SA110_CONFIG        128


#define OUTPUT_CELL_SA110_D31        0
#define OUTPUT_CELL_SA110_D30        2
#define OUTPUT_CELL_SA110_D29        4
#define OUTPUT_CELL_SA110_D28        6
#define OUTPUT_CELL_SA110_D27        8
#define OUTPUT_CELL_SA110_D26        10
#define OUTPUT_CELL_SA110_D25        12
#define OUTPUT_CELL_SA110_D24        14
#define OUTPUT_CELL_SA110_D23        16
#define OUTPUT_CELL_SA110_D22        20
#define OUTPUT_CELL_SA110_D21        22
#define OUTPUT_CELL_SA110_D20        24
#define OUTPUT_CELL_SA110_D19        26
#define OUTPUT_CELL_SA110_D18        28
#define OUTPUT_CELL_SA110_D17        30
#define OUTPUT_CELL_SA110_D16        32
#define OUTPUT_CELL_SA110_D15        34
#define OUTPUT_CELL_SA110_D14        36
#define OUTPUT_CELL_SA110_D13        38
#define OUTPUT_CELL_SA110_D12        40
#define OUTPUT_CELL_SA110_D11        42
#define OUTPUT_CELL_SA110_D10        44
#define OUTPUT_CELL_SA110_D9        46
#define OUTPUT_CELL_SA110_D8        48
#define OUTPUT_CELL_SA110_D7        50
#define OUTPUT_CELL_SA110_D6        52
#define OUTPUT_CELL_SA110_D5        54
#define OUTPUT_CELL_SA110_D4        56
#define OUTPUT_CELL_SA110_D3        58
#define OUTPUT_CELL_SA110_D2        60
#define OUTPUT_CELL_SA110_D1        62
#define OUTPUT_CELL_SA110_D0        64
#define OUTPUT_CELL_SA110_NMCLK        76
#define OUTPUT_CELL_SA110_A31        81
#define OUTPUT_CELL_SA110_A30        82
#define OUTPUT_CELL_SA110_A29        83
#define OUTPUT_CELL_SA110_A28        84
#define OUTPUT_CELL_SA110_A27        85
#define OUTPUT_CELL_SA110_A26        86
#define OUTPUT_CELL_SA110_A25        87
#define OUTPUT_CELL_SA110_A24        88
#define OUTPUT_CELL_SA110_A23        89
#define OUTPUT_CELL_SA110_A22        90
#define OUTPUT_CELL_SA110_A21        91
#define OUTPUT_CELL_SA110_A20        92
#define OUTPUT_CELL_SA110_A19        93
#define OUTPUT_CELL_SA110_A18        94
#define OUTPUT_CELL_SA110_A17        95
#define OUTPUT_CELL_SA110_A16        96
#define OUTPUT_CELL_SA110_A15        97
#define OUTPUT_CELL_SA110_A14        98
#define OUTPUT_CELL_SA110_A13        99
#define OUTPUT_CELL_SA110_A12        100
#define OUTPUT_CELL_SA110_A11        101
#define OUTPUT_CELL_SA110_A10        102
#define OUTPUT_CELL_SA110_A9        103
#define OUTPUT_CELL_SA110_A8        104
#define OUTPUT_CELL_SA110_A7        105
#define OUTPUT_CELL_SA110_A6        106
#define OUTPUT_CELL_SA110_A5        107
#define OUTPUT_CELL_SA110_A4        108
#define OUTPUT_CELL_SA110_A3        109
#define OUTPUT_CELL_SA110_A2        110
#define OUTPUT_CELL_SA110_A1        111
#define OUTPUT_CELL_SA110_A0        112
#define OUTPUT_CELL_SA110_MAS1        113
#define OUTPUT_CELL_SA110_MAS0        114
#define OUTPUT_CELL_SA110_RSTOUT        116
#define OUTPUT_CELL_SA110_NRW        123
#define OUTPUT_CELL_SA110_LOCK        124
#define OUTPUT_CELL_SA110_CLF        125
#define OUTPUT_CELL_SA110_SEQ        126
#define OUTPUT_CELL_SA110_NMREQ        127

#define CONTROL_CELL_SA110_A 115
#define CONTROL_CELL_SA110_D 19

extern void resetSa110Scanring(void);

extern long get_SA110_MSE();
extern void set_SA110_MSE(long);

extern long get_SA110_ABE();
extern void set_SA110_ABE(long);

extern long get_SA110_MCLK();
extern void set_SA110_MCLK(long);

extern long get_SA110_SNA();
extern void set_SA110_SNA(long);

extern long get_SA110_CONFIG();
extern void set_SA110_CONFIG(long);

extern void enable_SA110_NMREQ();
extern void disable_SA110_NMREQ();
extern long get_SA110_NMREQ();
extern void set_SA110_NMREQ(long);

extern long get_SA110_SEQ();
extern void set_SA110_SEQ(long);

extern void enable_SA110_CLF();
extern void disable_SA110_CLF();
extern void set_SA110_CLF(long);

extern void enable_SA110_LOCK();
extern void disable_SA110_LOCK();
extern void set_SA110_LOCK(long);

extern void enable_SA110_NRW();
extern void disable_SA110_NRW();
extern void set_SA110_NRW(long);

extern long get_SA110_SPDF();
extern void set_SA110_SPDF(long);

extern long get_SA110_MCCFG();
extern void set_SA110_MCCFG(long);

extern long get_SA110_CCCFG();
extern void set_SA110_CCCFG(long);

extern long get_SA110_RSTOUT();
extern void set_SA110_RSTOUT(long);

extern long get_SA110_MAS();
extern void set_SA110_MAS(long);

extern void enable_SA110_A();
extern void disable_SA110_A();
extern void set_SA110_A(long a);

extern long get_SA110_APE();
extern void set_SA110_APE(long);

extern long get_SA110_ABORT();
extern void set_SA110_ABORT(long);

extern long get_SA110_NMCLK();
extern void set_SA110_NMCLK(long);

extern long get_SA110_NWAIT();
extern void set_SA110_NWAIT(long);

extern long get_SA110_CLK();
extern void set_SA110_CLK(long);

extern long get_SA110_TESTBYP();
extern void set_SA110_TESTBYP(long);

extern long get_SA110_TESTCLK();
extern void set_SA110_TESTCLK(long);

extern long get_SA110_NRESET();
extern void set_SA110_NRESET(long);

extern long get_SA110_FIQ();
extern void set_SA110_FIQ(long);

extern long get_SA110_IRQ();
extern void set_SA110_IRQ(long);

extern void enable_SA110_D();
extern void disable_SA110_D();
extern long get_SA110_D();
extern void set_SA110_D(long d);

extern long get_SA110_DBE();
extern void set_SA110_DBE(long);

extern long get_SA110_PWRSLP();
extern void set_SA110_PWRSLP(long);

extern long get_SA110_TRST();
extern void set_SA110_TRST(long);

extern long get_SA110_TCK();
extern void set_SA110_TCK(long);

extern long get_SA110_TDI();
extern void set_SA110_TDI(long);

extern long get_SA110_TDO();
extern void set_SA110_TDO(long);

extern long get_SA110_TMS();
extern void set_SA110_TMS(long);

extern long get_SA110_VDD();
extern void set_SA110_VDD(long);

extern long get_SA110_VSS();
extern void set_SA110_VSS(long);

extern long get_SA110_VDDX();
extern void set_SA110_VDDX(long);

extern long get_SA110_VSSX();
extern void set_SA110_VSSX(long);

extern long get_SA110_NC();
extern void set_SA110_NC(long);

#endif /* _SA110BS_H_ */
