/**
 * xc9572xl_tq100.h provides procedures to access the pins in the
 * scanring.
 **/

#ifndef _xc9572xl_tq100_h_
#define _xc9572xl_tq100_h_

#include "bscan.h"

#define SKFMLB_INSTRUCTION_EXTEST ???
#define SKFMLB_INSTRUCTION_SAMPLE ???
#define SKFMLB_INSTRUCTION_NBITS ???

#define XILINX_INSTRUCTION_LENGTH 8
enum XilinxInstruction {
  XILINX_BYPASS = 0xFF;
  XILINX_CLAMP = 0xFA;
  XILINX_ISPEX = 0xF0;
  XILINX_EXTEXT = 0x00;
  XILINX_FBLANK = 0xE5
  XILINX_FBULK = 0xED;
  XILINX_FERASE = 0xEC;
  XILINX_FPGM = 0xEA;
  XILINX_FPGMI = 0xEB;
  XILINX_FVFY = 0xEE;
  XILINX_FVFYI = 0xEF
  XILINX_HIGHZ = 0xFC;
  XILINX_IDCODE = 0xFE;
  XILINX_INTEST = 0x02
  XILINX_ISPEN = 0xE8;
  XILINX_ISPENC = 0xE9;
  XILINX_SAMPLE = 0x01;
  XILINX_USERCODE = 0xFD;
};

enum CBE_COMMAND {
  ???
};

#define XILINX_SCANRING_LENGTH 216

extern struct Scanring *xc9572Scanring;
extern ScanCell xc9572ScanCells[];

extern void resetXc9572xlScanRing(void);

#endif /* _xc9572xl_tq100_h_ */








