/*
 * The entries in the symbol table
 */

import java.util.*;

/**
 * A symbol - entry in symbol-table
 */
class Symbol implements VhdlParserConstants
{

  public Symbol(String id, int k)
  {
    identifier = id;
    kind       = k;
  }

  /**
   * The identifier-string from the source-code
   */
  public String identifier;

  /**
   * The last alias used in the KIR-Graph
   */
  public String last_alias;

  /**
   * What type is it: procedure, type, signal, ...
   */
  public int kind;


  /**
   * print the symbol on screen for debugging purposes.
   */
  public void dump()
  {
    System.out.println("identifier: "+identifier);
    System.out.println("kind:       "+tokenImage[kind]);
  }

}


/**
 * Entry in the symbol tables for a signal or a variable.
 * if a signal kind is given, a signal is generated, if a
 * signal kind is not given, a variable is generated by the
 * constructor.
 */
class SignalSymbol extends Symbol
{
  /**
   * Create a new signal symbol for the identifier id with the type t
   * of a signal-kind (bus, register,...) sk and an initial value i
   */
  public SignalSymbol(String id, Symbol t, int sk, ASTrelation i)
  {
    super(id, SIGNAL);
    type = t;
    signal_kind = sk;
    init = i;
  }

  /**
   * Create a new variable symbol for the identifier id with the type t
   * and the inition value i.
   */
  public SignalSymbol(String id, Symbol t, ASTrelation i)
  {
    super(id, VARIABLE);
    type = t;
    signal_kind = DEFAULT;
    init = i;
  }

  /**
   * Type of this signal
   */
  public Symbol type;

  /**
   * Kind of this signal
   */
  public int signal_kind;

  /**
   * Expression for initial value
   */
  public ASTrelation init;
}


