//==========================================================================
//
// VHDL-93 grammar for JavaCC Version 0.7beta2
// 
// (c) 1997 Christoph Grimm,
// J.W. Goethe-University Frankfurt
// Department for computer engineering
//
// EMail: grimm@ti.informatik.uni-frankfurt.de
// Address:
// Christoph Grimm
// J. W. Goethe-University Frankfurt
// Robert-Mayer-Strasse 11-15
// 60054 Frankfurt
// Germany
//
//
// You may use and modify it, but when you distribute the grammar
// or derived work, you must also include all original files from me.
//
// If you use it for other then evaluation purposes, you need a signed
// agreement with our department. Send an email to me in such a case.
// 
//==========================================================================

public class Vhdl
{
  public static void main(String args[]) throws Exception
  {
    if (args.length == 1) 
    {
      java.io.FileInputStream  file    = new java.io.FileInputStream(args[0]);
      VhdlParser               parser  = new VhdlParser(file);
      ErrorHandler             errs    = parser.errs;
      System.out.println("VHDL-Parser (c) 1997 by Christoph Grimm, Version 0.1.2");
      try
      {
        System.out.println("reading from file: "+args[0]+"...");
        parser.design_file();
        errs.Summary();
      }
      catch(ParseError p)
      {
        System.out.println("syntax error... ");
        p.printStackTrace();
        throw p;
      }
      catch(Exception e)
      {
        System.out.println("error: ");
        e.printStackTrace();
        throw e;
      }
    }
    else
    {
      System.out.println("usage: Vhdl filename");
    }
  }
}

