--
-- Example for VHDL-AMS:
--
ENTITY diode IS
        GENERIC (Iss, n, Vt, tau, Cj0, Phi: real); -- diode model parameters
        PORT (TERMINAL p, m: electrical;  -- interface terminal
              QUANTITY power: OUT real);  -- interface quantity to export power
END ENTITY diode;

ARCHITECTURE level0 OF diode IS
        QUANTITY vd ACROSS id, icap THROUGH p TO m;
        -- id and icap define two parallel branches between terminals p and m
        QUANTITY qcap: real;  -- qcap is free quantity
BEGIN
        -- 4 simple simultaneous statements
        -- sqrt and exp are used from a math package (not declared here)
        qcap == tau*id - 2.0*Cj0 * sqrt(Phi**2 - Phi*vd);
        icap == qcap'dot;
        id == Iss * (exp(vd/(n*Vt)) - 1);
        power == vd * (id + icap);
END ARCHITECTURE level0;
