
-----------------------------------------------------------------------------
-- Description of a dynamic compressor in VHDL.
-- (c) 1995-1997 Peter Oehler, Christoph Grimm
-- J. W. Goethe-University Frankfurt, 
-- 
-- Used for demonstration of KANDIS (Tool for Construction of mixed 
-- Analog/Digital Systems)
-----------------------------------------------------------------------------

LIBRARY WORK;
USE WORK.kandis.ALL;           

ENTITY kompressor IS
  PORT (u1: IN REAL;
        u2: OUT REAL;
        reset: IN BOOLEAN);
  -- SIGNAL a: INTEGER;            -- entity_declarative_part not in level 1
 BEGIN
 -- assert (u1 < u2);              -- entity_statement_part not in level 1
END kompressor ;


ARCHITECTURE multiparadigmatic OF kompor IS
  SIGNAL u3,u4: REAL := 1.0 + 2.0 * 4 * 5 + 3;
  for hp1: s_polynomial use configuration work.s_polynomial_CFG;
  COMPONENT s_polynomial GENERIC(coefn : real_array;
                                 coefd : real_array);
                         PORT(inp: IN REAL; outp: OUT REAL);
  END COMPONENT;
BEGIN
  -- frequency-domain modeling
  -- of H(s) = s*(1000000/2pi)/(1+s*(1000000/2pi))
  -- => Grenzfrequenz omega_e = 2pi*1kHz
  hp1: s_polynomial GENERIC MAP(coefn => (0.0,159155.000), 
				coefd => (1.0,159155.000))
		    PORT MAP(u1, u3);

  --
  -- Algorithmic description
  --
  alg: PROCESS
    VARIABLE max:  REAL := 0.0;
    VARIABLE yold: REAL := 0.0;
    VARIABLE y:    REAL := 0.0;
    CONSTANT usw : REAL := 50.0;     -- Festlegung des Schwellwerts
    CONSTANT delta_t : REAL := 0.01; -- Schrittweite der numerischen Integration
  BEGIN
    l: IF reset = TRUE THEN
      y := usw; -- bewirkt, dass waehrend und kurz nach dem Reset-Impuls
                -- das Eingangssignal unveraendert (1:1) durchgeschaltet wird.
    ELSE
      IF (ABS(u3) < usw) THEN
         max := usw;
      ELSE
         max := ABS(u3);
      END IF;

      -- Deep error recovery:
      -- First three tokens fit for if-stmt, but then...
      la : IF sdf asd fasd f;

      -- Integration der Variablen max mittels implizitem Euler:
      y := ((1.0 - delta_t) * yold) + (delta_t * max);
      -- im Bsp:  99/100 * yold + 1/100 * max
      -- bewirkt, dass y gegen konstanten Wert usw laeuft,
      -- wenn Eingang kleiner Schwelle ist.
    END IF;
    yold := y;
    u4 <= y / usw; -- damit konstanter Wert (s.o.) = 1
    -- Integrationskonstante = delta_t / 100 ns = 100 kHz
    WAIT ON reset FOR 100 ns;
  END PROCESS alg;


  -- time-continous parallel modeling
  -- of nonlinearity 
  div: u2 <= u1 / u4;

END multiparadigmatic ;

CONFIGURATION kompressor_CFG OF kompressor IS
  FOR multiparadigmatic
  END FOR;
END kompressor_CFG;


