ENTITY change_state IS
  PORT(SIGNAL x: IN  real;
       SIGNAL y: OUT real);
END ENTITY change_state;

ARCHITECTURE behavior OF change_state IS
BEGIN
  p: PROCESS(x)
  BEGIN
    IF x > 5.0 THEN y <= 0.1;
    ELSE IF x < 0 THEN y <= -5.0;
    END IF; END IF;
  END PROCESS p;
END ARCHITECTURE behavior;


ENTITY integ IS
  GENERIC (k: real := 1.0);
  PORT(QUANTITY x: IN real;
       QUANTITY y: OUT real);
END ENTITY integ;

ARCHITECTURE signal_flow OF integ IS BEGIN
  y == k * x'integ;
END ARCHITECTURE signal_flow;



ENTITY siggen IS
  PORT (y_out: OUT REAL);
END ENTITY siggen;
ARCHITECTURE structure OF siggen IS
  SIGNAL y,x: REAL;
BEGIN
  i: integ PORT MAP(x, y);
  p: change_state PORT MAP(y, x);
  y_out <= y;
END ARCHITECTURE structure;

