/******************************************************************************
**
**  COPYRIGHT (C) 2000, 2001, 2002 Intel Corporation.
**
**  The information in this file is furnished for informational use 
**  only, is subject to change without notice, and should not be construed as 
**  a commitment by Intel Corporation. Intel Corporation assumes no 
**  responsibility or liability for any errors or inaccuracies that may appear 
**  in this document or any software that may be provided in association with 
**  this document. 
**
**  FILENAME:       Jflash.h
**
**  PURPOSE:        General header for the Jflash utility
**
**  LAST MODIFIED:  $Modtime: 6/18/02 2:54p $
******************************************************************************/

#ifdef SANDGATE_PLATFORM
    #define VERSION "2.09.003 - RBPXA250"
#endif //SANDGATE_PLATFORM 

#ifdef LUBBOCK_PLATFORM
#if !defined(LUBBOCK_SABINAL) && !defined(LUBBOCK_DALHART_16) && !defined(LUBBOCK_SA1110)
    #define VERSION "2.09.003 - DBPXA250"
#endif
#endif //LUBBOCK_PLATFORM 

#ifdef ASSABET_PLATFORM
#ifndef LUBBOCK_SA1110
    #define VERSION "2.09.003 - Assabet"
#endif
#endif //ASSABET_PLATFORM 

#ifdef LUBBOCK_SA1110
    #define VERSION "2.09.003 - Lubbock - SA1110"
#endif

#ifdef LUBBOCK_SABINAL
    #define VERSION "2.09.003 - DBPXA210"
#endif

#ifdef LUBBOCK_DALHART_16
    #define VERSION "2.09.003 - DALHART 16"
#endif

#define LPT1 0x3bc	// hardware base address for parallel port
#define LPT2 0x378	// the search order is LPT1 then 2 then 3
#define LPT3 0x278	// first valid address found is used (re-order if needed for multiple ports)


#define SA1110ID  "**** 1001001001100001 00000001001 1"	// JTAG ID-codes for the SA-1110
#define COTULLAID "**** 1001001001100100 00000001001 1" // JTAG ID-codes for the Cotulla
#define SABINALID "**** 1001001001101100 00000001001 1" // JTAG ID-codes for the New sabinal

#define PZ3128ID  "**** 0000000010001100 00000010101 1"	// and the 2 CPLD also in the chain
//#define PZ3032ID  "0000 0000000000011010 00000010101 1"	// contains version, part, and vendor codes
//#define PZ3032AID "0000 0000100000001010 00000010101 1"
#define PZ3032SID "**** 0000*000000*1010 00000010101 1"	// support both the 'A' and non 'A' versions of the part


#define READ 0		// Flags used to modify the SA-1110 JTAG chain data depending on
#define WRITE 1		// the access mode of the Flash Memory
#define SETUP 2
#define HOLD 3
#define RS 4

#define ENABLE 1
#define DISABLE 0

#define DRIVE 0
#define HIZ 1    // high Z (impedance)

#define IGNORE_PORT 0		// Flag used when accessing the parallel port
#define READ_PORT 1		    // READ_PORT = 'read port', IGNORE_PORT = 'ignore port', 
                            //   using IGNORE_PORT will speed access
#define IP IGNORE_PORT
#define RP READ_PORT

#define CONTINUE    0       // not the last instruction
#define TERMINATE   1       // this is the last instruction, so go to EXIT-1 IR


#define MAX_IN_LENGTH 100 // max length for user input strings
#define STATUS_UPDATE 2	// time between updates of program/verify status in seconds

/*
*******************************************************************************
Command codes for the flash
*******************************************************************************
*/

#if defined(LUBBOCK_SABINAL) || defined(LUBBOCK_DALHART_16)

	#define F_READ_ARRAY            0x00FFL
	#define F_READ_IDCODES          0x0090L
	#define F_READ_QUERY            0x0098L
	#define F_READ_STATUS           0x0070L
	#define F_CLEAR_STATUS          0x0050L
	#define F_WRITE_BUFFER          0x00E8L
	#define F_WORDBYTE_PROG         0x0040L

	#define F_BLOCK_ERASE           0x0020L
	#define F_BLOCK_ERASE_2ND       0x00D0L	

	#define F_BLK_ERASE_PS          0x00B0L
	#define F_BLK_ERASE_PR          0x00D0L
	#define F_CONFIGURATION         0x00B8L

	#define F_SET_READ_CFG_REG      0x0060L
	#define F_SET_READ_CFG_REG_2ND  0x0003L

	#define F_SET_BLOCK_LOCK        0x0060L
	#define F_SET_BLOCK_LOCK_2ND    0x0001L

	#define F_CLEAR_BLOCK_LOCK      0x0060L
	#define F_CLEAR_BLOCK_LOCK_2ND  0x00D0L

	#define F_PROTECTION            0x00C0L

	#define F_ATTR_Q				0x0051L
	#define F_ATTR_R				0x0052L
	#define F_ATTR_Y				0x0059L

	#define F_BLOCK_LOCKED			0x0001L
	#define F_STATUS_READY			0x0080L

	#define BUS_GRAIN				WORD
	#define access_rom				access_rom_16
#else 
	#define F_READ_ARRAY            0x00FF00FFL
	#define F_READ_IDCODES          0x00900090L
	#define F_READ_QUERY            0x00980098L
	#define F_READ_STATUS           0x00700070L
	#define F_CLEAR_STATUS          0x00500050L
	#define F_WRITE_BUFFER          0x00E800E8L
	#define F_WORDBYTE_PROG         0x00400040L

	#define F_BLOCK_ERASE           0x00200020L
	#define F_BLOCK_ERASE_2ND       0x00D000D0L

	#define F_BLK_ERASE_PS          0x00B000B0L
	#define F_BLK_ERASE_PR          0x00D000D0L
	#define F_CONFIGURATION         0x00B800B8L

	#define F_SET_READ_CFG_REG      0x00600060L
	#define F_SET_READ_CFG_REG_2ND  0x00030003L

	#define F_SET_BLOCK_LOCK        0x00600060L
	#define F_SET_BLOCK_LOCK_2ND    0x00010001L

	#define F_CLEAR_BLOCK_LOCK      0x00600060L
	#define F_CLEAR_BLOCK_LOCK_2ND  0x00D000D0L

	#define F_PROTECTION            0x00C000C0L

	#define F_ATTR_Q				0x00510051L
	#define F_ATTR_R				0x00520052L
	#define F_ATTR_Y				0x00590059L

	#define F_BLOCK_LOCKED			0x00010001L
	#define F_STATUS_READY			0x00800080L
	
	#define BUS_GRAIN				DWORD
	#define access_rom				access_rom_32
#endif

