/******************************************************************************
**
**  COPYRIGHT (C) 2000, 2001, 2002 Intel Corporation.
**
**  The information in this file is furnished for informational use 
**  only, is subject to change without notice, and should not be construed as 
**  a commitment by Intel Corporation. Intel Corporation assumes no 
**  responsibility or liability for any errors or inaccuracies that may appear 
**  in this document or any software that may be provided in association with 
**  this document. 
**
**  FILENAME:       cotullajtag.h
**
**  PURPOSE:        pin defines for the Cotulla Boundary Scan Chain
**
**  LAST MODIFIED:  $Modtime: 4/26/02 3:52p $
******************************************************************************/

#define COTULLA_CHAIN_LENGTH 385
#define SA1110_CHAIN_LENGTH 292

#define SANDGATE_WORKBUF_SIZE 387
#define LUBBOCK_WORKBUF_SIZE 385
#define ASSABET_WORKBUF_SIZE 294


#ifdef SANDGATE_PLATFORM

    #define CHAIN_LENGTH COTULLA_CHAIN_LENGTH
    #define DEVICES_BEFORE 2    // number of bypass bits before the controller
    #define DEVICES_AFTER 0     // number of bypass bits after the controller

#endif //SANDGATE_PLATFORM

#ifdef ASSABET_PLATFORM
#ifndef LUBBOCK_SA1110
    #define CHAIN_LENGTH SA1110_CHAIN_LENGTH
    #define DEVICES_BEFORE 2    // number of bypass bits before the controller
    #define DEVICES_AFTER 0     // number of bypass bits after the controller
#else
    #define CHAIN_LENGTH SA1110_CHAIN_LENGTH
    #define DEVICES_BEFORE 0    // number of bypass bits before the controller
    #define DEVICES_AFTER 0     // number of bypass bits after the controller
#endif
#endif //ASSABET_PLATFORM

#ifdef LUBBOCK_PLATFORM

    #define CHAIN_LENGTH COTULLA_CHAIN_LENGTH
    #define DEVICES_BEFORE 0    // number of bypass bits before the controller
    #define DEVICES_AFTER 0     // number of bypass bits after the controller

#endif //LUBBOCK_PLATFORM



 
#define MAX_DR_LENGTH 400
#define COTULLA_IRLENGTH 5
#define PZ_IRLENGTH 4


/*
*******************************************************************************
 Cotulla pin defines - note that some pins names do not match the BSDL 
 exactly because they have been changed to match the code that uses them.
 
 Possible bug here. ******
 
 The cotulla does not have a dedicated set of chip select 
 pins and uses GPIO pins in an alternate mode to do this work. It is unclear if 
 these gpio pins need to be enabled through the control pins to activate. If
 improper chip selects are happening, this is probably the reason. 
*******************************************************************************
*/

#ifndef ASSABET_PLATFORM

    #define  gpio0_ctrl       0                   
    #define  gpio1_ctrl       1                   
    #define  gpio2_ctrl       2                   
    #define  gpio3_ctrl       3                   
    #define  gpio4_ctrl       4                   
    #define  gpio5_ctrl       5                   
    #define  gpio6_ctrl       6                   
    #define  gpio7_ctrl       7                   
    #define  gpio8_ctrl       8                   
    #define  gpio9_ctrl       9                   
    #define  gpio10_ctrl      10                  
    #define  gpio11_ctrl      11                  
    #define  gpio12_ctrl      12                  
    #define  gpio13_ctrl      13                  
    #define  gpio14_ctrl      14                  
    #define  gpio15_ctrl      15                  
    #define  gpio16_ctrl      16                  
    #define  gpio17_ctrl      17                  
    #define  gpio18_ctrl      18                  
    #define  gpio19_ctrl      19                  
    #define  gpio20_ctrl      20                  
    #define  gpio21_ctrl      21                  
    #define  gpio22_ctrl      22                  
    #define  gpio23_ctrl      23                  
    #define  gpio24_ctrl      24                  
    #define  gpio25_ctrl      25                  
    #define  gpio26_ctrl      26                  
    #define  gpio27_ctrl      27                  
    #define  gpio28_ctrl      28                  
    #define  gpio29_ctrl      29                  
    #define  gpio30_ctrl      30                  
    #define  gpio31_ctrl      31                  
    #define  gpio32_ctrl      32                  
    #define  gpio33_ctrl      33                  
    #define  gpio34_ctrl      34                  
    #define  gpio35_ctrl      35                  
    #define  gpio36_ctrl      36                  
    #define  gpio37_ctrl      37                  
    #define  gpio38_ctrl      38                  
    #define  gpio39_ctrl      39                  
    #define  gpio40_ctrl      40                  
    #define  gpio41_ctrl      41                  
    #define  gpio42_ctrl      42                  
    #define  gpio43_ctrl      43                  
    #define  gpio44_ctrl      44                  
    #define  gpio45_ctrl      45                  
    #define  gpio46_ctrl      46                  
    #define  gpio47_ctrl      47                  
    #define  gpio48_ctrl      48                  
    #define  nPOE_ctrl gpio48_ctrl
    #define  nPOE_OUT gpio48
    #define  gpio49_ctrl      49                  
    #define  nPWE_ctrl gpio49_ctrl
    #define  nPWE_OUT gpio49
    #define  gpio50_ctrl      50                  
    #define  gpio51_ctrl      51                  
    #define  gpio52_ctrl      52                  
    #define  gpio53_ctrl      53                  
    #define  gpio54_ctrl      54                  
    #define  gpio55_ctrl      55                  
    #define  gpio56_ctrl      56                  
    #define  gpio57_ctrl      57                  
    #define  gpio58_ctrl      58                  
    #define  gpio59_ctrl      59                  
    #define  gpio60_ctrl      60                  
    #define  gpio61_ctrl      61                  
    #define  gpio62_ctrl      62                  
    #define  gpio63_ctrl      63                  
    #define  gpio64_ctrl      64                  
    #define  gpio65_ctrl      65                  
    #define  gpio66_ctrl      66                  
    #define  gpio67_ctrl      67                  
    #define  gpio68_ctrl      68                  
    #define  gpio69_ctrl      69                  
    #define  gpio70_ctrl      70                  
    #define  gpio71_ctrl      71                  
    #define  gpio72_ctrl      72                  
    #define  gpio73_ctrl      73                  
    #define  gpio74_ctrl      74                  
    #define  gpio75_ctrl      75                  
    #define  gpio76_ctrl      76                  
    #define  gpio77_ctrl      77                  
    #define  gpio78_ctrl      78        //             
    #define  gpio79_ctrl      79                  
    #define  gpio80_ctrl      80                  
    #define  usb_ctrl         81                  
    #define  mmdat_ctrl       82                  
    #define  mmcmd_ctrl       83                  
    #define  mdupper_ctrl     84                  
    #define  mdlower_ctrl     85                  
    #define  gpio0            86                  
    #define  gpio1            87                  
    #define  gpio2            88                  
    #define  gpio3            89                  
    #define  gpio4            90                  
    #define  gpio5            91                  
    #define  gpio6            92                  
    #define  gpio7            93                  
    #define  gpio8            94                  
    #define  gpio9            95                  
    #define  gpio10           96                  
    #define  gpio11           97                  
    #define  gpio12           98                  
    #define  gpio13           99                  
    #define  gpio14           100                 
    #define  nCS1_OUT         101       // gpio15 
    #define  gpio16           102                 
    #define  gpio17           103                 
    #define  gpio18           104                 
    #define  gpio19           105                 
    #define  gpio20           106                 
    #define  gpio21           107                 
    #define  gpio22           108                 
    #define  gpio23           109                 
    #define  gpio24           110                 
    #define  gpio25           111                 
    #define  gpio26           112                 
    #define  gpio27           113                 
    #define  gpio28           114                 
    #define  gpio29           115                 
    #define  gpio30           116                 
    #define  gpio31           117                 
    #define  gpio32           118                 
    #define  nCS5_OUT         119       // gpio33 
    #define  gpio34           120                 
    #define  gpio35           121                 
    #define  gpio36           122                 
    #define  gpio37           123                 
    #define  gpio38           124                 
    #define  gpio39           125                 
    #define  gpio40           126                 
    #define  gpio41           127                 
    #define  gpio42           128                 
    #define  gpio43           129                 
    #define  gpio44           130                 
    #define  gpio45           131                 
    #define  gpio46           132                 
    #define  gpio47           133                 
    #define  gpio48           134                 
    #define  gpio49           135                 
    #define  gpio50           136                 
    #define  gpio51           137                 
    #define  gpio52           138                 
    #define  gpio53           139                 
    #define  gpio54           140                 
    #define  gpio55           141                 
    #define  gpio56           142                 
    #define  gpio57           143                 
    #define  gpio58           144                 
    #define  gpio59           145                 
    #define  gpio60           146                 
    #define  gpio61           147                 
    #define  gpio62           148                 
    #define  gpio63           149                 
    #define  gpio64           150                 
    #define  gpio65           151                 
    #define  gpio66           152                 
    #define  gpio67           153                 
    #define  gpio68           154                 
    #define  gpio69           155                 
    #define  gpio70           156                 
    #define  gpio71           157                 
    #define  gpio72           158                 
    #define  gpio73           159                 
    #define  gpio74           160                 
    #define  gpio75           161                 
    #define  gpio76           162                 
    #define  gpio77           163                 
    #define  nCS2_OUT         164       // gpio78     
    #define  nCS3_OUT         165       // gpio79     
    #define  nCS4_OUT         166       // gpio80 
    #define  scl_out          167                 
    #define  sda_out          168                 
    #define  usb_n_out        169                 
    #define  usb_p_out        170                 
    #define  mmdat_out        171                 
    #define  mmcmd_out        172                 
    #define  md0_out          173                 
    #define  md1_out          174                 
    #define  md2_out          175                 
    #define  md3_out          176                 
    #define  md4_out          177                 
    #define  md5_out          178                 
    #define  md6_out          179                 
    #define  md7_out          180                 
    #define  md8_out          181                 
    #define  md9_out          182                 
    #define  md10_out         183                 
    #define  md11_out         184                 
    #define  md12_out         185                 
    #define  md13_out         186                 
    #define  md14_out         187                 
    #define  md15_out         188                 
    #define  md16_out         189                 
    #define  md17_out         190                 
    #define  md18_out         191                 
    #define  md19_out         192                 
    #define  md20_out         193                 
    #define  md21_out         194                 
    #define  md22_out         195                 
    #define  md23_out         196                 
    #define  md24_out         197                 
    #define  md25_out         198                 
    #define  md26_out         199                 
    #define  md27_out         200                 
    #define  md28_out         201                 
    #define  md29_out         202                 
    #define  md30_out         203                 
    #define  md31_out         204                 
    #define  rdnwr_ctrl       205                 
    #define  ncs_0_ctrl       206                 
    #define  nwe_ctrl         207                 
    #define  sdclk_0_ctrl     208                 
    #define  pwr_en           209                 
    #define  nreset_out       210                 
    #define  ac_reset_n       211                 
    #define  RD_nWR_OUT       212     //rdnwr       
    #define  sdclk_0          213                 
    #define  sdclk_1          214                 
    #define  sdclk_2          215                 
    #define  sdcke0           216                 
    #define  sdcke1           217                 
    #define  nsdcs_0          218                 
    #define  nsdcs_1          219                 
    #define  nsdcs_2          220                 
    #define  nsdcs_3          221                 
    #define  dqm_0            222                 
    #define  dqm_1            223                 
    #define  dqm_2            224                 
    #define  dqm_3            225                 
    #define  nsdcas           226                 
    #define  nsdras           227                 
    #define  nWE_OUT          228       //nwe     
    #define  nOE_OUT          229       //noe     
    #define  nCS0_OUT         230       //ncs_0          
    #define  ma0              231                 
    #define  ma1              232                 
    #define  ma2              233                 
    #define  ma3              234                 
    #define  ma4              235                 
    #define  ma5              236                 
    #define  ma6              237                 
    #define  ma7              238                 
    #define  ma8              239                 
    #define  ma9              240                 
    #define  ma10             241                 
    #define  ma11             242                 
    #define  ma12             243                 
    #define  ma13             244                 
    #define  ma14             245                 
    #define  ma15             246                 
    #define  ma16             247                 
    #define  ma17             248                 
    #define  ma18             249                 
    #define  ma19             250                 
    #define  ma20             251                 
    #define  ma21             252                 
    #define  ma22             253                 
    #define  ma23             254                 
    #define  ma24             255                 
    #define  ma25             256                 
    #define  gpio0_input      257                 
    #define  gpio1_input      258                 
    #define  gpio2_input      259                 
    #define  gpio3_input      260                 
    #define  gpio4_input      261                 
    #define  gpio5_input      262                 
    #define  gpio6_input      263                 
    #define  gpio7_input      264                 
    #define  gpio8_input      265                 
    #define  gpio9_input      266                 
    #define  gpio10_input     267                 
    #define  gpio11_input     268                 
    #define  gpio12_input     269                 
    #define  gpio13_input     270                 
    #define  gpio14_input     271                 
    #define  gpio15_input     272                 
    #define  gpio16_input     273                 
    #define  gpio17_input     274                 
    #define  gpio18_input     275                 
    #define  gpio19_input     276                 
    #define  gpio20_input     277                 
    #define  gpio21_input     278                 
    #define  gpio22_input     279                 
    #define  gpio23_input     280                 
    #define  gpio24_input     281                 
    #define  gpio25_input     282                 
    #define  gpio26_input     283                 
    #define  gpio27_input     284                 
    #define  gpio28_input     285                 
    #define  gpio29_input     286                 
    #define  gpio30_input     287                 
    #define  gpio31_input     288                 
    #define  gpio32_input     289                 
    #define  gpio33_input     290                 
    #define  gpio34_input     291                 
    #define  gpio35_input     292                 
    #define  gpio36_input     293                 
    #define  gpio37_input     294                 
    #define  gpio38_input     295                 
    #define  gpio39_input     296                 
    #define  gpio40_input     297                 
    #define  gpio41_input     298                 
    #define  gpio42_input     299                 
    #define  gpio43_input     300                 
    #define  gpio44_input     301                 
    #define  gpio45_input     302                 
    #define  gpio46_input     303                 
    #define  gpio47_input     304                 
    #define  gpio48_input     305                 
    #define  gpio49_input     306                 
    #define  gpio50_input     307                 
    #define  gpio51_input     308                 
    #define  gpio52_input     309                 
    #define  gpio53_input     310                 
    #define  gpio54_input     311                 
    #define  gpio55_input     312                 
    #define  gpio56_input     313                 
    #define  gpio57_input     314                 
    #define  gpio58_input     315                 
    #define  gpio59_input     316                 
    #define  gpio60_input     317                 
    #define  gpio61_input     318                 
    #define  gpio62_input     319                 
    #define  gpio63_input     320                 
    #define  gpio64_input     321                 
    #define  gpio65_input     322                 
    #define  gpio66_input     323                 
    #define  gpio67_input     324                 
    #define  gpio68_input     325                 
    #define  gpio69_input     326                 
    #define  gpio70_input     327                 
    #define  gpio71_input     328                 
    #define  gpio72_input     329                 
    #define  gpio73_input     330                 
    #define  gpio74_input     331                 
    #define  gpio75_input     332                 
    #define  gpio76_input     333                 
    #define  gpio77_input     334                 
    #define  gpio78_input     335                 
    #define  gpio79_input     336                 
    #define  gpio80_input     337                 
    #define  scl              338                 
    #define  sda              339                 
    #define  usb_n            340                 
    #define  usb_p            341                 
    #define  mmdat            342                 
    #define  mmcmd            343                 
    #define  md0              344                 
    #define  md1              345                 
    #define  md2              346                 
    #define  md3              347                 
    #define  md4              348                 
    #define  md5              349                 
    #define  md6              350                 
    #define  md7              351                 
    #define  md8              352                 
    #define  md9              353                 
    #define  md10             354                 
    #define  md11             355                 
    #define  md12             356                 
    #define  md13             357                 
    #define  md14             358                 
    #define  md15             359                 
    #define  md16             360                 
    #define  md17             361                 
    #define  md18             362                 
    #define  md19             363                 
    #define  md20             364                 
    #define  md21             365                 
    #define  md22             366                 
    #define  md23             367                 
    #define  md24             368                 
    #define  md25             369                 
    #define  md26             370                 
    #define  md27             371                 
    #define  md28             372                 
    #define  md29             373                 
    #define  md30             374                 
    #define  md31             375                 
    #define  pkg_sel          376                 
    #define  test             377                 
    #define  testclk          378                 
    #define  nvdd_fault       379                 
    #define  nbatt_fault      380                 
    #define  boot_sel0        381                 
    #define  boot_sel1        382                 
    #define  boot_sel2        383                 
    #define  nreset           384                 
/*
*******************************************************************************
Cotulla default pin levels
*******************************************************************************
*/

int pin[] = {

    0,    //  gpio0_ctrl       
    0,    //  gpio1_ctrl       
    0,    //  gpio2_ctrl       
    0,    //  gpio3_ctrl       
    0,    //  gpio4_ctrl       
    0,    //  gpio5_ctrl       
    0,    //  gpio6_ctrl       
    0,    //  gpio7_ctrl       
    0,    //  gpio8_ctrl       
    0,    //  gpio9_ctrl       
    0,    //  gpio10_ctrl      
    0,    //  gpio11_ctrl      
    0,    //  gpio12_ctrl      
    0,    //  gpio13_ctrl      
    0,    //  gpio14_ctrl      
    1,    //  gpio15_ctrl, nCS1_ctrl
    0,    //  gpio16_ctrl      
    0,    //  gpio17_ctrl      
    0,    //  gpio18_ctrl      
    0,    //  gpio19_ctrl      
    0,    //  gpio20_ctrl      
    0,    //  gpio21_ctrl      
    0,    //  gpio22_ctrl      
    0,    //  gpio23_ctrl      
    0,    //  gpio24_ctrl      
    0,    //  gpio25_ctrl      
    0,    //  gpio26_ctrl      
    0,    //  gpio27_ctrl      
    0,    //  gpio28_ctrl      
    0,    //  gpio29_ctrl      
    0,    //  gpio30_ctrl      
    0,    //  gpio31_ctrl      
    0,    //  gpio32_ctrl      
    1,    //  gpio33_ctrl      
    0,    //  gpio34_ctrl      
    0,    //  gpio35_ctrl      
    0,    //  gpio36_ctrl      
    0,    //  gpio37_ctrl      
    0,    //  gpio38_ctrl      
    0,    //  gpio39_ctrl      
    0,    //  gpio40_ctrl      
    0,    //  gpio41_ctrl      
    0,    //  gpio42_ctrl      
    0,    //  gpio43_ctrl      
    0,    //  gpio44_ctrl      
    0,    //  gpio45_ctrl      
    0,    //  gpio46_ctrl      
    0,    //  gpio47_ctrl      
    1,    //  gpio48_ctrl, nPOE_ctrl
    1,    //  gpio49_ctrl, nPWE_ctrl
    0,    //  gpio50_ctrl      
    0,    //  gpio51_ctrl      
    1,    //  gpio52_ctrl, nPCE1_ctrl
    1,    //  gpio53_ctrl, nPCE2_ctrl
    0,    //  gpio54_ctrl      
    0,    //  gpio55_ctrl      
    0,    //  gpio56_ctrl      
    0,    //  gpio57_ctrl      
    0,    //  gpio58_ctrl      
    0,    //  gpio59_ctrl      
    0,    //  gpio60_ctrl      
    0,    //  gpio61_ctrl      
    0,    //  gpio62_ctrl      
    0,    //  gpio63_ctrl      
    0,    //  gpio64_ctrl      
    0,    //  gpio65_ctrl      
    0,    //  gpio66_ctrl      
    0,    //  gpio67_ctrl      
    0,    //  gpio68_ctrl      
    0,    //  gpio69_ctrl      
    0,    //  gpio70_ctrl      
    0,    //  gpio71_ctrl      
    0,    //  gpio72_ctrl      
    0,    //  gpio73_ctrl      
    0,    //  gpio74_ctrl      
    0,    //  gpio75_ctrl      
    0,    //  gpio76_ctrl      
    0,    //  gpio77_ctrl      
    1,    //  gpio78_ctrl, nCS2
    1,    //  gpio79_ctrl, nCS3
    1,    //  gpio80_ctrl, nCS4
    0,    //  usb_ctrl         
    0,    //  mmdat_ctrl       
    0,    //  mmcmd_ctrl       
    0,    //  mdupper_ctrl     
    0,    //  mdlower_ctrl     
    0,    //  gpio0            
    0,    //  gpio1            
    0,    //  gpio2            
    0,    //  gpio3            
    0,    //  gpio4            
    0,    //  gpio5            
    0,    //  gpio6            
    0,    //  gpio7            
    0,    //  gpio8            
    0,    //  gpio9            
    0,    //  gpio10           
    0,    //  gpio11           
    0,    //  gpio12           
    0,    //  gpio13           
    0,    //  gpio14           
    1,    //  gpio15, nCS1_ctrl
    0,    //  gpio16           
    0,    //  gpio17           
    0,    //  gpio18           
    0,    //  gpio19           
    0,    //  gpio20           
    0,    //  gpio21           
    0,    //  gpio22           
    0,    //  gpio23           
    0,    //  gpio24           
    0,    //  gpio25           
    0,    //  gpio26           
    0,    //  gpio27           
    0,    //  gpio28           
    0,    //  gpio29           
    0,    //  gpio30           
    0,    //  gpio31           
    0,    //  gpio32           
    1,    //  gpio33           
    0,    //  gpio34           
    0,    //  gpio35           
    0,    //  gpio36           
    0,    //  gpio37           
    0,    //  gpio38           
    0,    //  gpio39           
    0,    //  gpio40           
    0,    //  gpio41           
    0,    //  gpio42           
    0,    //  gpio43           
    0,    //  gpio44           
    0,    //  gpio45           
    0,    //  gpio46           
    0,    //  gpio47           
    1,    //  gpio48, nPOE_ctrl          
    1,    //  gpio49, nPWE_ctrl          
    0,    //  gpio50           
    0,    //  gpio51           
    1,    //  gpio52, nPCE1_ctrl           
    1,    //  gpio53, nPCE2_ctrl
    0,    //  gpio54           
    0,    //  gpio55           
    0,    //  gpio56           
    0,    //  gpio57           
    0,    //  gpio58           
    0,    //  gpio59           
    0,    //  gpio60           
    0,    //  gpio61           
    0,    //  gpio62           
    0,    //  gpio63           
    0,    //  gpio64           
    0,    //  gpio65           
    0,    //  gpio66           
    0,    //  gpio67           
    0,    //  gpio68           
    0,    //  gpio69           
    0,    //  gpio70           
    0,    //  gpio71           
    0,    //  gpio72           
    0,    //  gpio73           
    0,    //  gpio74           
    0,    //  gpio75           
    0,    //  gpio76           
    0,    //  gpio77           
    1,    //  gpio78, nCS2
    1,    //  gpio79, nCS3
    1,    //  gpio80, nCS4
    0,    //  scl_out              
    0,    //  sda_out              
    0,    //  usb_n_out            
    0,    //  usb_p_out            
    0,    //  mmdat_out            
    0,    //  mmcmd_out            
    0,    //  md0_out          
    0,    //  md1_out          
    0,    //  md2_out          
    0,    //  md3_out          
    0,    //  md4_out          
    0,    //  md5_out          
    0,    //  md6_out          
    0,    //  md7_out          
    0,    //  md8_out          
    0,    //  md9_out          
    0,    //  md10_out         
    0,    //  md11_out         
    0,    //  md12_out         
    0,    //  md13_out         
    0,    //  md14_out         
    0,    //  md15_out         
    0,    //  md16_out         
    0,    //  md17_out         
    0,    //  md18_out         
    0,    //  md19_out         
    0,    //  md20_out         
    0,    //  md21_out         
    0,    //  md22_out         
    0,    //  md23_out         
    0,    //  md24_out         
    0,    //  md25_out         
    0,    //  md26_out         
    0,    //  md27_out         
    0,    //  md28_out         
    0,    //  md29_out         
    0,    //  md30_out         
    0,    //  md31_out         
    1,    //  rdnwr_ctrl       
    1,    //  ncs_0_ctrl       
    1,    //  nwe_ctrl         
    1,    //  sdclk_0_ctrl     
    1,    //  pwr_en           
    0,    //  nreset_out       
    0,    //  ac_reset_n       
    0,    //  rdnwr            
    0,    //  sdclk_0          
    0,    //  sdclk_1          
    0,    //  sdclk_2          
    0,    //  sdcke0           
    0,    //  sdcke1           
    1,    //  nsdcs_0          
    1,    //  nsdcs_1          
    1,    //  nsdcs_2          
    1,    //  nsdcs_3          
    0,    //  dqm_0            
    0,    //  dqm_1            
    0,    //  dqm_2            
    0,    //  dqm_3            
    1,    //  nsdcas           
    1,    //  nsdras           
    1,    //  nwe              
    1,    //  noe              
    1,    //  ncs_0            
    0,    //  ma0              
    0,    //  ma1              
    0,    //  ma2              
    0,    //  ma3              
    0,    //  ma4              
    0,    //  ma5              
    0,    //  ma6              
    0,    //  ma7              
    0,    //  ma8              
    0,    //  ma9              
    0,    //  ma10             
    0,    //  ma11             
    0,    //  ma12             
    0,    //  ma13             
    0,    //  ma14             
    0,    //  ma15             
    0,    //  ma16             
    0,    //  ma17             
    0,    //  ma18             
    0,    //  ma19             
    0,    //  ma20             
    0,    //  ma21             
    0,    //  ma22             
    0,    //  ma23             
    0,    //  ma24             
    0,    //  ma25             
    0,    //  gpio0_input      
    0,    //  gpio1_input      
    0,    //  gpio2_input      
    0,    //  gpio3_input      
    0,    //  gpio4_input      
    0,    //  gpio5_input      
    0,    //  gpio6_input      
    0,    //  gpio7_input      
    0,    //  gpio8_input      
    0,    //  gpio9_input      
    0,    //  gpio10_input     
    0,    //  gpio11_input     
    0,    //  gpio12_input     
    0,    //  gpio13_input     
    0,    //  gpio14_input     
    0,    //  gpio15_input     
    0,    //  gpio16_input     
    0,    //  gpio17_input     
    0,    //  gpio18_input     
    0,    //  gpio19_input     
    0,    //  gpio20_input     
    0,    //  gpio21_input     
    0,    //  gpio22_input     
    0,    //  gpio23_input     
    0,    //  gpio24_input     
    0,    //  gpio25_input     
    0,    //  gpio26_input     
    0,    //  gpio27_input     
    0,    //  gpio28_input     
    0,    //  gpio29_input     
    0,    //  gpio30_input     
    0,    //  gpio31_input     
    0,    //  gpio32_input     
    0,    //  gpio33_input     
    0,    //  gpio34_input     
    0,    //  gpio35_input     
    0,    //  gpio36_input     
    0,    //  gpio37_input     
    0,    //  gpio38_input     
    0,    //  gpio39_input     
    0,    //  gpio40_input     
    0,    //  gpio41_input     
    0,    //  gpio42_input     
    0,    //  gpio43_input     
    0,    //  gpio44_input     
    0,    //  gpio45_input     
    0,    //  gpio46_input     
    0,    //  gpio47_input     
    0,    //  gpio48_input     
    0,    //  gpio49_input     
    0,    //  gpio50_input     
    0,    //  gpio51_input     
    0,    //  gpio52_input     
    0,    //  gpio53_input     
    0,    //  gpio54_input     
    0,    //  gpio55_input     
    0,    //  gpio56_input     
    0,    //  gpio57_input     
    0,    //  gpio58_input     
    0,    //  gpio59_input     
    0,    //  gpio60_input     
    0,    //  gpio61_input     
    0,    //  gpio62_input     
    0,    //  gpio63_input     
    0,    //  gpio64_input     
    0,    //  gpio65_input     
    0,    //  gpio66_input     
    0,    //  gpio67_input     
    0,    //  gpio68_input     
    0,    //  gpio69_input     
    0,    //  gpio70_input     
    0,    //  gpio71_input     
    0,    //  gpio72_input     
    0,    //  gpio73_input     
    0,    //  gpio74_input     
    0,    //  gpio75_input     
    0,    //  gpio76_input     
    0,    //  gpio77_input     
    0,    //  gpio78_input     
    0,    //  gpio79_input     
    0,    //  gpio80_input     
    0,    //  scl              
    0,    //  sda              
    0,    //  usb_n            
    0,    //  usb_p            
    0,    //  mmdat            
    0,    //  mmcmd            
    0,    //  md0              
    0,    //  md1              
    0,    //  md2              
    0,    //  md3              
    0,    //  md4              
    0,    //  md5              
    0,    //  md6              
    0,    //  md7              
    0,    //  md8              
    0,    //  md9              
    0,    //  md10             
    0,    //  md11             
    0,    //  md12             
    0,    //  md13             
    0,    //  md14             
    0,    //  md15             
    0,    //  md16             
    0,    //  md17             
    0,    //  md18             
    0,    //  md19             
    0,    //  md20             
    0,    //  md21             
    0,    //  md22             
    0,    //  md23             
    0,    //  md24             
    0,    //  md25             
    0,    //  md26             
    0,    //  md27             
    0,    //  md28             
    0,    //  md29             
    0,    //  md30             
    0,    //  md31             
    0,    //  pkg_sel          
    0,    //  test             
    0,    //  testclk          
    1,    //  nvdd_fault       
    1,    //  nbatt_fault      
    0,    //  boot_sel0        
    0,    //  boot_sel1        
    0,    //  boot_sel2        
    0     //  nreset
};
/*
*******************************************************************************
 Data pins for Cotulla
*******************************************************************************
*/

int dat_order[] =   {	 
					 md0_out, md1_out, md2_out, md3_out, md4_out, md5_out, md6_out, md7_out,
					 md8_out, md9_out, md10_out,md11_out,md12_out,md13_out,md14_out,md15_out,
					 md16_out,md17_out,md18_out,md19_out,md20_out,md21_out,md22_out,md23_out,
					 md24_out,md25_out,md26_out,md27_out,md28_out,md29_out,md30_out,md31_out
                    };

int input_dat_order[] = {	 
					 md0, md1, md2, md3, md4, md5, md6, md7,
					 md8, md9, md10,md11,md12,md13,md14,md15,
					 md16,md17,md18,md19,md20,md21,md22,md23,
					 md24,md25,md26,md27,md28,md29,md30,md31
                     };

/*
*******************************************************************************
 Address order for Cotulla
*******************************************************************************
*/

int addr_order[] =  { ma0,  ma1,  ma2,   ma3,   ma4, 
                      ma5,  ma6,  ma7,   ma8,   ma9, 
                      ma10, ma11, ma12,  ma13,  ma14,
                      ma15, ma16, ma17,  ma18,  ma19,
                      ma20, ma21, ma22,  ma23,  ma24,
                      ma25
                    };


#endif // !ASSABET_PLATFORM

/*
*******************************************************************************
IRSCAN instructions for the Cotulla - only 5 valid bits
*******************************************************************************
*/
#define COT_EXTEST  0x0
#define COT_SAMPLE  0x1
#define COT_DBGRX   0x2
#define COT_CLAMP   0x4
#define COT_IDIC    0x7
#define COT_HIGHZ   0x8
#define COT_DCSR    0x9
#define COT_DBGTX   0x10
#define COT_IDCODE  0x1E
#define COT_BYPASS  0x1F

/*
*******************************************************************************
IRSCAN instructions for the SA-1110 - only 5 valid bits
*******************************************************************************
*/
#define SA_EXTEST   0x0
#define SA_SAMPLE   0x1
#define SA_CLAMP    0x4
#define SA_HIGHZ    0x5
#define SA_IDCODE   0x6
#define SA_BYPASS   0x1F


/*
*******************************************************************************
IRSCAN Instructions for the PZ3128 and the PZ3032 - only 4 valid bits.
There are also some ISP (In Circuit Programming) instructions.
*******************************************************************************
*/
#define PZ_SAMPLE   0x2
#define PZ_EXTEST   0x0
#define PZ_BYPASS   0xF
#define PZ_IDCODE   0x1
#define PZ_HIGHZ    0x5
#define PZ_ENABLE   0x9     // ISP - enable ISP functions
#define PZ_ERASE    0xA     // ISP erase
#define PZ_PROGRAM  0xB     // ISP Program
#define PZ_VERIFY   0xC     // ISP Verify

//----------------------------------------------------------------------------------------

#ifdef ASSABET_PLATFORM



#define	ROM_SEL_IN	0
#define	nRESET_OUT_OUT	1
#define	nRESET_IN	2
#define	TXD_3_IN	3
#define	TXD_3_OUT	4
#define	TXD_3_EN	5
#define	RXD_3_IN	6
#define	RXD_3_OUT	7
#define	RXD_3_EN	8
#define	TXD_2_IN	9
#define	TXD_2_OUT	10
#define	TXD_2_EN	11
#define	RXD_2_IN	12
#define	RXD_2_OUT	13
#define	RXD_2_EN	14
#define	TXD_1_IN	15
#define	TXD_1_OUT	16
#define	TXD_1_EN	17
#define	RXD_1_IN	18
#define	RXD_1_OUT	19
#define	RXD_1_EN	20
#define	UDCp_IN	21
#define	UDCp_OUT	22
#define	UDCp_EN	23
#define	UDCmUDCp_IN	24
#define	UDCm_IN	25
#define	UDCm_OUT	26
#define	UDCm_EN	27
#define	A0_OUT	28
#define	A1_OUT	29
#define	A2_OUT	30
#define	A3_OUT	31
#define	A4_OUT	32
#define	A5_OUT	33
#define	A6_OUT	34
#define	A7_OUT	35
#define	A8_OUT	36
#define	A9_OUT	37
#define	A10_OUT	38
#define	A11_OUT	39
#define	A12_OUT	40
#define	A13_OUT	41
#define	A14_OUT	42
#define	A15_OUT	43
#define	A16_OUT	44
#define	A17_OUT	45
#define	A18_OUT	46
#define	A19_OUT	47
#define	A20_OUT	48
#define	A21_OUT	49
#define	A22_OUT	50
#define	A23_OUT	51
#define	A24_OUT	52
#define	A25_OUT	53
#define	nCS0_OUT	54
#define	nCS1_OUT	55
#define	nCS2_OUT	56
#define	nCS3_OUT	57
#define	nCS4_OUT	58
#define	nCS5_OUT	59
#define	RDY_IN	60
#define	RD_nWR_OUT	61
#define	nCAS0_OUT	62
#define	nCAS1_OUT	63
#define	nCAS2_OUT	64
#define	nCAS3_OUT	65
#define	nRAS0_OUT	66
#define	nRAS1_OUT	67
#define	nRAS2_OUT	68
#define	nRAS3_OUT	69
#define	nSDCAS_OUT	70
#define	nSDRAS_OUT	71
#define	nOE_OUT	72
#define	nWE_OUT	73
#define	multiEN_EN	74
#define	nPCE1_OUT	75
#define	nPCE2_OUT	76
#define	nPREG_OUT	77
#define	nPWAIT_IN	78
#define	nIOIS16_IN	79
#define	PSKTSEL_OUT	80
#define	nPIOW_OUT	81
#define	nPIOR_OUT	82
#define	nPWE_OUT	83
#define	nPOE_OUT	84
#define	L_FCLK_IN	85
#define	L_FCLK_OUT	86
#define	L_FCLK_EN	87
#define	L_LCLK_IN	88
#define	L_LCLK_OUT	89
#define	L_LCLK_EN	90
#define	L_DD7_IN	91
#define	L_DD7_OUT	92
#define	L_DD7_EN	93
#define	L_DD6_IN	94
#define	L_DD6_OUT	95
#define	L_DD6_EN	96
#define	L_DD5_IN	97
#define	L_DD5_OUT	98
#define	L_DD5_EN	99
#define	L_DD4_IN	100
#define	L_DD4_OUT	101
#define	L_DD4_EN	102
#define	L_DD3_IN	103
#define	L_DD3_OUT	104
#define	L_DD3_EN	105
#define	L_DD2_IN	106
#define	L_DD2_OUT	107
#define	L_DD2_EN	108
#define	L_DD1_IN	109
#define	L_DD1_OUT	110
#define	L_DD1_EN	111
#define	L_DD0_IN	112
#define	L_DD0_OUT	113
#define	L_DD0_EN	114
#define	L_PCLK_IN	115
#define	L_PCLK_OUT	116
#define	L_PCLK_EN	117
#define	L_BIAS_IN	118
#define	L_BIAS_OUT	119
#define	L_BIAS_EN	120
#define	GP0_IN	121
#define	GP0_OUT	122
#define	GP0_EN	123
#define	GP1_IN	124
#define	GP1_OUT	125
#define	GP1_EN	126
#define	GP2_IN	127
#define	GP2_OUT	128
#define	GP2_EN	129
#define	GP3_IN	130
#define	GP3_OUT	131
#define	GP3_EN	132
#define	GP4_IN	133
#define	GP4_OUT	134
#define	GP4_EN	135
#define	GP5_IN	136
#define	GP5_OUT	137
#define	GP5_EN	138
#define	GP6_IN	139
#define	GP6_OUT	140
#define	GP6_EN	141
#define	GP7_IN	142
#define	GP7_OUT	143
#define	GP7_EN	144
#define	GP8_IN	145
#define	GP8_OUT	146
#define	GP8_EN	147
#define	GP9_IN	148
#define	GP9_OUT	149
#define	GP9_EN	150
#define	GP10_IN	151
#define	GP10_OUT	152
#define	GP10_EN	153
#define	GP11_IN	154
#define	GP11_OUT	155
#define	GP11_EN	156
#define	GP12_IN	157
#define	GP12_OUT	158
#define	GP12_EN	159
#define	GP13_IN	160
#define	GP13_OUT	161
#define	GP13_EN	162
#define	GP14_IN	163
#define	GP14_OUT	164
#define	GP14_EN	165
#define	GP15_IN	166
#define	GP15_OUT	167
#define	GP15_EN	168
#define	GP16_IN	169
#define	GP16_OUT	170
#define	GP16_EN	171
#define	GP17_IN	172
#define	GP17_OUT	173
#define	GP17_EN	174
#define	GP18_IN	175
#define	GP18_OUT	176
#define	GP18_EN	177
#define	GP19_IN	178
#define	GP19_OUT	179
#define	GP19_EN	180
#define	GP20_IN	181
#define	GP20_OUT	182
#define	GP20_EN	183
#define	GP21_IN	184
#define	GP21_OUT	185
#define	GP21_EN	186
#define	GP22_IN	187
#define	GP22_OUT	188
#define	GP22_EN	189
#define	GP23_IN	190
#define	GP23_OUT	191
#define	GP23_EN	192
#define	GP24_IN	193
#define	GP24_OUT	194
#define	GP24_EN	195
#define	GP25_IN	196
#define	GP25_OUT	197
#define	GP25_EN	198
#define	GP26_IN	199
#define	GP26_OUT	200
#define	GP26_EN	201
#define	GP27_IN	202
#define	GP27_OUT	203
#define	GP27_EN	204
#define	SMROM_EN_IN	205
#define	SDCKE0_OUT	206
#define	SDCLK0_OUT	207
#define	SDCLK1_OUT	208
#define	SDCLK1_EN	209
#define	SDCKE1_OUT	210
#define	SDCLK2_OUT	211
#define	D31_0_EN	212
#define	D31_IN	213
#define	D31_OUT	214
#define	D23_IN	215
#define	D23_OUT	216
#define	D15_IN	217
#define	D15_OUT	218
#define	D7_IN	219
#define	D7_OUT	220
#define	D30_IN	221
#define	D30_OUT	222
#define	D22_IN	223
#define	D22_OUT	224
#define	D14_IN	225
#define	D14_OUT	226
#define	D6_IN	227
#define	D6_OUT	228
#define	D29_IN	229
#define	D29_OUT	230
#define	D21_IN	231
#define	D21_OUT	232
#define	D13_IN	233
#define	D13_OUT	234
#define	D5_IN	235
#define	D5_OUT	236
#define	D28_IN	237
#define	D28_OUT	238
#define	D20_IN	239
#define	D20_OUT	240
#define	D12_IN	241
#define	D12_OUT	242
#define	D4_IN	243
#define	D4_OUT	244
#define	D27_IN	245
#define	D27_OUT	246
#define	D19_IN	247
#define	D19_OUT	248
#define	D11_IN	249
#define	D11_OUT	250
#define	D3_IN	251
#define	D3_OUT	252
#define	D26_IN	253
#define	D26_OUT	254
#define	D18_IN	255
#define	D18_OUT	256
#define	D10_IN	257
#define	D10_OUT	258
#define	D2_IN	259
#define	D2_OUT	260
#define	D25_IN	261
#define	D25_OUT	262
#define	D17_IN	263
#define	D17_OUT	264
#define	D9_IN	265
#define	D9_OUT	266
#define	D1_IN	267
#define	D1_OUT	268
#define	D24_IN	269
#define	D24_OUT	270
#define	D16_IN	271
#define	D16_OUT	272
#define	D8_IN	273
#define	D8_OUT	274
#define	D0_IN	275
#define	D0_OUT	276
#define	TXD_C_IN	277
#define	TXD_C_OUT	278
#define	TXD_C_EN	279
#define	RXD_C_IN	280
#define	RXD_C_OUT	281
#define	RXD_C_EN	282
#define	SCLK_C_IN	283
#define	SCLK_C_OUT	284
#define	SCLK_C_EN	285
#define	SFRM_C_IN	286
#define	SFRM_C_OUT	287
#define	SFRM_C_EN	288
#define	PWR_EN_OUT	289
#define	VDD_FAULT_IN	290
#define	BATT_FAULT_IN	291

int pin[] = {
1,	//	ROM_SEL_IN
1,	//	nRESET_OUT_OUT
1,	//	nRESET_IN
1,	//	TXD_3_IN
0,	//	TXD_3_OUT
0,	//	TXD_3_EN
1,	//	RXD_3_IN
0,	//	RXD_3_OUT
0,	//	RXD_3_EN
1,	//	TXD_2_IN
0,	//	TXD_2_OUT
0,	//	TXD_2_EN
0,	//	RXD_2_IN
0,	//	RXD_2_OUT
0,	//	RXD_2_EN
1,	//	TXD_1_IN
0,	//	TXD_1_OUT
0,	//	TXD_1_EN
1,	//	RXD_1_IN
0,	//	RXD_1_OUT
0,	//	RXD_1_EN
0,	//	UDCp_IN
0,	//	UDCp_OUT
0,	//	UDCp_EN
1,	//	UDCmUDCp_IN
0,	//	UDCm_IN
0,	//	UDCm_OUT
0,	//	UDCm_EN
0,	//	A0_OUT
0,	//	A1_OUT
1,	//	A2_OUT
0,	//	A3_OUT
0,	//	A4_OUT
0,	//	A5_OUT
0,	//	A6_OUT
0,	//	A7_OUT
0,	//	A8_OUT
0,	//	A9_OUT
0,	//	A10_OUT
0,	//	A11_OUT
0,	//	A12_OUT
0,	//	A13_OUT
0,	//	A14_OUT
0,	//	A15_OUT
0,	//	A16_OUT
0,	//	A17_OUT
0,	//	A18_OUT
0,	//	A19_OUT
0,	//	A20_OUT
0,	//	A21_OUT
0,	//	A22_OUT
0,	//	A23_OUT
0,	//	A24_OUT
0,	//	A25_OUT
1,	//	nCS0_OUT
1,	//	nCS1_OUT
1,	//	nCS2_OUT
1,	//	nCS3_OUT
1,	//	nCS4_OUT
1,	//	nCS5_OUT
1,	//	RDY_IN
0,	//	RD_nWR_OUT
1,	//	nCAS0_OUT
1,	//	nCAS1_OUT
1,	//	nCAS2_OUT
1,	//	nCAS3_OUT
1,	//	nRAS0_OUT
0,	//	nRAS1_OUT
0,	//	nRAS2_OUT
0,	//	nRAS3_OUT
0,	//	nSDCAS_OUT
0,	//	nSDRAS_OUT
0,	//	nOE_OUT
1,	//	nWE_OUT
0,	//	multiEN_EN
1,	//	nPCE1_OUT
1,	//	nPCE2_OUT
0,	//	nPREG_OUT
1,	//	nPWAIT_IN
1,	//	nIOIS16_IN
0,	//	PSKTSEL_OUT
0,	//	nPIOW_OUT
0,	//	nPIOR_OUT
0,	//	nPWE_OUT
0,	//	nPOE_OUT
1,	//	L_FCLK_IN
0,	//	L_FCLK_OUT
0,	//	L_FCLK_EN
1,	//	L_LCLK_IN
0,	//	L_LCLK_OUT
0,	//	L_LCLK_EN
1,	//	L_DD7_IN
0,	//	L_DD7_OUT
0,	//	L_DD7_EN
1,	//	L_DD6_IN
0,	//	L_DD6_OUT
0,	//	L_DD6_EN
1,	//	L_DD5_IN
0,	//	L_DD5_OUT
0,	//	L_DD5_EN
1,	//	L_DD4_IN
0,	//	L_DD4_OUT
0,	//	L_DD4_EN
1,	//	L_DD3_IN
0,	//	L_DD3_OUT
0,	//	L_DD3_EN
1,	//	L_DD2_IN
0,	//	L_DD2_OUT
0,	//	L_DD2_EN
1,	//	L_DD1_IN
0,	//	L_DD1_OUT
0,	//	L_DD1_EN
1,	//	L_DD0_IN
0,	//	L_DD0_OUT
0,	//	L_DD0_EN
1,	//	L_PCLK_IN
0,	//	L_PCLK_OUT
0,	//	L_PCLK_EN
1,	//	L_BIAS_IN
0,	//	L_BIAS_OUT
0,	//	L_BIAS_EN
0,	//	GP0_IN
0,	//	GP0_OUT
0,	//	GP0_EN
1,	//	GP1_IN
0,	//	GP1_OUT
0,	//	GP1_EN
1,	//	GP2_IN
0,	//	GP2_OUT
0,	//	GP2_EN
1,	//	GP3_IN
0,	//	GP3_OUT
0,	//	GP3_EN
1,	//	GP4_IN
0,	//	GP4_OUT
0,	//	GP4_EN
1,	//	GP5_IN
0,	//	GP5_OUT
0,	//	GP5_EN
1,	//	GP6_IN
0,	//	GP6_OUT
0,	//	GP6_EN
1,	//	GP7_IN
0,	//	GP7_OUT
0,	//	GP7_EN
1,	//	GP8_IN
0,	//	GP8_OUT
0,	//	GP8_EN
1,	//	GP9_IN
0,	//	GP9_OUT
0,	//	GP9_EN
1,	//	GP10_IN
0,	//	GP10_OUT
0,	//	GP10_EN
0,	//	GP11_IN
0,	//	GP11_OUT
0,	//	GP11_EN
1,	//	GP12_IN
0,	//	GP12_OUT
0,	//	GP12_EN
1,	//	GP13_IN
0,	//	GP13_OUT
0,	//	GP13_EN
1,	//	GP14_IN
0,	//	GP14_OUT
0,	//	GP14_EN
1,	//	GP15_IN
0,	//	GP15_OUT
0,	//	GP15_EN
1,	//	GP16_IN
0,	//	GP16_OUT
0,	//	GP16_EN
0,	//	GP17_IN
0,	//	GP17_OUT
1,	//	GP17_EN
1,	//	GP18_IN
0,	//	GP18_OUT
0,	//	GP18_EN
0,	//	GP19_IN
0,	//	GP19_OUT
0,	//	GP19_EN
1,	//	GP20_IN
0,	//	GP20_OUT
0,	//	GP20_EN
0,	//	GP21_IN
0,	//	GP21_OUT
0,	//	GP21_EN
1,	//	GP22_IN
0,	//	GP22_OUT
0,	//	GP22_EN
0,	//	GP23_IN
0,	//	GP23_OUT
0,	//	GP23_EN
1,	//	GP24_IN
0,	//	GP24_OUT
0,	//	GP24_EN
1,	//	GP25_IN
0,	//	GP25_OUT
0,	//	GP25_EN
1,	//	GP26_IN
0,	//	GP26_OUT
0,	//	GP26_EN
1,	//	GP27_IN
0,	//	GP27_OUT
0,	//	GP27_EN
0,	//	SMROM_EN_IN
0,	//	SDCKE0_OUT
0,	//	SDCLK0_OUT
0,	//	SDCLK1_OUT
1,	//	SDCLK1_EN
1,	//	SDCKE1_OUT
0,	//	SDCLK2_OUT
1,	//	D31_0_EN
0,	//	D31_IN
0,	//	D31_OUT
0,	//	D23_IN
0,	//	D23_OUT
0,	//	D15_IN
0,	//	D15_OUT
0,	//	D7_IN
0,	//	D7_OUT
0,	//	D30_IN
0,	//	D30_OUT
0,	//	D22_IN
0,	//	D22_OUT
0,	//	D14_IN
0,	//	D14_OUT
0,	//	D6_IN
0,	//	D6_OUT
0,	//	D29_IN
0,	//	D29_OUT
0,	//	D21_IN
0,	//	D21_OUT
0,	//	D13_IN
0,	//	D13_OUT
0,	//	D5_IN
0,	//	D5_OUT
0,	//	D28_IN
0,	//	D28_OUT
0,	//	D20_IN
0,	//	D20_OUT
0,	//	D12_IN
0,	//	D12_OUT
0,	//	D4_IN
0,	//	D4_OUT
0,	//	D27_OUT
0,	//	D27_IN
0,	//	D19_IN
0,	//	D19_OUT
0,	//	D11_IN
0,	//	D11_OUT
0,	//	D3_IN
0,	//	D3_OUT
0,	//	D26_IN
0,	//	D26_OUT
0,	//	D18_IN
0,	//	D18_OUT
0,	//	D10_IN
0,	//	D10_OUT
0,	//	D2_IN
0,	//	D2_OUT
0,	//	D25_IN
0,	//	D25_OUT
0,	//	D17_IN
0,	//	D17_OUT
0,	//	D9_IN
0,	//	D9_OUT
0,	//	D1_IN
0,	//	D1_OUT
0,	//	D24_IN
0,	//	D24_OUT
0,	//	D16_IN
1,	//	D16_OUT
0,	//	D8_IN
0,	//	D8_OUT
0,	//	D0_IN
1,	//	D0_OUT
1,	//	TXD_C_IN
0,	//	TXD_C_OUT
0,	//	TXD_C_EN
1,	//	RXD_C_IN
0,	//	RXD_C_OUT
0,	//	RXD_C_EN
1,	//	SCLK_C_IN
0,	//	SCLK_C_OUT
0,	//	SCLK_C_EN
1,	//	SFRM_C_IN
0,	//	SFRM_C_OUT
0,	//	SFRM_C_EN
1,	//	PWR_EN_OUT
0,	//	VDD_FAULT_IN
0};		//	BATT_FAULT_IN

int dat_order[] = {	 
					 D0_OUT, D1_OUT, D2_OUT, D3_OUT, D4_OUT, D5_OUT, D6_OUT, D7_OUT,
					 D8_OUT, D9_OUT,D10_OUT,D11_OUT,D12_OUT,D13_OUT,D14_OUT,D15_OUT,
					D16_OUT,D17_OUT,D18_OUT,D19_OUT,D20_OUT,D21_OUT,D22_OUT,D23_OUT,
					D24_OUT,D25_OUT,D26_OUT,D27_OUT,D28_OUT,D29_OUT,D30_OUT,D31_OUT};
                    
int input_dat_order[] = {	 
					 D0_IN, D1_IN, D2_IN, D3_IN, D4_IN, D5_IN, D6_IN, D7_IN,
					 D8_IN, D9_IN,D10_IN,D11_IN,D12_IN,D13_IN,D14_IN,D15_IN,
					D16_IN,D17_IN,D18_IN,D19_IN,D20_IN,D21_IN,D22_IN,D23_IN,
					D24_IN,D25_IN,D26_IN,D27_IN,D28_IN,D29_IN,D30_IN,D31_IN};
                    

int addr_order[] =  { A0_OUT,  A1_OUT,  A2_OUT,   A3_OUT,   A4_OUT, 
                      A5_OUT,  A6_OUT,  A7_OUT,   A8_OUT,   A9_OUT, 
                      A10_OUT, A11_OUT, A12_OUT,  A13_OUT,  A14_OUT,
                      A15_OUT, A16_OUT, A17_OUT,  A18_OUT,  A19_OUT,
                      A20_OUT, A21_OUT, A22_OUT,  A23_OUT,  A24_OUT,
                      A25_OUT
                    };



#endif // ASSABET_PLATFORM
