#!/bin/sh
#set -x

bindir=`echo $0 | sed 's![^/]*$!!'`
old=`pwd`
cd $bindir
bindir=`pwd`
cd $old || fatal "Could not return to orignal dir >$old<"

PATH="$bindir:$PATH"

. $bindir/reflash-utils.sh

progname=`basename $0`
exe=`getexe`
just_show='-P-'
wrdiropt=
. $bindir/wrdir-def.h
f_opt=
y_opt=
R_opt=

usage_msg=`cat <<EOF
No parameters are needed.
This program will tell you which file is needed next,
and will then call zmodem to transfer the file.
You must send the file specified or the system will
exit with an error.

Options:

-n        Do not actually change flash, just show what would be done.
-y        Answer to all prompts is y.
-wrdir d  Set the writable directory.  This dir is needed to hold some temp 
          files.  
-R        Do not reboot after successful reflashing.
EOF
`
while [ -n "$*" ]
do
    case "$1" in
	-n)
	    just_show='-x'
	    ;;

	-doit)
	    just_show='-P-'
	    ;;
	-wrdir)
	    wrdir=$2
	    wrdiropt="-wrdir $2"
	    f_opt="-F $2"
	    shift
	    ;;
	-y)
	    y_opt='-y'
	    ;;
	-h|-help|--help)
	    usage
	    ;;
	-R)
	    R_opt='-R'
	    ;;
	*)
	    emsg "Unsupported option >$1<"
	    usage
	    ;;
    esac
    shift
done

if [ $# != 0 ]
then
    usage
    exit 2
fi

PATH="$wrdir:$PATH"

arch=`uname -m`
case "$arch" in
    arm*)
	prep -rz $wrdiropt
	;;
esac

exec $exe $y_opt $f_opt $R_opt -c $bindir/rewince-z.ref -c $bindir/rewince.ref $just_show
