README.sh

In general, you should not use reflash directly.  We've written three
shell scripts to simplify the most common procedures:

1) Reinstalling wince from files on a network.
2) Reinstalling wince from files via ZMODEM.
3) Upgrading the various components of a Linux system.  The components
include: bootldr, parameters/partition table, kernel, file system.

The scripts are:

1) rewince.sh
2) rewince-z.sh (or rewince.sh -z)
3) reflash-upgrade.sh


All of the scripts call reflash-prep.sh which prepares the system to
be reflashed.  Extraneous processes are killed, mtd file systems are
remounted READ ONLY, and if zmodem is being used, the zmodem temp
files are created in the writable ramdisk file system.

Each of the three main scripts will print a usage message when the see
-h, -help or --help.

rewince.sh
	This script is used to reinstall wince onto your iPAQ.  It
	assumes that the files are directly readable, e.g. on an NFS
	or local file system.
	It uses the image files created by OSLoader's 
	OSLoader's Tools->Flash->Save command.  The files are named:
	flash_00000000.bin 
	flash_00400000.bin
	flash_00800000.bin
	flash_00c00000.bin
	If they do not exist in the current directory, you may specify
	their location with the -d option.

rewince-z.sh (or rewince.sh -z)
	This script is used to reinstall wince onto your iPAQ.  It is
	used when the files are not directly readable.  It uses zmodem
	to read the files over a serial link.
	A script will tell you which file you need to send next, and a
	prompt will be presented to you between files so that zmodem
	won't timeout if you are doing something else when a given
	download finishes.  Each file take ~5 minutes to download.
	You must download the exact files that the script asks for or
	it will not continue to the next file.

reflash-upgrade.sh
	This script is used to upgrade one or more parts of an
	existing linux system.
	Please see also the help from this file.
	There are four components that can be upgraded with this
	script:
	1) The bootldr (b)
	2) The parameters and partition table (p)
	3) The kernel (k)
	4) The file system (j)

	The file to use is specified using the -x <file> option where x
	is the letter list above after the description.
	e.g. -k zImage tells the script to upgrade the kernel with the
	file zImage.
	If you need to load the files over a serial line, then give
	``@rz'' as <file>.  This will tell the program to use
	zmodem to get the file.  You will need to send the file using
	your terminal package's zmodem command.  If you want to make
	sure you send the correct file, you can specify the filename
	after the @rz like so: -k @rz/zImage.  If you send any other
	file, zmodem will generate and error and you will be prompted
	to try again.

	In addition to the file names for each component, you may
	specify the offset and length of each component.  In general,
	this should not be necessary.  The length tells the system how
	much flash to erase starting at the component's offset.  The
	length to program is determined by the length of the file.
	You specify the region's offset with the -xo <offset> option,
	where x is the region's identifying character. Length is
	specified -xl <len> where x is the region's id char.

	Example:
	# reflash-upgrade.sh -k zImage -j @rz/base.jffs2 -jo 0x540000
	This example upgrades the kernel with a file named zImage in
	the current directory.  It also upgrades the file system with
	a file named base.jffs2 that is downloaded with zmodem.  In
	addition, this fils system is put into flash at the
	non-standard offset of 0x540000.


All of the scripts will show you a list of the actions it is about to
perform and wait for you to confirm that you wish to proceed.  Please
refer to the reflash documentation for information on what the various
commands do.

Reflash will reboot your iPAQ after it has successfully written to
flash.  If there is an error in the data phase, reflash will exit with
an error message.  If there is an error in the writing phase, then
reflash will enter a command loop to give you the opportunity to try
to recover.  Please refer to the README.reflash file for information
on what reflash can do.  It may also be a good idea to send mail to
ipaq@handhelds.org.  Please include as much of the debugging output as
you can.

Please refer the to scripts' builtin help (-h) for additional details.

NB: Programming large amounts of data to flash can take a long time.
Please do not interrupt the process.
