
# meant to be sourced

#
# print a messsage to stdout
#
emsg()
{
    echo 1>&2 "$progname: $*"
}

DEBUG()
{
    echo 1>&2 "DEBUG: $*"
}

#
# print a message to stdout and exit
#
fatal()
{
    emsg "$*"
    exit 1
}

#
# print the usage string and exit
#
usage()
{
    echo 1>&2 "usage: $usage_msg"
    exit 2
}

#
# get the dir part of a path name
#
dirname()
{
    name=$1
    name=`echo $name | sed 's![^/]*$!!'`
    case $name in
    /)
	;;
    */)
	name=`echo $name | sed 's!/*$!!'`
	;;
    esac

    old=`pwd`
    cd $name
    name=`pwd`
    cd $old || fatal "Could not return to orignal dir >$old<"

    [ -z "$name" ] && name='.'

    echo $name
}

#
# get the file part of a path name
#
basename()
{
    name=$1
    name=`echo $name | sed 's!.*/!!'`
    echo $name
}


#
# verify that the passed in names are of files
#
verify_image_files()
{
    bad=
    if [ $# = 4 ]
    then
	size=4194304
    else
	size=16777216
    fi
    files=$*
    for f in $files
    do
	[ -f $f ] || {
	    bad=y
	    emsg "$f is not a regular file"
	    continue
	}
	#
	# get proper len in case we are a symlink
	#
	set -- `ls -lL $f`
	[ $5 -eq $size ] || {
	    [ -z "$bad_size_ok" ] && bad=y
	    emsg "$f is the wrong size ($5 vs $size)"
	    continue
	}
	    
    done

    [ "$bad" = "y" ] && {
	emsg "One or more files cannot be used.  Exiting."
	exit 1
    }
}

#
# run the prep script, exiting on any errors.
#
prep()
{
    $bindir/reflash-prep.sh "$@" || {
	emsg "Reflash-prep failed.  Please fix the problems it detected."
	exit 1
    }
}

getexe()
{
    arch=`uname -m`
    case $arch in
	arm*)
	    exe=reflash
	    ;;
	*86)
	    exe=reflash-test
	    ;;
	*)
	    fatal "Unknown architecture >$arch<"
	    ;;
    esac
    echo $bindir/$exe
}

get_my_tty()
{
    mypid=$1
    raw_list=`ps augxwwh | grep " $mypid "`

    IFS='
'
    for psline in $raw_list
    do
	IFS="$origIFS"
	set -- $psline
	pid=$2
	tty=$7
	[ $pid = $mypid ] && {
	    echo $tty
	    return 0
	}
	    
    done

    DEBUG
    return 0
}

todecimal()
{
    num=$1

    prog=`getexe`
    echo `$prog -k $num`
}

declwrdir()
{
  wrdir=$*
}

C_and_sh_def()
{
    # $1   $2  $3 $4
    # type var =  val
    eval $2=\$4
}

find_binary()
{
    bin_name=$1
    bin_path=$2
    ret=

    oldIFS=$IFS
    path="$PATH:$bin_path"
    IFS=":"
    for dir in $path
    do
	case "$dir" in
	    *:)
		dir=$(echo $dir | sed 's/:$//')
		;;
	    "")
	        dir="."
		;;
	    *)
		;;
	esac
	
	[ -z "$dir" ] && dir="."
	file=$dir/$bin_name

	if [ -x $file ]
	then
	    ret=$file
	    break
	fi
    done

    IFS=$oldIFS
    [ -n "$ret" ] && {
	echo $ret
	return
    }

    fatal "Cannot find \`$bin_name' in your path ($PATH) 
or in my path ($bin_path).
Please add the directory where \`$bin_name' resides to your path and rerun $progname"
}

get_partition_value()
{
    exe=$1
    shift
    opts=$1
    shift
    cmd=''
    for i in $*
    do
	cmd="$cmd -L $i"
	#echo 1>&2 "cmd>$cmd<"
    done

    echo 1>&2 $exe $cmd -x
    echo `$exe $cmd -x`
}
