#include <asm/arch-sa1100/h3600.h>

#ifdef CONFIG_ARCH_H3900
#include <asm/arch-sa1100/h3600_asic.h>
#include <asm/arch/h3900-gpio.h>
#endif

#ifndef __ASSEMBLER__

enum led_color {
	BLUE_LED,
	GREEN_LED,
	YELLOW_LED
};

extern void ipaq_set_led (enum led_color color, int tbs, int pts, int dts);
extern void ipaq_backlight_power (int on);

#define ipaq_led_on(color)  \
        ipaq_set_led(color, LEDTBS_BLINK | LEDTBS_AUTOSTOP | LEDTBS_ALWAYS, 4, 4 )

#define ipaq_led_off(color)  \
        ipaq_set_led(color, 0, 0, 0)

#define ipaq_led_blink(color,rate,pts,dts)  \
        ipaq_set_led(color, LEDTBS_BLINK | LEDTBS_AUTOSTOP | LEDTBS_ALWAYS | rate, pts, dts )

#endif
