/*
 *
 * Definitions for HP iPAQ3 Handheld Computer
 *
 * Copyright 2002 Hewlett-Packard Company.
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * Author: Jamey Hicks
 *
 */

#ifndef _INCLUDE_IPAQ3_ASIC_H_ 
#define _INCLUDE_IPAQ3_ASIC_H_

#include <asm/arch-sa1100/h3600.h>

/* Define mappings to switch between physical and virtual space */

#define asic_p2v(x) ((((u32)(x))&(0x00ffffff)) | IPAQ3_ASIC_VIRT)
#define asic_v2p(x) ((((u32)(x))&(0x00ffffff)) | IPAQ3_ASIC_PHYS)

#define IPAQ3_ASIC_OFFSET(s,x,y)   \
     (*((volatile s *) (_IPAQ3_ASIC_Base + _IPAQ3_ASIC_ ## x ## _Base + (_IPAQ3_ASIC_ ## x ## _ ## y))))

#define _IPAQ3_ASIC_INTMEM_Base               0x00000
#define _IPAQ3_ASIC_USBHOST_Base              0x20000
#define _IPAQ3_ASIC_IC_Base                   0x30000
#define _IPAQ3_ASIC_DMAC_Base                 0x40000

/********* Clock and Power Management **********/

#define _IPAQ3_ASIC_CPM_Base                  0x50000
#define _IPAQ3_ASIC_CPM_LockTime              0x00000 /* defaults to 0x0fff */
#define _IPAQ3_ASIC_CPM_PllControl            0x00004 /* defaults to 0x00028080 */
#define _IPAQ3_ASIC_CPM_ClockControl          0x00008 /* defaults to 0x0ffe */
#define _IPAQ3_ASIC_CPM_ClockSleep            0x0000c

#define IPAQ3_ASIC_CPM_LockTime		IPAQ3_ASIC_OFFSET( u16, CPM, LockTime )
#define IPAQ3_ASIC_CPM_PllControl	IPAQ3_ASIC_OFFSET( u32, CPM, PllControl )
#define IPAQ3_ASIC_CPM_ClockControl	IPAQ3_ASIC_OFFSET( u16, CPM, ClockControl )
#define IPAQ3_ASIC_CPM_ClockSleep	IPAQ3_ASIC_OFFSET( u16, CPM, ClockSleep )

/* upll lock time count value for uclk, ltime > 150us */
#define IPAQ3_ASIC_CPM_LOCKTIME_MASK    ((1 << 11) -1) 
#define IPAQ3_ASIC_CPM_PLLCON_MDIV_SHIFT 12 /* main divider control */
#define IPAQ3_ASIC_CPM_PLLCON_MDIV_WIDTH 8
#define IPAQ3_ASIC_CPM_PLLCON_PDIV_SHIFT 4 /* pre-divider control */
#define IPAQ3_ASIC_CPM_PLLCON_PDIV_WIDTH 6
#define IPAQ3_ASIC_CPM_PLLCON_SDIV_SHIFT 0 /* post divider control */
#define IPAQ3_ASIC_CPM_PLLCON_SDIV_WIDTH 2

#define IPAQ3_ASIC_CPM_CLKCON_1WIRE_CLKEN	(1 << 11)
#define IPAQ3_ASIC_CPM_CLKCON_MISC_CLKEN	(1 << 10)
#define IPAQ3_ASIC_CPM_CLKCON_LED_CLKEN		(1 << 9)
#define IPAQ3_ASIC_CPM_CLKCON_UART1_CLKEN	(1 << 8)
#define IPAQ3_ASIC_CPM_CLKCON_UART2_CLKEN	(1 << 7)
#define IPAQ3_ASIC_CPM_CLKCON_ADC_CLKEN		(1 << 6)
#define IPAQ3_ASIC_CPM_CLKCON_SD_CLKEN		(1 << 5)
#define IPAQ3_ASIC_CPM_CLKCON_FCD_CLKEN		(1 << 4)
#define IPAQ3_ASIC_CPM_CLKCON_GPIO_CLKEN	(1 << 3)
#define IPAQ3_ASIC_CPM_CLKCON_DMAC_CLKEN	(1 << 2)
#define IPAQ3_ASIC_CPM_CLKCON_USBHOST_CLKEN	(1 << 1)
#define IPAQ3_ASIC_CPM_CLKCON_UCLK_EN		(1 << 0)

#define _IPAQ3_ASIC_CPM_CLKSLEEP_UCLK_ON	(1 << 2)
#define _IPAQ3_ASIC_CPM_CLKSLEEP_HALF_CLK	(1 << 1)
#define _IPAQ3_ASIC_CPM_CLKSLEEP_SLEEP		(1 << 0)

/********* ADC **********/
#define _IPAQ3_ASIC_ADC_Base                  0x80000
#define _IPAQ3_ASIC_ADC_Control               0x00000 /* resets to 0x3fc4 */
#define _IPAQ3_ASIC_ADC_TouchScreenControl    0x00004 /* resets to 0x58 */
#define _IPAQ3_ASIC_ADC_Delay                 0x00008 /* initializes to 0xff */
#define _IPAQ3_ASIC_ADC_Data0                 0x0000c /* xp conversion data register */
#define _IPAQ3_ASIC_ADC_Data1                 0x0000c /* yp conversion data register */

#define IPAQ3_ASIC_ADC_Control			IPAQ3_ASIC_OFFSET(  u8, ADC, Control )
#define IPAQ3_ASIC_ADC_TouchScreenControl	IPAQ3_ASIC_OFFSET(  u8, ADC, TouchScreenControl )
#define IPAQ3_ASIC_ADC_Delay			IPAQ3_ASIC_OFFSET( u16, ADC, Delay )
#define IPAQ3_ASIC_ADC_Data0			IPAQ3_ASIC_OFFSET( u16, ADC, Data0 )
#define IPAQ3_ASIC_ADC_Data1			IPAQ3_ASIC_OFFSET( u16, ADC, Data1 )

#define IPAQ3_ASIC_ADC_CONTROL_FORCE_START	(1 << 0) /* enables conversion start, bit cleared on start */
#define IPAQ3_ASIC_ADC_CONTROL_READ_START	(1 << 1) /* enable start by read operation */
#define IPAQ3_ASIC_ADC_CONTROL_STANDBY		(1 << 2)

#define IPAQ3_ASIC_ADC_CONTROL_SEL_AIN0		(0 << 3)
#define IPAQ3_ASIC_ADC_CONTROL_SEL_AIN1		(1 << 3)
#define IPAQ3_ASIC_ADC_CONTROL_SEL_AIN2		(2 << 3)
#define IPAQ3_ASIC_ADC_CONTROL_SEL_AIN3		(3 << 3)
#define IPAQ3_ASIC_ADC_CONTROL_SEL_YM		(4 << 3)
#define IPAQ3_ASIC_ADC_CONTROL_SEL_YP		(5 << 3)
#define IPAQ3_ASIC_ADC_CONTROL_SEL_XM		(6 << 3)
#define IPAQ3_ASIC_ADC_CONTROL_SEL_XP		(7 << 3)

#define IPAQ3_ASIC_ADC_CONTROL_PRESCALER_SHIFT	6  
#define IPAQ3_ASIC_ADC_CONTROL_PRESCALER_WIDTH  8	  
#define IPAQ3_ASIC_ADC_CONTROL_PRESCALER_ENABLE	(1 << 14)
#define IPAQ3_ASIC_ADC_CONTROL_CONVERSION_END	(1 << 15) /* read only */ 

/* touch screen measurement mode */
#define IPAQ3_ASIC_ADC_TSC_XYPST_NONE		(0 << 0)
#define IPAQ3_ASIC_ADC_TSC_XYPST_XPOS		(1 << 0)
#define IPAQ3_ASIC_ADC_TSC_XYPST_YPOS		(2 << 0)
#define IPAQ3_ASIC_ADC_TSC_XYPST_INTERRUPT	(3 << 0)
#define IPAQ3_ASIC_ADC_TSC_AUTO_MODE		(1 << 2) /* enable auto mode */
#define IPAQ3_ASIC_ADC_TSC_PULL_UP		(1 << 3) /* xp pullup disable */
#define IPAQ3_ASIC_ADC_TSC_XP_SEN		(1 << 4) /* xp output driver disable */
#define IPAQ3_ASIC_ADC_TSC_XM_SEN		(1 << 5) /* xm output driver disable */
#define IPAQ3_ASIC_ADC_TSC_YP_SEN		(1 << 6) /* yp output driver disable */
#define IPAQ3_ASIC_ADC_TSC_YM_SEN		(1 << 7) /* ym output driver disable */

#define IPAQ3_ASIC_ADC_DATA0_XPDATA		((1 << 10) - 1)
#define IPAQ3_ASIC_ADC_DATA0_XYPST_NONE		(0 << 12)
#define IPAQ3_ASIC_ADC_DATA0_XYPST_XPOS		(1 << 12)
#define IPAQ3_ASIC_ADC_DATA0_XYPST_YPOS		(2 << 12)
#define IPAQ3_ASIC_ADC_DATA0_XYPST_INTERRUPT	(3 << 12)
#define IPAQ3_ASIC_ADC_DATA0_AUTO_MODE		(1 << 14)
#define IPAQ3_ASIC_ADC_DATA0_PEN_UP		(1 << 15) /* stylus up */ 


/********* UART **********/
#define _IPAQ3_ASIC_UART_Base                 0x90000
/********* MISC **********/
#define _IPAQ3_ASIC_MISC_Base                 0xa0000
/********* Secure Digital Interface **********/
#define _IPAQ3_ASIC_SDI_Base                  0xb0000



/********* GPIO **********/
#define _IPAQ3_ASIC_GPIO_Base                 0xc0000

#define _IPAQ3_ASIC_GPIO_GPA_CON1	      0x00000 /* configures 1 the pins of port A, defaults to 0xaaaaaaaa */
#define _IPAQ3_ASIC_GPIO_GPA_CON2	      0x00004 /* configures 2 the pins of port A, defaults to 0xaaaaaaaa */
#define _IPAQ3_ASIC_GPIO_GPA_DAT	      0x00008 /* the data register for port A,    defaults to 0x00000000 */
#define _IPAQ3_ASIC_GPIO_GPA_PUP	      0x0000c /* pullup disable register for port A, defaults to 0x00080000 */

#define IPAQ3_ASIC_GPIO_GPA_CON1		IPAQ3_ASIC_OFFSET( u32, GPIO, GPA_CON1 )
#define IPAQ3_ASIC_GPIO_GPA_CON2		IPAQ3_ASIC_OFFSET( u32, GPIO, GPA_CON2 )
#define IPAQ3_ASIC_GPIO_GPA_DAT			IPAQ3_ASIC_OFFSET( u32, GPIO, GPA_DAT )
#define IPAQ3_ASIC_GPIO_GPA_PUP			IPAQ3_ASIC_OFFSET( u32, GPIO, GPA_PUP )

#define _IPAQ3_ASIC_GPIO_GPB_CON1	      0x00000 /* configures the pins of port B, defaults to 0x02a900ff */
#define _IPAQ3_ASIC_GPIO_GPB_DAT	      0x00008 /* the data register for port B,    defaults to 0x00000000 */
#define _IPAQ3_ASIC_GPIO_GPB_PUP	      0x0000c /* pullup disable register for port B, defaults to 0x0001e0ff */

#define IPAQ3_ASIC_GPIO_GPB_CON1		IPAQ3_ASIC_OFFSET( u32, GPIO, GPB_CON )
#define IPAQ3_ASIC_GPIO_GPB_DAT			IPAQ3_ASIC_OFFSET( u32, GPIO, GPB_DAT )
#define IPAQ3_ASIC_GPIO_GPB_PUP			IPAQ3_ASIC_OFFSET( u32, GPIO, GPB_PUP )

#define _IPAQ3_ASIC_GPIO_GPC_CON1	      0x00000 /* configures the pins of port C, defaults to 0x00000065 */
#define _IPAQ3_ASIC_GPIO_GPC_DAT	      0x00008 /* the data register for port C,    defaults to 0x00000002 */
#define _IPAQ3_ASIC_GPIO_GPC_PUP	      0x0000c /* pullup disable register for port C, defaults to 0x00000003 */

#define IPAQ3_ASIC_GPIO_GPC_CON1		IPAQ3_ASIC_OFFSET( u32, GPIO, GPC_CON )
#define IPAQ3_ASIC_GPIO_GPC_DAT			IPAQ3_ASIC_OFFSET( u32, GPIO, GPC_DAT )
#define IPAQ3_ASIC_GPIO_GPC_PUP			IPAQ3_ASIC_OFFSET( u32, GPIO, GPC_PUP )

#define _IPAQ3_ASIC_GPIO_GPC_CON1	      0x00000 /* configures the pins of port C, defaults to 0x02a900ff */
#define _IPAQ3_ASIC_GPIO_GPC_DAT	      0x00008 /* the data register for port C,    defaults to 0x00000000 */
#define _IPAQ3_ASIC_GPIO_GPC_PUP	      0x0000c /* pullup disable register for port C, defaults to 0x0001e0ff */

#define IPAQ3_ASIC_GPIO_GPC_CON1		IPAQ3_ASIC_OFFSET( u32, GPIO, GPC_CON )
#define IPAQ3_ASIC_GPIO_GPC_DAT			IPAQ3_ASIC_OFFSET( u32, GPIO, GPC_DAT )
#define IPAQ3_ASIC_GPIO_GPC_PUP			IPAQ3_ASIC_OFFSET( u32, GPIO, GPC_PUP )


/********* PCMCIA and Expansion Pack Interface **********/
#define _IPAQ3_ASIC_PCMCIA_Base               0xd0000
#define _IPAQ3_ASIC_PCMCIA_TDW                0x00000 /* data width, defaults to 0x01 */
#define _IPAQ3_ASIC_PCMCIA_EPS                0x00004 /* status, defaults to 0x00 */
#define _IPAQ3_ASIC_PCMCIA_CC                 0x00008 /* control, defaults to 0 */
#define _IPAQ3_ASIC_PCMCIA_IC                 0x0000c /* interrupt enable, defaults to 0 */
#define _IPAQ3_ASIC_PCMCIA_IM                 0x00010 /* interrupt edge config, defaults to 0x25a5 */
#define _IPAQ3_ASIC_PCMCIA_IP                 0x00014 /* interrupt pending */
#define _IPAQ3_ASIC_PCMCIA_MISC               0x00018 /* usb mask, defaults to 1 */ 

#define IPAQ3_ASIC_PCMCIA_TDW		IPAQ3_ASIC_OFFSET(  u8, PCMCIA, TDW )
#define IPAQ3_ASIC_PCMCIA_EPS		IPAQ3_ASIC_OFFSET(  u8, PCMCIA, EPS )
#define IPAQ3_ASIC_PCMCIA_CC		IPAQ3_ASIC_OFFSET(  u8, PCMCIA, CC )
#define IPAQ3_ASIC_PCMCIA_IC		IPAQ3_ASIC_OFFSET(  u8, PCMCIA, IC )
#define IPAQ3_ASIC_PCMCIA_IM		IPAQ3_ASIC_OFFSET( u16, PCMCIA, IM )
#define IPAQ3_ASIC_PCMCIA_IP		IPAQ3_ASIC_OFFSET(  u8, PCMCIA, IP )

#define IPAQ3_ASIC_PCMCIA_TDW_CS23_16BIT	(1 << 0)
#define IPAQ3_ASIC_PCMCIA_TDW_CS4_16BIT		(1 << 1)
#define IPAQ3_ASIC_PCMCIA_TDW_BIG_ENDIAN	(1 << 2)

#define IPAQ3_ASIC_PCMCIA_EPS_CD0_N             (1 << 0)
#define IPAQ3_ASIC_PCMCIA_EPS_CD1_N             (1 << 1)
#define IPAQ3_ASIC_PCMCIA_EPS_IRQ0_N            (1 << 2)
#define IPAQ3_ASIC_PCMCIA_EPS_IRQ1_N            (1 << 3)
#define IPAQ3_ASIC_PCMCIA_EPS_ODET0_N          	(1 << 4)
#define IPAQ3_ASIC_PCMCIA_EPS_ODET1_N          	(1 << 5)
#define IPAQ3_ASIC_PCMCIA_EPS_BATT_FLT		(1 << 6) 

#define IPAQ3_ASIC_PCMCIA_CC_RESET		(1 << 0)

#define IPAQ3_ASIC_PCMCIA_CD0			(1 << 0) /* cd0 interrupt */
#define IPAQ3_ASIC_PCMCIA_CD1			(1 << 1) /* cd1 interrupt */
#define IPAQ3_ASIC_PCMCIA_IRQ0			(1 << 2) /* irq0 interrupt */
#define IPAQ3_ASIC_PCMCIA_IRQ1			(1 << 3) /* irq1 interrupt */
#define IPAQ3_ASIC_PCMCIA_ODET0			(1 << 4) /* odet0 interrupt */
#define IPAQ3_ASIC_PCMCIA_ODET1			(1 << 5) /* odet1 interrupt */
#define IPAQ3_ASIC_PCMCIA_BATT_FLT		(1 << 6) /* batt_flt interrupt */

/* shift left by twice the interrupt number */
#define IPAQ3_ASIC_PCMCIA_IM_NONE    0
#define IPAQ3_ASIC_PCMCIA_IM_FALLING 1
#define IPAQ3_ASIC_PCMCIA_IM_RISING  2
#define IPAQ3_ASIC_PCMCIA_IM_BOTH    3

#define IPAQ3_ASIC_PCMCIA_MISC_USB_MASK   0 /* enables ust host master address masking when 1 */



#endif /* _INCLUDE_IPAQ3_ASIC_H_ */
