
/*
 * linux/arch/arm/mach-sa1100/jornada56x.c
 * Interrupt demux modeled on:
 *     linux/arch/arm/mach-sa1100/sa1111.c
 *         Original code by John Dorsey
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <asm/arch/irqs.h>
#include <asm/setup.h>
#include <asm/hardware.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/serial_sa1100.h>
#include <linux/sched.h>
#include "generic.h"
#include <linux/wait.h>          /* for wait_queue_head_t, used in h3600_ts.h */
#include <linux/types.h>         /* for u_char, used in h3600_ts.h */
#include <linux/h3600_ts.h>      /* for TS_RET */
#include <asm/arch/irq.h>
#include <asm/mach/irq.h>

enum {PCR_GET_VALUE=1, PCR_SET_VALUE, PCR_BIT_SET, PCR_BIT_CLEAR};
#if 0
spinlock_t jornada56x_controller_lock = SPIN_LOCK_UNLOCKED;
#endif

void SetPMUPCRRegister(long arg_action, long arg_value)
{
	long this_pcr;
	
	//Read PCR and remove the unwanted bit 6
	this_pcr = (((JORNADA_PCR & 0xff80) >>1) | (JORNADA_PCR & 0x3f));

	this_pcr &= ~(JORNADA_MUX_CLK0 | JORNADA_MUX_CLK1); 
	if (this_pcr & JORNADA_SM_CLK_EN)
		this_pcr |= JORNADA_MUX_CLK1;
	else if (this_pcr & JORNADA_MMC_CLK_EN)
		this_pcr |= JORNADA_MUX_CLK0; 
	switch (arg_action) {
		case PCR_SET_VALUE:
			this_pcr = arg_value;
			break;
		case PCR_BIT_SET: /* enable controller */
			if(arg_value & JORNADA_SM_CLK_EN) {		/* smart card controller */
				this_pcr &= ~(JORNADA_MUX_CLK0 | JORNADA_MUX_CLK1);
				this_pcr |= JORNADA_MUX_CLK1;
			}
			else if(arg_value & JORNADA_MMC_CLK_EN) {	/* mmc controller */
				this_pcr &= ~(JORNADA_MUX_CLK0 | JORNADA_MUX_CLK1); 
				this_pcr |= JORNADA_MUX_CLK0;
			}			
			this_pcr |= arg_value;
			break;
		case PCR_BIT_CLEAR:		/* disable controller */
			/* smart card or mmc controller */
			if (arg_value & (JORNADA_SM_CLK_EN | JORNADA_MMC_CLK_EN))
				this_pcr &= ~(JORNADA_MUX_CLK0 | JORNADA_MUX_CLK1);
			this_pcr &= ~arg_value;
			break;
		case PCR_GET_VALUE:
		default:
			break;
	}
	JORNADA_PCR = this_pcr;	
}

void jornada_microwire_init(void)
{
static int initialized = 0;

	if (initialized)
		return;
	initialized = 1;
	JORNADA_GPIOAFR |= JORNADA_GP_MW;
	udelay(100);
	JORNADA_MWFTR = (8 << JORNADA_MWFTR_V_TFT)
		| (8 << JORNADA_MWFTR_V_RFT); /* 0x108 */
	udelay(100);
  	SetPMUPCRRegister(PCR_BIT_SET, JORNADA_MW_CLK_EN);
	udelay(100);
	JORNADA_MWCR = JORNADA_MW_EN | JORNADA_DSS_16_BIT
		| (10 << JORNADA_MWCR_V_SCR) /* 0xa07 */
		| JORNADA_FIFO_RST; /* reset FIFO */
	udelay(100);
	JORNADA_MWCR &= ~JORNADA_FIFO_RST;
	/* set FIFO interrupt levels to 8 for each of Rx, Tx */
	udelay(100);
	JORNADA_MWFTR = (8 << JORNADA_MWFTR_V_TFT)
		| (8 << JORNADA_MWFTR_V_RFT); /* 0x108 */
}

void jornada_contrast(int arg_contrast)
{
}

int jornada_brightness(int arg_brightness)
{
	int i = 0;

        if (arg_brightness) {
        } else {
        }
	return i;
}

int temp_rer, temp_fer;
void jornada_microwire_start(void)
{
int i;
int retry = 90000;

	temp_rer = GRER & GPIO_JORNADA56X_TOUCH;
	temp_fer = GFER & GPIO_JORNADA56X_TOUCH;
	GRER &= ~GPIO_JORNADA56X_TOUCH;
	GFER &= ~GPIO_JORNADA56X_TOUCH;
	jornada_microwire_init();
	while(retry-- && (JORNADA_MWFSR & JORNADA_MW_RNE))
		i = JORNADA_MWDR;	 /* empty out existing data */
}

void jornada_microwire_wait(void)
{
int retry = 1000000;
	JORNADA_MWDR = JORNADA_MW_END;
while (retry-- && !(JORNADA_MWFSR & JORNADA_MW_RFS))
	;
}

#define MICROWIRE_SIZE	8	/* we always do 8 write/read pairs */
int microwire_data[MICROWIRE_SIZE];

void jornada_microwire_read(void)
{
int i;

	jornada_microwire_wait();
	for (i = 0; i < MICROWIRE_SIZE; i++)
		microwire_data[i] = (JORNADA_MWDR & 0xffff) >> 4;
	GRER |= temp_rer;
	GFER |= temp_fer;
}

void jornada56x_battery(void)
{
int i;
printk("%s() ", __FUNCTION__);
	jornada_microwire_start();
	JORNADA_MWDR = JORNADA_MW_MAIN_BATTERY;
	JORNADA_MWDR = JORNADA_MW_MAIN_BATTERY;
	JORNADA_MWDR = JORNADA_MW_MAIN_BATTERY;
	JORNADA_MWDR = JORNADA_MW_MAIN_BATTERY;
	JORNADA_MWDR = JORNADA_MW_BACKUP_BATTERY;
	JORNADA_MWDR = JORNADA_MW_BACKUP_BATTERY;
	JORNADA_MWDR = JORNADA_MW_BACKUP_BATTERY;
	jornada_microwire_read();
}

static void suspend_button_task_handler(void *data)
{
#if 0
PSDR = PPDR | PPC_TXD4; /* PPC sleep mode direction */
PGSR = GPLR; /* preserve GPIO levels */
	PGSR &= ~GPIO_GPIO8;	/* RS232 transceiver off */
	PCFR = PCFR_OPDE;
	PWER = GPIO_JORNADA720_KEYBOARD | GPIO_JORNADA720_MOUSE | PWER_RTC;
#endif
    pm_suggest_suspend();
}

static struct tq_struct  suspend_button_task =
	{ routine: suspend_button_task_handler };

int jornada56x_getkey(unsigned char *data, int size)
{
	int this_count = 0, i, j, this_suspend = 0;

	if (this_suspend) {
        	suspend_button_task.data = (void *) 0;
        	schedule_task(&suspend_button_task);
	}
	return this_count;
}
int jornada56x_gettouch(int *arg_x, int *arg_y)
{
int i;
	int this_return = 0;

	jornada_microwire_start();
	JORNADA_MWDR = JORNADA_MW_TOUCH_X;
	JORNADA_MWDR = JORNADA_MW_TOUCH_X;
	JORNADA_MWDR = JORNADA_MW_TOUCH_X;
	JORNADA_MWDR = JORNADA_MW_TOUCH_X;
	JORNADA_MWDR = JORNADA_MW_TOUCH_Y;
	JORNADA_MWDR = JORNADA_MW_TOUCH_Y;
	JORNADA_MWDR = JORNADA_MW_TOUCH_Y;
	jornada_microwire_read();
	*arg_x = microwire_data[0];
	*arg_y = microwire_data[4];
        this_return = ( (GPLR & GPIO_JORNADA56X_TOUCH) == 0);
//printk("(%d,%d)=%d\n", *arg_x, *arg_y, this_return);
	return this_return;
}

JORNADA_INTERRUPT myhandler;
int jornada_request_irq(JORNADA_INTERRUPT arg_handler)
{
	myhandler = arg_handler;
	return 0;
}
#if 1
#define JORNADA_IRQMASK_LO(x)	(1 << (x - IRQ_JORNADA_MMC))
static void jornada56x_mask_and_ack_lowirq(unsigned int irq)
{
	JORNADA_INT_STAT = JORNADA_IRQMASK_LO(irq);
}
static void jornada56x_mask_lowirq(unsigned int irq)
{
	JORNADA_INT_EN &= ~JORNADA_IRQMASK_LO(irq);
}
static void jornada56x_unmask_lowirq(unsigned int irq)
{
	JORNADA_INT_EN |= JORNADA_IRQMASK_LO(irq);
}

#define JORNADA_IRQMASK_HI(x)	(1 << (x - IRQ_JORNADA_UART))
static void jornada56x_mask_and_ack_highirq(unsigned int irq)
{
	JORNADA_INT_STAT2 = JORNADA_IRQMASK_HI(irq);
}
static void jornada56x_mask_highirq(unsigned int irq)
{
	JORNADA_INT_EN2 &= ~JORNADA_IRQMASK_HI(irq);
}
static void jornada56x_unmask_highirq(unsigned int irq)
{
	JORNADA_INT_EN2 |= JORNADA_IRQMASK_HI(irq);
}

#define JORNADA_IRQMASK_GPIOB(x)	(1 << (x - IRQ_JORNADA_GPIO_B0))
static void jornada56x_mask_and_ack_gpiobirq(unsigned int irq)
{
	JORNADA_GPIOB_STAT = JORNADA_IRQMASK_GPIOB(irq);
}
static void jornada56x_mask_gpiobirq(unsigned int irq)
{
	JORNADA_GPIOB_FE_EN &= ~JORNADA_IRQMASK_GPIOB(irq);
}
static void jornada56x_unmask_gpiobirq(unsigned int irq)
{
	JORNADA_GPIOB_FE_EN |= JORNADA_IRQMASK_GPIOB(irq);
}

#define JORNADA_IRQMASK_GPIOC(x)	(1 << (x - IRQ_JORNADA_GPIO_C0))
static void jornada56x_mask_and_ack_gpiocirq(unsigned int irq)
{
	JORNADA_GPIOC_STAT = JORNADA_IRQMASK_GPIOC(irq);
}
static void jornada56x_mask_gpiocirq(unsigned int irq)
{
	JORNADA_GPIOC_FE_EN &= ~JORNADA_IRQMASK_GPIOC(irq);
}
static void jornada56x_unmask_gpiocirq(unsigned int irq)
{
	JORNADA_GPIOC_FE_EN |= JORNADA_IRQMASK_GPIOC(irq);
}

void jornada56x_IRQ_demux(int irq, void *dev_id, struct pt_regs *regs)
{
	unsigned long stat0, stat1, statb, statc;

	while (1) {
		int i;

		stat0 = JORNADA_INT_EN & 0xffff;
		stat1 = JORNADA_INT_EN2 & 0xffff;
		statb = JORNADA_GPIOB_STAT & 0xffff;
		statc = JORNADA_GPIOC_STAT & 0xffff;

		if (stat0 == 0 && stat1 == 0)
			break;

		stat0 &= ~(JORNADA_GPIO_B_INT | JORNADA_GPIO_C_INT);
		for (i = IRQ_JORNADA_MMC; stat0; i++, stat0 >>= 1)
			if (stat0 & 1)
				do_IRQ(i, regs);

		for (i = IRQ_JORNADA_UART; stat1; i++, stat1 >>= 1)
			if (stat1 & 1)
				do_IRQ(i, regs);

		for (i = IRQ_JORNADA_GPIO_B0; statb; i++, statb >>= 1)
			if (statb & 1)
				do_IRQ(i, regs);

		for (i = IRQ_JORNADA_GPIO_C0; statc; i++, statc >>= 1)
			if (statc & 1)
				do_IRQ(i, regs);
	}
}
#endif
static void jornada56x_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
unsigned long flags;

	if (myhandler
		&& ((JORNADA_INT_EN & JORNADA_CF_REMOVE)
		  || (JORNADA_INT_EN2 & (JORNADA_CF_INT | JORNADA_CF_INSERT
			| JORNADA_CF_STSCHG | JORNADA_CF_WAIT_ERR)) ) )
		myhandler(irq, dev_id, regs);
	JORNADA_INT_STAT = 0xffffffff;
	JORNADA_INT_STAT2 = 0xffffffff;
#if 0
    spin_lock_irqsave(&jornada56x_controller_lock, flags);
    spin_unlock_irqrestore(&jornada56x_controller_lock, flags);
#endif
}

static int __init jornada56x_init(void)
{
int irq;
	//jca GPSR = GPIO_GPIO20;
	GPCR = 0x0f424000;
	GAFR = 0x080803fc;
	GPDR = 0x0f5243fc;
#if 0
outputs		0x0f5243fc
set to 0	0x0f424000
other		0x001003fc
alternate	0x080803fc
27 32kHz out
19 SSP_CLK
2-9 LCD controller
actual other	0x00100000
GPIO20 ASIC reset
#endif

	//GRER = 0x00448c00;
	//GFER = 0x00448800;
	//PPAR = 0;
	//PPDR = 0;
	//PPSR = 0;
	udelay(1);

#if 0	/* already done in bootldr */
	GPCR = GPIO_GPIO20;		// Toggle the Reset pin
	udelay(1);
	GPSR = GPIO_GPIO20;
#endif

	// Initialise the GPIO register
  	JORNADA_GPBPDR = 0x01FF;
  	JORNADA_GPCPDR = 0x37C2;
  	JORNADA_GPDPDR = 0xFFFF;
#if 0
  	JORNADA_GPBPDR = 0x01FF;
B output
0-8
  	JORNADA_GPCPDR = 0x37C2;
C output
1
6
7
8
9
10
12
13
  	JORNADA_GPDPDR = 0xFFFF;
D output
0-15
#endif
  	
  	JORNADA_GPBPSR = 0x001B;
  	JORNADA_GPCPSR = 0x31C0;
  	JORNADA_GPDPSR = 0xAD99;
  	
  	JORNADA_GPBPCR = 0x3E24;
  	JORNADA_GPCPCR = 0x0002;
  	JORNADA_GPDPCR = 0x5264;
	JORNADA_GPDPSR = JORNADA_RS232_ON;	/* enable rs232 transciever */
	JORNADA_GPDPSR = JORNADA_CF_POWER_OFF;	/* turn power off to CF */

  	JORNADA_GPBPSDR = 0x81FF;
  	JORNADA_GPCPSDR = 0xB96F;
  	JORNADA_GPDPSDR = 0xFBFF;
  	
  	JORNADA_GPBPSLR = 0x00D0;
  	JORNADA_GPCPSLR = 0x0000;
  	JORNADA_GPDPSLR = 0xA198;
  	
  	JORNADA_GPBPFDR = 0x81FF;
  	JORNADA_GPCPFDR = 0xB96F;
  	JORNADA_GPDPFDR = 0xFBFF;
  	
  	JORNADA_GPBPFLR = 0x01D0;
  	JORNADA_GPCPFLR = 0x0000;
  	JORNADA_GPDPFLR = 0xA198;

	// Clear screen here
	JORNADA_GPDPSR = GPIO_GPIO15; // Turn off the front light
	JORNADA_GPDPCR = GPIO_GPIO5;
	JORNADA_GPDPCR = GPIO_GPIO13;   // Turn on power to panel
	mdelay(2);	// Delay 2 milliseconds.

	// Initialise the PMU register
  	JORNADA_GPIOAFR = 0x02; /* enable pwm */
  	JORNADA_SCR = JORNADA_RCLK_EN;      // Enable the internal system reference clock for ASIC
mdelay(1); /* ???????? */


	// Read more on SetPMUPCRRegister function on the next section
	// It is better to turn on the GPIO int clock here,
	// the PWM clock is for adjusting the brightness of the display
  	SetPMUPCRRegister(PCR_BIT_SET,
		(JORNADA_GPIO_INT_CLK_EN|JORNADA_PWM1CLK_EN));

	JORNADA_PWM1_CKDR = 0;
	JORNADA_PWM2_CKDR = 0;
	JORNADA_INT_EN = 0;
	JORNADA_INT_STAT = 0xffffffff;
	JORNADA_INT_EN2 = 0;
	JORNADA_INT_STAT2 = 0xffffffff;
	for (irq = IRQ_JORNADA_MMC; irq <= IRQ_JORNADA_MMC+15; irq++) {
		irq_desc[irq].valid	= 1;
		irq_desc[irq].probe_ok	= 0;
		irq_desc[irq].mask_ack	= jornada56x_mask_and_ack_lowirq;
		irq_desc[irq].mask	= jornada56x_mask_lowirq;
		irq_desc[irq].unmask	= jornada56x_unmask_lowirq;
	}
	for (irq = IRQ_JORNADA_UART; irq <= IRQ_JORNADA_UART+15; irq++) {
		irq_desc[irq].valid	= 1;
		irq_desc[irq].probe_ok	= 0;
		irq_desc[irq].mask_ack	= jornada56x_mask_and_ack_highirq;
		irq_desc[irq].mask	= jornada56x_mask_highirq;
		irq_desc[irq].unmask	= jornada56x_unmask_highirq;
	}
	for (irq = IRQ_JORNADA_GPIO_B0; irq <= IRQ_JORNADA_GPIO_B0+15; irq++) {
		irq_desc[irq].valid	= 1;
		irq_desc[irq].probe_ok	= 0;
		irq_desc[irq].mask_ack	= jornada56x_mask_and_ack_gpiobirq;
		irq_desc[irq].mask	= jornada56x_mask_gpiobirq;
		irq_desc[irq].unmask	= jornada56x_unmask_gpiobirq;
	}
	for (irq = IRQ_JORNADA_GPIO_C0; irq <= IRQ_JORNADA_GPIO_C0+15; irq++) {
		irq_desc[irq].valid	= 1;
		irq_desc[irq].probe_ok	= 0;
		irq_desc[irq].mask_ack	= jornada56x_mask_and_ack_gpiocirq;
		irq_desc[irq].mask	= jornada56x_mask_gpiocirq;
		irq_desc[irq].unmask	= jornada56x_unmask_gpiocirq;
	}
        set_GPIO_IRQ_edge( GPIO_JORNADA56X_ASIC, GPIO_FALLING_EDGE );
        set_GPIO_IRQ_edge( GPIO_JORNADA56X_ASIC, GPIO_RISING_EDGE );
        if (request_irq(GPIO_JORNADA56X_ASIC_IRQ, jornada56x_interrupt,
                0, "Jornada56x ASIC", 0)) {
printk("%s(): request_irq failed\n", __FUNCTION__);
                return -1;
        }
#if 0
jornada56x_battery();
#endif
	return 0;
}
__initcall(jornada56x_init);

static void __init
fixup_jornada56x(struct machine_desc *desc, struct param_struct *params,
		 char **cmdline, struct meminfo *mi)
{
}

static struct map_desc jornada56x_io_desc[] __initdata = {
        /* virtual     physical    length      domain     r  w  c  b */
        { 0xe8000000, 0x00000000, 0x02000000, DOMAIN_IO, 1, 1, 0, 0 }, /* Flash bank 0 */
        { 0xf0000000, 0x40000000, 0x00100000, DOMAIN_IO, 1, 1, 0, 0 }, /* ASIC */
        LAST_DESC
};

static void __init jornada56x_map_io(void)
{
	sa1100_map_io();
	iotable_init(jornada56x_io_desc);

	sa1100_register_uart(0, 3);
	sa1100_register_uart(1, 1);
}

MACHINE_START(JORNADA56X, "HP Jornada 56x")
BOOT_MEM(0xc0000000, 0x80000000, 0xf8000000)
BOOT_PARAMS(0xc0000100)
FIXUP(fixup_jornada56x)
MAPIO(jornada56x_map_io)
INITIRQ(sa1100_init_irq)
MACHINE_END
