//  yopu.c
//
//  Main module of the application.
//

#include "yopu.h"

#define APP_NAME           "yopu yopu"   //  Name of the application.

///////////////////////////////////////////////////////
//           Main function of the                    //
//             game application.                     //
///////////////////////////////////////////////////////
long main(int argc, char* argv[], bool start)
{
  struct KeyParam* ptr_key_param;
  struct DirectKeyboard* ptr_keyboard; 
  struct Message* ptr_message;

  init_module(&main_module);

  set_clicks_enabled(FALSE);

  //  Gets pointer to the direct keyboard object.
  ptr_keyboard = DirectKeyboard_get_instance();

  while(!exit_game_session)  //  The application's main loop.
  {
    // init stuff!

    need_new_yopu = TRUE;
    wait_to_drop = 0;

    init_session();

    init_game();
  
    while(!exit_current_game)
    {
      ptr_message = cWinApp_get_message(main_module.m_process, 1, 1, MSG_USER);

      if (need_new_yopu)
         {
           make_new_yopu();
           show_yopu();
         }

      max_wait = (11 - level) * 2;

      if (max_wait <= 0) max_wait = 1;

      if (wait_to_drop == max_wait)
         {
            wait_to_drop = 0;
            move_down();
            show_yopu();
         }

      switch(ptr_message->msgid)
      {
        case MSG_GOTFOCUS:  //  The process gets the focus (after invitations). 
          show_board();
          break;
        case MSG_SHUTUP:   
        case MSG_QUIT:
          exit_current_game = TRUE;
          exit_game_session = TRUE;
          break;
        case MSG_KEYDOWN:  
           ptr_key_param = Message_get_key_param(ptr_message);
           switch(ptr_key_param->scancode)
           {
             case KEY_ESC:
               //  Shows CyWin modal dialog "Do you really want to quit ?".
               cDialog_ctor(&player_dialog, 
                            NULL, 
                            str_Really_exit, 
                            mbQuit | mbCancel, 
                            0, 
                            main_module.m_process);

               if(cDialog_ShowModal(&player_dialog) == mrQuit)
               {
                 exit_current_game = TRUE;
                 exit_game_session = TRUE;
               }
               cDialog_dtor(&player_dialog, LEAVE_MEMORY);

               show_board();
               break;
             default:
               //  Processes unprocessed message.
               //  Need for processing HELP key.
               cWinApp_defproc(main_module.m_process, ptr_message); 
           }  //  switch(ptr_key_param->KeyParam_scancode)
          break;
        default:
          //  Processes unprocessed message.
          cWinApp_defproc(main_module.m_process, ptr_message);
      }  //  switch(ptr_message->Message_msgid)

      //  Deletes message.                
      Message_delete(ptr_message);

      // This is the direct keyboard stuff!
      DirectKeyboard_scan(ptr_keyboard);

      if(DirectKeyboard_is_key_pressed(ptr_keyboard, KEY_UP))
       {
           move_piece(KEY_UP);
       }

      if(DirectKeyboard_is_key_pressed(ptr_keyboard, KEY_DOWN))
       {
           move_piece(KEY_DOWN);
       }

      if(DirectKeyboard_is_key_pressed(ptr_keyboard, KEY_LEFT))
       {
           move_piece(KEY_LEFT);
       }
 
      if(DirectKeyboard_is_key_pressed(ptr_keyboard, KEY_RIGHT))
       {
           move_piece(KEY_RIGHT);
       }

      if(DirectKeyboard_is_key_pressed(ptr_keyboard, KEY_ENTER))
       {
         rotate_piece();
       }

      wait_to_drop = wait_to_drop + 1;

    }  //  while(!exit_game_session)

  }  //  while(!exit_game_session)

  //  Performs cleanup.
  //  Performs cleanup.   
  DirectKeyboard_dtor(ptr_keyboard, FREE_MEMORY);

  set_clicks_enabled(TRUE);

  return 0;
}

///////////////////////////////////////////////////////
//           Performs initialization                 //
//             of the game session.                  //
///////////////////////////////////////////////////////
void init_session()
{
  int i;

  exit_game_session = FALSE;       

  score = 0;
  level = 1;
  total_yopus = 0;

  srand((int)clock());

//  ptr_background = (char*)malloc(DisplayGraphics_get_bytes_total(main_module.m_gfx));

  DisplayGraphics_set_draw_mode(main_module.m_gfx, DM_PUT);
  // Draw board on page 1
  DisplayGraphics_set_page(main_module.m_gfx, 1);
  DisplayGraphics_fill_screen(main_module.m_gfx, CLR_DKGRAY);

  // Clear some zones
  DisplayGraphics_set_color(main_module.m_gfx, CLR_WHITE);

  // Main "drop zone"
  DisplayGraphics_fill_rect(main_module.m_gfx, 4,0,72,96);

  // Score section
  DisplayGraphics_fill_rect(main_module.m_gfx, 80,4,76,62);

  DisplayGraphics_set_color(main_module.m_gfx, CLR_BLACK);
  Graphics_set_font( main_module.m_gfx, cool_normal_font );
  Graphics_draw_text(main_module.m_gfx, "Score", 82, 6);

  Graphics_draw_text(main_module.m_gfx, "Yopus", 82, 26);

  Graphics_draw_text(main_module.m_gfx, "Level", 82, 46);

  // Copy what we just did over to page 0
  DisplayGraphics_page_copy(main_module.m_gfx, 1, 0, 0, 0, 160, 100);

  // Set page to 0
  DisplayGraphics_set_page(main_module.m_gfx, 0);

  // And show it!
  DisplayGraphics_show(main_module.m_gfx);
  
}                                    

///////////////////////////////////////////////////////
//           Performs initialization of the          //
//                   each game.                      //
///////////////////////////////////////////////////////
void init_game()
{
  int t,u;

// init board to all -1
  for (t=0; t<12; t++)
    {
      for(u=0; u<9; u++)
         {
            board[t][u].color   = -1;
            board[t][u].counted = -1;
         }
    }

  exit_current_game = FALSE;        

}

bool check_left()
{
bool result;

switch(sprite.orient)
{
  case 0:
      if(sprite.bmp1_board_x == 0)
        {
          result = FALSE;
        }
      else
        {
          if ((board[sprite.bmp1_board_y][sprite.bmp1_board_x - 1].color == -1) 
           && (board[sprite.bmp2_board_y][sprite.bmp2_board_x - 1].color == -1))
          {
            result = TRUE;
          }
          else
          {
            result = FALSE;
          };
        };
      break;
  case 1:
      if(sprite.bmp2_board_x == 0)
        {
          result = FALSE;
        }
      else
        {
          if (board[sprite.bmp2_board_y][sprite.bmp2_board_x - 1].color == -1)
          {
            result = TRUE;
          }
          else
          {
            result = FALSE;
          };
        };
      break;
  case 2:
      if(sprite.bmp1_board_x == 0)
        {
          result = FALSE;
        }
      else
        {
          if ((board[sprite.bmp1_board_y][sprite.bmp1_board_x - 1].color == -1) 
           && (board[sprite.bmp2_board_y][sprite.bmp2_board_x - 1].color == -1))
          {
            result = TRUE;
          }
          else
          {
            result = FALSE;
          };
        };
      break;
  case 3:
      if(sprite.bmp1_board_x == 0)
        {
          result = FALSE;
        }
      else
        {
          if (board[sprite.bmp1_board_y][sprite.bmp1_board_x - 1].color == -1)
          {
            result = TRUE;
          }
          else
          {
            result = FALSE;
          };
        };
      break;
  }

return result;
}

bool check_right()
{
bool result;

switch(sprite.orient)
{
  case 0:
      if(sprite.bmp1_board_x == 8)
        {
          result = FALSE;
        }
      else
        {
          if ((board[sprite.bmp1_board_y][sprite.bmp1_board_x + 1].color == -1) 
           && (board[sprite.bmp2_board_y][sprite.bmp2_board_x + 1].color == -1))
          {
            result = TRUE;
          }
          else
          {
            result = FALSE;
          };
        };
      break;
  case 1:
      if(sprite.bmp1_board_x == 8)
        {
          result = FALSE;
        }
      else
        {
          if (board[sprite.bmp1_board_y][sprite.bmp1_board_x + 1].color == -1)
          {
            result = TRUE;
          }
          else
          {
            result = FALSE;
          };
        };
      break;
  case 2:
      if(sprite.bmp1_board_x == 8)
        {
          result = FALSE;
        }
      else
        {
          if ((board[sprite.bmp1_board_y][sprite.bmp1_board_x + 1].color == -1) 
           && (board[sprite.bmp2_board_y][sprite.bmp2_board_x + 1].color == -1))
          {
            result = TRUE;
          }
          else
          {
            result = FALSE;
          };
        };
      break;
  case 3:
      if(sprite.bmp2_board_x == 8)
        {
          result = FALSE;
        }
      else
        {
          if (board[sprite.bmp2_board_y][sprite.bmp2_board_x + 1].color == -1)
          {
            result = TRUE;
          }
          else
          {
            result = FALSE;
          };
        };
      break;
}
return result;
}

bool check_down()
{
bool result;

switch(sprite.orient)
{
  case 0:
      if (sprite.bmp2_board_y == 11)
        {
          result = FALSE;
        }
      else
        {
          if (board[sprite.bmp2_board_y + 1][sprite.bmp1_board_x].color == -1) 
          {
            result = TRUE;
          }
          else
          {
            result = FALSE;
          };
        };
      break;
  case 1:
      if (sprite.bmp1_board_y == 11)
        {
          result = FALSE;
        }
      else
        {
          if ((board[sprite.bmp1_board_y + 1][sprite.bmp1_board_x].color == -1)
           && (board[sprite.bmp2_board_y + 1][sprite.bmp2_board_x].color == -1))
          {
            result = TRUE;
          }
          else
          {
            result = FALSE;
          };
        };
      break;
  case 2:
      if(sprite.bmp1_board_y == 11)
        {
          result = FALSE;
        }
      else
        {
          if (board[sprite.bmp1_board_y + 1][sprite.bmp1_board_x].color == -1) 
          {
            result = TRUE;
          }
          else
          {
            result = FALSE;
          }
        }
      break;
  case 3:
      if(sprite.bmp1_board_y == 11)
        {
          result = FALSE;
        }
      else
        {
          if ((board[sprite.bmp1_board_y + 1][sprite.bmp1_board_x].color == -1)
           && (board[sprite.bmp2_board_y + 1][sprite.bmp2_board_x].color == -1))
          {
            result = TRUE;
          }
          else
          {
            result = FALSE;
          }
        }
      break;
}
return result;
}

void flash_yopu()
{
  int x, y, t;

   DisplayGraphics_set_page(main_module.m_gfx, 0);
   DisplayGraphics_set_draw_mode(main_module.m_gfx, DM_PUT);

   for (t=0; t<3; t++) // Do it three times
   {
   DisplayGraphics_set_color(main_module.m_gfx, CLR_LTGRAY);
   for(x=0; x<9; x++)
      {
        for(y=0; y<12; y++)
           {
              if(board[y][x].counted != -1)
                {
                  DisplayGraphics_fill_rect(main_module.m_gfx, (x*8)+4,y*8,8,8);
                }
            }
       }   

   show_info();

   DisplayGraphics_show(main_module.m_gfx); // Show it!

   cWinApp_pause(main_module.m_process, 500); // Half a second should be good!
   DisplayGraphics_page_copy(main_module.m_gfx, 1, 0, 0, 0, 160, 100);

   show_info();
   DisplayGraphics_show(main_module.m_gfx); // Show it!
   cWinApp_pause(main_module.m_process, 500); // Half a second should be good!
   }
  
}

void clear_yopus()
{
  int x,y,t,u,v,w;
  bool cleared_some;
  int num_adj;
  int num_cleared;
  int max_num_adj;
  int in_a_row;

  t=1;

  in_a_row = 1;

  max_num_adj = 0;

  for (x=0; x<9; x++)
      {
        for (y=0; y<12; y++)  
         {

            if((board[y][x].color != -1) && (board[y][x].counted == -1))
              {
                num_adj = check_yopu(x, y, board[y][x].color, t);

                if(num_adj > max_num_adj) max_num_adj = num_adj;

                if(num_adj < 4)
                  {
                     for(u=0; u<12; u++)
                        {
                          for(v=0; v<9; v++)
                             {
                                if(board[u][v].counted == t)
                                  {
                                   board[u][v].counted = -1;
                                  }
                             }
                        }
                  }

              t = t + 1;
              }
         }
      }

  if(max_num_adj >= 4)
    {

      total_yopus = total_yopus + 1;
      if((total_yopus % 5) == 0)
        {
          level = level + 1;
        }

      flash_yopu();
      score = score + ((in_a_row*5)*(max_num_adj*10));
      in_a_row++;

      num_cleared = clear_counted();
      while(num_cleared > 0)
           {
               num_cleared = clear_counted();
           }

      cleared_some=TRUE;
      while(cleared_some == TRUE)
           {
           cleared_some = FALSE;
           for(t=0; t<12; t++)
             {
             for(u=0; u<9; u++)
                {
                   if(board[t][u].color != -1)
                     {
                        num_adj = check_yopu(u,t, board[t][u].color,99);
    
                        if (num_adj >= 4)
                           {

                              total_yopus = total_yopus + 1;

                              if((total_yopus % 5) == 0)
                                {
                                   level = level + 1;
                                }

                              flash_yopu();
                              score = score + ((in_a_row*5)*(num_adj*10));
                              in_a_row++;

                              cleared_some = TRUE;
                              num_cleared = clear_counted();
                              while(num_cleared > 0)
                                   { 
                                     num_cleared = clear_counted();
                                   }
                            }

                           for(v=0; v<12; v++)
                              {
                               for(w=0; w<9; w++)
                                  {
                                     board[v][w].counted = -1;
                                  }
                              }
                     }
               }
            }
   
          } // End while cleared some
  } // End if max_num_adj >= 4

for(v=0; v<12; v++)
   {
     for(w=0; w<9; w++)
        {
            board[v][w].counted = -1;
        }
   }

}

void lock_block()
{
bool still_room_1;
bool still_room_2;
int num_adj;
int t,u,v,w;
int num_cleared;
bool cleared_some;

still_room_1 = TRUE;
still_room_2 = TRUE;

while((still_room_1 == TRUE) || (still_room_2 == TRUE))
{

   if (sprite.orient == 0) still_room_1 = FALSE;
   if (sprite.orient == 2) still_room_2 = FALSE;
   if (sprite.bmp1_board_y == 11) still_room_1 == FALSE;
   if (sprite.bmp2_board_y == 11) still_room_2 == FALSE;

   if (still_room_1 == TRUE)
      {
       if(board[sprite.bmp1_board_y+1][sprite.bmp1_board_x].color == -1 )
         {
           sprite.bmp1_board_y = sprite.bmp1_board_y + 1;
         }
       else
         {
           still_room_1 = FALSE;
         }
       }

   if (still_room_2 == TRUE)
      {
       if(board[sprite.bmp2_board_y+1][sprite.bmp2_board_x].color == -1 )
         {
           sprite.bmp2_board_y = sprite.bmp2_board_y + 1;
         }
       else
         {
           still_room_2 = FALSE;
         }
       }

      cWinApp_pause(main_module.m_process, 300);
      show_yopu();
}

   DisplayGraphics_set_page(main_module.m_gfx, 1);
   Graphics_set_draw_mode(main_module.m_gfx, DM_PUT);
   draw_lib(sprite.color1,0,(sprite.bmp1_board_x*8)+4, sprite.bmp1_board_y*8, BM_NORMAL);
   draw_lib(sprite.color2,0,(sprite.bmp2_board_x*8)+4, sprite.bmp2_board_y*8, BM_NORMAL);

   // Update board to show that we are taken!
   board[sprite.bmp1_board_y][sprite.bmp1_board_x].color = sprite.color1;
   board[sprite.bmp2_board_y][sprite.bmp2_board_x].color = sprite.color2;

   DisplayGraphics_page_copy(main_module.m_gfx, 1, 0, 0, 0, 160, 100);

   // Set page to 0
   DisplayGraphics_set_page(main_module.m_gfx, 0);

   // And show it!
   DisplayGraphics_show(main_module.m_gfx);

   clear_yopus();

}

int clear_counted()
{
  int y,x,v,a,z;
  int cleared;
  bool scroll;
  cleared = 0;

  for(y=11; y>0; y--)
     {
        for(x=0; x<9; x++)
           {
              scroll = TRUE;

              if(board[y][x].counted != -1)
                {
                   cleared = cleared + 1;
                   // Do this on page 1!
                   DisplayGraphics_set_page(main_module.m_gfx, 1);
                   Graphics_set_draw_mode(main_module.m_gfx, DM_PUT);
                   
                   // Scroll given column
                   DisplayGraphics_scroll(main_module.m_gfx, (x*8)+4, 0, 8, (y*8)+8, 0, 8);
                   DisplayGraphics_page_copy(main_module.m_gfx, 1, 0, 0, 0, 160, 100);

                   DisplayGraphics_set_page(main_module.m_gfx, 0);

                   DisplayGraphics_show(main_module.m_gfx);

                   //Now scroll board
                   for(v=y; v>0; v--)
                      {
                        z=v-1;
                        board[v][x].color   = board[z][x].color;
                        board[v][x].counted = board[z][x].counted;
                      }

                     board[0][x].color   = -1;
                     board[0][x].counted = -1;
               }
           }
     }

  return cleared;  
}

void move_down()
{

 wait_to_drop = 0;

 if (check_down() == TRUE)
    {
      sprite.bmp1_board_y = sprite.bmp1_board_y + 1;
      sprite.bmp2_board_y = sprite.bmp2_board_y + 1;
    }
 else  // We hit a wall
    {
       lock_block();
       need_new_yopu = TRUE;            
    }

}

///////////////////////////////////////////////////////
//         Moves player's cursor in the              //
//            specified direction.                   //
///////////////////////////////////////////////////////
void
move_piece(int direction)
{

  switch(direction)
  {
    case KEY_LEFT:
      if(check_left() == TRUE)
        {
          sprite.bmp1_board_x = sprite.bmp1_board_x - 1;
          sprite.bmp2_board_x = sprite.bmp2_board_x - 1;
        }
      break;
    case KEY_DOWN:
      move_down();
      break;
    case KEY_RIGHT:
      if (check_right() == TRUE)
         {
           sprite.bmp1_board_x = sprite.bmp1_board_x + 1;
           sprite.bmp2_board_x = sprite.bmp2_board_x + 1;
         }
      break;
    default:
      break;
   }

// Please choose better handling because they will rotate!

switch(sprite.orient)
{
 // * - bmp1
 // * - bmp2
 case 0: 
    if (sprite.bmp1_board_x < 0) sprite.bmp1_board_x = 0;
    if (sprite.bmp2_board_x < 0) sprite.bmp2_board_x = 0;
    if (sprite.bmp1_board_x > 8) sprite.bmp1_board_x = 8;
    if (sprite.bmp2_board_x > 8) sprite.bmp2_board_x = 8;
    if (sprite.bmp1_board_y > 10) sprite.bmp1_board_y = 10;
    if (sprite.bmp2_board_y > 11) sprite.bmp2_board_y = 11;
    break;

 // bmp2  bmp1
 //  *     *
 case 1: 
    if (sprite.bmp1_board_x < 1) sprite.bmp1_board_x = 1;
    if (sprite.bmp2_board_x < 0) sprite.bmp2_board_x = 0;
    if (sprite.bmp1_board_x > 8) sprite.bmp1_board_x = 8;
    if (sprite.bmp2_board_x > 7) sprite.bmp2_board_x = 7;
    if (sprite.bmp1_board_y > 11) sprite.bmp1_board_y = 11;
    if (sprite.bmp2_board_y > 11) sprite.bmp2_board_y = 11;
    break;

 // bmp2 - *
 // bmp1 - *
 case 2: 
    if (sprite.bmp1_board_x < 0) sprite.bmp1_board_x = 0;
    if (sprite.bmp2_board_x < 0) sprite.bmp2_board_x = 0;
    if (sprite.bmp1_board_x > 8) sprite.bmp1_board_x = 8;
    if (sprite.bmp2_board_x > 8) sprite.bmp2_board_x = 8;
    if (sprite.bmp1_board_y > 11) sprite.bmp1_board_y = 11;
    if (sprite.bmp2_board_y > 10) sprite.bmp2_board_y = 10;
    break;

 // bmp1  bmp2
 //  *     *
 case 3: 
    if (sprite.bmp1_board_x < 0) sprite.bmp1_board_x = 0;
    if (sprite.bmp2_board_x < 1) sprite.bmp2_board_x = 1;
    if (sprite.bmp1_board_x > 7) sprite.bmp1_board_x = 7;
    if (sprite.bmp2_board_x > 8) sprite.bmp2_board_x = 8;
    if (sprite.bmp1_board_y > 11) sprite.bmp1_board_y = 11;
    if (sprite.bmp2_board_y > 11) sprite.bmp2_board_y = 11;
    break;

}

   show_yopu();
  cWinApp_pause(main_module.m_process, 3);
}

void rotate_piece()
{
switch (sprite.orient)
{
  case 0:
       if(check_right() == TRUE)
         {       
           sprite.orient = 1;

           if (sprite.bmp1_board_x == 8)
             {
                sprite.bmp1_board_x = 7;
                sprite.bmp2_board_x = 7;
             }
  
          sprite.bmp1_board_x = sprite.bmp1_board_x + 1;
          sprite.bmp1_board_y = sprite.bmp1_board_y + 1;
         }
       break;
  case 1:
       if(check_down() == TRUE)
         {
           if (sprite.bmp1_board_y == 11)
              {
                 sprite.bmp1_board_y = 10;
                 sprite.bmp2_board_y = 10;
              }

           sprite.orient = 2;
           sprite.bmp1_board_x = sprite.bmp1_board_x - 1;
           sprite.bmp1_board_y = sprite.bmp1_board_y + 1;
         }
       break;

  case 2:
       if(check_left() == TRUE)
         {
           sprite.orient = 3;
           if (sprite.bmp1_board_x == 0)
              {
                 sprite.bmp1_board_x = 1;
                 sprite.bmp2_board_x = 1;
              }

           sprite.bmp1_board_x = sprite.bmp1_board_x - 1;
           sprite.bmp1_board_y = sprite.bmp1_board_y - 1;
          }
       break;
  case 3:
       sprite.orient = 0;
       sprite.bmp1_board_x = sprite.bmp1_board_x + 1;
       sprite.bmp1_board_y = sprite.bmp1_board_y - 1;
       break;
 
} // End of switch 

  show_yopu();
  cWinApp_pause(main_module.m_process, 80);

}

///////////////////////////////////////////////////////
//              Redraws CYBIKO                       //
//                  screen.                          //
///////////////////////////////////////////////////////
void show_board()
{
  if(cWinApp_has_focus(main_module.m_process))
  {
    Graphics_set_draw_mode(main_module.m_gfx, DM_PUT);

    DisplayGraphics_page_copy(main_module.m_gfx, 1, 0, 0, 0, 160, 100);

    // Draws cursor on current graphic page.
    if(!exit_current_game)
    {
      show_yopu();
    }

    // Shows current graphic page.
    DisplayGraphics_show(main_module.m_gfx);
  }
} 

void make_new_yopu()
{
int t;

need_new_yopu = FALSE;

if(board[1][4].color == -1)
  {
    t = (int)random(9);

    sprite.color1 = yopus[t][0];
    sprite.color2 = yopus[t][1];

    sprite.orient = 0;

    sprite.bmp1_board_x = 4; // Damn zero based...
    sprite.bmp1_board_y = 0;
    sprite.bmp2_board_x = 4; // Damn zero based...
    sprite.bmp2_board_y = 1;
  }
else // Well, it's game over folks!
  {
               cDialog_ctor(&player_dialog, 
                            NULL, 
                            "Game Over!", 
                            mbOk , 
                            0, 
                            main_module.m_process);

               if(cDialog_ShowModal(&player_dialog) == mrOk)
               {
                 exit_current_game = TRUE;
               }
               cDialog_dtor(&player_dialog, LEAVE_MEMORY);

  }

}

int check_yopu(int x, int y, int color, int value)
{
  int sum;

  sum = 0;

  if((x > 8) || (x < 0) || (y > 11)) return 0;

  if((board[y][x].counted == -1) && (board[y][x].color == color))
    {
       sum++;
       board[y][x].counted = value;
       sum += check_yopu(x-1, y, color, value);
       sum += check_yopu(x+1, y, color, value);
       sum += check_yopu(x, y-1, color, value);
       sum += check_yopu(x, y+1, color, value);
       
    }
  return sum;
}

void show_info()
{
  char score_s[10];
  char level_s[3];
  char num_yopus_s[10];

  sprintf(score_s, "%d", score);
  sprintf(level_s, "%d", level);
  sprintf(num_yopus_s, "%d", total_yopus);

  DisplayGraphics_set_color(main_module.m_gfx, CLR_BLACK);
  Graphics_draw_text(main_module.m_gfx, score_s, 82, 16);
  Graphics_draw_text(main_module.m_gfx, num_yopus_s, 82, 36);
  Graphics_draw_text(main_module.m_gfx, level_s, 82, 56);

}

void show_yopu()
{

Graphics_set_draw_mode(main_module.m_gfx, DM_PUT);

TGraph_set_color( main_module.m_gfx, CLR_WHITE);

// Copy page 1 to page 0
// This "restores" a virgin screen, this prevents "sprite bleeding"
DisplayGraphics_page_copy(main_module.m_gfx, 1, 0, 0, 0, 160, 100);

show_info();

draw_lib(sprite.color1,0,(sprite.bmp1_board_x*8)+4, sprite.bmp1_board_y*8, BM_NORMAL);
draw_lib(sprite.color2,0,(sprite.bmp2_board_x*8)+4, sprite.bmp2_board_y*8, BM_NORMAL);

DisplayGraphics_show(main_module.m_gfx);

}
