/* linux/arch/arm/mach-msm/board-htcleo-panel.c
*
* Copyright (C) 2010 Cotulla
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
*/

#include <linux/clk.h>
#include <linux/delay.h>
#include <linux/err.h>
#include <linux/gpio.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/leds.h>
#include <linux/platform_device.h>
#include <linux/workqueue.h>

#include <asm/io.h>
#include <asm/mach-types.h>

#include <mach/msm_fb.h>
#include <mach/msm_iomap.h>
#include <mach/vreg.h>

#include "proc_comm.h"
#include "board-htcleo.h"
#include "devices.h"


typedef uint16_t UINT;

struct spi_cmd
{
    uint16_t reg;
    uint16_t val;
    uint16_t delay;
} __attribute__((packed));


#define PANELTYPE_UNKNOWN	0
#define PANELTYPE_AUO		1
#define PANELTYPE_SHARP		2

int panel_type = -1;
int board_id = -1;
static struct vreg *vreg_lcd;


#define LCM_DELAY(a)		msleep(a)

// from board-htcleo-spi.c
extern void qspi_enable();
extern void qspi_disable();
extern int qspi_send_9bit(unsigned char id, unsigned data);
extern int qspi_send_16bit(unsigned char id, unsigned data);
extern int qspi_send(unsigned char id, unsigned data);

static DEFINE_MUTEX(panel_lock);

//////////////////////////////////////////////////////////////////////////


static uint8_t AUO_INIT_NORMAL[2124] =
{
	0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x86, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x86, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC1, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC2, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x12, 0x00, 0x01, 0x00, 0x01, 0x00, 0xC2, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x42, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x2A, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x27, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x55, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x02, 0x00, 0x57, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x0E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x21, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x55, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x57, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x02, 0x00, 0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x79, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x55, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x11, 0x00, 0x00, 0x00, 0x02, 0x00, 0x57, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3B, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x02, 0x00, 0x88, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x14, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x55, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x02, 0x00, 0x57, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x2A, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x27, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x55, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x02, 0x00, 0x57, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x0E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x21, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00, 
	0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00, 
	0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 
	0x55, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 
	0x02, 0x00, 0x57, 0x00, 0x00, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x02, 0x00, 0x50, 0x00, 0x00, 0x00, 0x01, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x78, 0x00, 0x01, 0x00, 0x29, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00
};


static uint8_t AUO_INIT_2V8[2178] =
{
    0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x86, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x86, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC1, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x45, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC2, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x31, 0x00, 0x01, 0x00, 0x01, 0x00, 0xC2, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x2A, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x27, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x55, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x02, 0x00, 0x57, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x0E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x21, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x55, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x57, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x02, 0x00, 0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x79, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
    0x02, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x55, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x02, 0x00, 0x57, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3B, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x02, 0x00, 0x88, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x14, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x55, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x02, 0x00, 0x57, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x2A, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x27, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x55, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x02, 0x00, 0x57, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x0E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x21, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x55, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x57, 0x00, 0x00, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x50, 0x00, 0x00, 0x00, 0x01, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x78, 0x00, 0x01, 0x00, 0xC1, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC2, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xC2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x32, 0x00, 0x14, 0x00,
    0x01, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00
};


static uint8_t AUO_INIT_3V0[2178] =
{
    0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x86, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x86, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC1, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x45, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC2, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x31, 0x00, 0x01, 0x00, 0x01, 0x00, 0xC2, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x2A, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x27, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x55, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x02, 0x00, 0x57, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x0E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x21, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x55, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x57, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x02, 0x00, 0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x79, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
    0x02, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x55, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x02, 0x00, 0x57, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3B, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x02, 0x00, 0x88, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x14, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x55, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE3, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x02, 0x00, 0x57, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x0E, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x2A, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x27, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE4, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x55, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x02, 0x00, 0x57, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x0E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3B, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x02, 0x00, 0x64, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x02, 0x00, 0x3F, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x21, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x27, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x88, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x02, 0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x79, 0x00, 0x00, 0x00,
    0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x00, 0xB8, 0x00,
    0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x55, 0x00, 0x00, 0x00, 0x01, 0x00, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x57, 0x00, 0x00, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x50, 0x00, 0x00, 0x00, 0x01, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x78, 0x00, 0x01, 0x00, 0xC1, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x01, 0x00, 0xC2, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x12, 0x00, 0x00, 0x00, 0x01, 0x00,
    0xC2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x42, 0x00, 0x14, 0x00,
    0x01, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00
};

static uint8_t AUO_DEINIT[36] =
{
    0x01, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x22, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x64, 0x00
};

//////////////////////////////////////////////////////////////////////////

static uint8_t SHARP_INIT[60] =
{
    0x00, 0x00, 0x11, 0x00, 0x6E, 0x00, 0x00, 0x00, 0xB9, 0x00, 0x00, 0x00, 0x01, 0x00, 0xFF, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xB9, 0x00, 0x00, 0x00, 0x01, 0x00, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xB9, 0x00, 0x00, 0x00, 0x01, 0x00, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00
};


static uint8_t SHARP_DEINIT[12] =
{
    0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00
};

//////////////////////////////////////////////////////////////////////////

static void config_gpio_table(uint32_t *table, int len)
{
    int n;
    unsigned id;
    for(n = 0; n < len; n++)
    {
        id = table[n];
        msm_proc_comm(PCOM_RPC_GPIO_TLMM_CONFIG_EX, &id, 0);
    }
}

//////////////////////////////////////////////////////////////////////////
// SPI GPIO config
//////////////////////////////////////////////////////////////////////////


#define SPI_CLK 17
#define SPI_DO  18
#define SPI_DI  19
#define SPI_CS  20

#define LCM_GPIO_CFG(gpio, func) \
    GPIO_CFG(gpio, func, GPIO_OUTPUT, GPIO_NO_PULL, GPIO_16MA)

static uint32_t spi_on_gpio_table[] =
{
    LCM_GPIO_CFG(SPI_CLK, 1),
    LCM_GPIO_CFG(SPI_CS, 1),
    LCM_GPIO_CFG(SPI_DO, 1),
    GPIO_CFG(SPI_DI, 1, GPIO_INPUT, GPIO_NO_PULL, GPIO_16MA),
};

static uint32_t spi_off_gpio_table[] =
{
    LCM_GPIO_CFG(SPI_CLK, 0),
    LCM_GPIO_CFG(SPI_CS, 0),
    LCM_GPIO_CFG(SPI_DO, 0),
    GPIO_CFG(SPI_DI, 0, GPIO_INPUT, GPIO_NO_PULL, GPIO_16MA),
};

static int spi_gpio_switch(int on)
{
    config_gpio_table(!!on ? spi_on_gpio_table : spi_off_gpio_table,
                    ARRAY_SIZE(spi_on_gpio_table));
    return 0;
}

//////////////////////////////////////////////////////////////////////////
// LCM GPIO config
//////////////////////////////////////////////////////////////////////////

static uint32_t display_on_gpio_table[] =
{
    LCM_GPIO_CFG(HTCLEO_LCD_R1, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_R2, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_R3, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_R4, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_R5, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_G0, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_G1, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_G2, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_G3, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_G4, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_G5, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_B1, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_B2, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_B3, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_B4, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_B5, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_PCLK, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_VSYNC, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_HSYNC, 1),
    LCM_GPIO_CFG(HTCLEO_LCD_DE, 1),
};


static uint32_t display_off_gpio_table[] =
{
    LCM_GPIO_CFG(HTCLEO_LCD_R1, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_R2, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_R3, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_R4, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_R5, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_G0, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_G1, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_G2, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_G3, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_G4, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_G5, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_B1, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_B2, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_B3, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_B4, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_B5, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_PCLK, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_VSYNC, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_HSYNC, 0),
    LCM_GPIO_CFG(HTCLEO_LCD_DE, 0),
};

static int panel_gpio_switch(int on)
{
    config_gpio_table(!!on ? display_on_gpio_table : display_off_gpio_table,
                    ARRAY_SIZE(display_on_gpio_table));
    return 0;
}


//////////////////////////////////////////////////////////////////////////

static void auo_panel_cfg_setup(int on)
{
    int i, ret;
    int spisize;
    struct spi_cmd *spiseq;

    if (on)
	{
        if (board_id >= 4)
		{
            spiseq = (struct spi_cmd*)AUO_INIT_NORMAL;
            spisize = ARRAY_SIZE(AUO_INIT_NORMAL) / 6;
		}
        else if (board_id >= 3) // 3V
        {
            spiseq = (struct spi_cmd*)AUO_INIT_3V0;
            spisize = ARRAY_SIZE(AUO_INIT_3V0) / 6;
        }
        else // 2.8V
        {
            spiseq = (struct spi_cmd*)AUO_INIT_2V8;
            spisize = ARRAY_SIZE(AUO_INIT_2V8) / 6;
        }
    }
    else
    {
        spiseq = (struct spi_cmd*)AUO_DEINIT;
        spisize = ARRAY_SIZE(AUO_DEINIT) / 6;
	}

	qspi_enable();
    for (i = 0; i < spisize; i++)
    {
        ret = qspi_send_16bit(spiseq[i].reg, spiseq[i].val);
        if (ret < 0)
        {
            printk("%s: spi_write fail!\n", __func__);
        }
        if (spiseq[i].delay)
        {
            LCM_DELAY(spiseq[i].delay);
        }
    }
	qspi_disable();
}

static int auo_panel_init(struct msm_lcdc_panel_ops *ops)
{
    printk("%s\n", __func__);
    return 0;
}

static int auo_panel_unblank(struct msm_lcdc_panel_ops *ops)
{
    printk("%s\n", __func__);

    mutex_lock(&panel_lock);

    gpio_set_value(HTCLEO_GPIO_LCM_POWER, 1);
    LCM_DELAY(2);
    vreg_enable(vreg_lcd);
    LCM_DELAY(2);

    gpio_set_value(HTCLEO_GPIO_LCM_RESET, 1);
    LCM_DELAY(1);
    gpio_set_value(HTCLEO_GPIO_LCM_RESET, 0);
    LCM_DELAY(1);
    gpio_set_value(HTCLEO_GPIO_LCM_RESET, 1);
    LCM_DELAY(25);

    spi_gpio_switch(1);
    panel_gpio_switch(1);

    LCM_DELAY(33);

    auo_panel_cfg_setup(1);

    LCM_DELAY(1);

    mutex_unlock(&panel_lock);
    return 0;
}

static int auo_panel_blank(struct msm_lcdc_panel_ops *ops)
{
    printk("%s\n", __func__);
	mutex_lock(&panel_lock);

    auo_panel_cfg_setup(0);

    spi_gpio_switch(0);
    panel_gpio_switch(0);

    gpio_set_value(HTCLEO_GPIO_LCM_RESET, 0);
    LCM_DELAY(70);
    vreg_disable(vreg_lcd);
    gpio_set_value(HTCLEO_GPIO_LCM_POWER, 0);

	mutex_unlock(&panel_lock);

	return 0;
}

//////////////////////////////////////////////////////////////////////////

static void sharp_panel_cfg_setup(int on)
{
    int i, ret;
    int spisize;
    struct spi_cmd *spiseq;

    if (on)
    {
        spiseq = (struct spi_cmd*)SHARP_INIT;
        spisize = ARRAY_SIZE(SHARP_INIT) / 6;
    }
    else
    {
        spiseq = (struct spi_cmd*)SHARP_DEINIT;
        spisize = ARRAY_SIZE(SHARP_DEINIT) / 6;
    }

	qspi_enable();
    for (i = 0; i < spisize; i++)
    {
        ret = qspi_send_9bit(spiseq[i].reg, spiseq[i].val);
        if (ret < 0)
        {
            printk("%s: spi_write fail!\n", __func__);
        }
        if (spiseq[i].delay)
        {
            LCM_DELAY(spiseq[i].delay);
        }
    }
	qspi_disable();
}

static int sharp_panel_init(struct msm_lcdc_panel_ops *ops)
{
    pr_info("%s\n", __func__);
    return 0;
}

static int sharp_panel_unblank(struct msm_lcdc_panel_ops *ops)
{
    pr_info("%s\n", __func__);

	mutex_lock(&panel_lock);

    gpio_set_value(HTCLEO_GPIO_LCM_POWER, 1);

    LCM_DELAY(2);

    vreg_enable(vreg_lcd);

    LCM_DELAY(2);

    gpio_set_value(HTCLEO_GPIO_LCM_RESET, 1);

    spi_gpio_switch(1);
    panel_gpio_switch(1);

    LCM_DELAY(40);

    sharp_panel_cfg_setup(1);

    LCM_DELAY(57);

	mutex_unlock(&panel_lock);
	return 0;
}

static int sharp_panel_blank(struct msm_lcdc_panel_ops *ops)
{
    pr_info("%s\n", __func__);
	mutex_lock(&panel_lock);

    sharp_panel_cfg_setup(0);

    LCM_DELAY(60);

    spi_gpio_switch(0);
    panel_gpio_switch(0);

    gpio_set_value(HTCLEO_GPIO_LCM_RESET, 0);
    LCM_DELAY(2);
    vreg_disable(vreg_lcd);
    gpio_set_value(HTCLEO_GPIO_LCM_POWER, 0);

	mutex_unlock(&panel_lock);
	return 0;
}

//////////////////////////////////////////////////////////////////////////

static int unk_panel_init(struct msm_lcdc_panel_ops *ops)
{
    return 0;
}

static int unk_panel_unblank(struct msm_lcdc_panel_ops *ops)
{
    return 0;
}

static int unk_panel_blank(struct msm_lcdc_panel_ops *ops)
{
    return 0;
}

//////////////////////////////////////////////////////////////////////////

static void detect_panel_type(void)
{
    uint32_t type;
    void __iomem *glob_base;

    if (panel_type != -1)
    {
        return;
    }

    glob_base = ioremap(MSM_PANEL_PHYS, MSM_PANEL_SIZE);
    type = readl(glob_base + 0x1034);
    board_id = readl(glob_base + 0x1030);
    iounmap(glob_base);

    printk("panel type is %d :", type);
    printk("board id is %d :", board_id);

    if (type == 1) // AUO
    {
        printk(" AUO\n");
        panel_type = PANELTYPE_AUO;
    }
    else if (type == 10) // SHARP
    {
        printk(" SHARP\n");
        panel_type = PANELTYPE_SHARP;
    }
    else
    {
        printk(" UNKNOWN, stop system now\n");
        panel_type = PANELTYPE_UNKNOWN;
        BUG();
    }
}

//////////////////////////////////////////////////////////////////////////

static struct resource resources_msm_fb[] =
{
    {
        .start = MSM_FB_BASE,
        .end = MSM_FB_BASE + MSM_FB_SIZE - 1,
        .flags = IORESOURCE_MEM,
    },
};


static struct msm_lcdc_panel_ops unk_lcdc_panel_ops =
{
    .init		= unk_panel_init,
    .blank		= unk_panel_blank,
    .unblank	= unk_panel_unblank,
};

static struct msm_lcdc_panel_ops auo_lcdc_panel_ops =
{
	.init		= auo_panel_init,
	.blank		= auo_panel_blank,
	.unblank	= auo_panel_unblank,
};

static struct msm_lcdc_panel_ops sharp_lcdc_panel_ops =
{
    .init		= sharp_panel_init,
    .blank		= sharp_panel_blank,
    .unblank	= sharp_panel_unblank,
};

static struct msm_lcdc_timing htcleo_lcdc_timing =
{
		.clk_rate		= 24576000,
		.hsync_pulse_width	= 2,
		.hsync_back_porch	= 30,
		.hsync_front_porch	= 2,
		.hsync_skew		= 0,
		.vsync_pulse_width	= 2,
		.vsync_back_porch	= 5,
		.vsync_front_porch	= 2,
		.vsync_act_low		= 1,
		.hsync_act_low		= 1,
		.den_act_low		= 0,
};

static struct msm_fb_data htcleo_lcdc_fb_data =
{
		.xres		= 480,
		.yres		= 800,
		.width		= 48,
		.height		= 80,
		.output_format	= 0,
};

static struct msm_lcdc_platform_data htcleo_lcdc_platform_data =
{
    .panel_ops	= &auo_lcdc_panel_ops,
	.timing		= &htcleo_lcdc_timing,
	.fb_id		= 0,
	.fb_data	= &htcleo_lcdc_fb_data,
    .fb_resource= &resources_msm_fb[0],
};

static struct platform_device htcleo_lcdc_device =
{
	.name	= "msm_mdp_lcdc",
	.id	= -1,
    .dev	=
    {
		.platform_data = &htcleo_lcdc_platform_data,
	},
};


int __init htcleo_init_panel(void)
{
	int ret=0;
	pr_info("Init Panel\n");
	if (!machine_is_htcleo())
		return 0;

    vreg_lcd = vreg_get(0, "gp4");
    if (IS_ERR(vreg_lcd))
    {
        return PTR_ERR(vreg_lcd);
    }

    detect_panel_type();

	ret = platform_device_register(&msm_device_mdp);
	if (ret != 0)
		return ret;

    if (panel_type == PANELTYPE_AUO)
        htcleo_lcdc_platform_data.panel_ops = &auo_lcdc_panel_ops;
    else if (panel_type == PANELTYPE_SHARP)
        htcleo_lcdc_platform_data.panel_ops = &sharp_lcdc_panel_ops;
    else
        htcleo_lcdc_platform_data.panel_ops = &unk_lcdc_panel_ops;

	ret = platform_device_register(&htcleo_lcdc_device);
	if (ret != 0)
		return ret;

	return 0;
}

device_initcall(htcleo_init_panel);
