#ifndef DS2745_I2C_H
#define DS2745_I2C_H

#define DS2745_I2C_NAME "ds2745-battery"

// The four possible Rsns
enum {
	DS2745_RSNS_25,			/* 25 mOHM */
	DS2745_RSNS_20,			/* 20 mOHM */
	DS2745_RSNS_15,			/* 15 mOHM */
	DS2745_RSNS_10,			/* 10 mOHM */
	DS2745_RSNS_5,			/* 5 mOHM */
};

struct battery_info_reply {
	u32 batt_id;			/* Battery ID from ADC */
	u32 batt_vol;			/* Battery voltage from ADC */
	u32 batt_temp;			/* Battery Temperature (C) ADC */
	int batt_current;		/* Battery current from ADC */
	u32 level;			/* formula */
	u32 charging_source;		/* 0: no cable, 1:usb, 2:AC */
	u32 charging_enabled;		/* 0: Disable, 1: Enable */
	u32 full_bat;			/* Full capacity of battery */
}; 

struct ds2745_platform_data {
	uint8_t		rsns_id;			/* resistance Rsns one of the 4 in the enum above */
	uint32_t	bat_capa;			/*  Battery capacity in mAh */
	uint32_t	bat_voltage;			/*  Battery nominal voltage mV */
	uint32_t	bat_max_voltage;		/*  Battery maximal charging voltage mV */
	uint32_t	bat_min_voltage;		/*  Battery minimal voltage (off) mV */
	uint32_t	bat_vol_up_thresholt;		/*  Battery voltage upper thresholt in percent from bat_max_voltage for 100% e.G. 95 */
	uint32_t	bat_vol_lo_thresholt;		/*  Battery voltage lower thresholt in percent from bat_min_voltage for approximate formula e.g. 10 */
	uint32_t	bat_cap_lo_thresholt;		/*  Battery capacity lower thresholt in percent from bat_capa for approximate formula e.g. 5 */
	
};

#endif

